
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "configurationTemplate",
    "contentType",
    "id",
    "isDefault",
    "maxSmsLength",
    "name",
    "parameters",
    "password",
    "sendUrlParameters",
    "uid",
    "urlTemplate",
    "useGet",
    "username"
})
@Generated("jsonschema2pojo")
public class GenericHttpGatewayConfig implements Serializable
{

    @JsonProperty("configurationTemplate")
    private String configurationTemplate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    private GenericHttpGatewayConfig.ContentType contentType;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    private Boolean isDefault;
    @JsonProperty("maxSmsLength")
    private String maxSmsLength;
    @JsonProperty("name")
    private String name;
    @JsonProperty("parameters")
    private List<GenericGatewayParameter> parameters = null;
    @JsonProperty("password")
    private String password;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    private Boolean sendUrlParameters;
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("urlTemplate")
    private String urlTemplate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useGet")
    private Boolean useGet;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5102511329449320885L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GenericHttpGatewayConfig() {
    }

    /**
     * 
     * @param source
     */
    public GenericHttpGatewayConfig(GenericHttpGatewayConfig source) {
        super();
        this.configurationTemplate = source.configurationTemplate;
        this.contentType = source.contentType;
        this.id = source.id;
        this.isDefault = source.isDefault;
        this.maxSmsLength = source.maxSmsLength;
        this.name = source.name;
        this.parameters = source.parameters;
        this.password = source.password;
        this.sendUrlParameters = source.sendUrlParameters;
        this.uid = source.uid;
        this.urlTemplate = source.urlTemplate;
        this.useGet = source.useGet;
        this.username = source.username;
    }

    /**
     * 
     * @param useGet
     * @param configurationTemplate
     * @param urlTemplate
     * @param uid
     * @param isDefault
     * @param password
     * @param maxSmsLength
     * @param sendUrlParameters
     * @param name
     * @param id
     * @param contentType
     * @param parameters
     * @param username
     */
    public GenericHttpGatewayConfig(String configurationTemplate, GenericHttpGatewayConfig.ContentType contentType, String id, Boolean isDefault, String maxSmsLength, String name, List<GenericGatewayParameter> parameters, String password, Boolean sendUrlParameters, String uid, String urlTemplate, Boolean useGet, String username) {
        super();
        this.configurationTemplate = configurationTemplate;
        this.contentType = contentType;
        this.id = id;
        this.isDefault = isDefault;
        this.maxSmsLength = maxSmsLength;
        this.name = name;
        this.parameters = parameters;
        this.password = password;
        this.sendUrlParameters = sendUrlParameters;
        this.uid = uid;
        this.urlTemplate = urlTemplate;
        this.useGet = useGet;
        this.username = username;
    }

    @JsonProperty("configurationTemplate")
    public Optional<String> getConfigurationTemplate() {
        return Optional.ofNullable(configurationTemplate);
    }

    @JsonProperty("configurationTemplate")
    public void setConfigurationTemplate(String configurationTemplate) {
        this.configurationTemplate = configurationTemplate;
    }

    public GenericHttpGatewayConfig withConfigurationTemplate(String configurationTemplate) {
        this.configurationTemplate = configurationTemplate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    public GenericHttpGatewayConfig.ContentType getContentType() {
        return contentType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("contentType")
    public void setContentType(GenericHttpGatewayConfig.ContentType contentType) {
        this.contentType = contentType;
    }

    public GenericHttpGatewayConfig withContentType(GenericHttpGatewayConfig.ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public GenericHttpGatewayConfig withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public GenericHttpGatewayConfig withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @JsonProperty("maxSmsLength")
    public Optional<String> getMaxSmsLength() {
        return Optional.ofNullable(maxSmsLength);
    }

    @JsonProperty("maxSmsLength")
    public void setMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
    }

    public GenericHttpGatewayConfig withMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public GenericHttpGatewayConfig withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("parameters")
    public Optional<List<GenericGatewayParameter>> getParameters() {
        return Optional.ofNullable(parameters);
    }

    @JsonProperty("parameters")
    public void setParameters(List<GenericGatewayParameter> parameters) {
        this.parameters = parameters;
    }

    public GenericHttpGatewayConfig withParameters(List<GenericGatewayParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @JsonProperty("password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    public GenericHttpGatewayConfig withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    public Boolean getSendUrlParameters() {
        return sendUrlParameters;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    public void setSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
    }

    public GenericHttpGatewayConfig withSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public GenericHttpGatewayConfig withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonProperty("urlTemplate")
    public Optional<String> getUrlTemplate() {
        return Optional.ofNullable(urlTemplate);
    }

    @JsonProperty("urlTemplate")
    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public GenericHttpGatewayConfig withUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useGet")
    public Boolean getUseGet() {
        return useGet;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("useGet")
    public void setUseGet(Boolean useGet) {
        this.useGet = useGet;
    }

    public GenericHttpGatewayConfig withUseGet(Boolean useGet) {
        this.useGet = useGet;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public GenericHttpGatewayConfig withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GenericHttpGatewayConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "configurationTemplate":
                if (value instanceof String) {
                    setConfigurationTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"configurationTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "contentType":
                if (value instanceof GenericHttpGatewayConfig.ContentType) {
                    setContentType(((GenericHttpGatewayConfig.ContentType) value));
                } else {
                    throw new IllegalArgumentException(("property \"contentType\" is of type \"org.hisp.dhis.api.model.v40_0.GenericHttpGatewayConfig.ContentType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "isDefault":
                if (value instanceof Boolean) {
                    setIsDefault(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"isDefault\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxSmsLength":
                if (value instanceof String) {
                    setMaxSmsLength(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxSmsLength\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parameters":
                if (value instanceof List) {
                    setParameters(((List<GenericGatewayParameter> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"parameters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.GenericGatewayParameter>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "password":
                if (value instanceof String) {
                    setPassword(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"password\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sendUrlParameters":
                if (value instanceof Boolean) {
                    setSendUrlParameters(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sendUrlParameters\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "urlTemplate":
                if (value instanceof String) {
                    setUrlTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"urlTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "useGet":
                if (value instanceof Boolean) {
                    setUseGet(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"useGet\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "username":
                if (value instanceof String) {
                    setUsername(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "configurationTemplate":
                return getConfigurationTemplate();
            case "contentType":
                return getContentType();
            case "id":
                return getId();
            case "isDefault":
                return getIsDefault();
            case "maxSmsLength":
                return getMaxSmsLength();
            case "name":
                return getName();
            case "parameters":
                return getParameters();
            case "password":
                return getPassword();
            case "sendUrlParameters":
                return getSendUrlParameters();
            case "uid":
                return getUid();
            case "urlTemplate":
                return getUrlTemplate();
            case "useGet":
                return getUseGet();
            case "username":
                return getUsername();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GenericHttpGatewayConfig.NOT_FOUND_VALUE);
        if (GenericHttpGatewayConfig.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GenericHttpGatewayConfig with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GenericHttpGatewayConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("configurationTemplate");
        sb.append('=');
        sb.append(((this.configurationTemplate == null)?"<null>":this.configurationTemplate));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("isDefault");
        sb.append('=');
        sb.append(((this.isDefault == null)?"<null>":this.isDefault));
        sb.append(',');
        sb.append("maxSmsLength");
        sb.append('=');
        sb.append(((this.maxSmsLength == null)?"<null>":this.maxSmsLength));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("parameters");
        sb.append('=');
        sb.append(((this.parameters == null)?"<null>":this.parameters));
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(((this.password == null)?"<null>":this.password));
        sb.append(',');
        sb.append("sendUrlParameters");
        sb.append('=');
        sb.append(((this.sendUrlParameters == null)?"<null>":this.sendUrlParameters));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("urlTemplate");
        sb.append('=');
        sb.append(((this.urlTemplate == null)?"<null>":this.urlTemplate));
        sb.append(',');
        sb.append("useGet");
        sb.append('=');
        sb.append(((this.useGet == null)?"<null>":this.useGet));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.useGet == null)? 0 :this.useGet.hashCode()));
        result = ((result* 31)+((this.configurationTemplate == null)? 0 :this.configurationTemplate.hashCode()));
        result = ((result* 31)+((this.urlTemplate == null)? 0 :this.urlTemplate.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.isDefault == null)? 0 :this.isDefault.hashCode()));
        result = ((result* 31)+((this.password == null)? 0 :this.password.hashCode()));
        result = ((result* 31)+((this.maxSmsLength == null)? 0 :this.maxSmsLength.hashCode()));
        result = ((result* 31)+((this.sendUrlParameters == null)? 0 :this.sendUrlParameters.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.parameters == null)? 0 :this.parameters.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GenericHttpGatewayConfig) == false) {
            return false;
        }
        GenericHttpGatewayConfig rhs = ((GenericHttpGatewayConfig) other);
        return (((((((((((((((this.useGet == rhs.useGet)||((this.useGet!= null)&&this.useGet.equals(rhs.useGet)))&&((this.configurationTemplate == rhs.configurationTemplate)||((this.configurationTemplate!= null)&&this.configurationTemplate.equals(rhs.configurationTemplate))))&&((this.urlTemplate == rhs.urlTemplate)||((this.urlTemplate!= null)&&this.urlTemplate.equals(rhs.urlTemplate))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.isDefault == rhs.isDefault)||((this.isDefault!= null)&&this.isDefault.equals(rhs.isDefault))))&&((this.password == rhs.password)||((this.password!= null)&&this.password.equals(rhs.password))))&&((this.maxSmsLength == rhs.maxSmsLength)||((this.maxSmsLength!= null)&&this.maxSmsLength.equals(rhs.maxSmsLength))))&&((this.sendUrlParameters == rhs.sendUrlParameters)||((this.sendUrlParameters!= null)&&this.sendUrlParameters.equals(rhs.sendUrlParameters))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))))&&((this.parameters == rhs.parameters)||((this.parameters!= null)&&this.parameters.equals(rhs.parameters))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum ContentType {

        APPLICATION_JSON("APPLICATION_JSON"),
        APPLICATION_XML("APPLICATION_XML"),
        TEXT_PLAIN("TEXT_PLAIN"),
        FORM_URL_ENCODED("FORM_URL_ENCODED");
        private final String value;
        private final static Map<String, GenericHttpGatewayConfig.ContentType> CONSTANTS = new HashMap<String, GenericHttpGatewayConfig.ContentType>();

        static {
            for (GenericHttpGatewayConfig.ContentType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ContentType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GenericHttpGatewayConfig.ContentType fromValue(String value) {
            GenericHttpGatewayConfig.ContentType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
