
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "included",
    "transformation"
})
@Generated("jsonschema2pojo")
public class GistPreferences implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("included")
    private GistPreferences.Included included;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transformation")
    private GistPreferences.Transformation transformation;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1425190452377845360L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GistPreferences() {
    }

    /**
     * 
     * @param source
     */
    public GistPreferences(GistPreferences source) {
        super();
        this.included = source.included;
        this.transformation = source.transformation;
    }

    /**
     * 
     * @param transformation
     * @param included
     */
    public GistPreferences(GistPreferences.Included included, GistPreferences.Transformation transformation) {
        super();
        this.included = included;
        this.transformation = transformation;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("included")
    public GistPreferences.Included getIncluded() {
        return included;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("included")
    public void setIncluded(GistPreferences.Included included) {
        this.included = included;
    }

    public GistPreferences withIncluded(GistPreferences.Included included) {
        this.included = included;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transformation")
    public GistPreferences.Transformation getTransformation() {
        return transformation;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transformation")
    public void setTransformation(GistPreferences.Transformation transformation) {
        this.transformation = transformation;
    }

    public GistPreferences withTransformation(GistPreferences.Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GistPreferences withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "included":
                if (value instanceof GistPreferences.Included) {
                    setIncluded(((GistPreferences.Included) value));
                } else {
                    throw new IllegalArgumentException(("property \"included\" is of type \"org.hisp.dhis.api.model.v40_0.GistPreferences.Included\", but got "+ value.getClass().toString()));
                }
                return true;
            case "transformation":
                if (value instanceof GistPreferences.Transformation) {
                    setTransformation(((GistPreferences.Transformation) value));
                } else {
                    throw new IllegalArgumentException(("property \"transformation\" is of type \"org.hisp.dhis.api.model.v40_0.GistPreferences.Transformation\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "included":
                return getIncluded();
            case "transformation":
                return getTransformation();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, GistPreferences.NOT_FOUND_VALUE);
        if (GistPreferences.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public GistPreferences with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GistPreferences.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("included");
        sb.append('=');
        sb.append(((this.included == null)?"<null>":this.included));
        sb.append(',');
        sb.append("transformation");
        sb.append('=');
        sb.append(((this.transformation == null)?"<null>":this.transformation));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.transformation == null)? 0 :this.transformation.hashCode()));
        result = ((result* 31)+((this.included == null)? 0 :this.included.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GistPreferences) == false) {
            return false;
        }
        GistPreferences rhs = ((GistPreferences) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.transformation == rhs.transformation)||((this.transformation!= null)&&this.transformation.equals(rhs.transformation))))&&((this.included == rhs.included)||((this.included!= null)&&this.included.equals(rhs.included))));
    }

    @Generated("jsonschema2pojo")
    public enum Included {

        FALSE("FALSE"),
        TRUE("TRUE"),
        AUTO("AUTO");
        private final String value;
        private final static Map<String, GistPreferences.Included> CONSTANTS = new HashMap<String, GistPreferences.Included>();

        static {
            for (GistPreferences.Included c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Included(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GistPreferences.Included fromValue(String value) {
            GistPreferences.Included constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Transformation {

        AUTO("AUTO"),
        NONE("NONE"),
        IS_EMPTY("IS_EMPTY"),
        IS_NOT_EMPTY("IS_NOT_EMPTY"),
        SIZE("SIZE"),
        MEMBER("MEMBER"),
        NOT_MEMBER("NOT_MEMBER"),
        IDS("IDS"),
        ID_OBJECTS("ID_OBJECTS"),
        PLUCK("PLUCK"),
        FROM("FROM");
        private final String value;
        private final static Map<String, GistPreferences.Transformation> CONSTANTS = new HashMap<String, GistPreferences.Transformation>();

        static {
            for (GistPreferences.Transformation c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Transformation(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GistPreferences.Transformation fromValue(String value) {
            GistPreferences.Transformation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
