
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "set",
    "showKey",
    "strategy",
    "style"
})
@Generated("jsonschema2pojo")
public class LegendDefinitions implements Serializable
{

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private RefLegendSet set;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showKey")
    private Boolean showKey;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    private LegendDefinitions.Strategy strategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    private LegendDefinitions.Style style;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1482466773095608897L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LegendDefinitions() {
    }

    /**
     * 
     * @param source
     */
    public LegendDefinitions(LegendDefinitions source) {
        super();
        this.set = source.set;
        this.showKey = source.showKey;
        this.strategy = source.strategy;
        this.style = source.style;
    }

    /**
     * 
     * @param set
     * @param showKey
     * @param style
     * @param strategy
     */
    public LegendDefinitions(RefLegendSet set, Boolean showKey, LegendDefinitions.Strategy strategy, LegendDefinitions.Style style) {
        super();
        this.set = set;
        this.showKey = showKey;
        this.strategy = strategy;
        this.style = style;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    public Optional<RefLegendSet> getSet() {
        return Optional.ofNullable(set);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    public void setSet(RefLegendSet set) {
        this.set = set;
    }

    public LegendDefinitions withSet(RefLegendSet set) {
        this.set = set;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showKey")
    public Boolean getShowKey() {
        return showKey;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("showKey")
    public void setShowKey(Boolean showKey) {
        this.showKey = showKey;
    }

    public LegendDefinitions withShowKey(Boolean showKey) {
        this.showKey = showKey;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    public LegendDefinitions.Strategy getStrategy() {
        return strategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    public void setStrategy(LegendDefinitions.Strategy strategy) {
        this.strategy = strategy;
    }

    public LegendDefinitions withStrategy(LegendDefinitions.Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    public LegendDefinitions.Style getStyle() {
        return style;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    public void setStyle(LegendDefinitions.Style style) {
        this.style = style;
    }

    public LegendDefinitions withStyle(LegendDefinitions.Style style) {
        this.style = style;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LegendDefinitions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "set":
                if (value instanceof RefLegendSet) {
                    setSet(((RefLegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"set\" is of type \"org.hisp.dhis.api.model.v40_0.RefLegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "showKey":
                if (value instanceof Boolean) {
                    setShowKey(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showKey\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "strategy":
                if (value instanceof LegendDefinitions.Strategy) {
                    setStrategy(((LegendDefinitions.Strategy) value));
                } else {
                    throw new IllegalArgumentException(("property \"strategy\" is of type \"org.hisp.dhis.api.model.v40_0.LegendDefinitions.Strategy\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof LegendDefinitions.Style) {
                    setStyle(((LegendDefinitions.Style) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_0.LegendDefinitions.Style\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "set":
                return getSet();
            case "showKey":
                return getShowKey();
            case "strategy":
                return getStrategy();
            case "style":
                return getStyle();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LegendDefinitions.NOT_FOUND_VALUE);
        if (LegendDefinitions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LegendDefinitions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LegendDefinitions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("set");
        sb.append('=');
        sb.append(((this.set == null)?"<null>":this.set));
        sb.append(',');
        sb.append("showKey");
        sb.append('=');
        sb.append(((this.showKey == null)?"<null>":this.showKey));
        sb.append(',');
        sb.append("strategy");
        sb.append('=');
        sb.append(((this.strategy == null)?"<null>":this.strategy));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.set == null)? 0 :this.set.hashCode()));
        result = ((result* 31)+((this.showKey == null)? 0 :this.showKey.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.strategy == null)? 0 :this.strategy.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LegendDefinitions) == false) {
            return false;
        }
        LegendDefinitions rhs = ((LegendDefinitions) other);
        return ((((((this.set == rhs.set)||((this.set!= null)&&this.set.equals(rhs.set)))&&((this.showKey == rhs.showKey)||((this.showKey!= null)&&this.showKey.equals(rhs.showKey))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.strategy == rhs.strategy)||((this.strategy!= null)&&this.strategy.equals(rhs.strategy))));
    }

    @Generated("jsonschema2pojo")
    public enum Strategy {

        FIXED("FIXED"),
        BY_DATA_ITEM("BY_DATA_ITEM");
        private final String value;
        private final static Map<String, LegendDefinitions.Strategy> CONSTANTS = new HashMap<String, LegendDefinitions.Strategy>();

        static {
            for (LegendDefinitions.Strategy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Strategy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LegendDefinitions.Strategy fromValue(String value) {
            LegendDefinitions.Strategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum Style {

        FILL("FILL"),
        TEXT("TEXT");
        private final String value;
        private final static Map<String, LegendDefinitions.Style> CONSTANTS = new HashMap<String, LegendDefinitions.Style>();

        static {
            for (LegendDefinitions.Style c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Style(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LegendDefinitions.Style fromValue(String value) {
            LegendDefinitions.Style constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
