
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "address",
    "closedDate",
    "code",
    "comment",
    "contactPerson",
    "description",
    "email",
    "featureType",
    "id",
    "imageId",
    "latitude",
    "level",
    "levelName",
    "longitude",
    "name",
    "openingDate",
    "parentName",
    "phoneNumber",
    "shortName",
    "url"
})
@Generated("jsonschema2pojo")
public class OrgUnitInfo implements Serializable
{

    @JsonProperty("address")
    private String address;
    @JsonProperty("closedDate")
    private Date closedDate;
    @JsonProperty("code")
    private String code;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("contactPerson")
    private String contactPerson;
    @JsonProperty("description")
    private String description;
    @JsonProperty("email")
    private String email;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    private OrgUnitInfo.FeatureType featureType;
    @JsonProperty("id")
    private String id;
    @JsonProperty("imageId")
    private String imageId;
    @JsonProperty("latitude")
    private Double latitude;
    @JsonProperty("level")
    private Integer level;
    @JsonProperty("levelName")
    private String levelName;
    @JsonProperty("longitude")
    private Double longitude;
    @JsonProperty("name")
    private String name;
    @JsonProperty("openingDate")
    private Date openingDate;
    @JsonProperty("parentName")
    private String parentName;
    @JsonProperty("phoneNumber")
    private String phoneNumber;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("url")
    private String url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5522008901056868763L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrgUnitInfo() {
    }

    /**
     * 
     * @param source
     */
    public OrgUnitInfo(OrgUnitInfo source) {
        super();
        this.address = source.address;
        this.closedDate = source.closedDate;
        this.code = source.code;
        this.comment = source.comment;
        this.contactPerson = source.contactPerson;
        this.description = source.description;
        this.email = source.email;
        this.featureType = source.featureType;
        this.id = source.id;
        this.imageId = source.imageId;
        this.latitude = source.latitude;
        this.level = source.level;
        this.levelName = source.levelName;
        this.longitude = source.longitude;
        this.name = source.name;
        this.openingDate = source.openingDate;
        this.parentName = source.parentName;
        this.phoneNumber = source.phoneNumber;
        this.shortName = source.shortName;
        this.url = source.url;
    }

    /**
     * 
     * @param address
     * @param code
     * @param imageId
     * @param level
     * @param latitude
     * @param contactPerson
     * @param description
     * @param levelName
     * @param url
     * @param parentName
     * @param phoneNumber
     * @param closedDate
     * @param featureType
     * @param name
     * @param comment
     * @param id
     * @param shortName
     * @param openingDate
     * @param email
     * @param longitude
     */
    public OrgUnitInfo(String address, Date closedDate, String code, String comment, String contactPerson, String description, String email, OrgUnitInfo.FeatureType featureType, String id, String imageId, Double latitude, Integer level, String levelName, Double longitude, String name, Date openingDate, String parentName, String phoneNumber, String shortName, String url) {
        super();
        this.address = address;
        this.closedDate = closedDate;
        this.code = code;
        this.comment = comment;
        this.contactPerson = contactPerson;
        this.description = description;
        this.email = email;
        this.featureType = featureType;
        this.id = id;
        this.imageId = imageId;
        this.latitude = latitude;
        this.level = level;
        this.levelName = levelName;
        this.longitude = longitude;
        this.name = name;
        this.openingDate = openingDate;
        this.parentName = parentName;
        this.phoneNumber = phoneNumber;
        this.shortName = shortName;
        this.url = url;
    }

    @JsonProperty("address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    public OrgUnitInfo withAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty("closedDate")
    public Optional<Date> getClosedDate() {
        return Optional.ofNullable(closedDate);
    }

    @JsonProperty("closedDate")
    public void setClosedDate(Date closedDate) {
        this.closedDate = closedDate;
    }

    public OrgUnitInfo withClosedDate(Date closedDate) {
        this.closedDate = closedDate;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public OrgUnitInfo withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public OrgUnitInfo withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("contactPerson")
    public Optional<String> getContactPerson() {
        return Optional.ofNullable(contactPerson);
    }

    @JsonProperty("contactPerson")
    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public OrgUnitInfo withContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public OrgUnitInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("email")
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    public OrgUnitInfo withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public OrgUnitInfo.FeatureType getFeatureType() {
        return featureType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public void setFeatureType(OrgUnitInfo.FeatureType featureType) {
        this.featureType = featureType;
    }

    public OrgUnitInfo withFeatureType(OrgUnitInfo.FeatureType featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public OrgUnitInfo withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("imageId")
    public Optional<String> getImageId() {
        return Optional.ofNullable(imageId);
    }

    @JsonProperty("imageId")
    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public OrgUnitInfo withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    @JsonProperty("latitude")
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    @JsonProperty("latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public OrgUnitInfo withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @JsonProperty("level")
    public Optional<Integer> getLevel() {
        return Optional.ofNullable(level);
    }

    @JsonProperty("level")
    public void setLevel(Integer level) {
        this.level = level;
    }

    public OrgUnitInfo withLevel(Integer level) {
        this.level = level;
        return this;
    }

    @JsonProperty("levelName")
    public Optional<String> getLevelName() {
        return Optional.ofNullable(levelName);
    }

    @JsonProperty("levelName")
    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public OrgUnitInfo withLevelName(String levelName) {
        this.levelName = levelName;
        return this;
    }

    @JsonProperty("longitude")
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    @JsonProperty("longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public OrgUnitInfo withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public OrgUnitInfo withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("openingDate")
    public Optional<Date> getOpeningDate() {
        return Optional.ofNullable(openingDate);
    }

    @JsonProperty("openingDate")
    public void setOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
    }

    public OrgUnitInfo withOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
        return this;
    }

    @JsonProperty("parentName")
    public Optional<String> getParentName() {
        return Optional.ofNullable(parentName);
    }

    @JsonProperty("parentName")
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public OrgUnitInfo withParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    @JsonProperty("phoneNumber")
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    @JsonProperty("phoneNumber")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public OrgUnitInfo withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public OrgUnitInfo withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public OrgUnitInfo withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrgUnitInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "address":
                if (value instanceof String) {
                    setAddress(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"address\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "closedDate":
                if (value instanceof Date) {
                    setClosedDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"closedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comment":
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "contactPerson":
                if (value instanceof String) {
                    setContactPerson(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"contactPerson\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "email":
                if (value instanceof String) {
                    setEmail(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"email\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "featureType":
                if (value instanceof OrgUnitInfo.FeatureType) {
                    setFeatureType(((OrgUnitInfo.FeatureType) value));
                } else {
                    throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v40_0.OrgUnitInfo.FeatureType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "imageId":
                if (value instanceof String) {
                    setImageId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"imageId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "latitude":
                if (value instanceof Double) {
                    setLatitude(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"latitude\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "level":
                if (value instanceof Integer) {
                    setLevel(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"level\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "levelName":
                if (value instanceof String) {
                    setLevelName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"levelName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "longitude":
                if (value instanceof Double) {
                    setLongitude(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"longitude\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openingDate":
                if (value instanceof Date) {
                    setOpeningDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"openingDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parentName":
                if (value instanceof String) {
                    setParentName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"parentName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "phoneNumber":
                if (value instanceof String) {
                    setPhoneNumber(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"phoneNumber\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "url":
                if (value instanceof String) {
                    setUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "address":
                return getAddress();
            case "closedDate":
                return getClosedDate();
            case "code":
                return getCode();
            case "comment":
                return getComment();
            case "contactPerson":
                return getContactPerson();
            case "description":
                return getDescription();
            case "email":
                return getEmail();
            case "featureType":
                return getFeatureType();
            case "id":
                return getId();
            case "imageId":
                return getImageId();
            case "latitude":
                return getLatitude();
            case "level":
                return getLevel();
            case "levelName":
                return getLevelName();
            case "longitude":
                return getLongitude();
            case "name":
                return getName();
            case "openingDate":
                return getOpeningDate();
            case "parentName":
                return getParentName();
            case "phoneNumber":
                return getPhoneNumber();
            case "shortName":
                return getShortName();
            case "url":
                return getUrl();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrgUnitInfo.NOT_FOUND_VALUE);
        if (OrgUnitInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrgUnitInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrgUnitInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("address");
        sb.append('=');
        sb.append(((this.address == null)?"<null>":this.address));
        sb.append(',');
        sb.append("closedDate");
        sb.append('=');
        sb.append(((this.closedDate == null)?"<null>":this.closedDate));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("contactPerson");
        sb.append('=');
        sb.append(((this.contactPerson == null)?"<null>":this.contactPerson));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(((this.email == null)?"<null>":this.email));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("imageId");
        sb.append('=');
        sb.append(((this.imageId == null)?"<null>":this.imageId));
        sb.append(',');
        sb.append("latitude");
        sb.append('=');
        sb.append(((this.latitude == null)?"<null>":this.latitude));
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(((this.level == null)?"<null>":this.level));
        sb.append(',');
        sb.append("levelName");
        sb.append('=');
        sb.append(((this.levelName == null)?"<null>":this.levelName));
        sb.append(',');
        sb.append("longitude");
        sb.append('=');
        sb.append(((this.longitude == null)?"<null>":this.longitude));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("openingDate");
        sb.append('=');
        sb.append(((this.openingDate == null)?"<null>":this.openingDate));
        sb.append(',');
        sb.append("parentName");
        sb.append('=');
        sb.append(((this.parentName == null)?"<null>":this.parentName));
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(((this.phoneNumber == null)?"<null>":this.phoneNumber));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.address == null)? 0 :this.address.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.imageId == null)? 0 :this.imageId.hashCode()));
        result = ((result* 31)+((this.level == null)? 0 :this.level.hashCode()));
        result = ((result* 31)+((this.latitude == null)? 0 :this.latitude.hashCode()));
        result = ((result* 31)+((this.contactPerson == null)? 0 :this.contactPerson.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.levelName == null)? 0 :this.levelName.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.parentName == null)? 0 :this.parentName.hashCode()));
        result = ((result* 31)+((this.phoneNumber == null)? 0 :this.phoneNumber.hashCode()));
        result = ((result* 31)+((this.closedDate == null)? 0 :this.closedDate.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.openingDate == null)? 0 :this.openingDate.hashCode()));
        result = ((result* 31)+((this.email == null)? 0 :this.email.hashCode()));
        result = ((result* 31)+((this.longitude == null)? 0 :this.longitude.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrgUnitInfo) == false) {
            return false;
        }
        OrgUnitInfo rhs = ((OrgUnitInfo) other);
        return ((((((((((((((((((((((this.address == rhs.address)||((this.address!= null)&&this.address.equals(rhs.address)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.imageId == rhs.imageId)||((this.imageId!= null)&&this.imageId.equals(rhs.imageId))))&&((this.level == rhs.level)||((this.level!= null)&&this.level.equals(rhs.level))))&&((this.latitude == rhs.latitude)||((this.latitude!= null)&&this.latitude.equals(rhs.latitude))))&&((this.contactPerson == rhs.contactPerson)||((this.contactPerson!= null)&&this.contactPerson.equals(rhs.contactPerson))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.levelName == rhs.levelName)||((this.levelName!= null)&&this.levelName.equals(rhs.levelName))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.parentName == rhs.parentName)||((this.parentName!= null)&&this.parentName.equals(rhs.parentName))))&&((this.phoneNumber == rhs.phoneNumber)||((this.phoneNumber!= null)&&this.phoneNumber.equals(rhs.phoneNumber))))&&((this.closedDate == rhs.closedDate)||((this.closedDate!= null)&&this.closedDate.equals(rhs.closedDate))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.openingDate == rhs.openingDate)||((this.openingDate!= null)&&this.openingDate.equals(rhs.openingDate))))&&((this.email == rhs.email)||((this.email!= null)&&this.email.equals(rhs.email))))&&((this.longitude == rhs.longitude)||((this.longitude!= null)&&this.longitude.equals(rhs.longitude))));
    }

    @Generated("jsonschema2pojo")
    public enum FeatureType {

        NONE("NONE"),
        MULTI_POLYGON("MULTI_POLYGON"),
        POLYGON("POLYGON"),
        POINT("POINT"),
        SYMBOL("SYMBOL");
        private final String value;
        private final static Map<String, OrgUnitInfo.FeatureType> CONSTANTS = new HashMap<String, OrgUnitInfo.FeatureType>();

        static {
            for (OrgUnitInfo.FeatureType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FeatureType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OrgUnitInfo.FeatureType fromValue(String value) {
            OrgUnitInfo.FeatureType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
