
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bindType",
    "compressed",
    "host",
    "id",
    "isDefault",
    "maxSmsLength",
    "name",
    "numberPlanIndicator",
    "password",
    "port",
    "sendUrlParameters",
    "systemId",
    "systemType",
    "typeOfNumber",
    "uid",
    "urlTemplate",
    "username"
})
@Generated("jsonschema2pojo")
public class SMPPGatewayConfig implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    private SMPPGatewayConfig.BindType bindType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compressed")
    private Boolean compressed;
    @JsonProperty("host")
    private String host;
    @JsonProperty("id")
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    private Boolean isDefault;
    @JsonProperty("maxSmsLength")
    private String maxSmsLength;
    @JsonProperty("name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    private SMPPGatewayConfig.NumberPlanIndicator numberPlanIndicator;
    @JsonProperty("password")
    private String password;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    private Integer port;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    private Boolean sendUrlParameters;
    @JsonProperty("systemId")
    private String systemId;
    @JsonProperty("systemType")
    private String systemType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    private SMPPGatewayConfig.TypeOfNumber typeOfNumber;
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("urlTemplate")
    private String urlTemplate;
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6014260172115646233L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SMPPGatewayConfig() {
    }

    /**
     * 
     * @param source
     */
    public SMPPGatewayConfig(SMPPGatewayConfig source) {
        super();
        this.bindType = source.bindType;
        this.compressed = source.compressed;
        this.host = source.host;
        this.id = source.id;
        this.isDefault = source.isDefault;
        this.maxSmsLength = source.maxSmsLength;
        this.name = source.name;
        this.numberPlanIndicator = source.numberPlanIndicator;
        this.password = source.password;
        this.port = source.port;
        this.sendUrlParameters = source.sendUrlParameters;
        this.systemId = source.systemId;
        this.systemType = source.systemType;
        this.typeOfNumber = source.typeOfNumber;
        this.uid = source.uid;
        this.urlTemplate = source.urlTemplate;
        this.username = source.username;
    }

    /**
     * 
     * @param numberPlanIndicator
     * @param systemId
     * @param urlTemplate
     * @param bindType
     * @param uid
     * @param isDefault
     * @param password
     * @param maxSmsLength
     * @param typeOfNumber
     * @param port
     * @param sendUrlParameters
     * @param host
     * @param name
     * @param systemType
     * @param compressed
     * @param id
     * @param username
     */
    public SMPPGatewayConfig(SMPPGatewayConfig.BindType bindType, Boolean compressed, String host, String id, Boolean isDefault, String maxSmsLength, String name, SMPPGatewayConfig.NumberPlanIndicator numberPlanIndicator, String password, Integer port, Boolean sendUrlParameters, String systemId, String systemType, SMPPGatewayConfig.TypeOfNumber typeOfNumber, String uid, String urlTemplate, String username) {
        super();
        this.bindType = bindType;
        this.compressed = compressed;
        this.host = host;
        this.id = id;
        this.isDefault = isDefault;
        this.maxSmsLength = maxSmsLength;
        this.name = name;
        this.numberPlanIndicator = numberPlanIndicator;
        this.password = password;
        this.port = port;
        this.sendUrlParameters = sendUrlParameters;
        this.systemId = systemId;
        this.systemType = systemType;
        this.typeOfNumber = typeOfNumber;
        this.uid = uid;
        this.urlTemplate = urlTemplate;
        this.username = username;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    public SMPPGatewayConfig.BindType getBindType() {
        return bindType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("bindType")
    public void setBindType(SMPPGatewayConfig.BindType bindType) {
        this.bindType = bindType;
    }

    public SMPPGatewayConfig withBindType(SMPPGatewayConfig.BindType bindType) {
        this.bindType = bindType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compressed")
    public Boolean getCompressed() {
        return compressed;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("compressed")
    public void setCompressed(Boolean compressed) {
        this.compressed = compressed;
    }

    public SMPPGatewayConfig withCompressed(Boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    @JsonProperty("host")
    public Optional<String> getHost() {
        return Optional.ofNullable(host);
    }

    @JsonProperty("host")
    public void setHost(String host) {
        this.host = host;
    }

    public SMPPGatewayConfig withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public SMPPGatewayConfig withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("isDefault")
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public SMPPGatewayConfig withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @JsonProperty("maxSmsLength")
    public Optional<String> getMaxSmsLength() {
        return Optional.ofNullable(maxSmsLength);
    }

    @JsonProperty("maxSmsLength")
    public void setMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
    }

    public SMPPGatewayConfig withMaxSmsLength(String maxSmsLength) {
        this.maxSmsLength = maxSmsLength;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public SMPPGatewayConfig withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    public SMPPGatewayConfig.NumberPlanIndicator getNumberPlanIndicator() {
        return numberPlanIndicator;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("numberPlanIndicator")
    public void setNumberPlanIndicator(SMPPGatewayConfig.NumberPlanIndicator numberPlanIndicator) {
        this.numberPlanIndicator = numberPlanIndicator;
    }

    public SMPPGatewayConfig withNumberPlanIndicator(SMPPGatewayConfig.NumberPlanIndicator numberPlanIndicator) {
        this.numberPlanIndicator = numberPlanIndicator;
        return this;
    }

    @JsonProperty("password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(password);
    }

    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    public SMPPGatewayConfig withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public SMPPGatewayConfig withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    public Boolean getSendUrlParameters() {
        return sendUrlParameters;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sendUrlParameters")
    public void setSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
    }

    public SMPPGatewayConfig withSendUrlParameters(Boolean sendUrlParameters) {
        this.sendUrlParameters = sendUrlParameters;
        return this;
    }

    @JsonProperty("systemId")
    public Optional<String> getSystemId() {
        return Optional.ofNullable(systemId);
    }

    @JsonProperty("systemId")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public SMPPGatewayConfig withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty("systemType")
    public Optional<String> getSystemType() {
        return Optional.ofNullable(systemType);
    }

    @JsonProperty("systemType")
    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public SMPPGatewayConfig withSystemType(String systemType) {
        this.systemType = systemType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    public SMPPGatewayConfig.TypeOfNumber getTypeOfNumber() {
        return typeOfNumber;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("typeOfNumber")
    public void setTypeOfNumber(SMPPGatewayConfig.TypeOfNumber typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
    }

    public SMPPGatewayConfig withTypeOfNumber(SMPPGatewayConfig.TypeOfNumber typeOfNumber) {
        this.typeOfNumber = typeOfNumber;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public SMPPGatewayConfig withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonProperty("urlTemplate")
    public Optional<String> getUrlTemplate() {
        return Optional.ofNullable(urlTemplate);
    }

    @JsonProperty("urlTemplate")
    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public SMPPGatewayConfig withUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return Optional.ofNullable(username);
    }

    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SMPPGatewayConfig withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SMPPGatewayConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "bindType":
                if (value instanceof SMPPGatewayConfig.BindType) {
                    setBindType(((SMPPGatewayConfig.BindType) value));
                } else {
                    throw new IllegalArgumentException(("property \"bindType\" is of type \"org.hisp.dhis.api.model.v40_0.SMPPGatewayConfig.BindType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "compressed":
                if (value instanceof Boolean) {
                    setCompressed(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"compressed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "host":
                if (value instanceof String) {
                    setHost(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"host\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "isDefault":
                if (value instanceof Boolean) {
                    setIsDefault(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"isDefault\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maxSmsLength":
                if (value instanceof String) {
                    setMaxSmsLength(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxSmsLength\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "numberPlanIndicator":
                if (value instanceof SMPPGatewayConfig.NumberPlanIndicator) {
                    setNumberPlanIndicator(((SMPPGatewayConfig.NumberPlanIndicator) value));
                } else {
                    throw new IllegalArgumentException(("property \"numberPlanIndicator\" is of type \"org.hisp.dhis.api.model.v40_0.SMPPGatewayConfig.NumberPlanIndicator\", but got "+ value.getClass().toString()));
                }
                return true;
            case "password":
                if (value instanceof String) {
                    setPassword(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"password\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "port":
                if (value instanceof Integer) {
                    setPort(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"port\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "sendUrlParameters":
                if (value instanceof Boolean) {
                    setSendUrlParameters(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"sendUrlParameters\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "systemId":
                if (value instanceof String) {
                    setSystemId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"systemId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "systemType":
                if (value instanceof String) {
                    setSystemType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"systemType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "typeOfNumber":
                if (value instanceof SMPPGatewayConfig.TypeOfNumber) {
                    setTypeOfNumber(((SMPPGatewayConfig.TypeOfNumber) value));
                } else {
                    throw new IllegalArgumentException(("property \"typeOfNumber\" is of type \"org.hisp.dhis.api.model.v40_0.SMPPGatewayConfig.TypeOfNumber\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "urlTemplate":
                if (value instanceof String) {
                    setUrlTemplate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"urlTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "username":
                if (value instanceof String) {
                    setUsername(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"username\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "bindType":
                return getBindType();
            case "compressed":
                return getCompressed();
            case "host":
                return getHost();
            case "id":
                return getId();
            case "isDefault":
                return getIsDefault();
            case "maxSmsLength":
                return getMaxSmsLength();
            case "name":
                return getName();
            case "numberPlanIndicator":
                return getNumberPlanIndicator();
            case "password":
                return getPassword();
            case "port":
                return getPort();
            case "sendUrlParameters":
                return getSendUrlParameters();
            case "systemId":
                return getSystemId();
            case "systemType":
                return getSystemType();
            case "typeOfNumber":
                return getTypeOfNumber();
            case "uid":
                return getUid();
            case "urlTemplate":
                return getUrlTemplate();
            case "username":
                return getUsername();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SMPPGatewayConfig.NOT_FOUND_VALUE);
        if (SMPPGatewayConfig.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SMPPGatewayConfig with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SMPPGatewayConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bindType");
        sb.append('=');
        sb.append(((this.bindType == null)?"<null>":this.bindType));
        sb.append(',');
        sb.append("compressed");
        sb.append('=');
        sb.append(((this.compressed == null)?"<null>":this.compressed));
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(((this.host == null)?"<null>":this.host));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("isDefault");
        sb.append('=');
        sb.append(((this.isDefault == null)?"<null>":this.isDefault));
        sb.append(',');
        sb.append("maxSmsLength");
        sb.append('=');
        sb.append(((this.maxSmsLength == null)?"<null>":this.maxSmsLength));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("numberPlanIndicator");
        sb.append('=');
        sb.append(((this.numberPlanIndicator == null)?"<null>":this.numberPlanIndicator));
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(((this.password == null)?"<null>":this.password));
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(((this.port == null)?"<null>":this.port));
        sb.append(',');
        sb.append("sendUrlParameters");
        sb.append('=');
        sb.append(((this.sendUrlParameters == null)?"<null>":this.sendUrlParameters));
        sb.append(',');
        sb.append("systemId");
        sb.append('=');
        sb.append(((this.systemId == null)?"<null>":this.systemId));
        sb.append(',');
        sb.append("systemType");
        sb.append('=');
        sb.append(((this.systemType == null)?"<null>":this.systemType));
        sb.append(',');
        sb.append("typeOfNumber");
        sb.append('=');
        sb.append(((this.typeOfNumber == null)?"<null>":this.typeOfNumber));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("urlTemplate");
        sb.append('=');
        sb.append(((this.urlTemplate == null)?"<null>":this.urlTemplate));
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(((this.username == null)?"<null>":this.username));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.numberPlanIndicator == null)? 0 :this.numberPlanIndicator.hashCode()));
        result = ((result* 31)+((this.systemId == null)? 0 :this.systemId.hashCode()));
        result = ((result* 31)+((this.urlTemplate == null)? 0 :this.urlTemplate.hashCode()));
        result = ((result* 31)+((this.bindType == null)? 0 :this.bindType.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.isDefault == null)? 0 :this.isDefault.hashCode()));
        result = ((result* 31)+((this.password == null)? 0 :this.password.hashCode()));
        result = ((result* 31)+((this.maxSmsLength == null)? 0 :this.maxSmsLength.hashCode()));
        result = ((result* 31)+((this.typeOfNumber == null)? 0 :this.typeOfNumber.hashCode()));
        result = ((result* 31)+((this.port == null)? 0 :this.port.hashCode()));
        result = ((result* 31)+((this.sendUrlParameters == null)? 0 :this.sendUrlParameters.hashCode()));
        result = ((result* 31)+((this.host == null)? 0 :this.host.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.systemType == null)? 0 :this.systemType.hashCode()));
        result = ((result* 31)+((this.compressed == null)? 0 :this.compressed.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.username == null)? 0 :this.username.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SMPPGatewayConfig) == false) {
            return false;
        }
        SMPPGatewayConfig rhs = ((SMPPGatewayConfig) other);
        return (((((((((((((((((((this.numberPlanIndicator == rhs.numberPlanIndicator)||((this.numberPlanIndicator!= null)&&this.numberPlanIndicator.equals(rhs.numberPlanIndicator)))&&((this.systemId == rhs.systemId)||((this.systemId!= null)&&this.systemId.equals(rhs.systemId))))&&((this.urlTemplate == rhs.urlTemplate)||((this.urlTemplate!= null)&&this.urlTemplate.equals(rhs.urlTemplate))))&&((this.bindType == rhs.bindType)||((this.bindType!= null)&&this.bindType.equals(rhs.bindType))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.isDefault == rhs.isDefault)||((this.isDefault!= null)&&this.isDefault.equals(rhs.isDefault))))&&((this.password == rhs.password)||((this.password!= null)&&this.password.equals(rhs.password))))&&((this.maxSmsLength == rhs.maxSmsLength)||((this.maxSmsLength!= null)&&this.maxSmsLength.equals(rhs.maxSmsLength))))&&((this.typeOfNumber == rhs.typeOfNumber)||((this.typeOfNumber!= null)&&this.typeOfNumber.equals(rhs.typeOfNumber))))&&((this.port == rhs.port)||((this.port!= null)&&this.port.equals(rhs.port))))&&((this.sendUrlParameters == rhs.sendUrlParameters)||((this.sendUrlParameters!= null)&&this.sendUrlParameters.equals(rhs.sendUrlParameters))))&&((this.host == rhs.host)||((this.host!= null)&&this.host.equals(rhs.host))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.systemType == rhs.systemType)||((this.systemType!= null)&&this.systemType.equals(rhs.systemType))))&&((this.compressed == rhs.compressed)||((this.compressed!= null)&&this.compressed.equals(rhs.compressed))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.username == rhs.username)||((this.username!= null)&&this.username.equals(rhs.username))));
    }

    @Generated("jsonschema2pojo")
    public enum BindType {

        BIND_TX("BIND_TX"),
        BIND_RX("BIND_RX"),
        BIND_TRX("BIND_TRX");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.BindType> CONSTANTS = new HashMap<String, SMPPGatewayConfig.BindType>();

        static {
            for (SMPPGatewayConfig.BindType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        BindType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.BindType fromValue(String value) {
            SMPPGatewayConfig.BindType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum NumberPlanIndicator {

        UNKNOWN("UNKNOWN"),
        ISDN("ISDN"),
        DATA("DATA"),
        TELEX("TELEX"),
        LAND_MOBILE("LAND_MOBILE"),
        NATIONAL("NATIONAL"),
        PRIVATE("PRIVATE"),
        ERMES("ERMES"),
        INTERNET("INTERNET"),
        WAP("WAP");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.NumberPlanIndicator> CONSTANTS = new HashMap<String, SMPPGatewayConfig.NumberPlanIndicator>();

        static {
            for (SMPPGatewayConfig.NumberPlanIndicator c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NumberPlanIndicator(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.NumberPlanIndicator fromValue(String value) {
            SMPPGatewayConfig.NumberPlanIndicator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TypeOfNumber {

        UNKNOWN("UNKNOWN"),
        INTERNATIONAL("INTERNATIONAL"),
        NATIONAL("NATIONAL"),
        NETWORK_SPECIFIC("NETWORK_SPECIFIC"),
        SUBSCRIBER_NUMBER("SUBSCRIBER_NUMBER"),
        ALPHANUMERIC("ALPHANUMERIC"),
        ABBREVIATED("ABBREVIATED");
        private final String value;
        private final static Map<String, SMPPGatewayConfig.TypeOfNumber> CONSTANTS = new HashMap<String, SMPPGatewayConfig.TypeOfNumber>();

        static {
            for (SMPPGatewayConfig.TypeOfNumber c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeOfNumber(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SMPPGatewayConfig.TypeOfNumber fromValue(String value) {
            SMPPGatewayConfig.TypeOfNumber constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
