
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "external",
    "owner",
    "public",
    "userGroups",
    "users"
})
@Generated("jsonschema2pojo")
public class Sharing implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("external")
    private Boolean external;
    @JsonProperty("owner")
    private String owner;
    @JsonProperty("public")
    private String _public;
    @JsonProperty("userGroups")
    private UserGroups userGroups;
    @JsonProperty("users")
    private Users users;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8660574617921267586L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Sharing() {
    }

    /**
     * 
     * @param source
     */
    public Sharing(Sharing source) {
        super();
        this.external = source.external;
        this.owner = source.owner;
        this._public = source._public;
        this.userGroups = source.userGroups;
        this.users = source.users;
    }

    /**
     * 
     * @param owner
     * @param userGroups
     * @param external
     * @param _public
     * @param users
     */
    public Sharing(Boolean external, String owner, String _public, UserGroups userGroups, Users users) {
        super();
        this.external = external;
        this.owner = owner;
        this._public = _public;
        this.userGroups = userGroups;
        this.users = users;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("external")
    public Boolean getExternal() {
        return external;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("external")
    public void setExternal(Boolean external) {
        this.external = external;
    }

    public Sharing withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    @JsonProperty("owner")
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    @JsonProperty("owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Sharing withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty("public")
    public Optional<String> getPublic() {
        return Optional.ofNullable(_public);
    }

    @JsonProperty("public")
    public void setPublic(String _public) {
        this._public = _public;
    }

    public Sharing withPublic(String _public) {
        this._public = _public;
        return this;
    }

    @JsonProperty("userGroups")
    public Optional<UserGroups> getUserGroups() {
        return Optional.ofNullable(userGroups);
    }

    @JsonProperty("userGroups")
    public void setUserGroups(UserGroups userGroups) {
        this.userGroups = userGroups;
    }

    public Sharing withUserGroups(UserGroups userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    @JsonProperty("users")
    public Optional<Users> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(Users users) {
        this.users = users;
    }

    public Sharing withUsers(Users users) {
        this.users = users;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Sharing withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "external":
                if (value instanceof Boolean) {
                    setExternal(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"external\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "owner":
                if (value instanceof String) {
                    setOwner(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"owner\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "public":
                if (value instanceof String) {
                    setPublic(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"public\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroups":
                if (value instanceof UserGroups) {
                    setUserGroups(((UserGroups) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroups\" is of type \"org.hisp.dhis.api.model.v40_0.UserGroups\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof Users) {
                    setUsers(((Users) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"org.hisp.dhis.api.model.v40_0.Users\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "external":
                return getExternal();
            case "owner":
                return getOwner();
            case "public":
                return getPublic();
            case "userGroups":
                return getUserGroups();
            case "users":
                return getUsers();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Sharing.NOT_FOUND_VALUE);
        if (Sharing.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Sharing with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Sharing.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("external");
        sb.append('=');
        sb.append(((this.external == null)?"<null>":this.external));
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(((this.owner == null)?"<null>":this.owner));
        sb.append(',');
        sb.append("_public");
        sb.append('=');
        sb.append(((this._public == null)?"<null>":this._public));
        sb.append(',');
        sb.append("userGroups");
        sb.append('=');
        sb.append(((this.userGroups == null)?"<null>":this.userGroups));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.owner == null)? 0 :this.owner.hashCode()));
        result = ((result* 31)+((this.userGroups == null)? 0 :this.userGroups.hashCode()));
        result = ((result* 31)+((this.external == null)? 0 :this.external.hashCode()));
        result = ((result* 31)+((this._public == null)? 0 :this._public.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Sharing) == false) {
            return false;
        }
        Sharing rhs = ((Sharing) other);
        return (((((((this.owner == rhs.owner)||((this.owner!= null)&&this.owner.equals(rhs.owner)))&&((this.userGroups == rhs.userGroups)||((this.userGroups!= null)&&this.userGroups.equals(rhs.userGroups))))&&((this.external == rhs.external)||((this.external!= null)&&this.external.equals(rhs.external))))&&((this._public == rhs._public)||((this._public!= null)&&this._public.equals(rhs._public))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))));
    }

}
