
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryOptionComboIdScheme",
    "dataElementIdScheme",
    "idScheme",
    "orgUnitIdScheme"
})
@Generated("jsonschema2pojo")
public class TargetRequest implements Serializable
{

    @JsonProperty("categoryOptionComboIdScheme")
    private String categoryOptionComboIdScheme;
    @JsonProperty("dataElementIdScheme")
    private String dataElementIdScheme;
    @JsonProperty("idScheme")
    private String idScheme;
    @JsonProperty("orgUnitIdScheme")
    private String orgUnitIdScheme;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4680703950525488231L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TargetRequest() {
    }

    /**
     * 
     * @param source
     */
    public TargetRequest(TargetRequest source) {
        super();
        this.categoryOptionComboIdScheme = source.categoryOptionComboIdScheme;
        this.dataElementIdScheme = source.dataElementIdScheme;
        this.idScheme = source.idScheme;
        this.orgUnitIdScheme = source.orgUnitIdScheme;
    }

    /**
     * 
     * @param dataElementIdScheme
     * @param idScheme
     * @param orgUnitIdScheme
     * @param categoryOptionComboIdScheme
     */
    public TargetRequest(String categoryOptionComboIdScheme, String dataElementIdScheme, String idScheme, String orgUnitIdScheme) {
        super();
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        this.dataElementIdScheme = dataElementIdScheme;
        this.idScheme = idScheme;
        this.orgUnitIdScheme = orgUnitIdScheme;
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public Optional<String> getCategoryOptionComboIdScheme() {
        return Optional.ofNullable(categoryOptionComboIdScheme);
    }

    @JsonProperty("categoryOptionComboIdScheme")
    public void setCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
    }

    public TargetRequest withCategoryOptionComboIdScheme(String categoryOptionComboIdScheme) {
        this.categoryOptionComboIdScheme = categoryOptionComboIdScheme;
        return this;
    }

    @JsonProperty("dataElementIdScheme")
    public Optional<String> getDataElementIdScheme() {
        return Optional.ofNullable(dataElementIdScheme);
    }

    @JsonProperty("dataElementIdScheme")
    public void setDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
    }

    public TargetRequest withDataElementIdScheme(String dataElementIdScheme) {
        this.dataElementIdScheme = dataElementIdScheme;
        return this;
    }

    @JsonProperty("idScheme")
    public Optional<String> getIdScheme() {
        return Optional.ofNullable(idScheme);
    }

    @JsonProperty("idScheme")
    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public TargetRequest withIdScheme(String idScheme) {
        this.idScheme = idScheme;
        return this;
    }

    @JsonProperty("orgUnitIdScheme")
    public Optional<String> getOrgUnitIdScheme() {
        return Optional.ofNullable(orgUnitIdScheme);
    }

    @JsonProperty("orgUnitIdScheme")
    public void setOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
    }

    public TargetRequest withOrgUnitIdScheme(String orgUnitIdScheme) {
        this.orgUnitIdScheme = orgUnitIdScheme;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TargetRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "categoryOptionComboIdScheme":
                if (value instanceof String) {
                    setCategoryOptionComboIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataElementIdScheme":
                if (value instanceof String) {
                    setDataElementIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElementIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "idScheme":
                if (value instanceof String) {
                    setIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"idScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitIdScheme":
                if (value instanceof String) {
                    setOrgUnitIdScheme(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitIdScheme\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "categoryOptionComboIdScheme":
                return getCategoryOptionComboIdScheme();
            case "dataElementIdScheme":
                return getDataElementIdScheme();
            case "idScheme":
                return getIdScheme();
            case "orgUnitIdScheme":
                return getOrgUnitIdScheme();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TargetRequest.NOT_FOUND_VALUE);
        if (TargetRequest.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TargetRequest with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TargetRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryOptionComboIdScheme");
        sb.append('=');
        sb.append(((this.categoryOptionComboIdScheme == null)?"<null>":this.categoryOptionComboIdScheme));
        sb.append(',');
        sb.append("dataElementIdScheme");
        sb.append('=');
        sb.append(((this.dataElementIdScheme == null)?"<null>":this.dataElementIdScheme));
        sb.append(',');
        sb.append("idScheme");
        sb.append('=');
        sb.append(((this.idScheme == null)?"<null>":this.idScheme));
        sb.append(',');
        sb.append("orgUnitIdScheme");
        sb.append('=');
        sb.append(((this.orgUnitIdScheme == null)?"<null>":this.orgUnitIdScheme));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementIdScheme == null)? 0 :this.dataElementIdScheme.hashCode()));
        result = ((result* 31)+((this.idScheme == null)? 0 :this.idScheme.hashCode()));
        result = ((result* 31)+((this.orgUnitIdScheme == null)? 0 :this.orgUnitIdScheme.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboIdScheme == null)? 0 :this.categoryOptionComboIdScheme.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TargetRequest) == false) {
            return false;
        }
        TargetRequest rhs = ((TargetRequest) other);
        return ((((((this.dataElementIdScheme == rhs.dataElementIdScheme)||((this.dataElementIdScheme!= null)&&this.dataElementIdScheme.equals(rhs.dataElementIdScheme)))&&((this.idScheme == rhs.idScheme)||((this.idScheme!= null)&&this.idScheme.equals(rhs.idScheme))))&&((this.orgUnitIdScheme == rhs.orgUnitIdScheme)||((this.orgUnitIdScheme!= null)&&this.orgUnitIdScheme.equals(rhs.orgUnitIdScheme))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboIdScheme == rhs.categoryOptionComboIdScheme)||((this.categoryOptionComboIdScheme!= null)&&this.categoryOptionComboIdScheme.equals(rhs.categoryOptionComboIdScheme))));
    }

}
