
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "failAtItem",
    "failAtStage",
    "failWithException",
    "failWithMessage",
    "failWithPolicy",
    "itemDuration",
    "items",
    "runStagesParallel",
    "stages",
    "waitMillis"
})
@Generated("jsonschema2pojo")
public class TestJobParameters implements Serializable
{

    @JsonProperty("failAtItem")
    private Integer failAtItem;
    @JsonProperty("failAtStage")
    private Integer failAtStage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithException")
    private Boolean failWithException;
    @JsonProperty("failWithMessage")
    private String failWithMessage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithPolicy")
    private TestJobParameters.FailWithPolicy failWithPolicy;
    @JsonProperty("itemDuration")
    private Integer itemDuration;
    @JsonProperty("items")
    private Integer items;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("runStagesParallel")
    private Boolean runStagesParallel;
    @JsonProperty("stages")
    private Integer stages;
    @JsonProperty("waitMillis")
    private Integer waitMillis;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6608847708396769959L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TestJobParameters() {
    }

    /**
     * 
     * @param source
     */
    public TestJobParameters(TestJobParameters source) {
        super();
        this.failAtItem = source.failAtItem;
        this.failAtStage = source.failAtStage;
        this.failWithException = source.failWithException;
        this.failWithMessage = source.failWithMessage;
        this.failWithPolicy = source.failWithPolicy;
        this.itemDuration = source.itemDuration;
        this.items = source.items;
        this.runStagesParallel = source.runStagesParallel;
        this.stages = source.stages;
        this.waitMillis = source.waitMillis;
    }

    /**
     * 
     * @param runStagesParallel
     * @param failWithPolicy
     * @param waitMillis
     * @param stages
     * @param failAtItem
     * @param failWithException
     * @param items
     * @param failWithMessage
     * @param itemDuration
     * @param failAtStage
     */
    public TestJobParameters(Integer failAtItem, Integer failAtStage, Boolean failWithException, String failWithMessage, TestJobParameters.FailWithPolicy failWithPolicy, Integer itemDuration, Integer items, Boolean runStagesParallel, Integer stages, Integer waitMillis) {
        super();
        this.failAtItem = failAtItem;
        this.failAtStage = failAtStage;
        this.failWithException = failWithException;
        this.failWithMessage = failWithMessage;
        this.failWithPolicy = failWithPolicy;
        this.itemDuration = itemDuration;
        this.items = items;
        this.runStagesParallel = runStagesParallel;
        this.stages = stages;
        this.waitMillis = waitMillis;
    }

    @JsonProperty("failAtItem")
    public Optional<Integer> getFailAtItem() {
        return Optional.ofNullable(failAtItem);
    }

    @JsonProperty("failAtItem")
    public void setFailAtItem(Integer failAtItem) {
        this.failAtItem = failAtItem;
    }

    public TestJobParameters withFailAtItem(Integer failAtItem) {
        this.failAtItem = failAtItem;
        return this;
    }

    @JsonProperty("failAtStage")
    public Optional<Integer> getFailAtStage() {
        return Optional.ofNullable(failAtStage);
    }

    @JsonProperty("failAtStage")
    public void setFailAtStage(Integer failAtStage) {
        this.failAtStage = failAtStage;
    }

    public TestJobParameters withFailAtStage(Integer failAtStage) {
        this.failAtStage = failAtStage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithException")
    public Boolean getFailWithException() {
        return failWithException;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithException")
    public void setFailWithException(Boolean failWithException) {
        this.failWithException = failWithException;
    }

    public TestJobParameters withFailWithException(Boolean failWithException) {
        this.failWithException = failWithException;
        return this;
    }

    @JsonProperty("failWithMessage")
    public Optional<String> getFailWithMessage() {
        return Optional.ofNullable(failWithMessage);
    }

    @JsonProperty("failWithMessage")
    public void setFailWithMessage(String failWithMessage) {
        this.failWithMessage = failWithMessage;
    }

    public TestJobParameters withFailWithMessage(String failWithMessage) {
        this.failWithMessage = failWithMessage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithPolicy")
    public TestJobParameters.FailWithPolicy getFailWithPolicy() {
        return failWithPolicy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("failWithPolicy")
    public void setFailWithPolicy(TestJobParameters.FailWithPolicy failWithPolicy) {
        this.failWithPolicy = failWithPolicy;
    }

    public TestJobParameters withFailWithPolicy(TestJobParameters.FailWithPolicy failWithPolicy) {
        this.failWithPolicy = failWithPolicy;
        return this;
    }

    @JsonProperty("itemDuration")
    public Optional<Integer> getItemDuration() {
        return Optional.ofNullable(itemDuration);
    }

    @JsonProperty("itemDuration")
    public void setItemDuration(Integer itemDuration) {
        this.itemDuration = itemDuration;
    }

    public TestJobParameters withItemDuration(Integer itemDuration) {
        this.itemDuration = itemDuration;
        return this;
    }

    @JsonProperty("items")
    public Optional<Integer> getItems() {
        return Optional.ofNullable(items);
    }

    @JsonProperty("items")
    public void setItems(Integer items) {
        this.items = items;
    }

    public TestJobParameters withItems(Integer items) {
        this.items = items;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("runStagesParallel")
    public Boolean getRunStagesParallel() {
        return runStagesParallel;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("runStagesParallel")
    public void setRunStagesParallel(Boolean runStagesParallel) {
        this.runStagesParallel = runStagesParallel;
    }

    public TestJobParameters withRunStagesParallel(Boolean runStagesParallel) {
        this.runStagesParallel = runStagesParallel;
        return this;
    }

    @JsonProperty("stages")
    public Optional<Integer> getStages() {
        return Optional.ofNullable(stages);
    }

    @JsonProperty("stages")
    public void setStages(Integer stages) {
        this.stages = stages;
    }

    public TestJobParameters withStages(Integer stages) {
        this.stages = stages;
        return this;
    }

    @JsonProperty("waitMillis")
    public Optional<Integer> getWaitMillis() {
        return Optional.ofNullable(waitMillis);
    }

    @JsonProperty("waitMillis")
    public void setWaitMillis(Integer waitMillis) {
        this.waitMillis = waitMillis;
    }

    public TestJobParameters withWaitMillis(Integer waitMillis) {
        this.waitMillis = waitMillis;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TestJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "failAtItem":
                if (value instanceof Integer) {
                    setFailAtItem(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"failAtItem\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "failAtStage":
                if (value instanceof Integer) {
                    setFailAtStage(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"failAtStage\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "failWithException":
                if (value instanceof Boolean) {
                    setFailWithException(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"failWithException\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "failWithMessage":
                if (value instanceof String) {
                    setFailWithMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"failWithMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "failWithPolicy":
                if (value instanceof TestJobParameters.FailWithPolicy) {
                    setFailWithPolicy(((TestJobParameters.FailWithPolicy) value));
                } else {
                    throw new IllegalArgumentException(("property \"failWithPolicy\" is of type \"org.hisp.dhis.api.model.v40_0.TestJobParameters.FailWithPolicy\", but got "+ value.getClass().toString()));
                }
                return true;
            case "itemDuration":
                if (value instanceof Integer) {
                    setItemDuration(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"itemDuration\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof Integer) {
                    setItems(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "runStagesParallel":
                if (value instanceof Boolean) {
                    setRunStagesParallel(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"runStagesParallel\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "stages":
                if (value instanceof Integer) {
                    setStages(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"stages\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "waitMillis":
                if (value instanceof Integer) {
                    setWaitMillis(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"waitMillis\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "failAtItem":
                return getFailAtItem();
            case "failAtStage":
                return getFailAtStage();
            case "failWithException":
                return getFailWithException();
            case "failWithMessage":
                return getFailWithMessage();
            case "failWithPolicy":
                return getFailWithPolicy();
            case "itemDuration":
                return getItemDuration();
            case "items":
                return getItems();
            case "runStagesParallel":
                return getRunStagesParallel();
            case "stages":
                return getStages();
            case "waitMillis":
                return getWaitMillis();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TestJobParameters.NOT_FOUND_VALUE);
        if (TestJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TestJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("failAtItem");
        sb.append('=');
        sb.append(((this.failAtItem == null)?"<null>":this.failAtItem));
        sb.append(',');
        sb.append("failAtStage");
        sb.append('=');
        sb.append(((this.failAtStage == null)?"<null>":this.failAtStage));
        sb.append(',');
        sb.append("failWithException");
        sb.append('=');
        sb.append(((this.failWithException == null)?"<null>":this.failWithException));
        sb.append(',');
        sb.append("failWithMessage");
        sb.append('=');
        sb.append(((this.failWithMessage == null)?"<null>":this.failWithMessage));
        sb.append(',');
        sb.append("failWithPolicy");
        sb.append('=');
        sb.append(((this.failWithPolicy == null)?"<null>":this.failWithPolicy));
        sb.append(',');
        sb.append("itemDuration");
        sb.append('=');
        sb.append(((this.itemDuration == null)?"<null>":this.itemDuration));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("runStagesParallel");
        sb.append('=');
        sb.append(((this.runStagesParallel == null)?"<null>":this.runStagesParallel));
        sb.append(',');
        sb.append("stages");
        sb.append('=');
        sb.append(((this.stages == null)?"<null>":this.stages));
        sb.append(',');
        sb.append("waitMillis");
        sb.append('=');
        sb.append(((this.waitMillis == null)?"<null>":this.waitMillis));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.waitMillis == null)? 0 :this.waitMillis.hashCode()));
        result = ((result* 31)+((this.failWithException == null)? 0 :this.failWithException.hashCode()));
        result = ((result* 31)+((this.runStagesParallel == null)? 0 :this.runStagesParallel.hashCode()));
        result = ((result* 31)+((this.failWithPolicy == null)? 0 :this.failWithPolicy.hashCode()));
        result = ((result* 31)+((this.stages == null)? 0 :this.stages.hashCode()));
        result = ((result* 31)+((this.failAtItem == null)? 0 :this.failAtItem.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.failWithMessage == null)? 0 :this.failWithMessage.hashCode()));
        result = ((result* 31)+((this.itemDuration == null)? 0 :this.itemDuration.hashCode()));
        result = ((result* 31)+((this.failAtStage == null)? 0 :this.failAtStage.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TestJobParameters) == false) {
            return false;
        }
        TestJobParameters rhs = ((TestJobParameters) other);
        return ((((((((((((this.waitMillis == rhs.waitMillis)||((this.waitMillis!= null)&&this.waitMillis.equals(rhs.waitMillis)))&&((this.failWithException == rhs.failWithException)||((this.failWithException!= null)&&this.failWithException.equals(rhs.failWithException))))&&((this.runStagesParallel == rhs.runStagesParallel)||((this.runStagesParallel!= null)&&this.runStagesParallel.equals(rhs.runStagesParallel))))&&((this.failWithPolicy == rhs.failWithPolicy)||((this.failWithPolicy!= null)&&this.failWithPolicy.equals(rhs.failWithPolicy))))&&((this.stages == rhs.stages)||((this.stages!= null)&&this.stages.equals(rhs.stages))))&&((this.failAtItem == rhs.failAtItem)||((this.failAtItem!= null)&&this.failAtItem.equals(rhs.failAtItem))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.failWithMessage == rhs.failWithMessage)||((this.failWithMessage!= null)&&this.failWithMessage.equals(rhs.failWithMessage))))&&((this.itemDuration == rhs.itemDuration)||((this.itemDuration!= null)&&this.itemDuration.equals(rhs.itemDuration))))&&((this.failAtStage == rhs.failAtStage)||((this.failAtStage!= null)&&this.failAtStage.equals(rhs.failAtStage))));
    }

    @Generated("jsonschema2pojo")
    public enum FailWithPolicy {

        PARENT("PARENT"),
        FAIL("FAIL"),
        SKIP_STAGE("SKIP_STAGE"),
        SKIP_ITEM("SKIP_ITEM"),
        SKIP_ITEM_OUTLIER("SKIP_ITEM_OUTLIER");
        private final String value;
        private final static Map<String, TestJobParameters.FailWithPolicy> CONSTANTS = new HashMap<String, TestJobParameters.FailWithPolicy>();

        static {
            for (TestJobParameters.FailWithPolicy c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FailWithPolicy(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TestJobParameters.FailWithPolicy fromValue(String value) {
            TestJobParameters.FailWithPolicy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
