
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "filter",
    "legendSet",
    "programIndicator"
})
@Generated("jsonschema2pojo")
public class TrackedEntityProgramIndicatorDimension implements Serializable
{

    @JsonProperty("filter")
    private String filter;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private RefLegendSet legendSet;
    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    @JsonPropertyDescription("A UID reference to a ProgramIndicator  \n(Java name `org.hisp.dhis.program.ProgramIndicator`)")
    private RefProgramIndicator programIndicator;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6825810046233864061L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityProgramIndicatorDimension() {
    }

    /**
     * 
     * @param source
     */
    public TrackedEntityProgramIndicatorDimension(TrackedEntityProgramIndicatorDimension source) {
        super();
        this.filter = source.filter;
        this.legendSet = source.legendSet;
        this.programIndicator = source.programIndicator;
    }

    /**
     * 
     * @param filter
     * @param legendSet
     * @param programIndicator
     */
    public TrackedEntityProgramIndicatorDimension(String filter, RefLegendSet legendSet, RefProgramIndicator programIndicator) {
        super();
        this.filter = filter;
        this.legendSet = legendSet;
        this.programIndicator = programIndicator;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public TrackedEntityProgramIndicatorDimension withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<RefLegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public TrackedEntityProgramIndicatorDimension withLegendSet(RefLegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public Optional<RefProgramIndicator> getProgramIndicator() {
        return Optional.ofNullable(programIndicator);
    }

    /**
     * A UID reference to a ProgramIndicator  
     * (Java name `org.hisp.dhis.program.ProgramIndicator`)
     * 
     */
    @JsonProperty("programIndicator")
    public void setProgramIndicator(RefProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
    }

    public TrackedEntityProgramIndicatorDimension withProgramIndicator(RefProgramIndicator programIndicator) {
        this.programIndicator = programIndicator;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityProgramIndicatorDimension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "filter":
                if (value instanceof String) {
                    setFilter(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof RefLegendSet) {
                    setLegendSet(((RefLegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_0.RefLegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programIndicator":
                if (value instanceof RefProgramIndicator) {
                    setProgramIndicator(((RefProgramIndicator) value));
                } else {
                    throw new IllegalArgumentException(("property \"programIndicator\" is of type \"org.hisp.dhis.api.model.v40_0.RefProgramIndicator\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "filter":
                return getFilter();
            case "legendSet":
                return getLegendSet();
            case "programIndicator":
                return getProgramIndicator();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityProgramIndicatorDimension.NOT_FOUND_VALUE);
        if (TrackedEntityProgramIndicatorDimension.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityProgramIndicatorDimension with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityProgramIndicatorDimension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("programIndicator");
        sb.append('=');
        sb.append(((this.programIndicator == null)?"<null>":this.programIndicator));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.programIndicator == null)? 0 :this.programIndicator.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityProgramIndicatorDimension) == false) {
            return false;
        }
        TrackedEntityProgramIndicatorDimension rhs = ((TrackedEntityProgramIndicatorDimension) other);
        return (((((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter)))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.programIndicator == rhs.programIndicator)||((this.programIndicator!= null)&&this.programIndicator.equals(rhs.programIndicator))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
