
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bundleReport",
    "message",
    "stats",
    "status",
    "timingsStats",
    "validationReport"
})
@Generated("jsonschema2pojo")
public class TrackerReportImportReport implements Serializable
{

    @JsonProperty("bundleReport")
    private PersistenceReport bundleReport;
    @JsonProperty("message")
    private String message;
    @JsonProperty("stats")
    private TrackerReportStats stats;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private TrackerReportImportReport.Status status;
    @JsonProperty("timingsStats")
    private TimingsStats timingsStats;
    @JsonProperty("validationReport")
    private ValidationReport validationReport;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1929805043775490788L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerReportImportReport() {
    }

    /**
     * 
     * @param source
     */
    public TrackerReportImportReport(TrackerReportImportReport source) {
        super();
        this.bundleReport = source.bundleReport;
        this.message = source.message;
        this.stats = source.stats;
        this.status = source.status;
        this.timingsStats = source.timingsStats;
        this.validationReport = source.validationReport;
    }

    /**
     * 
     * @param bundleReport
     * @param stats
     * @param validationReport
     * @param message
     * @param timingsStats
     * @param status
     */
    public TrackerReportImportReport(PersistenceReport bundleReport, String message, TrackerReportStats stats, TrackerReportImportReport.Status status, TimingsStats timingsStats, ValidationReport validationReport) {
        super();
        this.bundleReport = bundleReport;
        this.message = message;
        this.stats = stats;
        this.status = status;
        this.timingsStats = timingsStats;
        this.validationReport = validationReport;
    }

    @JsonProperty("bundleReport")
    public Optional<PersistenceReport> getBundleReport() {
        return Optional.ofNullable(bundleReport);
    }

    @JsonProperty("bundleReport")
    public void setBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
    }

    public TrackerReportImportReport withBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerReportImportReport withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("stats")
    public Optional<TrackerReportStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerReportStats stats) {
        this.stats = stats;
    }

    public TrackerReportImportReport withStats(TrackerReportStats stats) {
        this.stats = stats;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public TrackerReportImportReport.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(TrackerReportImportReport.Status status) {
        this.status = status;
    }

    public TrackerReportImportReport withStatus(TrackerReportImportReport.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("timingsStats")
    public Optional<TimingsStats> getTimingsStats() {
        return Optional.ofNullable(timingsStats);
    }

    @JsonProperty("timingsStats")
    public void setTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
    }

    public TrackerReportImportReport withTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
        return this;
    }

    @JsonProperty("validationReport")
    public Optional<ValidationReport> getValidationReport() {
        return Optional.ofNullable(validationReport);
    }

    @JsonProperty("validationReport")
    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public TrackerReportImportReport withValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerReportImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "bundleReport":
                if (value instanceof PersistenceReport) {
                    setBundleReport(((PersistenceReport) value));
                } else {
                    throw new IllegalArgumentException(("property \"bundleReport\" is of type \"org.hisp.dhis.api.model.v40_0.PersistenceReport\", but got "+ value.getClass().toString()));
                }
                return true;
            case "message":
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "stats":
                if (value instanceof TrackerReportStats) {
                    setStats(((TrackerReportStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_0.TrackerReportStats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof TrackerReportImportReport.Status) {
                    setStatus(((TrackerReportImportReport.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.TrackerReportImportReport.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "timingsStats":
                if (value instanceof TimingsStats) {
                    setTimingsStats(((TimingsStats) value));
                } else {
                    throw new IllegalArgumentException(("property \"timingsStats\" is of type \"org.hisp.dhis.api.model.v40_0.TimingsStats\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationReport":
                if (value instanceof ValidationReport) {
                    setValidationReport(((ValidationReport) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationReport\" is of type \"org.hisp.dhis.api.model.v40_0.ValidationReport\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "bundleReport":
                return getBundleReport();
            case "message":
                return getMessage();
            case "stats":
                return getStats();
            case "status":
                return getStatus();
            case "timingsStats":
                return getTimingsStats();
            case "validationReport":
                return getValidationReport();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerReportImportReport.NOT_FOUND_VALUE);
        if (TrackerReportImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerReportImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerReportImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bundleReport");
        sb.append('=');
        sb.append(((this.bundleReport == null)?"<null>":this.bundleReport));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("timingsStats");
        sb.append('=');
        sb.append(((this.timingsStats == null)?"<null>":this.timingsStats));
        sb.append(',');
        sb.append("validationReport");
        sb.append('=');
        sb.append(((this.validationReport == null)?"<null>":this.validationReport));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.bundleReport == null)? 0 :this.bundleReport.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.validationReport == null)? 0 :this.validationReport.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.timingsStats == null)? 0 :this.timingsStats.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerReportImportReport) == false) {
            return false;
        }
        TrackerReportImportReport rhs = ((TrackerReportImportReport) other);
        return ((((((((this.bundleReport == rhs.bundleReport)||((this.bundleReport!= null)&&this.bundleReport.equals(rhs.bundleReport)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.validationReport == rhs.validationReport)||((this.validationReport!= null)&&this.validationReport.equals(rhs.validationReport))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.timingsStats == rhs.timingsStats)||((this.timingsStats!= null)&&this.timingsStats.equals(rhs.timingsStats))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, TrackerReportImportReport.Status> CONSTANTS = new HashMap<String, TrackerReportImportReport.Status>();

        static {
            for (TrackerReportImportReport.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerReportImportReport.Status fromValue(String value) {
            TrackerReportImportReport.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
