
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionCombo",
    "created",
    "dayInPeriod",
    "id",
    "leftsideValue",
    "notificationSent",
    "organisationUnit",
    "period",
    "rightsideValue",
    "validationRule"
})
@Generated("jsonschema2pojo")
public class ValidationResult implements Serializable
{

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    @JsonPropertyDescription("A UID reference to a CategoryOptionCombo  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private RefCategoryOptionCombo attributeOptionCombo;
    @JsonProperty("created")
    private Date created;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dayInPeriod")
    private Integer dayInPeriod;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    private Integer id;
    @JsonProperty("leftsideValue")
    private Double leftsideValue;
    @JsonProperty("notificationSent")
    private Boolean notificationSent;
    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    @JsonPropertyDescription("A UID reference to a OrganisationUnit  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private RefOrganisationUnit organisationUnit;
    @JsonProperty("period")
    private String period;
    @JsonProperty("rightsideValue")
    private Double rightsideValue;
    /**
     * A UID reference to a ValidationRule  
     * (Java name `org.hisp.dhis.validation.ValidationRule`)
     * 
     */
    @JsonProperty("validationRule")
    @JsonPropertyDescription("A UID reference to a ValidationRule  \n(Java name `org.hisp.dhis.validation.ValidationRule`)")
    private RefValidationRule validationRule;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1070505105183234771L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationResult() {
    }

    /**
     * 
     * @param source
     */
    public ValidationResult(ValidationResult source) {
        super();
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.created = source.created;
        this.dayInPeriod = source.dayInPeriod;
        this.id = source.id;
        this.leftsideValue = source.leftsideValue;
        this.notificationSent = source.notificationSent;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.rightsideValue = source.rightsideValue;
        this.validationRule = source.validationRule;
    }

    /**
     * 
     * @param period
     * @param organisationUnit
     * @param created
     * @param validationRule
     * @param attributeOptionCombo
     * @param rightsideValue
     * @param id
     * @param leftsideValue
     * @param notificationSent
     * @param dayInPeriod
     */
    public ValidationResult(RefCategoryOptionCombo attributeOptionCombo, Date created, Integer dayInPeriod, Integer id, Double leftsideValue, Boolean notificationSent, RefOrganisationUnit organisationUnit, String period, Double rightsideValue, RefValidationRule validationRule) {
        super();
        this.attributeOptionCombo = attributeOptionCombo;
        this.created = created;
        this.dayInPeriod = dayInPeriod;
        this.id = id;
        this.leftsideValue = leftsideValue;
        this.notificationSent = notificationSent;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.rightsideValue = rightsideValue;
        this.validationRule = validationRule;
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public Optional<RefCategoryOptionCombo> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(RefCategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public ValidationResult withAttributeOptionCombo(RefCategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ValidationResult withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dayInPeriod")
    public Integer getDayInPeriod() {
        return dayInPeriod;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dayInPeriod")
    public void setDayInPeriod(Integer dayInPeriod) {
        this.dayInPeriod = dayInPeriod;
    }

    public ValidationResult withDayInPeriod(Integer dayInPeriod) {
        this.dayInPeriod = dayInPeriod;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    public Integer getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ValidationResult withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty("leftsideValue")
    public Optional<Double> getLeftsideValue() {
        return Optional.ofNullable(leftsideValue);
    }

    @JsonProperty("leftsideValue")
    public void setLeftsideValue(Double leftsideValue) {
        this.leftsideValue = leftsideValue;
    }

    public ValidationResult withLeftsideValue(Double leftsideValue) {
        this.leftsideValue = leftsideValue;
        return this;
    }

    @JsonProperty("notificationSent")
    public Optional<Boolean> getNotificationSent() {
        return Optional.ofNullable(notificationSent);
    }

    @JsonProperty("notificationSent")
    public void setNotificationSent(Boolean notificationSent) {
        this.notificationSent = notificationSent;
    }

    public ValidationResult withNotificationSent(Boolean notificationSent) {
        this.notificationSent = notificationSent;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public Optional<RefOrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(RefOrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ValidationResult withOrganisationUnit(RefOrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public ValidationResult withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("rightsideValue")
    public Optional<Double> getRightsideValue() {
        return Optional.ofNullable(rightsideValue);
    }

    @JsonProperty("rightsideValue")
    public void setRightsideValue(Double rightsideValue) {
        this.rightsideValue = rightsideValue;
    }

    public ValidationResult withRightsideValue(Double rightsideValue) {
        this.rightsideValue = rightsideValue;
        return this;
    }

    /**
     * A UID reference to a ValidationRule  
     * (Java name `org.hisp.dhis.validation.ValidationRule`)
     * 
     */
    @JsonProperty("validationRule")
    public Optional<RefValidationRule> getValidationRule() {
        return Optional.ofNullable(validationRule);
    }

    /**
     * A UID reference to a ValidationRule  
     * (Java name `org.hisp.dhis.validation.ValidationRule`)
     * 
     */
    @JsonProperty("validationRule")
    public void setValidationRule(RefValidationRule validationRule) {
        this.validationRule = validationRule;
    }

    public ValidationResult withValidationRule(RefValidationRule validationRule) {
        this.validationRule = validationRule;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationResult withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributeOptionCombo":
                if (value instanceof RefCategoryOptionCombo) {
                    setAttributeOptionCombo(((RefCategoryOptionCombo) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v40_0.RefCategoryOptionCombo\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dayInPeriod":
                if (value instanceof Integer) {
                    setDayInPeriod(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"dayInPeriod\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof Integer) {
                    setId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "leftsideValue":
                if (value instanceof Double) {
                    setLeftsideValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"leftsideValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationSent":
                if (value instanceof Boolean) {
                    setNotificationSent(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationSent\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnit":
                if (value instanceof RefOrganisationUnit) {
                    setOrganisationUnit(((RefOrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v40_0.RefOrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "period":
                if (value instanceof String) {
                    setPeriod(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "rightsideValue":
                if (value instanceof Double) {
                    setRightsideValue(((Double) value));
                } else {
                    throw new IllegalArgumentException(("property \"rightsideValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                }
                return true;
            case "validationRule":
                if (value instanceof RefValidationRule) {
                    setValidationRule(((RefValidationRule) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRule\" is of type \"org.hisp.dhis.api.model.v40_0.RefValidationRule\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributeOptionCombo":
                return getAttributeOptionCombo();
            case "created":
                return getCreated();
            case "dayInPeriod":
                return getDayInPeriod();
            case "id":
                return getId();
            case "leftsideValue":
                return getLeftsideValue();
            case "notificationSent":
                return getNotificationSent();
            case "organisationUnit":
                return getOrganisationUnit();
            case "period":
                return getPeriod();
            case "rightsideValue":
                return getRightsideValue();
            case "validationRule":
                return getValidationRule();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationResult.NOT_FOUND_VALUE);
        if (ValidationResult.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationResult with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dayInPeriod");
        sb.append('=');
        sb.append(((this.dayInPeriod == null)?"<null>":this.dayInPeriod));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("leftsideValue");
        sb.append('=');
        sb.append(((this.leftsideValue == null)?"<null>":this.leftsideValue));
        sb.append(',');
        sb.append("notificationSent");
        sb.append('=');
        sb.append(((this.notificationSent == null)?"<null>":this.notificationSent));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("rightsideValue");
        sb.append('=');
        sb.append(((this.rightsideValue == null)?"<null>":this.rightsideValue));
        sb.append(',');
        sb.append("validationRule");
        sb.append('=');
        sb.append(((this.validationRule == null)?"<null>":this.validationRule));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.validationRule == null)? 0 :this.validationRule.hashCode()));
        result = ((result* 31)+((this.rightsideValue == null)? 0 :this.rightsideValue.hashCode()));
        result = ((result* 31)+((this.notificationSent == null)? 0 :this.notificationSent.hashCode()));
        result = ((result* 31)+((this.dayInPeriod == null)? 0 :this.dayInPeriod.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.leftsideValue == null)? 0 :this.leftsideValue.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationResult) == false) {
            return false;
        }
        ValidationResult rhs = ((ValidationResult) other);
        return ((((((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.validationRule == rhs.validationRule)||((this.validationRule!= null)&&this.validationRule.equals(rhs.validationRule))))&&((this.rightsideValue == rhs.rightsideValue)||((this.rightsideValue!= null)&&this.rightsideValue.equals(rhs.rightsideValue))))&&((this.notificationSent == rhs.notificationSent)||((this.notificationSent!= null)&&this.notificationSent.equals(rhs.notificationSent))))&&((this.dayInPeriod == rhs.dayInPeriod)||((this.dayInPeriod!= null)&&this.dayInPeriod.equals(rhs.dayInPeriod))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.leftsideValue == rhs.leftsideValue)||((this.leftsideValue!= null)&&this.leftsideValue.equals(rhs.leftsideValue))));
    }

}
