
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "message",
    "trackerType",
    "uid",
    "warningCode"
})
@Generated("jsonschema2pojo")
public class Warning implements Serializable
{

    @JsonProperty("message")
    private String message;
    @JsonProperty("trackerType")
    private String trackerType;
    @JsonProperty("uid")
    private String uid;
    @JsonProperty("warningCode")
    private String warningCode;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4998932994759271371L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Warning() {
    }

    /**
     * 
     * @param source
     */
    public Warning(Warning source) {
        super();
        this.message = source.message;
        this.trackerType = source.trackerType;
        this.uid = source.uid;
        this.warningCode = source.warningCode;
    }

    /**
     * 
     * @param uid
     * @param warningCode
     * @param trackerType
     * @param message
     */
    public Warning(String message, String trackerType, String uid, String warningCode) {
        super();
        this.message = message;
        this.trackerType = trackerType;
        this.uid = uid;
        this.warningCode = warningCode;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Warning withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("trackerType")
    public Optional<String> getTrackerType() {
        return Optional.ofNullable(trackerType);
    }

    @JsonProperty("trackerType")
    public void setTrackerType(String trackerType) {
        this.trackerType = trackerType;
    }

    public Warning withTrackerType(String trackerType) {
        this.trackerType = trackerType;
        return this;
    }

    @JsonProperty("uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public Warning withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonProperty("warningCode")
    public Optional<String> getWarningCode() {
        return Optional.ofNullable(warningCode);
    }

    @JsonProperty("warningCode")
    public void setWarningCode(String warningCode) {
        this.warningCode = warningCode;
    }

    public Warning withWarningCode(String warningCode) {
        this.warningCode = warningCode;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Warning withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "message":
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackerType":
                if (value instanceof String) {
                    setTrackerType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackerType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uid":
                if (value instanceof String) {
                    setUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"uid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "warningCode":
                if (value instanceof String) {
                    setWarningCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"warningCode\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "message":
                return getMessage();
            case "trackerType":
                return getTrackerType();
            case "uid":
                return getUid();
            case "warningCode":
                return getWarningCode();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Warning.NOT_FOUND_VALUE);
        if (Warning.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Warning with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Warning.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("trackerType");
        sb.append('=');
        sb.append(((this.trackerType == null)?"<null>":this.trackerType));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("warningCode");
        sb.append('=');
        sb.append(((this.warningCode == null)?"<null>":this.warningCode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.warningCode == null)? 0 :this.warningCode.hashCode()));
        result = ((result* 31)+((this.trackerType == null)? 0 :this.trackerType.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Warning) == false) {
            return false;
        }
        Warning rhs = ((Warning) other);
        return ((((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.warningCode == rhs.warningCode)||((this.warningCode!= null)&&this.warningCode.equals(rhs.warningCode))))&&((this.trackerType == rhs.trackerType)||((this.trackerType!= null)&&this.trackerType.equals(rhs.trackerType))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))));
    }

}
