
package org.hisp.dhis.api.model.v40_0;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "completedAt",
    "completedBy",
    "createdAt",
    "createdAtClient",
    "createdBy",
    "deleted",
    "enrolledAt",
    "enrollment",
    "events",
    "followUp",
    "geometry",
    "notes",
    "occurredAt",
    "orgUnit",
    "orgUnitName",
    "program",
    "relationships",
    "status",
    "storedBy",
    "trackedEntity",
    "updatedAt",
    "updatedAtClient",
    "updatedBy"
})
@Generated("jsonschema2pojo")
public class WebapiControllerTrackerViewEnrollment implements Serializable
{

    @JsonProperty("attributes")
    private List<WebapiControllerTrackerViewAttribute> attributes = null;
    @JsonProperty("completedAt")
    private Object completedAt;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("createdAt")
    private Object createdAt;
    @JsonProperty("createdAtClient")
    private Object createdAtClient;
    @JsonProperty("createdBy")
    private WebapiControllerTrackerViewUser createdBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    private Boolean deleted;
    @JsonProperty("enrolledAt")
    private Object enrolledAt;
    @JsonProperty("enrollment")
    private String enrollment;
    @JsonProperty("events")
    private List<WebapiControllerTrackerViewEvent> events = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("geometry")
    private Geometry__4 geometry;
    @JsonProperty("notes")
    private List<WebapiControllerTrackerViewNote> notes = null;
    @JsonProperty("occurredAt")
    private Object occurredAt;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("orgUnitName")
    private String orgUnitName;
    @JsonProperty("program")
    private String program;
    @JsonProperty("relationships")
    private List<WebapiControllerTrackerViewRelationship> relationships = null;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private WebapiControllerTrackerViewEnrollment.Status status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("trackedEntity")
    private String trackedEntity;
    @JsonProperty("updatedAt")
    private Object updatedAt;
    @JsonProperty("updatedAtClient")
    private Object updatedAtClient;
    @JsonProperty("updatedBy")
    private WebapiControllerTrackerViewUser updatedBy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2766428065636977231L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WebapiControllerTrackerViewEnrollment() {
    }

    /**
     * 
     * @param source
     */
    public WebapiControllerTrackerViewEnrollment(WebapiControllerTrackerViewEnrollment source) {
        super();
        this.attributes = source.attributes;
        this.completedAt = source.completedAt;
        this.completedBy = source.completedBy;
        this.createdAt = source.createdAt;
        this.createdAtClient = source.createdAtClient;
        this.createdBy = source.createdBy;
        this.deleted = source.deleted;
        this.enrolledAt = source.enrolledAt;
        this.enrollment = source.enrollment;
        this.events = source.events;
        this.followUp = source.followUp;
        this.geometry = source.geometry;
        this.notes = source.notes;
        this.occurredAt = source.occurredAt;
        this.orgUnit = source.orgUnit;
        this.orgUnitName = source.orgUnitName;
        this.program = source.program;
        this.relationships = source.relationships;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.trackedEntity = source.trackedEntity;
        this.updatedAt = source.updatedAt;
        this.updatedAtClient = source.updatedAtClient;
        this.updatedBy = source.updatedBy;
    }

    /**
     * 
     * @param trackedEntity
     * @param completedAt
     * @param occurredAt
     * @param updatedAtClient
     * @param notes
     * @param storedBy
     * @param updatedBy
     * @param orgUnit
     * @param createdAtClient
     * @param program
     * @param enrollment
     * @param createdAt
     * @param followUp
     * @param relationships
     * @param deleted
     * @param createdBy
     * @param attributes
     * @param geometry
     * @param completedBy
     * @param events
     * @param enrolledAt
     * @param orgUnitName
     * @param status
     * @param updatedAt
     */
    public WebapiControllerTrackerViewEnrollment(List<WebapiControllerTrackerViewAttribute> attributes, Object completedAt, String completedBy, Object createdAt, Object createdAtClient, WebapiControllerTrackerViewUser createdBy, Boolean deleted, Object enrolledAt, String enrollment, List<WebapiControllerTrackerViewEvent> events, Boolean followUp, Geometry__4 geometry, List<WebapiControllerTrackerViewNote> notes, Object occurredAt, String orgUnit, String orgUnitName, String program, List<WebapiControllerTrackerViewRelationship> relationships, WebapiControllerTrackerViewEnrollment.Status status, String storedBy, String trackedEntity, Object updatedAt, Object updatedAtClient, WebapiControllerTrackerViewUser updatedBy) {
        super();
        this.attributes = attributes;
        this.completedAt = completedAt;
        this.completedBy = completedBy;
        this.createdAt = createdAt;
        this.createdAtClient = createdAtClient;
        this.createdBy = createdBy;
        this.deleted = deleted;
        this.enrolledAt = enrolledAt;
        this.enrollment = enrollment;
        this.events = events;
        this.followUp = followUp;
        this.geometry = geometry;
        this.notes = notes;
        this.occurredAt = occurredAt;
        this.orgUnit = orgUnit;
        this.orgUnitName = orgUnitName;
        this.program = program;
        this.relationships = relationships;
        this.status = status;
        this.storedBy = storedBy;
        this.trackedEntity = trackedEntity;
        this.updatedAt = updatedAt;
        this.updatedAtClient = updatedAtClient;
        this.updatedBy = updatedBy;
    }

    @JsonProperty("attributes")
    public Optional<List<WebapiControllerTrackerViewAttribute>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<WebapiControllerTrackerViewAttribute> attributes) {
        this.attributes = attributes;
    }

    public WebapiControllerTrackerViewEnrollment withAttributes(List<WebapiControllerTrackerViewAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("completedAt")
    public Optional<Object> getCompletedAt() {
        return Optional.ofNullable(completedAt);
    }

    @JsonProperty("completedAt")
    public void setCompletedAt(Object completedAt) {
        this.completedAt = completedAt;
    }

    public WebapiControllerTrackerViewEnrollment withCompletedAt(Object completedAt) {
        this.completedAt = completedAt;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public WebapiControllerTrackerViewEnrollment withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("createdAt")
    public Optional<Object> getCreatedAt() {
        return Optional.ofNullable(createdAt);
    }

    @JsonProperty("createdAt")
    public void setCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
    }

    public WebapiControllerTrackerViewEnrollment withCreatedAt(Object createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty("createdAtClient")
    public Optional<Object> getCreatedAtClient() {
        return Optional.ofNullable(createdAtClient);
    }

    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(Object createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public WebapiControllerTrackerViewEnrollment withCreatedAtClient(Object createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<WebapiControllerTrackerViewUser> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(WebapiControllerTrackerViewUser createdBy) {
        this.createdBy = createdBy;
    }

    public WebapiControllerTrackerViewEnrollment withCreatedBy(WebapiControllerTrackerViewUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public Boolean getDeleted() {
        return deleted;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public WebapiControllerTrackerViewEnrollment withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("enrolledAt")
    public Optional<Object> getEnrolledAt() {
        return Optional.ofNullable(enrolledAt);
    }

    @JsonProperty("enrolledAt")
    public void setEnrolledAt(Object enrolledAt) {
        this.enrolledAt = enrolledAt;
    }

    public WebapiControllerTrackerViewEnrollment withEnrolledAt(Object enrolledAt) {
        this.enrolledAt = enrolledAt;
        return this;
    }

    @JsonProperty("enrollment")
    public Optional<String> getEnrollment() {
        return Optional.ofNullable(enrollment);
    }

    @JsonProperty("enrollment")
    public void setEnrollment(String enrollment) {
        this.enrollment = enrollment;
    }

    public WebapiControllerTrackerViewEnrollment withEnrollment(String enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<WebapiControllerTrackerViewEvent>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<WebapiControllerTrackerViewEvent> events) {
        this.events = events;
    }

    public WebapiControllerTrackerViewEnrollment withEvents(List<WebapiControllerTrackerViewEvent> events) {
        this.events = events;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followUp")
    public Boolean getFollowUp() {
        return followUp;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public WebapiControllerTrackerViewEnrollment withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("geometry")
    public Optional<Geometry__4> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    @JsonProperty("geometry")
    public void setGeometry(Geometry__4 geometry) {
        this.geometry = geometry;
    }

    public WebapiControllerTrackerViewEnrollment withGeometry(Geometry__4 geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("notes")
    public Optional<List<WebapiControllerTrackerViewNote>> getNotes() {
        return Optional.ofNullable(notes);
    }

    @JsonProperty("notes")
    public void setNotes(List<WebapiControllerTrackerViewNote> notes) {
        this.notes = notes;
    }

    public WebapiControllerTrackerViewEnrollment withNotes(List<WebapiControllerTrackerViewNote> notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty("occurredAt")
    public Optional<Object> getOccurredAt() {
        return Optional.ofNullable(occurredAt);
    }

    @JsonProperty("occurredAt")
    public void setOccurredAt(Object occurredAt) {
        this.occurredAt = occurredAt;
    }

    public WebapiControllerTrackerViewEnrollment withOccurredAt(Object occurredAt) {
        this.occurredAt = occurredAt;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public WebapiControllerTrackerViewEnrollment withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("orgUnitName")
    public Optional<String> getOrgUnitName() {
        return Optional.ofNullable(orgUnitName);
    }

    @JsonProperty("orgUnitName")
    public void setOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
    }

    public WebapiControllerTrackerViewEnrollment withOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
        return this;
    }

    @JsonProperty("program")
    public Optional<String> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public WebapiControllerTrackerViewEnrollment withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<WebapiControllerTrackerViewRelationship>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<WebapiControllerTrackerViewRelationship> relationships) {
        this.relationships = relationships;
    }

    public WebapiControllerTrackerViewEnrollment withRelationships(List<WebapiControllerTrackerViewRelationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public WebapiControllerTrackerViewEnrollment.Status getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(WebapiControllerTrackerViewEnrollment.Status status) {
        this.status = status;
    }

    public WebapiControllerTrackerViewEnrollment withStatus(WebapiControllerTrackerViewEnrollment.Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public WebapiControllerTrackerViewEnrollment withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("trackedEntity")
    public Optional<String> getTrackedEntity() {
        return Optional.ofNullable(trackedEntity);
    }

    @JsonProperty("trackedEntity")
    public void setTrackedEntity(String trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    public WebapiControllerTrackerViewEnrollment withTrackedEntity(String trackedEntity) {
        this.trackedEntity = trackedEntity;
        return this;
    }

    @JsonProperty("updatedAt")
    public Optional<Object> getUpdatedAt() {
        return Optional.ofNullable(updatedAt);
    }

    @JsonProperty("updatedAt")
    public void setUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
    }

    public WebapiControllerTrackerViewEnrollment withUpdatedAt(Object updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty("updatedAtClient")
    public Optional<Object> getUpdatedAtClient() {
        return Optional.ofNullable(updatedAtClient);
    }

    @JsonProperty("updatedAtClient")
    public void setUpdatedAtClient(Object updatedAtClient) {
        this.updatedAtClient = updatedAtClient;
    }

    public WebapiControllerTrackerViewEnrollment withUpdatedAtClient(Object updatedAtClient) {
        this.updatedAtClient = updatedAtClient;
        return this;
    }

    @JsonProperty("updatedBy")
    public Optional<WebapiControllerTrackerViewUser> getUpdatedBy() {
        return Optional.ofNullable(updatedBy);
    }

    @JsonProperty("updatedBy")
    public void setUpdatedBy(WebapiControllerTrackerViewUser updatedBy) {
        this.updatedBy = updatedBy;
    }

    public WebapiControllerTrackerViewEnrollment withUpdatedBy(WebapiControllerTrackerViewUser updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public WebapiControllerTrackerViewEnrollment withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "attributes":
                if (value instanceof List) {
                    setAttributes(((List<WebapiControllerTrackerViewAttribute> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewAttribute>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedAt":
                if (value instanceof Object) {
                    setCompletedAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "completedBy":
                if (value instanceof String) {
                    setCompletedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdAt":
                if (value instanceof Object) {
                    setCreatedAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdAtClient":
                if (value instanceof Object) {
                    setCreatedAtClient(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "createdBy":
                if (value instanceof WebapiControllerTrackerViewUser) {
                    setCreatedBy(((WebapiControllerTrackerViewUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewUser\", but got "+ value.getClass().toString()));
                }
                return true;
            case "deleted":
                if (value instanceof Boolean) {
                    setDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrolledAt":
                if (value instanceof Object) {
                    setEnrolledAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrolledAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enrollment":
                if (value instanceof String) {
                    setEnrollment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"enrollment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "events":
                if (value instanceof List) {
                    setEvents(((List<WebapiControllerTrackerViewEvent> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewEvent>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followUp":
                if (value instanceof Boolean) {
                    setFollowUp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "geometry":
                if (value instanceof Geometry__4) {
                    setGeometry(((Geometry__4) value));
                } else {
                    throw new IllegalArgumentException(("property \"geometry\" is of type \"org.hisp.dhis.api.model.v40_0.Geometry__4\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notes":
                if (value instanceof List) {
                    setNotes(((List<WebapiControllerTrackerViewNote> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"notes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewNote>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "occurredAt":
                if (value instanceof Object) {
                    setOccurredAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"occurredAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnit":
                if (value instanceof String) {
                    setOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "orgUnitName":
                if (value instanceof String) {
                    setOrgUnitName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"orgUnitName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof String) {
                    setProgram(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "relationships":
                if (value instanceof List) {
                    setRelationships(((List<WebapiControllerTrackerViewRelationship> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewRelationship>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof WebapiControllerTrackerViewEnrollment.Status) {
                    setStatus(((WebapiControllerTrackerViewEnrollment.Status) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewEnrollment.Status\", but got "+ value.getClass().toString()));
                }
                return true;
            case "storedBy":
                if (value instanceof String) {
                    setStoredBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntity":
                if (value instanceof String) {
                    setTrackedEntity(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntity\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "updatedAt":
                if (value instanceof Object) {
                    setUpdatedAt(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"updatedAt\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "updatedAtClient":
                if (value instanceof Object) {
                    setUpdatedAtClient(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"updatedAtClient\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "updatedBy":
                if (value instanceof WebapiControllerTrackerViewUser) {
                    setUpdatedBy(((WebapiControllerTrackerViewUser) value));
                } else {
                    throw new IllegalArgumentException(("property \"updatedBy\" is of type \"org.hisp.dhis.api.model.v40_0.WebapiControllerTrackerViewUser\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "attributes":
                return getAttributes();
            case "completedAt":
                return getCompletedAt();
            case "completedBy":
                return getCompletedBy();
            case "createdAt":
                return getCreatedAt();
            case "createdAtClient":
                return getCreatedAtClient();
            case "createdBy":
                return getCreatedBy();
            case "deleted":
                return getDeleted();
            case "enrolledAt":
                return getEnrolledAt();
            case "enrollment":
                return getEnrollment();
            case "events":
                return getEvents();
            case "followUp":
                return getFollowUp();
            case "geometry":
                return getGeometry();
            case "notes":
                return getNotes();
            case "occurredAt":
                return getOccurredAt();
            case "orgUnit":
                return getOrgUnit();
            case "orgUnitName":
                return getOrgUnitName();
            case "program":
                return getProgram();
            case "relationships":
                return getRelationships();
            case "status":
                return getStatus();
            case "storedBy":
                return getStoredBy();
            case "trackedEntity":
                return getTrackedEntity();
            case "updatedAt":
                return getUpdatedAt();
            case "updatedAtClient":
                return getUpdatedAtClient();
            case "updatedBy":
                return getUpdatedBy();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, WebapiControllerTrackerViewEnrollment.NOT_FOUND_VALUE);
        if (WebapiControllerTrackerViewEnrollment.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public WebapiControllerTrackerViewEnrollment with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebapiControllerTrackerViewEnrollment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("completedAt");
        sb.append('=');
        sb.append(((this.completedAt == null)?"<null>":this.completedAt));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("createdAt");
        sb.append('=');
        sb.append(((this.createdAt == null)?"<null>":this.createdAt));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("enrolledAt");
        sb.append('=');
        sb.append(((this.enrolledAt == null)?"<null>":this.enrolledAt));
        sb.append(',');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(((this.notes == null)?"<null>":this.notes));
        sb.append(',');
        sb.append("occurredAt");
        sb.append('=');
        sb.append(((this.occurredAt == null)?"<null>":this.occurredAt));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("orgUnitName");
        sb.append('=');
        sb.append(((this.orgUnitName == null)?"<null>":this.orgUnitName));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntity");
        sb.append('=');
        sb.append(((this.trackedEntity == null)?"<null>":this.trackedEntity));
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(((this.updatedAt == null)?"<null>":this.updatedAt));
        sb.append(',');
        sb.append("updatedAtClient");
        sb.append('=');
        sb.append(((this.updatedAtClient == null)?"<null>":this.updatedAtClient));
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(((this.updatedBy == null)?"<null>":this.updatedBy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.trackedEntity == null)? 0 :this.trackedEntity.hashCode()));
        result = ((result* 31)+((this.notes == null)? 0 :this.notes.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.createdAt == null)? 0 :this.createdAt.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.updatedAt == null)? 0 :this.updatedAt.hashCode()));
        result = ((result* 31)+((this.completedAt == null)? 0 :this.completedAt.hashCode()));
        result = ((result* 31)+((this.occurredAt == null)? 0 :this.occurredAt.hashCode()));
        result = ((result* 31)+((this.updatedAtClient == null)? 0 :this.updatedAtClient.hashCode()));
        result = ((result* 31)+((this.updatedBy == null)? 0 :this.updatedBy.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.enrolledAt == null)? 0 :this.enrolledAt.hashCode()));
        result = ((result* 31)+((this.orgUnitName == null)? 0 :this.orgUnitName.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof WebapiControllerTrackerViewEnrollment) == false) {
            return false;
        }
        WebapiControllerTrackerViewEnrollment rhs = ((WebapiControllerTrackerViewEnrollment) other);
        return ((((((((((((((((((((((((((this.trackedEntity == rhs.trackedEntity)||((this.trackedEntity!= null)&&this.trackedEntity.equals(rhs.trackedEntity)))&&((this.notes == rhs.notes)||((this.notes!= null)&&this.notes.equals(rhs.notes))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.createdAt == rhs.createdAt)||((this.createdAt!= null)&&this.createdAt.equals(rhs.createdAt))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.updatedAt == rhs.updatedAt)||((this.updatedAt!= null)&&this.updatedAt.equals(rhs.updatedAt))))&&((this.completedAt == rhs.completedAt)||((this.completedAt!= null)&&this.completedAt.equals(rhs.completedAt))))&&((this.occurredAt == rhs.occurredAt)||((this.occurredAt!= null)&&this.occurredAt.equals(rhs.occurredAt))))&&((this.updatedAtClient == rhs.updatedAtClient)||((this.updatedAtClient!= null)&&this.updatedAtClient.equals(rhs.updatedAtClient))))&&((this.updatedBy == rhs.updatedBy)||((this.updatedBy!= null)&&this.updatedBy.equals(rhs.updatedBy))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.enrolledAt == rhs.enrolledAt)||((this.enrolledAt!= null)&&this.enrolledAt.equals(rhs.enrolledAt))))&&((this.orgUnitName == rhs.orgUnitName)||((this.orgUnitName!= null)&&this.orgUnitName.equals(rhs.orgUnitName))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, WebapiControllerTrackerViewEnrollment.Status> CONSTANTS = new HashMap<String, WebapiControllerTrackerViewEnrollment.Status>();

        static {
            for (WebapiControllerTrackerViewEnrollment.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static WebapiControllerTrackerViewEnrollment.Status fromValue(String value) {
            WebapiControllerTrackerViewEnrollment.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
