
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionCombo",
    "completed",
    "dataSet",
    "date",
    "lastUpdated",
    "lastUpdatedBy",
    "organisationUnit",
    "period",
    "storedBy"
})
@Generated("jsonschema2pojo")
public class CompleteDataSetRegistration implements Serializable
{

    @JsonProperty("attributeOptionCombo")
    private CategoryOptionCombo attributeOptionCombo;
    @JsonProperty("completed")
    private Boolean completed;
    @JsonProperty("dataSet")
    private DataSet dataSet;
    @JsonProperty("date")
    private Date date;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private String lastUpdatedBy;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("period")
    private Period period;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3759531657044996675L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CompleteDataSetRegistration() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CompleteDataSetRegistration(CompleteDataSetRegistration source) {
        super();
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.completed = source.completed;
        this.dataSet = source.dataSet;
        this.date = source.date;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.storedBy = source.storedBy;
    }

    public CompleteDataSetRegistration(CategoryOptionCombo attributeOptionCombo, Boolean completed, DataSet dataSet, Date date, Date lastUpdated, String lastUpdatedBy, OrganisationUnit organisationUnit, Period period, String storedBy) {
        super();
        this.attributeOptionCombo = attributeOptionCombo;
        this.completed = completed;
        this.dataSet = dataSet;
        this.date = date;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.storedBy = storedBy;
    }

    @JsonProperty("attributeOptionCombo")
    public Optional<CategoryOptionCombo> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public CompleteDataSetRegistration withAttributeOptionCombo(CategoryOptionCombo attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(completed);
    }

    @JsonProperty("completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public CompleteDataSetRegistration withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<DataSet> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public CompleteDataSetRegistration withDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("date")
    public Optional<Date> getDate() {
        return Optional.ofNullable(date);
    }

    @JsonProperty("date")
    public void setDate(Date date) {
        this.date = date;
    }

    public CompleteDataSetRegistration withDate(Date date) {
        this.date = date;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public CompleteDataSetRegistration withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<String> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public CompleteDataSetRegistration withLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public CompleteDataSetRegistration withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public CompleteDataSetRegistration withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public CompleteDataSetRegistration withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CompleteDataSetRegistration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributeOptionCombo".equals(name)) {
            if (value instanceof CategoryOptionCombo) {
                setAttributeOptionCombo(((CategoryOptionCombo) value));
            } else {
                throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completed".equals(name)) {
                if (value instanceof Boolean) {
                    setCompleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"completed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataSet".equals(name)) {
                    if (value instanceof DataSet) {
                        setDataSet(((DataSet) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.DataSet\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("date".equals(name)) {
                        if (value instanceof Date) {
                            setDate(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"date\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("lastUpdated".equals(name)) {
                            if (value instanceof Date) {
                                setLastUpdated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("lastUpdatedBy".equals(name)) {
                                if (value instanceof String) {
                                    setLastUpdatedBy(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("organisationUnit".equals(name)) {
                                    if (value instanceof OrganisationUnit) {
                                        setOrganisationUnit(((OrganisationUnit) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_35_13.OrganisationUnit\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("period".equals(name)) {
                                        if (value instanceof Period) {
                                            setPeriod(((Period) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_35_13.Period\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("storedBy".equals(name)) {
                                            if (value instanceof String) {
                                                setStoredBy(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributeOptionCombo".equals(name)) {
            return getAttributeOptionCombo();
        } else {
            if ("completed".equals(name)) {
                return getCompleted();
            } else {
                if ("dataSet".equals(name)) {
                    return getDataSet();
                } else {
                    if ("date".equals(name)) {
                        return getDate();
                    } else {
                        if ("lastUpdated".equals(name)) {
                            return getLastUpdated();
                        } else {
                            if ("lastUpdatedBy".equals(name)) {
                                return getLastUpdatedBy();
                            } else {
                                if ("organisationUnit".equals(name)) {
                                    return getOrganisationUnit();
                                } else {
                                    if ("period".equals(name)) {
                                        return getPeriod();
                                    } else {
                                        if ("storedBy".equals(name)) {
                                            return getStoredBy();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CompleteDataSetRegistration.NOT_FOUND_VALUE);
        if (CompleteDataSetRegistration.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CompleteDataSetRegistration with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompleteDataSetRegistration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(((this.completed == null)?"<null>":this.completed));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(((this.date == null)?"<null>":this.date));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.date == null)? 0 :this.date.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.completed == null)? 0 :this.completed.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CompleteDataSetRegistration) == false) {
            return false;
        }
        CompleteDataSetRegistration rhs = ((CompleteDataSetRegistration) other);
        return (((((((((((this.date == rhs.date)||((this.date!= null)&&this.date.equals(rhs.date)))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.completed == rhs.completed)||((this.completed!= null)&&this.completed.equals(rhs.completed))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
