
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationLevels",
    "aggregationType",
    "attributeValues",
    "categoryCombo",
    "code",
    "commentOptionSet",
    "created",
    "dataElementGroups",
    "dataSetElements",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "domainType",
    "externalAccess",
    "favorite",
    "favorites",
    "fieldMask",
    "formName",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "name",
    "optionSet",
    "optionSetValue",
    "periodOffset",
    "publicAccess",
    "shortName",
    "style",
    "translations",
    "url",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "valueType",
    "zeroIsSignificant"
})
@Generated("jsonschema2pojo")
public class DataElement implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationLevels")
    private List<Integer> aggregationLevels;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("categoryCombo")
    private CategoryCombo categoryCombo;
    @JsonProperty("code")
    private String code;
    @JsonProperty("commentOptionSet")
    private OptionSet commentOptionSet;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataElementGroups")
    private List<DataElementGroup> dataElementGroups;
    @JsonProperty("dataSetElements")
    private List<DataSetElement> dataSetElements;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("domainType")
    private DataElement.DataElementDomain domainType;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("fieldMask")
    private String fieldMask;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets;
    @JsonProperty("name")
    private String name;
    @JsonProperty("optionSet")
    private OptionSet optionSet;
    @JsonProperty("optionSetValue")
    private Boolean optionSetValue;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("valueType")
    private OptionSet.ValueType valueType;
    @JsonProperty("zeroIsSignificant")
    private Boolean zeroIsSignificant;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8945600282276801134L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataElement() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataElement(DataElement source) {
        super();
        this.access = source.access;
        this.aggregationLevels = source.aggregationLevels;
        this.aggregationType = source.aggregationType;
        this.attributeValues = source.attributeValues;
        this.categoryCombo = source.categoryCombo;
        this.code = source.code;
        this.commentOptionSet = source.commentOptionSet;
        this.created = source.created;
        this.dataElementGroups = source.dataElementGroups;
        this.dataSetElements = source.dataSetElements;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.domainType = source.domainType;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.fieldMask = source.fieldMask;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.optionSet = source.optionSet;
        this.optionSetValue = source.optionSetValue;
        this.periodOffset = source.periodOffset;
        this.publicAccess = source.publicAccess;
        this.shortName = source.shortName;
        this.style = source.style;
        this.translations = source.translations;
        this.url = source.url;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.valueType = source.valueType;
        this.zeroIsSignificant = source.zeroIsSignificant;
    }

    public DataElement(Access access, List<Integer> aggregationLevels, AggregationType aggregationType, List<AttributeValue> attributeValues, CategoryCombo categoryCombo, String code, OptionSet commentOptionSet, Date created, List<DataElementGroup> dataElementGroups, List<DataSetElement> dataSetElements, String description, String dimensionItem, org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType, String displayDescription, String displayFormName, String displayName, String displayShortName, DataElement.DataElementDomain domainType, Boolean externalAccess, Boolean favorite, List<String> favorites, String fieldMask, String formName, String href, String id, Date lastUpdated, User lastUpdatedBy, LegendSet legendSet, List<LegendSet> legendSets, String name, OptionSet optionSet, Boolean optionSetValue, Integer periodOffset, String publicAccess, String shortName, ObjectStyle style, List<Translation> translations, String url, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, OptionSet.ValueType valueType, Boolean zeroIsSignificant) {
        super();
        this.access = access;
        this.aggregationLevels = aggregationLevels;
        this.aggregationType = aggregationType;
        this.attributeValues = attributeValues;
        this.categoryCombo = categoryCombo;
        this.code = code;
        this.commentOptionSet = commentOptionSet;
        this.created = created;
        this.dataElementGroups = dataElementGroups;
        this.dataSetElements = dataSetElements;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.domainType = domainType;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.fieldMask = fieldMask;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.optionSet = optionSet;
        this.optionSetValue = optionSetValue;
        this.periodOffset = periodOffset;
        this.publicAccess = publicAccess;
        this.shortName = shortName;
        this.style = style;
        this.translations = translations;
        this.url = url;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.valueType = valueType;
        this.zeroIsSignificant = zeroIsSignificant;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DataElement withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationLevels")
    public Optional<List<Integer>> getAggregationLevels() {
        return Optional.ofNullable(aggregationLevels);
    }

    @JsonProperty("aggregationLevels")
    public void setAggregationLevels(List<Integer> aggregationLevels) {
        this.aggregationLevels = aggregationLevels;
    }

    public DataElement withAggregationLevels(List<Integer> aggregationLevels) {
        this.aggregationLevels = aggregationLevels;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public DataElement withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DataElement withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("categoryCombo")
    public Optional<CategoryCombo> getCategoryCombo() {
        return Optional.ofNullable(categoryCombo);
    }

    @JsonProperty("categoryCombo")
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public DataElement withCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataElement withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("commentOptionSet")
    public Optional<OptionSet> getCommentOptionSet() {
        return Optional.ofNullable(commentOptionSet);
    }

    @JsonProperty("commentOptionSet")
    public void setCommentOptionSet(OptionSet commentOptionSet) {
        this.commentOptionSet = commentOptionSet;
    }

    public DataElement withCommentOptionSet(OptionSet commentOptionSet) {
        this.commentOptionSet = commentOptionSet;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataElement withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataElementGroups")
    public Optional<List<DataElementGroup>> getDataElementGroups() {
        return Optional.ofNullable(dataElementGroups);
    }

    @JsonProperty("dataElementGroups")
    public void setDataElementGroups(List<DataElementGroup> dataElementGroups) {
        this.dataElementGroups = dataElementGroups;
    }

    public DataElement withDataElementGroups(List<DataElementGroup> dataElementGroups) {
        this.dataElementGroups = dataElementGroups;
        return this;
    }

    @JsonProperty("dataSetElements")
    public Optional<List<DataSetElement>> getDataSetElements() {
        return Optional.ofNullable(dataSetElements);
    }

    @JsonProperty("dataSetElements")
    public void setDataSetElements(List<DataSetElement> dataSetElements) {
        this.dataSetElements = dataSetElements;
    }

    public DataElement withDataSetElements(List<DataSetElement> dataSetElements) {
        this.dataSetElements = dataSetElements;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataElement withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public DataElement withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public DataElement withDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public DataElement withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public DataElement withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DataElement withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public DataElement withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("domainType")
    public Optional<DataElement.DataElementDomain> getDomainType() {
        return Optional.ofNullable(domainType);
    }

    @JsonProperty("domainType")
    public void setDomainType(DataElement.DataElementDomain domainType) {
        this.domainType = domainType;
    }

    public DataElement withDomainType(DataElement.DataElementDomain domainType) {
        this.domainType = domainType;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DataElement withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DataElement withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DataElement withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("fieldMask")
    public Optional<String> getFieldMask() {
        return Optional.ofNullable(fieldMask);
    }

    @JsonProperty("fieldMask")
    public void setFieldMask(String fieldMask) {
        this.fieldMask = fieldMask;
    }

    public DataElement withFieldMask(String fieldMask) {
        this.fieldMask = fieldMask;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public DataElement withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DataElement withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DataElement withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataElement withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DataElement withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public DataElement withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public DataElement withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DataElement withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("optionSet")
    public Optional<OptionSet> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    @JsonProperty("optionSet")
    public void setOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
    }

    public DataElement withOptionSet(OptionSet optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    @JsonProperty("optionSetValue")
    public Optional<Boolean> getOptionSetValue() {
        return Optional.ofNullable(optionSetValue);
    }

    @JsonProperty("optionSetValue")
    public void setOptionSetValue(Boolean optionSetValue) {
        this.optionSetValue = optionSetValue;
    }

    public DataElement withOptionSetValue(Boolean optionSetValue) {
        this.optionSetValue = optionSetValue;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public DataElement withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DataElement withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public DataElement withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public DataElement withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DataElement withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public DataElement withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public DataElement withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DataElement withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DataElement withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("valueType")
    public Optional<OptionSet.ValueType> getValueType() {
        return Optional.ofNullable(valueType);
    }

    @JsonProperty("valueType")
    public void setValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
    }

    public DataElement withValueType(OptionSet.ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonProperty("zeroIsSignificant")
    public Optional<Boolean> getZeroIsSignificant() {
        return Optional.ofNullable(zeroIsSignificant);
    }

    @JsonProperty("zeroIsSignificant")
    public void setZeroIsSignificant(Boolean zeroIsSignificant) {
        this.zeroIsSignificant = zeroIsSignificant;
    }

    public DataElement withZeroIsSignificant(Boolean zeroIsSignificant) {
        this.zeroIsSignificant = zeroIsSignificant;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataElement withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationLevels".equals(name)) {
                if (value instanceof List) {
                    setAggregationLevels(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("aggregationType".equals(name)) {
                    if (value instanceof AggregationType) {
                        setAggregationType(((AggregationType) value));
                    } else {
                        throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.AggregationType\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValues".equals(name)) {
                        if (value instanceof List) {
                            setAttributeValues(((List<AttributeValue> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("categoryCombo".equals(name)) {
                            if (value instanceof CategoryCombo) {
                                setCategoryCombo(((CategoryCombo) value));
                            } else {
                                throw new IllegalArgumentException(("property \"categoryCombo\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryCombo\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("code".equals(name)) {
                                if (value instanceof String) {
                                    setCode(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("commentOptionSet".equals(name)) {
                                    if (value instanceof OptionSet) {
                                        setCommentOptionSet(((OptionSet) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"commentOptionSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.OptionSet\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("created".equals(name)) {
                                        if (value instanceof Date) {
                                            setCreated(((Date) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataElementGroups".equals(name)) {
                                            if (value instanceof List) {
                                                setDataElementGroups(((List<DataElementGroup> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataElementGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataElementGroup>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("dataSetElements".equals(name)) {
                                                if (value instanceof List) {
                                                    setDataSetElements(((List<DataSetElement> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"dataSetElements\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataSetElement>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("description".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDescription(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("dimensionItem".equals(name)) {
                                                        if (value instanceof String) {
                                                            setDimensionItem(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("dimensionItemType".equals(name)) {
                                                            if (value instanceof org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) {
                                                                setDimensionItemType(((org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayDescription".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayDescription(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("displayFormName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setDisplayFormName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("displayName".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setDisplayName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("displayShortName".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setDisplayShortName(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("domainType".equals(name)) {
                                                                                if (value instanceof DataElement.DataElementDomain) {
                                                                                    setDomainType(((DataElement.DataElementDomain) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"domainType\" is of type \"org.hisp.dhis.api.model.v2_35_13.DataElement.DataElementDomain\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("externalAccess".equals(name)) {
                                                                                    if (value instanceof Boolean) {
                                                                                        setExternalAccess(((Boolean) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("favorite".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setFavorite(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("favorites".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setFavorites(((List<String> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("fieldMask".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setFieldMask(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"fieldMask\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("formName".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setFormName(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("href".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setHref(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("id".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setId(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                if (value instanceof Date) {
                                                                                                                    setLastUpdated(((Date) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                    if (value instanceof User) {
                                                                                                                        setLastUpdatedBy(((User) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("legendSet".equals(name)) {
                                                                                                                        if (value instanceof LegendSet) {
                                                                                                                            setLegendSet(((LegendSet) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.LegendSet\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("legendSets".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setLegendSets(((List<LegendSet> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.LegendSet>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("name".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setName(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("optionSet".equals(name)) {
                                                                                                                                    if (value instanceof OptionSet) {
                                                                                                                                        setOptionSet(((OptionSet) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.OptionSet\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("optionSetValue".equals(name)) {
                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                            setOptionSetValue(((Boolean) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"optionSetValue\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("periodOffset".equals(name)) {
                                                                                                                                            if (value instanceof Integer) {
                                                                                                                                                setPeriodOffset(((Integer) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setPublicAccess(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                        setShortName(((String) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("style".equals(name)) {
                                                                                                                                                        if (value instanceof ObjectStyle) {
                                                                                                                                                            setStyle(((ObjectStyle) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_35_13.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("url".equals(name)) {
                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                    setUrl(((String) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                    if (value instanceof User) {
                                                                                                                                                                        setUser(((User) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                            setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                                                                if (value instanceof OptionSet.ValueType) {
                                                                                                                                                                                    setValueType(((OptionSet.ValueType) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v2_35_13.OptionSet.ValueType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("zeroIsSignificant".equals(name)) {
                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                        setZeroIsSignificant(((Boolean) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"zeroIsSignificant\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationLevels".equals(name)) {
                return getAggregationLevels();
            } else {
                if ("aggregationType".equals(name)) {
                    return getAggregationType();
                } else {
                    if ("attributeValues".equals(name)) {
                        return getAttributeValues();
                    } else {
                        if ("categoryCombo".equals(name)) {
                            return getCategoryCombo();
                        } else {
                            if ("code".equals(name)) {
                                return getCode();
                            } else {
                                if ("commentOptionSet".equals(name)) {
                                    return getCommentOptionSet();
                                } else {
                                    if ("created".equals(name)) {
                                        return getCreated();
                                    } else {
                                        if ("dataElementGroups".equals(name)) {
                                            return getDataElementGroups();
                                        } else {
                                            if ("dataSetElements".equals(name)) {
                                                return getDataSetElements();
                                            } else {
                                                if ("description".equals(name)) {
                                                    return getDescription();
                                                } else {
                                                    if ("dimensionItem".equals(name)) {
                                                        return getDimensionItem();
                                                    } else {
                                                        if ("dimensionItemType".equals(name)) {
                                                            return getDimensionItemType();
                                                        } else {
                                                            if ("displayDescription".equals(name)) {
                                                                return getDisplayDescription();
                                                            } else {
                                                                if ("displayFormName".equals(name)) {
                                                                    return getDisplayFormName();
                                                                } else {
                                                                    if ("displayName".equals(name)) {
                                                                        return getDisplayName();
                                                                    } else {
                                                                        if ("displayShortName".equals(name)) {
                                                                            return getDisplayShortName();
                                                                        } else {
                                                                            if ("domainType".equals(name)) {
                                                                                return getDomainType();
                                                                            } else {
                                                                                if ("externalAccess".equals(name)) {
                                                                                    return getExternalAccess();
                                                                                } else {
                                                                                    if ("favorite".equals(name)) {
                                                                                        return getFavorite();
                                                                                    } else {
                                                                                        if ("favorites".equals(name)) {
                                                                                            return getFavorites();
                                                                                        } else {
                                                                                            if ("fieldMask".equals(name)) {
                                                                                                return getFieldMask();
                                                                                            } else {
                                                                                                if ("formName".equals(name)) {
                                                                                                    return getFormName();
                                                                                                } else {
                                                                                                    if ("href".equals(name)) {
                                                                                                        return getHref();
                                                                                                    } else {
                                                                                                        if ("id".equals(name)) {
                                                                                                            return getId();
                                                                                                        } else {
                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                return getLastUpdated();
                                                                                                            } else {
                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                    return getLastUpdatedBy();
                                                                                                                } else {
                                                                                                                    if ("legendSet".equals(name)) {
                                                                                                                        return getLegendSet();
                                                                                                                    } else {
                                                                                                                        if ("legendSets".equals(name)) {
                                                                                                                            return getLegendSets();
                                                                                                                        } else {
                                                                                                                            if ("name".equals(name)) {
                                                                                                                                return getName();
                                                                                                                            } else {
                                                                                                                                if ("optionSet".equals(name)) {
                                                                                                                                    return getOptionSet();
                                                                                                                                } else {
                                                                                                                                    if ("optionSetValue".equals(name)) {
                                                                                                                                        return getOptionSetValue();
                                                                                                                                    } else {
                                                                                                                                        if ("periodOffset".equals(name)) {
                                                                                                                                            return getPeriodOffset();
                                                                                                                                        } else {
                                                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                                                return getPublicAccess();
                                                                                                                                            } else {
                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                    return getShortName();
                                                                                                                                                } else {
                                                                                                                                                    if ("style".equals(name)) {
                                                                                                                                                        return getStyle();
                                                                                                                                                    } else {
                                                                                                                                                        if ("translations".equals(name)) {
                                                                                                                                                            return getTranslations();
                                                                                                                                                        } else {
                                                                                                                                                            if ("url".equals(name)) {
                                                                                                                                                                return getUrl();
                                                                                                                                                            } else {
                                                                                                                                                                if ("user".equals(name)) {
                                                                                                                                                                    return getUser();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("userAccesses".equals(name)) {
                                                                                                                                                                        return getUserAccesses();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                            return getUserGroupAccesses();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("valueType".equals(name)) {
                                                                                                                                                                                return getValueType();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("zeroIsSignificant".equals(name)) {
                                                                                                                                                                                    return getZeroIsSignificant();
                                                                                                                                                                                } else {
                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataElement.NOT_FOUND_VALUE);
        if (DataElement.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataElement with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationLevels");
        sb.append('=');
        sb.append(((this.aggregationLevels == null)?"<null>":this.aggregationLevels));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryCombo");
        sb.append('=');
        sb.append(((this.categoryCombo == null)?"<null>":this.categoryCombo));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("commentOptionSet");
        sb.append('=');
        sb.append(((this.commentOptionSet == null)?"<null>":this.commentOptionSet));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElementGroups");
        sb.append('=');
        sb.append(((this.dataElementGroups == null)?"<null>":this.dataElementGroups));
        sb.append(',');
        sb.append("dataSetElements");
        sb.append('=');
        sb.append(((this.dataSetElements == null)?"<null>":this.dataSetElements));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("domainType");
        sb.append('=');
        sb.append(((this.domainType == null)?"<null>":this.domainType));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("fieldMask");
        sb.append('=');
        sb.append(((this.fieldMask == null)?"<null>":this.fieldMask));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("optionSetValue");
        sb.append('=');
        sb.append(((this.optionSetValue == null)?"<null>":this.optionSetValue));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("zeroIsSignificant");
        sb.append('=');
        sb.append(((this.zeroIsSignificant == null)?"<null>":this.zeroIsSignificant));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.dataSetElements == null)? 0 :this.dataSetElements.hashCode()));
        result = ((result* 31)+((this.domainType == null)? 0 :this.domainType.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.categoryCombo == null)? 0 :this.categoryCombo.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.commentOptionSet == null)? 0 :this.commentOptionSet.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.fieldMask == null)? 0 :this.fieldMask.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.dataElementGroups == null)? 0 :this.dataElementGroups.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.zeroIsSignificant == null)? 0 :this.zeroIsSignificant.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.aggregationLevels == null)? 0 :this.aggregationLevels.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        result = ((result* 31)+((this.optionSetValue == null)? 0 :this.optionSetValue.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataElement) == false) {
            return false;
        }
        DataElement rhs = ((DataElement) other);
        return (((((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.dataSetElements == rhs.dataSetElements)||((this.dataSetElements!= null)&&this.dataSetElements.equals(rhs.dataSetElements))))&&((this.domainType == rhs.domainType)||((this.domainType!= null)&&this.domainType.equals(rhs.domainType))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.categoryCombo == rhs.categoryCombo)||((this.categoryCombo!= null)&&this.categoryCombo.equals(rhs.categoryCombo))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.commentOptionSet == rhs.commentOptionSet)||((this.commentOptionSet!= null)&&this.commentOptionSet.equals(rhs.commentOptionSet))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.fieldMask == rhs.fieldMask)||((this.fieldMask!= null)&&this.fieldMask.equals(rhs.fieldMask))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.dataElementGroups == rhs.dataElementGroups)||((this.dataElementGroups!= null)&&this.dataElementGroups.equals(rhs.dataElementGroups))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.zeroIsSignificant == rhs.zeroIsSignificant)||((this.zeroIsSignificant!= null)&&this.zeroIsSignificant.equals(rhs.zeroIsSignificant))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.aggregationLevels == rhs.aggregationLevels)||((this.aggregationLevels!= null)&&this.aggregationLevels.equals(rhs.aggregationLevels))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))))&&((this.optionSetValue == rhs.optionSetValue)||((this.optionSetValue!= null)&&this.optionSetValue.equals(rhs.optionSetValue))));
    }

    @Generated("jsonschema2pojo")
    public enum DataElementDomain {

        AGGREGATE("AGGREGATE"),
        TRACKER("TRACKER");
        private final String value;
        private final static Map<String, DataElement.DataElementDomain> CONSTANTS = new HashMap<String, DataElement.DataElementDomain>();

        static {
            for (DataElement.DataElementDomain c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataElementDomain(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataElement.DataElementDomain fromValue(String value) {
            DataElement.DataElementDomain constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
