
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUserMode",
    "assignedUsers",
    "eventCreatedPeriod",
    "eventStatus",
    "programStage"
})
@Generated("jsonschema2pojo")
public class EventFilter implements Serializable
{

    @JsonProperty("assignedUserMode")
    private AssignedUserSelectionMode assignedUserMode;
    @JsonProperty("assignedUsers")
    private List<String> assignedUsers;
    @JsonProperty("eventCreatedPeriod")
    private FilterPeriod eventCreatedPeriod;
    @JsonProperty("eventStatus")
    private org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus eventStatus;
    @JsonProperty("programStage")
    private String programStage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 531841840265163980L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventFilter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EventFilter(EventFilter source) {
        super();
        this.assignedUserMode = source.assignedUserMode;
        this.assignedUsers = source.assignedUsers;
        this.eventCreatedPeriod = source.eventCreatedPeriod;
        this.eventStatus = source.eventStatus;
        this.programStage = source.programStage;
    }

    public EventFilter(AssignedUserSelectionMode assignedUserMode, List<String> assignedUsers, FilterPeriod eventCreatedPeriod, org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus eventStatus, String programStage) {
        super();
        this.assignedUserMode = assignedUserMode;
        this.assignedUsers = assignedUsers;
        this.eventCreatedPeriod = eventCreatedPeriod;
        this.eventStatus = eventStatus;
        this.programStage = programStage;
    }

    @JsonProperty("assignedUserMode")
    public Optional<AssignedUserSelectionMode> getAssignedUserMode() {
        return Optional.ofNullable(assignedUserMode);
    }

    @JsonProperty("assignedUserMode")
    public void setAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
    }

    public EventFilter withAssignedUserMode(AssignedUserSelectionMode assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
        return this;
    }

    @JsonProperty("assignedUsers")
    public Optional<List<String>> getAssignedUsers() {
        return Optional.ofNullable(assignedUsers);
    }

    @JsonProperty("assignedUsers")
    public void setAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public EventFilter withAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
        return this;
    }

    @JsonProperty("eventCreatedPeriod")
    public Optional<FilterPeriod> getEventCreatedPeriod() {
        return Optional.ofNullable(eventCreatedPeriod);
    }

    @JsonProperty("eventCreatedPeriod")
    public void setEventCreatedPeriod(FilterPeriod eventCreatedPeriod) {
        this.eventCreatedPeriod = eventCreatedPeriod;
    }

    public EventFilter withEventCreatedPeriod(FilterPeriod eventCreatedPeriod) {
        this.eventCreatedPeriod = eventCreatedPeriod;
        return this;
    }

    @JsonProperty("eventStatus")
    public Optional<org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus> getEventStatus() {
        return Optional.ofNullable(eventStatus);
    }

    @JsonProperty("eventStatus")
    public void setEventStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public EventFilter withEventStatus(org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public EventFilter withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventFilter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assignedUserMode".equals(name)) {
            if (value instanceof AssignedUserSelectionMode) {
                setAssignedUserMode(((AssignedUserSelectionMode) value));
            } else {
                throw new IllegalArgumentException(("property \"assignedUserMode\" is of type \"org.hisp.dhis.api.model.v2_35_13.AssignedUserSelectionMode\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("assignedUsers".equals(name)) {
                if (value instanceof List) {
                    setAssignedUsers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUsers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("eventCreatedPeriod".equals(name)) {
                    if (value instanceof FilterPeriod) {
                        setEventCreatedPeriod(((FilterPeriod) value));
                    } else {
                        throw new IllegalArgumentException(("property \"eventCreatedPeriod\" is of type \"org.hisp.dhis.api.model.v2_35_13.FilterPeriod\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("eventStatus".equals(name)) {
                        if (value instanceof org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus) {
                            setEventStatus(((org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus) value));
                        } else {
                            throw new IllegalArgumentException(("property \"eventStatus\" is of type \"org.hisp.dhis.api.model.v2_35_13.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("programStage".equals(name)) {
                            if (value instanceof String) {
                                setProgramStage(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assignedUserMode".equals(name)) {
            return getAssignedUserMode();
        } else {
            if ("assignedUsers".equals(name)) {
                return getAssignedUsers();
            } else {
                if ("eventCreatedPeriod".equals(name)) {
                    return getEventCreatedPeriod();
                } else {
                    if ("eventStatus".equals(name)) {
                        return getEventStatus();
                    } else {
                        if ("programStage".equals(name)) {
                            return getProgramStage();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventFilter.NOT_FOUND_VALUE);
        if (EventFilter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventFilter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventFilter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUserMode");
        sb.append('=');
        sb.append(((this.assignedUserMode == null)?"<null>":this.assignedUserMode));
        sb.append(',');
        sb.append("assignedUsers");
        sb.append('=');
        sb.append(((this.assignedUsers == null)?"<null>":this.assignedUsers));
        sb.append(',');
        sb.append("eventCreatedPeriod");
        sb.append('=');
        sb.append(((this.eventCreatedPeriod == null)?"<null>":this.eventCreatedPeriod));
        sb.append(',');
        sb.append("eventStatus");
        sb.append('=');
        sb.append(((this.eventStatus == null)?"<null>":this.eventStatus));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.assignedUserMode == null)? 0 :this.assignedUserMode.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.eventStatus == null)? 0 :this.eventStatus.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.assignedUsers == null)? 0 :this.assignedUsers.hashCode()));
        result = ((result* 31)+((this.eventCreatedPeriod == null)? 0 :this.eventCreatedPeriod.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventFilter) == false) {
            return false;
        }
        EventFilter rhs = ((EventFilter) other);
        return (((((((this.assignedUserMode == rhs.assignedUserMode)||((this.assignedUserMode!= null)&&this.assignedUserMode.equals(rhs.assignedUserMode)))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.eventStatus == rhs.eventStatus)||((this.eventStatus!= null)&&this.eventStatus.equals(rhs.eventStatus))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.assignedUsers == rhs.assignedUsers)||((this.assignedUsers!= null)&&this.assignedUsers.equals(rhs.assignedUsers))))&&((this.eventCreatedPeriod == rhs.eventCreatedPeriod)||((this.eventCreatedPeriod!= null)&&this.eventCreatedPeriod.equals(rhs.eventCreatedPeriod))));
    }

}
