
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "contentLength",
    "contentMd5",
    "contentType",
    "created",
    "displayName",
    "domain",
    "externalAccess",
    "favorite",
    "favorites",
    "hasMultipleStorageFiles",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "publicAccess",
    "storageStatus",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class FileResource implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("contentLength")
    private Integer contentLength;
    @JsonProperty("contentMd5")
    private String contentMd5;
    @JsonProperty("contentType")
    private String contentType;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("domain")
    private FileResource.FileResourceDomain domain;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("hasMultipleStorageFiles")
    private Boolean hasMultipleStorageFiles;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("storageStatus")
    private FileResource.FileResourceStorageStatus storageStatus;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2461189425234435784L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FileResource() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FileResource(FileResource source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.contentLength = source.contentLength;
        this.contentMd5 = source.contentMd5;
        this.contentType = source.contentType;
        this.created = source.created;
        this.displayName = source.displayName;
        this.domain = source.domain;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.hasMultipleStorageFiles = source.hasMultipleStorageFiles;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.storageStatus = source.storageStatus;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    public FileResource(Access access, List<AttributeValue> attributeValues, String code, Integer contentLength, String contentMd5, String contentType, Date created, String displayName, FileResource.FileResourceDomain domain, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean hasMultipleStorageFiles, String href, String id, Date lastUpdated, User lastUpdatedBy, String name, String publicAccess, FileResource.FileResourceStorageStatus storageStatus, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.contentLength = contentLength;
        this.contentMd5 = contentMd5;
        this.contentType = contentType;
        this.created = created;
        this.displayName = displayName;
        this.domain = domain;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.hasMultipleStorageFiles = hasMultipleStorageFiles;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.publicAccess = publicAccess;
        this.storageStatus = storageStatus;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public FileResource withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public FileResource withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public FileResource withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("contentLength")
    public Optional<Integer> getContentLength() {
        return Optional.ofNullable(contentLength);
    }

    @JsonProperty("contentLength")
    public void setContentLength(Integer contentLength) {
        this.contentLength = contentLength;
    }

    public FileResource withContentLength(Integer contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @JsonProperty("contentMd5")
    public Optional<String> getContentMd5() {
        return Optional.ofNullable(contentMd5);
    }

    @JsonProperty("contentMd5")
    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public FileResource withContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
        return this;
    }

    @JsonProperty("contentType")
    public Optional<String> getContentType() {
        return Optional.ofNullable(contentType);
    }

    @JsonProperty("contentType")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public FileResource withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public FileResource withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public FileResource withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("domain")
    public Optional<FileResource.FileResourceDomain> getDomain() {
        return Optional.ofNullable(domain);
    }

    @JsonProperty("domain")
    public void setDomain(FileResource.FileResourceDomain domain) {
        this.domain = domain;
    }

    public FileResource withDomain(FileResource.FileResourceDomain domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public FileResource withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public FileResource withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public FileResource withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("hasMultipleStorageFiles")
    public Optional<Boolean> getHasMultipleStorageFiles() {
        return Optional.ofNullable(hasMultipleStorageFiles);
    }

    @JsonProperty("hasMultipleStorageFiles")
    public void setHasMultipleStorageFiles(Boolean hasMultipleStorageFiles) {
        this.hasMultipleStorageFiles = hasMultipleStorageFiles;
    }

    public FileResource withHasMultipleStorageFiles(Boolean hasMultipleStorageFiles) {
        this.hasMultipleStorageFiles = hasMultipleStorageFiles;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public FileResource withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public FileResource withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public FileResource withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public FileResource withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public FileResource withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public FileResource withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("storageStatus")
    public Optional<FileResource.FileResourceStorageStatus> getStorageStatus() {
        return Optional.ofNullable(storageStatus);
    }

    @JsonProperty("storageStatus")
    public void setStorageStatus(FileResource.FileResourceStorageStatus storageStatus) {
        this.storageStatus = storageStatus;
    }

    public FileResource withStorageStatus(FileResource.FileResourceStorageStatus storageStatus) {
        this.storageStatus = storageStatus;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public FileResource withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public FileResource withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public FileResource withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public FileResource withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FileResource withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("contentLength".equals(name)) {
                        if (value instanceof Integer) {
                            setContentLength(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"contentLength\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("contentMd5".equals(name)) {
                            if (value instanceof String) {
                                setContentMd5(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"contentMd5\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("contentType".equals(name)) {
                                if (value instanceof String) {
                                    setContentType(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"contentType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("created".equals(name)) {
                                    if (value instanceof Date) {
                                        setCreated(((Date) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("domain".equals(name)) {
                                            if (value instanceof FileResource.FileResourceDomain) {
                                                setDomain(((FileResource.FileResourceDomain) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"domain\" is of type \"org.hisp.dhis.api.model.v2_35_13.FileResource.FileResourceDomain\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setExternalAccess(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setFavorite(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        if (value instanceof List) {
                                                            setFavorites(((List<String> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("hasMultipleStorageFiles".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setHasMultipleStorageFiles(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"hasMultipleStorageFiles\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("href".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setHref(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("id".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setId(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("lastUpdated".equals(name)) {
                                                                        if (value instanceof Date) {
                                                                            setLastUpdated(((Date) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                            if (value instanceof User) {
                                                                                setLastUpdatedBy(((User) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("name".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setName(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("publicAccess".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setPublicAccess(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("storageStatus".equals(name)) {
                                                                                        if (value instanceof FileResource.FileResourceStorageStatus) {
                                                                                            setStorageStatus(((FileResource.FileResourceStorageStatus) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"storageStatus\" is of type \"org.hisp.dhis.api.model.v2_35_13.FileResource.FileResourceStorageStatus\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("translations".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setTranslations(((List<Translation> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("user".equals(name)) {
                                                                                                if (value instanceof User) {
                                                                                                    setUser(((User) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("userAccesses".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setUserAccesses(((List<UserAccess> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("contentLength".equals(name)) {
                        return getContentLength();
                    } else {
                        if ("contentMd5".equals(name)) {
                            return getContentMd5();
                        } else {
                            if ("contentType".equals(name)) {
                                return getContentType();
                            } else {
                                if ("created".equals(name)) {
                                    return getCreated();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("domain".equals(name)) {
                                            return getDomain();
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                return getExternalAccess();
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    return getFavorite();
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        return getFavorites();
                                                    } else {
                                                        if ("hasMultipleStorageFiles".equals(name)) {
                                                            return getHasMultipleStorageFiles();
                                                        } else {
                                                            if ("href".equals(name)) {
                                                                return getHref();
                                                            } else {
                                                                if ("id".equals(name)) {
                                                                    return getId();
                                                                } else {
                                                                    if ("lastUpdated".equals(name)) {
                                                                        return getLastUpdated();
                                                                    } else {
                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                            return getLastUpdatedBy();
                                                                        } else {
                                                                            if ("name".equals(name)) {
                                                                                return getName();
                                                                            } else {
                                                                                if ("publicAccess".equals(name)) {
                                                                                    return getPublicAccess();
                                                                                } else {
                                                                                    if ("storageStatus".equals(name)) {
                                                                                        return getStorageStatus();
                                                                                    } else {
                                                                                        if ("translations".equals(name)) {
                                                                                            return getTranslations();
                                                                                        } else {
                                                                                            if ("user".equals(name)) {
                                                                                                return getUser();
                                                                                            } else {
                                                                                                if ("userAccesses".equals(name)) {
                                                                                                    return getUserAccesses();
                                                                                                } else {
                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                        return getUserGroupAccesses();
                                                                                                    } else {
                                                                                                        return notFoundValue;
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FileResource.NOT_FOUND_VALUE);
        if (FileResource.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FileResource with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FileResource.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("contentLength");
        sb.append('=');
        sb.append(((this.contentLength == null)?"<null>":this.contentLength));
        sb.append(',');
        sb.append("contentMd5");
        sb.append('=');
        sb.append(((this.contentMd5 == null)?"<null>":this.contentMd5));
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(((this.contentType == null)?"<null>":this.contentType));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(((this.domain == null)?"<null>":this.domain));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("hasMultipleStorageFiles");
        sb.append('=');
        sb.append(((this.hasMultipleStorageFiles == null)?"<null>":this.hasMultipleStorageFiles));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("storageStatus");
        sb.append('=');
        sb.append(((this.storageStatus == null)?"<null>":this.storageStatus));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.contentMd5 == null)? 0 :this.contentMd5 .hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.storageStatus == null)? 0 :this.storageStatus.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.contentType == null)? 0 :this.contentType.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.domain == null)? 0 :this.domain.hashCode()));
        result = ((result* 31)+((this.hasMultipleStorageFiles == null)? 0 :this.hasMultipleStorageFiles.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.contentLength == null)? 0 :this.contentLength.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FileResource) == false) {
            return false;
        }
        FileResource rhs = ((FileResource) other);
        return ((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.contentMd5 == rhs.contentMd5)||((this.contentMd5 != null)&&this.contentMd5 .equals(rhs.contentMd5))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.storageStatus == rhs.storageStatus)||((this.storageStatus!= null)&&this.storageStatus.equals(rhs.storageStatus))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.contentType == rhs.contentType)||((this.contentType!= null)&&this.contentType.equals(rhs.contentType))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.domain == rhs.domain)||((this.domain!= null)&&this.domain.equals(rhs.domain))))&&((this.hasMultipleStorageFiles == rhs.hasMultipleStorageFiles)||((this.hasMultipleStorageFiles!= null)&&this.hasMultipleStorageFiles.equals(rhs.hasMultipleStorageFiles))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.contentLength == rhs.contentLength)||((this.contentLength!= null)&&this.contentLength.equals(rhs.contentLength))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum FileResourceDomain {

        DATA_VALUE("DATA_VALUE"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        DOCUMENT("DOCUMENT"),
        MESSAGE_ATTACHMENT("MESSAGE_ATTACHMENT"),
        USER_AVATAR("USER_AVATAR");
        private final String value;
        private final static Map<String, FileResource.FileResourceDomain> CONSTANTS = new HashMap<String, FileResource.FileResourceDomain>();

        static {
            for (FileResource.FileResourceDomain c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FileResourceDomain(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FileResource.FileResourceDomain fromValue(String value) {
            FileResource.FileResourceDomain constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum FileResourceStorageStatus {

        NONE("NONE"),
        PENDING("PENDING"),
        FAILED("FAILED"),
        STORED("STORED");
        private final String value;
        private final static Map<String, FileResource.FileResourceStorageStatus> CONSTANTS = new HashMap<String, FileResource.FileResourceStorageStatus>();

        static {
            for (FileResource.FileResourceStorageStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FileResourceStorageStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static FileResource.FileResourceStorageStatus fromValue(String value) {
            FileResource.FileResourceStorageStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
