
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "configurable",
    "created",
    "cronExpression",
    "delay",
    "displayName",
    "enabled",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "jobParameters",
    "jobStatus",
    "jobType",
    "lastExecuted",
    "lastExecutedStatus",
    "lastRuntimeExecution",
    "lastUpdated",
    "lastUpdatedBy",
    "leaderOnlyJob",
    "name",
    "nextExecutionTime",
    "publicAccess",
    "schedulingType",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userUid"
})
@Generated("jsonschema2pojo")
public class JobConfiguration implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("configurable")
    private Boolean configurable;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("cronExpression")
    private String cronExpression;
    @JsonProperty("delay")
    private Integer delay;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("enabled")
    private Boolean enabled;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("jobParameters")
    private Object jobParameters;
    @JsonProperty("jobStatus")
    private JobConfiguration.JobStatus jobStatus;
    @JsonProperty("jobType")
    private JobConfiguration.JobType jobType;
    @JsonProperty("lastExecuted")
    private Date lastExecuted;
    @JsonProperty("lastExecutedStatus")
    private JobConfiguration.JobStatus lastExecutedStatus;
    @JsonProperty("lastRuntimeExecution")
    private String lastRuntimeExecution;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("leaderOnlyJob")
    private Boolean leaderOnlyJob;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nextExecutionTime")
    private Date nextExecutionTime;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("schedulingType")
    private JobConfiguration.SchedulingType schedulingType;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("userUid")
    private String userUid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4336869787925067737L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JobConfiguration() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public JobConfiguration(JobConfiguration source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.configurable = source.configurable;
        this.created = source.created;
        this.cronExpression = source.cronExpression;
        this.delay = source.delay;
        this.displayName = source.displayName;
        this.enabled = source.enabled;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.jobParameters = source.jobParameters;
        this.jobStatus = source.jobStatus;
        this.jobType = source.jobType;
        this.lastExecuted = source.lastExecuted;
        this.lastExecutedStatus = source.lastExecutedStatus;
        this.lastRuntimeExecution = source.lastRuntimeExecution;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.leaderOnlyJob = source.leaderOnlyJob;
        this.name = source.name;
        this.nextExecutionTime = source.nextExecutionTime;
        this.publicAccess = source.publicAccess;
        this.schedulingType = source.schedulingType;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userUid = source.userUid;
    }

    public JobConfiguration(Access access, List<AttributeValue> attributeValues, String code, Boolean configurable, Date created, String cronExpression, Integer delay, String displayName, Boolean enabled, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Object jobParameters, JobConfiguration.JobStatus jobStatus, JobConfiguration.JobType jobType, Date lastExecuted, JobConfiguration.JobStatus lastExecutedStatus, String lastRuntimeExecution, Date lastUpdated, User lastUpdatedBy, Boolean leaderOnlyJob, String name, Date nextExecutionTime, String publicAccess, JobConfiguration.SchedulingType schedulingType, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, String userUid) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.configurable = configurable;
        this.created = created;
        this.cronExpression = cronExpression;
        this.delay = delay;
        this.displayName = displayName;
        this.enabled = enabled;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.jobParameters = jobParameters;
        this.jobStatus = jobStatus;
        this.jobType = jobType;
        this.lastExecuted = lastExecuted;
        this.lastExecutedStatus = lastExecutedStatus;
        this.lastRuntimeExecution = lastRuntimeExecution;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.leaderOnlyJob = leaderOnlyJob;
        this.name = name;
        this.nextExecutionTime = nextExecutionTime;
        this.publicAccess = publicAccess;
        this.schedulingType = schedulingType;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userUid = userUid;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public JobConfiguration withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public JobConfiguration withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public JobConfiguration withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("configurable")
    public Optional<Boolean> getConfigurable() {
        return Optional.ofNullable(configurable);
    }

    @JsonProperty("configurable")
    public void setConfigurable(Boolean configurable) {
        this.configurable = configurable;
    }

    public JobConfiguration withConfigurable(Boolean configurable) {
        this.configurable = configurable;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public JobConfiguration withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("cronExpression")
    public Optional<String> getCronExpression() {
        return Optional.ofNullable(cronExpression);
    }

    @JsonProperty("cronExpression")
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public JobConfiguration withCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @JsonProperty("delay")
    public Optional<Integer> getDelay() {
        return Optional.ofNullable(delay);
    }

    @JsonProperty("delay")
    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public JobConfiguration withDelay(Integer delay) {
        this.delay = delay;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JobConfiguration withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("enabled")
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public JobConfiguration withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public JobConfiguration withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public JobConfiguration withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public JobConfiguration withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public JobConfiguration withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public JobConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("jobParameters")
    public Optional<Object> getJobParameters() {
        return Optional.ofNullable(jobParameters);
    }

    @JsonProperty("jobParameters")
    public void setJobParameters(Object jobParameters) {
        this.jobParameters = jobParameters;
    }

    public JobConfiguration withJobParameters(Object jobParameters) {
        this.jobParameters = jobParameters;
        return this;
    }

    @JsonProperty("jobStatus")
    public Optional<JobConfiguration.JobStatus> getJobStatus() {
        return Optional.ofNullable(jobStatus);
    }

    @JsonProperty("jobStatus")
    public void setJobStatus(JobConfiguration.JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public JobConfiguration withJobStatus(JobConfiguration.JobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    @JsonProperty("jobType")
    public Optional<JobConfiguration.JobType> getJobType() {
        return Optional.ofNullable(jobType);
    }

    @JsonProperty("jobType")
    public void setJobType(JobConfiguration.JobType jobType) {
        this.jobType = jobType;
    }

    public JobConfiguration withJobType(JobConfiguration.JobType jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty("lastExecuted")
    public Optional<Date> getLastExecuted() {
        return Optional.ofNullable(lastExecuted);
    }

    @JsonProperty("lastExecuted")
    public void setLastExecuted(Date lastExecuted) {
        this.lastExecuted = lastExecuted;
    }

    public JobConfiguration withLastExecuted(Date lastExecuted) {
        this.lastExecuted = lastExecuted;
        return this;
    }

    @JsonProperty("lastExecutedStatus")
    public Optional<JobConfiguration.JobStatus> getLastExecutedStatus() {
        return Optional.ofNullable(lastExecutedStatus);
    }

    @JsonProperty("lastExecutedStatus")
    public void setLastExecutedStatus(JobConfiguration.JobStatus lastExecutedStatus) {
        this.lastExecutedStatus = lastExecutedStatus;
    }

    public JobConfiguration withLastExecutedStatus(JobConfiguration.JobStatus lastExecutedStatus) {
        this.lastExecutedStatus = lastExecutedStatus;
        return this;
    }

    @JsonProperty("lastRuntimeExecution")
    public Optional<String> getLastRuntimeExecution() {
        return Optional.ofNullable(lastRuntimeExecution);
    }

    @JsonProperty("lastRuntimeExecution")
    public void setLastRuntimeExecution(String lastRuntimeExecution) {
        this.lastRuntimeExecution = lastRuntimeExecution;
    }

    public JobConfiguration withLastRuntimeExecution(String lastRuntimeExecution) {
        this.lastRuntimeExecution = lastRuntimeExecution;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public JobConfiguration withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public JobConfiguration withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("leaderOnlyJob")
    public Optional<Boolean> getLeaderOnlyJob() {
        return Optional.ofNullable(leaderOnlyJob);
    }

    @JsonProperty("leaderOnlyJob")
    public void setLeaderOnlyJob(Boolean leaderOnlyJob) {
        this.leaderOnlyJob = leaderOnlyJob;
    }

    public JobConfiguration withLeaderOnlyJob(Boolean leaderOnlyJob) {
        this.leaderOnlyJob = leaderOnlyJob;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public JobConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nextExecutionTime")
    public Optional<Date> getNextExecutionTime() {
        return Optional.ofNullable(nextExecutionTime);
    }

    @JsonProperty("nextExecutionTime")
    public void setNextExecutionTime(Date nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }

    public JobConfiguration withNextExecutionTime(Date nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public JobConfiguration withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("schedulingType")
    public Optional<JobConfiguration.SchedulingType> getSchedulingType() {
        return Optional.ofNullable(schedulingType);
    }

    @JsonProperty("schedulingType")
    public void setSchedulingType(JobConfiguration.SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
    }

    public JobConfiguration withSchedulingType(JobConfiguration.SchedulingType schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public JobConfiguration withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public JobConfiguration withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public JobConfiguration withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public JobConfiguration withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userUid")
    public Optional<String> getUserUid() {
        return Optional.ofNullable(userUid);
    }

    @JsonProperty("userUid")
    public void setUserUid(String userUid) {
        this.userUid = userUid;
    }

    public JobConfiguration withUserUid(String userUid) {
        this.userUid = userUid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public JobConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("configurable".equals(name)) {
                        if (value instanceof Boolean) {
                            setConfigurable(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"configurable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("cronExpression".equals(name)) {
                                if (value instanceof String) {
                                    setCronExpression(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"cronExpression\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("delay".equals(name)) {
                                    if (value instanceof Integer) {
                                        setDelay(((Integer) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"delay\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("enabled".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setEnabled(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"enabled\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setExternalAccess(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setFavorite(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        if (value instanceof List) {
                                                            setFavorites(((List<String> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            if (value instanceof String) {
                                                                setHref(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setId(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("jobParameters".equals(name)) {
                                                                    if (value instanceof Object) {
                                                                        setJobParameters(((Object) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"jobParameters\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("jobStatus".equals(name)) {
                                                                        if (value instanceof JobConfiguration.JobStatus) {
                                                                            setJobStatus(((JobConfiguration.JobStatus) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"jobStatus\" is of type \"org.hisp.dhis.api.model.v2_35_13.JobConfiguration.JobStatus\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("jobType".equals(name)) {
                                                                            if (value instanceof JobConfiguration.JobType) {
                                                                                setJobType(((JobConfiguration.JobType) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"jobType\" is of type \"org.hisp.dhis.api.model.v2_35_13.JobConfiguration.JobType\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastExecuted".equals(name)) {
                                                                                if (value instanceof Date) {
                                                                                    setLastExecuted(((Date) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastExecuted\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("lastExecutedStatus".equals(name)) {
                                                                                    if (value instanceof JobConfiguration.JobStatus) {
                                                                                        setLastExecutedStatus(((JobConfiguration.JobStatus) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"lastExecutedStatus\" is of type \"org.hisp.dhis.api.model.v2_35_13.JobConfiguration.JobStatus\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("lastRuntimeExecution".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setLastRuntimeExecution(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"lastRuntimeExecution\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("lastUpdated".equals(name)) {
                                                                                            if (value instanceof Date) {
                                                                                                setLastUpdated(((Date) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                                if (value instanceof User) {
                                                                                                    setLastUpdatedBy(((User) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("leaderOnlyJob".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setLeaderOnlyJob(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"leaderOnlyJob\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setName(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("nextExecutionTime".equals(name)) {
                                                                                                            if (value instanceof Date) {
                                                                                                                setNextExecutionTime(((Date) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"nextExecutionTime\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setPublicAccess(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("schedulingType".equals(name)) {
                                                                                                                    if (value instanceof JobConfiguration.SchedulingType) {
                                                                                                                        setSchedulingType(((JobConfiguration.SchedulingType) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"schedulingType\" is of type \"org.hisp.dhis.api.model.v2_35_13.JobConfiguration.SchedulingType\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("user".equals(name)) {
                                                                                                                            if (value instanceof User) {
                                                                                                                                setUser(((User) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("userUid".equals(name)) {
                                                                                                                                        if (value instanceof String) {
                                                                                                                                            setUserUid(((String) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"userUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("configurable".equals(name)) {
                        return getConfigurable();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("cronExpression".equals(name)) {
                                return getCronExpression();
                            } else {
                                if ("delay".equals(name)) {
                                    return getDelay();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("enabled".equals(name)) {
                                            return getEnabled();
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                return getExternalAccess();
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    return getFavorite();
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        return getFavorites();
                                                    } else {
                                                        if ("href".equals(name)) {
                                                            return getHref();
                                                        } else {
                                                            if ("id".equals(name)) {
                                                                return getId();
                                                            } else {
                                                                if ("jobParameters".equals(name)) {
                                                                    return getJobParameters();
                                                                } else {
                                                                    if ("jobStatus".equals(name)) {
                                                                        return getJobStatus();
                                                                    } else {
                                                                        if ("jobType".equals(name)) {
                                                                            return getJobType();
                                                                        } else {
                                                                            if ("lastExecuted".equals(name)) {
                                                                                return getLastExecuted();
                                                                            } else {
                                                                                if ("lastExecutedStatus".equals(name)) {
                                                                                    return getLastExecutedStatus();
                                                                                } else {
                                                                                    if ("lastRuntimeExecution".equals(name)) {
                                                                                        return getLastRuntimeExecution();
                                                                                    } else {
                                                                                        if ("lastUpdated".equals(name)) {
                                                                                            return getLastUpdated();
                                                                                        } else {
                                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                                return getLastUpdatedBy();
                                                                                            } else {
                                                                                                if ("leaderOnlyJob".equals(name)) {
                                                                                                    return getLeaderOnlyJob();
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        return getName();
                                                                                                    } else {
                                                                                                        if ("nextExecutionTime".equals(name)) {
                                                                                                            return getNextExecutionTime();
                                                                                                        } else {
                                                                                                            if ("publicAccess".equals(name)) {
                                                                                                                return getPublicAccess();
                                                                                                            } else {
                                                                                                                if ("schedulingType".equals(name)) {
                                                                                                                    return getSchedulingType();
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        return getTranslations();
                                                                                                                    } else {
                                                                                                                        if ("user".equals(name)) {
                                                                                                                            return getUser();
                                                                                                                        } else {
                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                return getUserAccesses();
                                                                                                                            } else {
                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                } else {
                                                                                                                                    if ("userUid".equals(name)) {
                                                                                                                                        return getUserUid();
                                                                                                                                    } else {
                                                                                                                                        return notFoundValue;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, JobConfiguration.NOT_FOUND_VALUE);
        if (JobConfiguration.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public JobConfiguration with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JobConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("configurable");
        sb.append('=');
        sb.append(((this.configurable == null)?"<null>":this.configurable));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("cronExpression");
        sb.append('=');
        sb.append(((this.cronExpression == null)?"<null>":this.cronExpression));
        sb.append(',');
        sb.append("delay");
        sb.append('=');
        sb.append(((this.delay == null)?"<null>":this.delay));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(((this.enabled == null)?"<null>":this.enabled));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("jobParameters");
        sb.append('=');
        sb.append(((this.jobParameters == null)?"<null>":this.jobParameters));
        sb.append(',');
        sb.append("jobStatus");
        sb.append('=');
        sb.append(((this.jobStatus == null)?"<null>":this.jobStatus));
        sb.append(',');
        sb.append("jobType");
        sb.append('=');
        sb.append(((this.jobType == null)?"<null>":this.jobType));
        sb.append(',');
        sb.append("lastExecuted");
        sb.append('=');
        sb.append(((this.lastExecuted == null)?"<null>":this.lastExecuted));
        sb.append(',');
        sb.append("lastExecutedStatus");
        sb.append('=');
        sb.append(((this.lastExecutedStatus == null)?"<null>":this.lastExecutedStatus));
        sb.append(',');
        sb.append("lastRuntimeExecution");
        sb.append('=');
        sb.append(((this.lastRuntimeExecution == null)?"<null>":this.lastRuntimeExecution));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("leaderOnlyJob");
        sb.append('=');
        sb.append(((this.leaderOnlyJob == null)?"<null>":this.leaderOnlyJob));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nextExecutionTime");
        sb.append('=');
        sb.append(((this.nextExecutionTime == null)?"<null>":this.nextExecutionTime));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("schedulingType");
        sb.append('=');
        sb.append(((this.schedulingType == null)?"<null>":this.schedulingType));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userUid");
        sb.append('=');
        sb.append(((this.userUid == null)?"<null>":this.userUid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.jobStatus == null)? 0 :this.jobStatus.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.enabled == null)? 0 :this.enabled.hashCode()));
        result = ((result* 31)+((this.leaderOnlyJob == null)? 0 :this.leaderOnlyJob.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.jobType == null)? 0 :this.jobType.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.nextExecutionTime == null)? 0 :this.nextExecutionTime.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.cronExpression == null)? 0 :this.cronExpression.hashCode()));
        result = ((result* 31)+((this.schedulingType == null)? 0 :this.schedulingType.hashCode()));
        result = ((result* 31)+((this.lastRuntimeExecution == null)? 0 :this.lastRuntimeExecution.hashCode()));
        result = ((result* 31)+((this.delay == null)? 0 :this.delay.hashCode()));
        result = ((result* 31)+((this.lastExecutedStatus == null)? 0 :this.lastExecutedStatus.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.jobParameters == null)? 0 :this.jobParameters.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.lastExecuted == null)? 0 :this.lastExecuted.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.configurable == null)? 0 :this.configurable.hashCode()));
        result = ((result* 31)+((this.userUid == null)? 0 :this.userUid.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JobConfiguration) == false) {
            return false;
        }
        JobConfiguration rhs = ((JobConfiguration) other);
        return ((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.jobStatus == rhs.jobStatus)||((this.jobStatus!= null)&&this.jobStatus.equals(rhs.jobStatus))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.enabled == rhs.enabled)||((this.enabled!= null)&&this.enabled.equals(rhs.enabled))))&&((this.leaderOnlyJob == rhs.leaderOnlyJob)||((this.leaderOnlyJob!= null)&&this.leaderOnlyJob.equals(rhs.leaderOnlyJob))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.jobType == rhs.jobType)||((this.jobType!= null)&&this.jobType.equals(rhs.jobType))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.nextExecutionTime == rhs.nextExecutionTime)||((this.nextExecutionTime!= null)&&this.nextExecutionTime.equals(rhs.nextExecutionTime))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.cronExpression == rhs.cronExpression)||((this.cronExpression!= null)&&this.cronExpression.equals(rhs.cronExpression))))&&((this.schedulingType == rhs.schedulingType)||((this.schedulingType!= null)&&this.schedulingType.equals(rhs.schedulingType))))&&((this.lastRuntimeExecution == rhs.lastRuntimeExecution)||((this.lastRuntimeExecution!= null)&&this.lastRuntimeExecution.equals(rhs.lastRuntimeExecution))))&&((this.delay == rhs.delay)||((this.delay!= null)&&this.delay.equals(rhs.delay))))&&((this.lastExecutedStatus == rhs.lastExecutedStatus)||((this.lastExecutedStatus!= null)&&this.lastExecutedStatus.equals(rhs.lastExecutedStatus))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.jobParameters == rhs.jobParameters)||((this.jobParameters!= null)&&this.jobParameters.equals(rhs.jobParameters))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.lastExecuted == rhs.lastExecuted)||((this.lastExecuted!= null)&&this.lastExecuted.equals(rhs.lastExecuted))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.configurable == rhs.configurable)||((this.configurable!= null)&&this.configurable.equals(rhs.configurable))))&&((this.userUid == rhs.userUid)||((this.userUid!= null)&&this.userUid.equals(rhs.userUid))));
    }

    @Generated("jsonschema2pojo")
    public enum JobStatus {

        RUNNING("RUNNING"),
        COMPLETED("COMPLETED"),
        STOPPED("STOPPED"),
        SCHEDULED("SCHEDULED"),
        DISABLED("DISABLED"),
        FAILED("FAILED"),
        NOT_STARTED("NOT_STARTED");
        private final String value;
        private final static Map<String, JobConfiguration.JobStatus> CONSTANTS = new HashMap<String, JobConfiguration.JobStatus>();

        static {
            for (JobConfiguration.JobStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        JobStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobConfiguration.JobStatus fromValue(String value) {
            JobConfiguration.JobStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum JobType {

        DATA_STATISTICS("DATA_STATISTICS"),
        DATA_INTEGRITY("DATA_INTEGRITY"),
        RESOURCE_TABLE("RESOURCE_TABLE"),
        ANALYTICS_TABLE("ANALYTICS_TABLE"),
        CONTINUOUS_ANALYTICS_TABLE("CONTINUOUS_ANALYTICS_TABLE"),
        DATA_SYNC("DATA_SYNC"),
        TRACKER_PROGRAMS_DATA_SYNC("TRACKER_PROGRAMS_DATA_SYNC"),
        EVENT_PROGRAMS_DATA_SYNC("EVENT_PROGRAMS_DATA_SYNC"),
        FILE_RESOURCE_CLEANUP("FILE_RESOURCE_CLEANUP"),
        IMAGE_PROCESSING("IMAGE_PROCESSING"),
        META_DATA_SYNC("META_DATA_SYNC"),
        SMS_SEND("SMS_SEND"),
        SEND_SCHEDULED_MESSAGE("SEND_SCHEDULED_MESSAGE"),
        PROGRAM_NOTIFICATIONS("PROGRAM_NOTIFICATIONS"),
        VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
        CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
        MONITORING("MONITORING"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        PREDICTOR("PREDICTOR"),
        DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
        REMOVE_USED_OR_EXPIRED_RESERVED_VALUES("REMOVE_USED_OR_EXPIRED_RESERVED_VALUES"),
        TRACKER_IMPORT_JOB("TRACKER_IMPORT_JOB"),
        TRACKER_IMPORT_NOTIFICATION_JOB("TRACKER_IMPORT_NOTIFICATION_JOB"),
        TRACKER_IMPORT_RULE_ENGINE_JOB("TRACKER_IMPORT_RULE_ENGINE_JOB"),
        LEADER_ELECTION("LEADER_ELECTION"),
        LEADER_RENEWAL("LEADER_RENEWAL"),
        COMPLETE_DATA_SET_REGISTRATION_IMPORT("COMPLETE_DATA_SET_REGISTRATION_IMPORT"),
        DATAVALUE_IMPORT_INTERNAL("DATAVALUE_IMPORT_INTERNAL"),
        METADATA_IMPORT("METADATA_IMPORT"),
        DATAVALUE_IMPORT("DATAVALUE_IMPORT"),
        EVENT_IMPORT("EVENT_IMPORT"),
        ENROLLMENT_IMPORT("ENROLLMENT_IMPORT"),
        TEI_IMPORT("TEI_IMPORT"),
        MOCK("MOCK"),
        GML_IMPORT("GML_IMPORT"),
        ANALYTICSTABLE_UPDATE("ANALYTICSTABLE_UPDATE"),
        PROGRAM_DATA_SYNC("PROGRAM_DATA_SYNC");
        private final String value;
        private final static Map<String, JobConfiguration.JobType> CONSTANTS = new HashMap<String, JobConfiguration.JobType>();

        static {
            for (JobConfiguration.JobType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        JobType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobConfiguration.JobType fromValue(String value) {
            JobConfiguration.JobType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SchedulingType {

        CRON("CRON"),
        FIXED_DELAY("FIXED_DELAY");
        private final String value;
        private final static Map<String, JobConfiguration.SchedulingType> CONSTANTS = new HashMap<String, JobConfiguration.SchedulingType>();

        static {
            for (JobConfiguration.SchedulingType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SchedulingType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobConfiguration.SchedulingType fromValue(String value) {
            JobConfiguration.SchedulingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
