
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "persistResults",
    "relativeEnd",
    "relativeStart",
    "sendNotifications",
    "validationRuleGroups"
})
@Generated("jsonschema2pojo")
public class MonitoringJobParameters implements Serializable
{

    @JsonProperty("persistResults")
    private Boolean persistResults;
    @JsonProperty("relativeEnd")
    private Integer relativeEnd;
    @JsonProperty("relativeStart")
    private Integer relativeStart;
    @JsonProperty("sendNotifications")
    private Boolean sendNotifications;
    @JsonProperty("validationRuleGroups")
    private List<String> validationRuleGroups;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6296700317020301740L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MonitoringJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MonitoringJobParameters(MonitoringJobParameters source) {
        super();
        this.persistResults = source.persistResults;
        this.relativeEnd = source.relativeEnd;
        this.relativeStart = source.relativeStart;
        this.sendNotifications = source.sendNotifications;
        this.validationRuleGroups = source.validationRuleGroups;
    }

    public MonitoringJobParameters(Boolean persistResults, Integer relativeEnd, Integer relativeStart, Boolean sendNotifications, List<String> validationRuleGroups) {
        super();
        this.persistResults = persistResults;
        this.relativeEnd = relativeEnd;
        this.relativeStart = relativeStart;
        this.sendNotifications = sendNotifications;
        this.validationRuleGroups = validationRuleGroups;
    }

    @JsonProperty("persistResults")
    public Optional<Boolean> getPersistResults() {
        return Optional.ofNullable(persistResults);
    }

    @JsonProperty("persistResults")
    public void setPersistResults(Boolean persistResults) {
        this.persistResults = persistResults;
    }

    public MonitoringJobParameters withPersistResults(Boolean persistResults) {
        this.persistResults = persistResults;
        return this;
    }

    @JsonProperty("relativeEnd")
    public Optional<Integer> getRelativeEnd() {
        return Optional.ofNullable(relativeEnd);
    }

    @JsonProperty("relativeEnd")
    public void setRelativeEnd(Integer relativeEnd) {
        this.relativeEnd = relativeEnd;
    }

    public MonitoringJobParameters withRelativeEnd(Integer relativeEnd) {
        this.relativeEnd = relativeEnd;
        return this;
    }

    @JsonProperty("relativeStart")
    public Optional<Integer> getRelativeStart() {
        return Optional.ofNullable(relativeStart);
    }

    @JsonProperty("relativeStart")
    public void setRelativeStart(Integer relativeStart) {
        this.relativeStart = relativeStart;
    }

    public MonitoringJobParameters withRelativeStart(Integer relativeStart) {
        this.relativeStart = relativeStart;
        return this;
    }

    @JsonProperty("sendNotifications")
    public Optional<Boolean> getSendNotifications() {
        return Optional.ofNullable(sendNotifications);
    }

    @JsonProperty("sendNotifications")
    public void setSendNotifications(Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
    }

    public MonitoringJobParameters withSendNotifications(Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
    }

    @JsonProperty("validationRuleGroups")
    public Optional<List<String>> getValidationRuleGroups() {
        return Optional.ofNullable(validationRuleGroups);
    }

    @JsonProperty("validationRuleGroups")
    public void setValidationRuleGroups(List<String> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
    }

    public MonitoringJobParameters withValidationRuleGroups(List<String> validationRuleGroups) {
        this.validationRuleGroups = validationRuleGroups;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MonitoringJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("persistResults".equals(name)) {
            if (value instanceof Boolean) {
                setPersistResults(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"persistResults\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("relativeEnd".equals(name)) {
                if (value instanceof Integer) {
                    setRelativeEnd(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"relativeEnd\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("relativeStart".equals(name)) {
                    if (value instanceof Integer) {
                        setRelativeStart(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"relativeStart\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("sendNotifications".equals(name)) {
                        if (value instanceof Boolean) {
                            setSendNotifications(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"sendNotifications\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("validationRuleGroups".equals(name)) {
                            if (value instanceof List) {
                                setValidationRuleGroups(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"validationRuleGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("persistResults".equals(name)) {
            return getPersistResults();
        } else {
            if ("relativeEnd".equals(name)) {
                return getRelativeEnd();
            } else {
                if ("relativeStart".equals(name)) {
                    return getRelativeStart();
                } else {
                    if ("sendNotifications".equals(name)) {
                        return getSendNotifications();
                    } else {
                        if ("validationRuleGroups".equals(name)) {
                            return getValidationRuleGroups();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MonitoringJobParameters.NOT_FOUND_VALUE);
        if (MonitoringJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MonitoringJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MonitoringJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("persistResults");
        sb.append('=');
        sb.append(((this.persistResults == null)?"<null>":this.persistResults));
        sb.append(',');
        sb.append("relativeEnd");
        sb.append('=');
        sb.append(((this.relativeEnd == null)?"<null>":this.relativeEnd));
        sb.append(',');
        sb.append("relativeStart");
        sb.append('=');
        sb.append(((this.relativeStart == null)?"<null>":this.relativeStart));
        sb.append(',');
        sb.append("sendNotifications");
        sb.append('=');
        sb.append(((this.sendNotifications == null)?"<null>":this.sendNotifications));
        sb.append(',');
        sb.append("validationRuleGroups");
        sb.append('=');
        sb.append(((this.validationRuleGroups == null)?"<null>":this.validationRuleGroups));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.relativeEnd == null)? 0 :this.relativeEnd.hashCode()));
        result = ((result* 31)+((this.validationRuleGroups == null)? 0 :this.validationRuleGroups.hashCode()));
        result = ((result* 31)+((this.persistResults == null)? 0 :this.persistResults.hashCode()));
        result = ((result* 31)+((this.relativeStart == null)? 0 :this.relativeStart.hashCode()));
        result = ((result* 31)+((this.sendNotifications == null)? 0 :this.sendNotifications.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MonitoringJobParameters) == false) {
            return false;
        }
        MonitoringJobParameters rhs = ((MonitoringJobParameters) other);
        return (((((((this.relativeEnd == rhs.relativeEnd)||((this.relativeEnd!= null)&&this.relativeEnd.equals(rhs.relativeEnd)))&&((this.validationRuleGroups == rhs.validationRuleGroups)||((this.validationRuleGroups!= null)&&this.validationRuleGroups.equals(rhs.validationRuleGroups))))&&((this.persistResults == rhs.persistResults)||((this.persistResults!= null)&&this.persistResults.equals(rhs.persistResults))))&&((this.relativeStart == rhs.relativeStart)||((this.relativeStart!= null)&&this.relativeStart.equals(rhs.relativeStart))))&&((this.sendNotifications == rhs.sendNotifications)||((this.sendNotifications!= null)&&this.sendNotifications.equals(rhs.sendNotifications))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
