
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "cc",
    "cd",
    "completed",
    "cp",
    "ds",
    "multiOu",
    "ou",
    "pe",
    "sb"
})
@Generated("jsonschema2pojo")
public class CompleteDataSetRegistrationRequest implements Serializable
{

    @JsonProperty("cc")
    private String cc;
    @JsonProperty("cd")
    private Date cd;
    @JsonProperty("completed")
    private Boolean completed;
    @JsonProperty("cp")
    private String cp;
    @JsonProperty("ds")
    private String ds;
    @JsonProperty("multiOu")
    private Boolean multiOu;
    @JsonProperty("ou")
    private String ou;
    @JsonProperty("pe")
    private String pe;
    @JsonProperty("sb")
    private String sb;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4591659332776641326L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CompleteDataSetRegistrationRequest() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CompleteDataSetRegistrationRequest(CompleteDataSetRegistrationRequest source) {
        super();
        this.cc = source.cc;
        this.cd = source.cd;
        this.completed = source.completed;
        this.cp = source.cp;
        this.ds = source.ds;
        this.multiOu = source.multiOu;
        this.ou = source.ou;
        this.pe = source.pe;
        this.sb = source.sb;
    }

    public CompleteDataSetRegistrationRequest(String cc, Date cd, Boolean completed, String cp, String ds, Boolean multiOu, String ou, String pe, String sb) {
        super();
        this.cc = cc;
        this.cd = cd;
        this.completed = completed;
        this.cp = cp;
        this.ds = ds;
        this.multiOu = multiOu;
        this.ou = ou;
        this.pe = pe;
        this.sb = sb;
    }

    @JsonProperty("cc")
    public Optional<String> getCc() {
        return Optional.ofNullable(cc);
    }

    @JsonProperty("cc")
    public void setCc(String cc) {
        this.cc = cc;
    }

    public CompleteDataSetRegistrationRequest withCc(String cc) {
        this.cc = cc;
        return this;
    }

    @JsonProperty("cd")
    public Optional<Date> getCd() {
        return Optional.ofNullable(cd);
    }

    @JsonProperty("cd")
    public void setCd(Date cd) {
        this.cd = cd;
    }

    public CompleteDataSetRegistrationRequest withCd(Date cd) {
        this.cd = cd;
        return this;
    }

    @JsonProperty("completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(completed);
    }

    @JsonProperty("completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public CompleteDataSetRegistrationRequest withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty("cp")
    public Optional<String> getCp() {
        return Optional.ofNullable(cp);
    }

    @JsonProperty("cp")
    public void setCp(String cp) {
        this.cp = cp;
    }

    public CompleteDataSetRegistrationRequest withCp(String cp) {
        this.cp = cp;
        return this;
    }

    @JsonProperty("ds")
    public Optional<String> getDs() {
        return Optional.ofNullable(ds);
    }

    @JsonProperty("ds")
    public void setDs(String ds) {
        this.ds = ds;
    }

    public CompleteDataSetRegistrationRequest withDs(String ds) {
        this.ds = ds;
        return this;
    }

    @JsonProperty("multiOu")
    public Optional<Boolean> getMultiOu() {
        return Optional.ofNullable(multiOu);
    }

    @JsonProperty("multiOu")
    public void setMultiOu(Boolean multiOu) {
        this.multiOu = multiOu;
    }

    public CompleteDataSetRegistrationRequest withMultiOu(Boolean multiOu) {
        this.multiOu = multiOu;
        return this;
    }

    @JsonProperty("ou")
    public Optional<String> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(String ou) {
        this.ou = ou;
    }

    public CompleteDataSetRegistrationRequest withOu(String ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("pe")
    public Optional<String> getPe() {
        return Optional.ofNullable(pe);
    }

    @JsonProperty("pe")
    public void setPe(String pe) {
        this.pe = pe;
    }

    public CompleteDataSetRegistrationRequest withPe(String pe) {
        this.pe = pe;
        return this;
    }

    @JsonProperty("sb")
    public Optional<String> getSb() {
        return Optional.ofNullable(sb);
    }

    @JsonProperty("sb")
    public void setSb(String sb) {
        this.sb = sb;
    }

    public CompleteDataSetRegistrationRequest withSb(String sb) {
        this.sb = sb;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CompleteDataSetRegistrationRequest withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("cc".equals(name)) {
            if (value instanceof String) {
                setCc(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"cc\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("cd".equals(name)) {
                if (value instanceof Date) {
                    setCd(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"cd\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("completed".equals(name)) {
                    if (value instanceof Boolean) {
                        setCompleted(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"completed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("cp".equals(name)) {
                        if (value instanceof String) {
                            setCp(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"cp\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("ds".equals(name)) {
                            if (value instanceof String) {
                                setDs(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"ds\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("multiOu".equals(name)) {
                                if (value instanceof Boolean) {
                                    setMultiOu(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"multiOu\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("ou".equals(name)) {
                                    if (value instanceof String) {
                                        setOu(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"ou\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("pe".equals(name)) {
                                        if (value instanceof String) {
                                            setPe(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"pe\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("sb".equals(name)) {
                                            if (value instanceof String) {
                                                setSb(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"sb\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("cc".equals(name)) {
            return getCc();
        } else {
            if ("cd".equals(name)) {
                return getCd();
            } else {
                if ("completed".equals(name)) {
                    return getCompleted();
                } else {
                    if ("cp".equals(name)) {
                        return getCp();
                    } else {
                        if ("ds".equals(name)) {
                            return getDs();
                        } else {
                            if ("multiOu".equals(name)) {
                                return getMultiOu();
                            } else {
                                if ("ou".equals(name)) {
                                    return getOu();
                                } else {
                                    if ("pe".equals(name)) {
                                        return getPe();
                                    } else {
                                        if ("sb".equals(name)) {
                                            return getSb();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CompleteDataSetRegistrationRequest.NOT_FOUND_VALUE);
        if (CompleteDataSetRegistrationRequest.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CompleteDataSetRegistrationRequest with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompleteDataSetRegistrationRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("cc");
        sb.append('=');
        sb.append(((this.cc == null)?"<null>":this.cc));
        sb.append(',');
        sb.append("cd");
        sb.append('=');
        sb.append(((this.cd == null)?"<null>":this.cd));
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(((this.completed == null)?"<null>":this.completed));
        sb.append(',');
        sb.append("cp");
        sb.append('=');
        sb.append(((this.cp == null)?"<null>":this.cp));
        sb.append(',');
        sb.append("ds");
        sb.append('=');
        sb.append(((this.ds == null)?"<null>":this.ds));
        sb.append(',');
        sb.append("multiOu");
        sb.append('=');
        sb.append(((this.multiOu == null)?"<null>":this.multiOu));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("pe");
        sb.append('=');
        sb.append(((this.pe == null)?"<null>":this.pe));
        sb.append(',');
        sb.append("sb");
        sb.append('=');
        sb.append(((this.sb == null)?"<null>":this.sb));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.cc == null)? 0 :this.cc.hashCode()));
        result = ((result* 31)+((this.cd == null)? 0 :this.cd.hashCode()));
        result = ((result* 31)+((this.pe == null)? 0 :this.pe.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.multiOu == null)? 0 :this.multiOu.hashCode()));
        result = ((result* 31)+((this.completed == null)? 0 :this.completed.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.cp == null)? 0 :this.cp.hashCode()));
        result = ((result* 31)+((this.ds == null)? 0 :this.ds.hashCode()));
        result = ((result* 31)+((this.sb == null)? 0 :this.sb.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CompleteDataSetRegistrationRequest) == false) {
            return false;
        }
        CompleteDataSetRegistrationRequest rhs = ((CompleteDataSetRegistrationRequest) other);
        return (((((((((((this.cc == rhs.cc)||((this.cc!= null)&&this.cc.equals(rhs.cc)))&&((this.cd == rhs.cd)||((this.cd!= null)&&this.cd.equals(rhs.cd))))&&((this.pe == rhs.pe)||((this.pe!= null)&&this.pe.equals(rhs.pe))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.multiOu == rhs.multiOu)||((this.multiOu!= null)&&this.multiOu.equals(rhs.multiOu))))&&((this.completed == rhs.completed)||((this.completed!= null)&&this.completed.equals(rhs.completed))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.cp == rhs.cp)||((this.cp!= null)&&this.cp.equals(rhs.cp))))&&((this.ds == rhs.ds)||((this.ds!= null)&&this.ds.equals(rhs.ds))))&&((this.sb == rhs.sb)||((this.sb!= null)&&this.sb.equals(rhs.sb))));
    }

}
