
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "appCount",
    "apps",
    "chartCount",
    "charts",
    "eventChartCount",
    "eventCharts",
    "eventReportCount",
    "eventReports",
    "mapCount",
    "maps",
    "reportCount",
    "reportTableCount",
    "reportTables",
    "reports",
    "resourceCount",
    "resources",
    "searchCount",
    "userCount",
    "users",
    "visualizationCount",
    "visualizations"
})
@Generated("jsonschema2pojo")
public class DashboardSearchResult implements Serializable
{

    @JsonProperty("appCount")
    private Integer appCount;
    @JsonProperty("apps")
    private List<App> apps;
    @JsonProperty("chartCount")
    private Integer chartCount;
    @JsonProperty("charts")
    private List<Visualization> charts;
    @JsonProperty("eventChartCount")
    private Integer eventChartCount;
    @JsonProperty("eventCharts")
    private List<EventChart> eventCharts;
    @JsonProperty("eventReportCount")
    private Integer eventReportCount;
    @JsonProperty("eventReports")
    private List<EventReport> eventReports;
    @JsonProperty("mapCount")
    private Integer mapCount;
    @JsonProperty("maps")
    private List<org.hisp.dhis.api.model.v2_36_11.Map> maps;
    @JsonProperty("reportCount")
    private Integer reportCount;
    @JsonProperty("reportTableCount")
    private Integer reportTableCount;
    @JsonProperty("reportTables")
    private List<Visualization> reportTables;
    @JsonProperty("reports")
    private List<Report> reports;
    @JsonProperty("resourceCount")
    private Integer resourceCount;
    @JsonProperty("resources")
    private List<Document> resources;
    @JsonProperty("searchCount")
    private Integer searchCount;
    @JsonProperty("userCount")
    private Integer userCount;
    @JsonProperty("users")
    private List<User> users;
    @JsonProperty("visualizationCount")
    private Integer visualizationCount;
    @JsonProperty("visualizations")
    private List<SimpleVisualizationView> visualizations;
    @JsonIgnore
    private java.util.Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 509052874972463959L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DashboardSearchResult() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DashboardSearchResult(DashboardSearchResult source) {
        super();
        this.appCount = source.appCount;
        this.apps = source.apps;
        this.chartCount = source.chartCount;
        this.charts = source.charts;
        this.eventChartCount = source.eventChartCount;
        this.eventCharts = source.eventCharts;
        this.eventReportCount = source.eventReportCount;
        this.eventReports = source.eventReports;
        this.mapCount = source.mapCount;
        this.maps = source.maps;
        this.reportCount = source.reportCount;
        this.reportTableCount = source.reportTableCount;
        this.reportTables = source.reportTables;
        this.reports = source.reports;
        this.resourceCount = source.resourceCount;
        this.resources = source.resources;
        this.searchCount = source.searchCount;
        this.userCount = source.userCount;
        this.users = source.users;
        this.visualizationCount = source.visualizationCount;
        this.visualizations = source.visualizations;
    }

    public DashboardSearchResult(Integer appCount, List<App> apps, Integer chartCount, List<Visualization> charts, Integer eventChartCount, List<EventChart> eventCharts, Integer eventReportCount, List<EventReport> eventReports, Integer mapCount, List<org.hisp.dhis.api.model.v2_36_11.Map> maps, Integer reportCount, Integer reportTableCount, List<Visualization> reportTables, List<Report> reports, Integer resourceCount, List<Document> resources, Integer searchCount, Integer userCount, List<User> users, Integer visualizationCount, List<SimpleVisualizationView> visualizations) {
        super();
        this.appCount = appCount;
        this.apps = apps;
        this.chartCount = chartCount;
        this.charts = charts;
        this.eventChartCount = eventChartCount;
        this.eventCharts = eventCharts;
        this.eventReportCount = eventReportCount;
        this.eventReports = eventReports;
        this.mapCount = mapCount;
        this.maps = maps;
        this.reportCount = reportCount;
        this.reportTableCount = reportTableCount;
        this.reportTables = reportTables;
        this.reports = reports;
        this.resourceCount = resourceCount;
        this.resources = resources;
        this.searchCount = searchCount;
        this.userCount = userCount;
        this.users = users;
        this.visualizationCount = visualizationCount;
        this.visualizations = visualizations;
    }

    @JsonProperty("appCount")
    public Optional<Integer> getAppCount() {
        return Optional.ofNullable(appCount);
    }

    @JsonProperty("appCount")
    public void setAppCount(Integer appCount) {
        this.appCount = appCount;
    }

    public DashboardSearchResult withAppCount(Integer appCount) {
        this.appCount = appCount;
        return this;
    }

    @JsonProperty("apps")
    public Optional<List<App>> getApps() {
        return Optional.ofNullable(apps);
    }

    @JsonProperty("apps")
    public void setApps(List<App> apps) {
        this.apps = apps;
    }

    public DashboardSearchResult withApps(List<App> apps) {
        this.apps = apps;
        return this;
    }

    @JsonProperty("chartCount")
    public Optional<Integer> getChartCount() {
        return Optional.ofNullable(chartCount);
    }

    @JsonProperty("chartCount")
    public void setChartCount(Integer chartCount) {
        this.chartCount = chartCount;
    }

    public DashboardSearchResult withChartCount(Integer chartCount) {
        this.chartCount = chartCount;
        return this;
    }

    @JsonProperty("charts")
    public Optional<List<Visualization>> getCharts() {
        return Optional.ofNullable(charts);
    }

    @JsonProperty("charts")
    public void setCharts(List<Visualization> charts) {
        this.charts = charts;
    }

    public DashboardSearchResult withCharts(List<Visualization> charts) {
        this.charts = charts;
        return this;
    }

    @JsonProperty("eventChartCount")
    public Optional<Integer> getEventChartCount() {
        return Optional.ofNullable(eventChartCount);
    }

    @JsonProperty("eventChartCount")
    public void setEventChartCount(Integer eventChartCount) {
        this.eventChartCount = eventChartCount;
    }

    public DashboardSearchResult withEventChartCount(Integer eventChartCount) {
        this.eventChartCount = eventChartCount;
        return this;
    }

    @JsonProperty("eventCharts")
    public Optional<List<EventChart>> getEventCharts() {
        return Optional.ofNullable(eventCharts);
    }

    @JsonProperty("eventCharts")
    public void setEventCharts(List<EventChart> eventCharts) {
        this.eventCharts = eventCharts;
    }

    public DashboardSearchResult withEventCharts(List<EventChart> eventCharts) {
        this.eventCharts = eventCharts;
        return this;
    }

    @JsonProperty("eventReportCount")
    public Optional<Integer> getEventReportCount() {
        return Optional.ofNullable(eventReportCount);
    }

    @JsonProperty("eventReportCount")
    public void setEventReportCount(Integer eventReportCount) {
        this.eventReportCount = eventReportCount;
    }

    public DashboardSearchResult withEventReportCount(Integer eventReportCount) {
        this.eventReportCount = eventReportCount;
        return this;
    }

    @JsonProperty("eventReports")
    public Optional<List<EventReport>> getEventReports() {
        return Optional.ofNullable(eventReports);
    }

    @JsonProperty("eventReports")
    public void setEventReports(List<EventReport> eventReports) {
        this.eventReports = eventReports;
    }

    public DashboardSearchResult withEventReports(List<EventReport> eventReports) {
        this.eventReports = eventReports;
        return this;
    }

    @JsonProperty("mapCount")
    public Optional<Integer> getMapCount() {
        return Optional.ofNullable(mapCount);
    }

    @JsonProperty("mapCount")
    public void setMapCount(Integer mapCount) {
        this.mapCount = mapCount;
    }

    public DashboardSearchResult withMapCount(Integer mapCount) {
        this.mapCount = mapCount;
        return this;
    }

    @JsonProperty("maps")
    public Optional<List<org.hisp.dhis.api.model.v2_36_11.Map>> getMaps() {
        return Optional.ofNullable(maps);
    }

    @JsonProperty("maps")
    public void setMaps(List<org.hisp.dhis.api.model.v2_36_11.Map> maps) {
        this.maps = maps;
    }

    public DashboardSearchResult withMaps(List<org.hisp.dhis.api.model.v2_36_11.Map> maps) {
        this.maps = maps;
        return this;
    }

    @JsonProperty("reportCount")
    public Optional<Integer> getReportCount() {
        return Optional.ofNullable(reportCount);
    }

    @JsonProperty("reportCount")
    public void setReportCount(Integer reportCount) {
        this.reportCount = reportCount;
    }

    public DashboardSearchResult withReportCount(Integer reportCount) {
        this.reportCount = reportCount;
        return this;
    }

    @JsonProperty("reportTableCount")
    public Optional<Integer> getReportTableCount() {
        return Optional.ofNullable(reportTableCount);
    }

    @JsonProperty("reportTableCount")
    public void setReportTableCount(Integer reportTableCount) {
        this.reportTableCount = reportTableCount;
    }

    public DashboardSearchResult withReportTableCount(Integer reportTableCount) {
        this.reportTableCount = reportTableCount;
        return this;
    }

    @JsonProperty("reportTables")
    public Optional<List<Visualization>> getReportTables() {
        return Optional.ofNullable(reportTables);
    }

    @JsonProperty("reportTables")
    public void setReportTables(List<Visualization> reportTables) {
        this.reportTables = reportTables;
    }

    public DashboardSearchResult withReportTables(List<Visualization> reportTables) {
        this.reportTables = reportTables;
        return this;
    }

    @JsonProperty("reports")
    public Optional<List<Report>> getReports() {
        return Optional.ofNullable(reports);
    }

    @JsonProperty("reports")
    public void setReports(List<Report> reports) {
        this.reports = reports;
    }

    public DashboardSearchResult withReports(List<Report> reports) {
        this.reports = reports;
        return this;
    }

    @JsonProperty("resourceCount")
    public Optional<Integer> getResourceCount() {
        return Optional.ofNullable(resourceCount);
    }

    @JsonProperty("resourceCount")
    public void setResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
    }

    public DashboardSearchResult withResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
        return this;
    }

    @JsonProperty("resources")
    public Optional<List<Document>> getResources() {
        return Optional.ofNullable(resources);
    }

    @JsonProperty("resources")
    public void setResources(List<Document> resources) {
        this.resources = resources;
    }

    public DashboardSearchResult withResources(List<Document> resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty("searchCount")
    public Optional<Integer> getSearchCount() {
        return Optional.ofNullable(searchCount);
    }

    @JsonProperty("searchCount")
    public void setSearchCount(Integer searchCount) {
        this.searchCount = searchCount;
    }

    public DashboardSearchResult withSearchCount(Integer searchCount) {
        this.searchCount = searchCount;
        return this;
    }

    @JsonProperty("userCount")
    public Optional<Integer> getUserCount() {
        return Optional.ofNullable(userCount);
    }

    @JsonProperty("userCount")
    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public DashboardSearchResult withUserCount(Integer userCount) {
        this.userCount = userCount;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<User>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<User> users) {
        this.users = users;
    }

    public DashboardSearchResult withUsers(List<User> users) {
        this.users = users;
        return this;
    }

    @JsonProperty("visualizationCount")
    public Optional<Integer> getVisualizationCount() {
        return Optional.ofNullable(visualizationCount);
    }

    @JsonProperty("visualizationCount")
    public void setVisualizationCount(Integer visualizationCount) {
        this.visualizationCount = visualizationCount;
    }

    public DashboardSearchResult withVisualizationCount(Integer visualizationCount) {
        this.visualizationCount = visualizationCount;
        return this;
    }

    @JsonProperty("visualizations")
    public Optional<List<SimpleVisualizationView>> getVisualizations() {
        return Optional.ofNullable(visualizations);
    }

    @JsonProperty("visualizations")
    public void setVisualizations(List<SimpleVisualizationView> visualizations) {
        this.visualizations = visualizations;
    }

    public DashboardSearchResult withVisualizations(List<SimpleVisualizationView> visualizations) {
        this.visualizations = visualizations;
        return this;
    }

    @JsonAnyGetter
    public java.util.Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DashboardSearchResult withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("appCount".equals(name)) {
            if (value instanceof Integer) {
                setAppCount(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"appCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("apps".equals(name)) {
                if (value instanceof List) {
                    setApps(((List<App> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"apps\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.App>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("chartCount".equals(name)) {
                    if (value instanceof Integer) {
                        setChartCount(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"chartCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("charts".equals(name)) {
                        if (value instanceof List) {
                            setCharts(((List<Visualization> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"charts\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Visualization>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("eventChartCount".equals(name)) {
                            if (value instanceof Integer) {
                                setEventChartCount(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"eventChartCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("eventCharts".equals(name)) {
                                if (value instanceof List) {
                                    setEventCharts(((List<EventChart> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"eventCharts\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.EventChart>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("eventReportCount".equals(name)) {
                                    if (value instanceof Integer) {
                                        setEventReportCount(((Integer) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"eventReportCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("eventReports".equals(name)) {
                                        if (value instanceof List) {
                                            setEventReports(((List<EventReport> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"eventReports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.EventReport>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("mapCount".equals(name)) {
                                            if (value instanceof Integer) {
                                                setMapCount(((Integer) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"mapCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("maps".equals(name)) {
                                                if (value instanceof List) {
                                                    setMaps(((List<org.hisp.dhis.api.model.v2_36_11.Map> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"maps\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Map>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("reportCount".equals(name)) {
                                                    if (value instanceof Integer) {
                                                        setReportCount(((Integer) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"reportCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("reportTableCount".equals(name)) {
                                                        if (value instanceof Integer) {
                                                            setReportTableCount(((Integer) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"reportTableCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("reportTables".equals(name)) {
                                                            if (value instanceof List) {
                                                                setReportTables(((List<Visualization> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"reportTables\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Visualization>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("reports".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setReports(((List<Report> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"reports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Report>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("resourceCount".equals(name)) {
                                                                    if (value instanceof Integer) {
                                                                        setResourceCount(((Integer) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"resourceCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("resources".equals(name)) {
                                                                        if (value instanceof List) {
                                                                            setResources(((List<Document> ) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"resources\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Document>\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("searchCount".equals(name)) {
                                                                            if (value instanceof Integer) {
                                                                                setSearchCount(((Integer) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"searchCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("userCount".equals(name)) {
                                                                                if (value instanceof Integer) {
                                                                                    setUserCount(((Integer) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"userCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("users".equals(name)) {
                                                                                    if (value instanceof List) {
                                                                                        setUsers(((List<User> ) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.User>\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("visualizationCount".equals(name)) {
                                                                                        if (value instanceof Integer) {
                                                                                            setVisualizationCount(((Integer) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"visualizationCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("visualizations".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setVisualizations(((List<SimpleVisualizationView> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"visualizations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.SimpleVisualizationView>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            return false;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("appCount".equals(name)) {
            return getAppCount();
        } else {
            if ("apps".equals(name)) {
                return getApps();
            } else {
                if ("chartCount".equals(name)) {
                    return getChartCount();
                } else {
                    if ("charts".equals(name)) {
                        return getCharts();
                    } else {
                        if ("eventChartCount".equals(name)) {
                            return getEventChartCount();
                        } else {
                            if ("eventCharts".equals(name)) {
                                return getEventCharts();
                            } else {
                                if ("eventReportCount".equals(name)) {
                                    return getEventReportCount();
                                } else {
                                    if ("eventReports".equals(name)) {
                                        return getEventReports();
                                    } else {
                                        if ("mapCount".equals(name)) {
                                            return getMapCount();
                                        } else {
                                            if ("maps".equals(name)) {
                                                return getMaps();
                                            } else {
                                                if ("reportCount".equals(name)) {
                                                    return getReportCount();
                                                } else {
                                                    if ("reportTableCount".equals(name)) {
                                                        return getReportTableCount();
                                                    } else {
                                                        if ("reportTables".equals(name)) {
                                                            return getReportTables();
                                                        } else {
                                                            if ("reports".equals(name)) {
                                                                return getReports();
                                                            } else {
                                                                if ("resourceCount".equals(name)) {
                                                                    return getResourceCount();
                                                                } else {
                                                                    if ("resources".equals(name)) {
                                                                        return getResources();
                                                                    } else {
                                                                        if ("searchCount".equals(name)) {
                                                                            return getSearchCount();
                                                                        } else {
                                                                            if ("userCount".equals(name)) {
                                                                                return getUserCount();
                                                                            } else {
                                                                                if ("users".equals(name)) {
                                                                                    return getUsers();
                                                                                } else {
                                                                                    if ("visualizationCount".equals(name)) {
                                                                                        return getVisualizationCount();
                                                                                    } else {
                                                                                        if ("visualizations".equals(name)) {
                                                                                            return getVisualizations();
                                                                                        } else {
                                                                                            return notFoundValue;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DashboardSearchResult.NOT_FOUND_VALUE);
        if (DashboardSearchResult.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DashboardSearchResult with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DashboardSearchResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("appCount");
        sb.append('=');
        sb.append(((this.appCount == null)?"<null>":this.appCount));
        sb.append(',');
        sb.append("apps");
        sb.append('=');
        sb.append(((this.apps == null)?"<null>":this.apps));
        sb.append(',');
        sb.append("chartCount");
        sb.append('=');
        sb.append(((this.chartCount == null)?"<null>":this.chartCount));
        sb.append(',');
        sb.append("charts");
        sb.append('=');
        sb.append(((this.charts == null)?"<null>":this.charts));
        sb.append(',');
        sb.append("eventChartCount");
        sb.append('=');
        sb.append(((this.eventChartCount == null)?"<null>":this.eventChartCount));
        sb.append(',');
        sb.append("eventCharts");
        sb.append('=');
        sb.append(((this.eventCharts == null)?"<null>":this.eventCharts));
        sb.append(',');
        sb.append("eventReportCount");
        sb.append('=');
        sb.append(((this.eventReportCount == null)?"<null>":this.eventReportCount));
        sb.append(',');
        sb.append("eventReports");
        sb.append('=');
        sb.append(((this.eventReports == null)?"<null>":this.eventReports));
        sb.append(',');
        sb.append("mapCount");
        sb.append('=');
        sb.append(((this.mapCount == null)?"<null>":this.mapCount));
        sb.append(',');
        sb.append("maps");
        sb.append('=');
        sb.append(((this.maps == null)?"<null>":this.maps));
        sb.append(',');
        sb.append("reportCount");
        sb.append('=');
        sb.append(((this.reportCount == null)?"<null>":this.reportCount));
        sb.append(',');
        sb.append("reportTableCount");
        sb.append('=');
        sb.append(((this.reportTableCount == null)?"<null>":this.reportTableCount));
        sb.append(',');
        sb.append("reportTables");
        sb.append('=');
        sb.append(((this.reportTables == null)?"<null>":this.reportTables));
        sb.append(',');
        sb.append("reports");
        sb.append('=');
        sb.append(((this.reports == null)?"<null>":this.reports));
        sb.append(',');
        sb.append("resourceCount");
        sb.append('=');
        sb.append(((this.resourceCount == null)?"<null>":this.resourceCount));
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(((this.resources == null)?"<null>":this.resources));
        sb.append(',');
        sb.append("searchCount");
        sb.append('=');
        sb.append(((this.searchCount == null)?"<null>":this.searchCount));
        sb.append(',');
        sb.append("userCount");
        sb.append('=');
        sb.append(((this.userCount == null)?"<null>":this.userCount));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("visualizationCount");
        sb.append('=');
        sb.append(((this.visualizationCount == null)?"<null>":this.visualizationCount));
        sb.append(',');
        sb.append("visualizations");
        sb.append('=');
        sb.append(((this.visualizations == null)?"<null>":this.visualizations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.appCount == null)? 0 :this.appCount.hashCode()));
        result = ((result* 31)+((this.reportTables == null)? 0 :this.reportTables.hashCode()));
        result = ((result* 31)+((this.reports == null)? 0 :this.reports.hashCode()));
        result = ((result* 31)+((this.charts == null)? 0 :this.charts.hashCode()));
        result = ((result* 31)+((this.eventChartCount == null)? 0 :this.eventChartCount.hashCode()));
        result = ((result* 31)+((this.visualizations == null)? 0 :this.visualizations.hashCode()));
        result = ((result* 31)+((this.eventReports == null)? 0 :this.eventReports.hashCode()));
        result = ((result* 31)+((this.maps == null)? 0 :this.maps.hashCode()));
        result = ((result* 31)+((this.reportTableCount == null)? 0 :this.reportTableCount.hashCode()));
        result = ((result* 31)+((this.eventReportCount == null)? 0 :this.eventReportCount.hashCode()));
        result = ((result* 31)+((this.searchCount == null)? 0 :this.searchCount.hashCode()));
        result = ((result* 31)+((this.resources == null)? 0 :this.resources.hashCode()));
        result = ((result* 31)+((this.visualizationCount == null)? 0 :this.visualizationCount.hashCode()));
        result = ((result* 31)+((this.eventCharts == null)? 0 :this.eventCharts.hashCode()));
        result = ((result* 31)+((this.mapCount == null)? 0 :this.mapCount.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.chartCount == null)? 0 :this.chartCount.hashCode()));
        result = ((result* 31)+((this.userCount == null)? 0 :this.userCount.hashCode()));
        result = ((result* 31)+((this.resourceCount == null)? 0 :this.resourceCount.hashCode()));
        result = ((result* 31)+((this.reportCount == null)? 0 :this.reportCount.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.apps == null)? 0 :this.apps.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DashboardSearchResult) == false) {
            return false;
        }
        DashboardSearchResult rhs = ((DashboardSearchResult) other);
        return (((((((((((((((((((((((this.appCount == rhs.appCount)||((this.appCount!= null)&&this.appCount.equals(rhs.appCount)))&&((this.reportTables == rhs.reportTables)||((this.reportTables!= null)&&this.reportTables.equals(rhs.reportTables))))&&((this.reports == rhs.reports)||((this.reports!= null)&&this.reports.equals(rhs.reports))))&&((this.charts == rhs.charts)||((this.charts!= null)&&this.charts.equals(rhs.charts))))&&((this.eventChartCount == rhs.eventChartCount)||((this.eventChartCount!= null)&&this.eventChartCount.equals(rhs.eventChartCount))))&&((this.visualizations == rhs.visualizations)||((this.visualizations!= null)&&this.visualizations.equals(rhs.visualizations))))&&((this.eventReports == rhs.eventReports)||((this.eventReports!= null)&&this.eventReports.equals(rhs.eventReports))))&&((this.maps == rhs.maps)||((this.maps!= null)&&this.maps.equals(rhs.maps))))&&((this.reportTableCount == rhs.reportTableCount)||((this.reportTableCount!= null)&&this.reportTableCount.equals(rhs.reportTableCount))))&&((this.eventReportCount == rhs.eventReportCount)||((this.eventReportCount!= null)&&this.eventReportCount.equals(rhs.eventReportCount))))&&((this.searchCount == rhs.searchCount)||((this.searchCount!= null)&&this.searchCount.equals(rhs.searchCount))))&&((this.resources == rhs.resources)||((this.resources!= null)&&this.resources.equals(rhs.resources))))&&((this.visualizationCount == rhs.visualizationCount)||((this.visualizationCount!= null)&&this.visualizationCount.equals(rhs.visualizationCount))))&&((this.eventCharts == rhs.eventCharts)||((this.eventCharts!= null)&&this.eventCharts.equals(rhs.eventCharts))))&&((this.mapCount == rhs.mapCount)||((this.mapCount!= null)&&this.mapCount.equals(rhs.mapCount))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.chartCount == rhs.chartCount)||((this.chartCount!= null)&&this.chartCount.equals(rhs.chartCount))))&&((this.userCount == rhs.userCount)||((this.userCount!= null)&&this.userCount.equals(rhs.userCount))))&&((this.resourceCount == rhs.resourceCount)||((this.resourceCount!= null)&&this.resourceCount.equals(rhs.resourceCount))))&&((this.reportCount == rhs.reportCount)||((this.reportCount!= null)&&this.reportCount.equals(rhs.reportCount))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.apps == rhs.apps)||((this.apps!= null)&&this.apps.equals(rhs.apps))));
    }

}
