
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "deleted",
    "ignored",
    "imported",
    "updated"
})
@Generated("jsonschema2pojo")
public class ImportCount implements Serializable
{

    @JsonProperty("deleted")
    private Integer deleted;
    @JsonProperty("ignored")
    private Integer ignored;
    @JsonProperty("imported")
    private Integer imported;
    @JsonProperty("updated")
    private Integer updated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 732833980175062105L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportCount() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportCount(ImportCount source) {
        super();
        this.deleted = source.deleted;
        this.ignored = source.ignored;
        this.imported = source.imported;
        this.updated = source.updated;
    }

    public ImportCount(Integer deleted, Integer ignored, Integer imported, Integer updated) {
        super();
        this.deleted = deleted;
        this.ignored = ignored;
        this.imported = imported;
        this.updated = updated;
    }

    @JsonProperty("deleted")
    public Optional<Integer> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public ImportCount withDeleted(Integer deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("ignored")
    public Optional<Integer> getIgnored() {
        return Optional.ofNullable(ignored);
    }

    @JsonProperty("ignored")
    public void setIgnored(Integer ignored) {
        this.ignored = ignored;
    }

    public ImportCount withIgnored(Integer ignored) {
        this.ignored = ignored;
        return this;
    }

    @JsonProperty("imported")
    public Optional<Integer> getImported() {
        return Optional.ofNullable(imported);
    }

    @JsonProperty("imported")
    public void setImported(Integer imported) {
        this.imported = imported;
    }

    public ImportCount withImported(Integer imported) {
        this.imported = imported;
        return this;
    }

    @JsonProperty("updated")
    public Optional<Integer> getUpdated() {
        return Optional.ofNullable(updated);
    }

    @JsonProperty("updated")
    public void setUpdated(Integer updated) {
        this.updated = updated;
    }

    public ImportCount withUpdated(Integer updated) {
        this.updated = updated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportCount withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("deleted".equals(name)) {
            if (value instanceof Integer) {
                setDeleted(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("ignored".equals(name)) {
                if (value instanceof Integer) {
                    setIgnored(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"ignored\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("imported".equals(name)) {
                    if (value instanceof Integer) {
                        setImported(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"imported\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("updated".equals(name)) {
                        if (value instanceof Integer) {
                            setUpdated(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"updated\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("deleted".equals(name)) {
            return getDeleted();
        } else {
            if ("ignored".equals(name)) {
                return getIgnored();
            } else {
                if ("imported".equals(name)) {
                    return getImported();
                } else {
                    if ("updated".equals(name)) {
                        return getUpdated();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportCount.NOT_FOUND_VALUE);
        if (ImportCount.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportCount with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportCount.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("ignored");
        sb.append('=');
        sb.append(((this.ignored == null)?"<null>":this.ignored));
        sb.append(',');
        sb.append("imported");
        sb.append('=');
        sb.append(((this.imported == null)?"<null>":this.imported));
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(((this.updated == null)?"<null>":this.updated));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.ignored == null)? 0 :this.ignored.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.imported == null)? 0 :this.imported.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.updated == null)? 0 :this.updated.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportCount) == false) {
            return false;
        }
        ImportCount rhs = ((ImportCount) other);
        return ((((((this.ignored == rhs.ignored)||((this.ignored!= null)&&this.ignored.equals(rhs.ignored)))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.imported == rhs.imported)||((this.imported!= null)&&this.imported.equals(rhs.imported))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.updated == rhs.updated)||((this.updated!= null)&&this.updated.equals(rhs.updated))));
    }

}
