
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "algorithm",
    "count",
    "dataEndDate",
    "dataStartDate",
    "maxResults",
    "orderBy",
    "threshold"
})
@Generated("jsonschema2pojo")
public class OutlierDetectionMetadata implements Serializable
{

    @JsonProperty("algorithm")
    private OutlierDetectionAlgorithm algorithm;
    @JsonProperty("count")
    private Integer count;
    @JsonProperty("dataEndDate")
    private Date dataEndDate;
    @JsonProperty("dataStartDate")
    private Date dataStartDate;
    @JsonProperty("maxResults")
    private Integer maxResults;
    @JsonProperty("orderBy")
    private Order orderBy;
    @JsonProperty("threshold")
    private Double threshold;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3597664932488096709L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OutlierDetectionMetadata() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OutlierDetectionMetadata(OutlierDetectionMetadata source) {
        super();
        this.algorithm = source.algorithm;
        this.count = source.count;
        this.dataEndDate = source.dataEndDate;
        this.dataStartDate = source.dataStartDate;
        this.maxResults = source.maxResults;
        this.orderBy = source.orderBy;
        this.threshold = source.threshold;
    }

    public OutlierDetectionMetadata(OutlierDetectionAlgorithm algorithm, Integer count, Date dataEndDate, Date dataStartDate, Integer maxResults, Order orderBy, Double threshold) {
        super();
        this.algorithm = algorithm;
        this.count = count;
        this.dataEndDate = dataEndDate;
        this.dataStartDate = dataStartDate;
        this.maxResults = maxResults;
        this.orderBy = orderBy;
        this.threshold = threshold;
    }

    @JsonProperty("algorithm")
    public Optional<OutlierDetectionAlgorithm> getAlgorithm() {
        return Optional.ofNullable(algorithm);
    }

    @JsonProperty("algorithm")
    public void setAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public OutlierDetectionMetadata withAlgorithm(OutlierDetectionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty("count")
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    @JsonProperty("count")
    public void setCount(Integer count) {
        this.count = count;
    }

    public OutlierDetectionMetadata withCount(Integer count) {
        this.count = count;
        return this;
    }

    @JsonProperty("dataEndDate")
    public Optional<Date> getDataEndDate() {
        return Optional.ofNullable(dataEndDate);
    }

    @JsonProperty("dataEndDate")
    public void setDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
    }

    public OutlierDetectionMetadata withDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
        return this;
    }

    @JsonProperty("dataStartDate")
    public Optional<Date> getDataStartDate() {
        return Optional.ofNullable(dataStartDate);
    }

    @JsonProperty("dataStartDate")
    public void setDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public OutlierDetectionMetadata withDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
        return this;
    }

    @JsonProperty("maxResults")
    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(maxResults);
    }

    @JsonProperty("maxResults")
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public OutlierDetectionMetadata withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @JsonProperty("orderBy")
    public Optional<Order> getOrderBy() {
        return Optional.ofNullable(orderBy);
    }

    @JsonProperty("orderBy")
    public void setOrderBy(Order orderBy) {
        this.orderBy = orderBy;
    }

    public OutlierDetectionMetadata withOrderBy(Order orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @JsonProperty("threshold")
    public Optional<Double> getThreshold() {
        return Optional.ofNullable(threshold);
    }

    @JsonProperty("threshold")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public OutlierDetectionMetadata withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierDetectionMetadata withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("algorithm".equals(name)) {
            if (value instanceof OutlierDetectionAlgorithm) {
                setAlgorithm(((OutlierDetectionAlgorithm) value));
            } else {
                throw new IllegalArgumentException(("property \"algorithm\" is of type \"org.hisp.dhis.api.model.v2_36_11.OutlierDetectionAlgorithm\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("count".equals(name)) {
                if (value instanceof Integer) {
                    setCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"count\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataEndDate".equals(name)) {
                    if (value instanceof Date) {
                        setDataEndDate(((Date) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataEndDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dataStartDate".equals(name)) {
                        if (value instanceof Date) {
                            setDataStartDate(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dataStartDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("maxResults".equals(name)) {
                            if (value instanceof Integer) {
                                setMaxResults(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"maxResults\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("orderBy".equals(name)) {
                                if (value instanceof Order) {
                                    setOrderBy(((Order) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"orderBy\" is of type \"org.hisp.dhis.api.model.v2_36_11.Order\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("threshold".equals(name)) {
                                    if (value instanceof Double) {
                                        setThreshold(((Double) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"threshold\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("algorithm".equals(name)) {
            return getAlgorithm();
        } else {
            if ("count".equals(name)) {
                return getCount();
            } else {
                if ("dataEndDate".equals(name)) {
                    return getDataEndDate();
                } else {
                    if ("dataStartDate".equals(name)) {
                        return getDataStartDate();
                    } else {
                        if ("maxResults".equals(name)) {
                            return getMaxResults();
                        } else {
                            if ("orderBy".equals(name)) {
                                return getOrderBy();
                            } else {
                                if ("threshold".equals(name)) {
                                    return getThreshold();
                                } else {
                                    return notFoundValue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OutlierDetectionMetadata.NOT_FOUND_VALUE);
        if (OutlierDetectionMetadata.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OutlierDetectionMetadata with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierDetectionMetadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(((this.algorithm == null)?"<null>":this.algorithm));
        sb.append(',');
        sb.append("count");
        sb.append('=');
        sb.append(((this.count == null)?"<null>":this.count));
        sb.append(',');
        sb.append("dataEndDate");
        sb.append('=');
        sb.append(((this.dataEndDate == null)?"<null>":this.dataEndDate));
        sb.append(',');
        sb.append("dataStartDate");
        sb.append('=');
        sb.append(((this.dataStartDate == null)?"<null>":this.dataStartDate));
        sb.append(',');
        sb.append("maxResults");
        sb.append('=');
        sb.append(((this.maxResults == null)?"<null>":this.maxResults));
        sb.append(',');
        sb.append("orderBy");
        sb.append('=');
        sb.append(((this.orderBy == null)?"<null>":this.orderBy));
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(((this.threshold == null)?"<null>":this.threshold));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataStartDate == null)? 0 :this.dataStartDate.hashCode()));
        result = ((result* 31)+((this.maxResults == null)? 0 :this.maxResults.hashCode()));
        result = ((result* 31)+((this.count == null)? 0 :this.count.hashCode()));
        result = ((result* 31)+((this.orderBy == null)? 0 :this.orderBy.hashCode()));
        result = ((result* 31)+((this.threshold == null)? 0 :this.threshold.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataEndDate == null)? 0 :this.dataEndDate.hashCode()));
        result = ((result* 31)+((this.algorithm == null)? 0 :this.algorithm.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OutlierDetectionMetadata) == false) {
            return false;
        }
        OutlierDetectionMetadata rhs = ((OutlierDetectionMetadata) other);
        return (((((((((this.dataStartDate == rhs.dataStartDate)||((this.dataStartDate!= null)&&this.dataStartDate.equals(rhs.dataStartDate)))&&((this.maxResults == rhs.maxResults)||((this.maxResults!= null)&&this.maxResults.equals(rhs.maxResults))))&&((this.count == rhs.count)||((this.count!= null)&&this.count.equals(rhs.count))))&&((this.orderBy == rhs.orderBy)||((this.orderBy!= null)&&this.orderBy.equals(rhs.orderBy))))&&((this.threshold == rhs.threshold)||((this.threshold!= null)&&this.threshold.equals(rhs.threshold))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataEndDate == rhs.dataEndDate)||((this.dataEndDate!= null)&&this.dataEndDate.equals(rhs.dataEndDate))))&&((this.algorithm == rhs.algorithm)||((this.algorithm!= null)&&this.algorithm.equals(rhs.algorithm))));
    }

}
