
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "predictorGroups",
    "predictors",
    "relativeEnd",
    "relativeStart"
})
@Generated("jsonschema2pojo")
public class PredictorJobParameters implements Serializable
{

    @JsonProperty("predictorGroups")
    private List<String> predictorGroups;
    @JsonProperty("predictors")
    private List<String> predictors;
    @JsonProperty("relativeEnd")
    private Integer relativeEnd;
    @JsonProperty("relativeStart")
    private Integer relativeStart;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4649644879696578933L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PredictorJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public PredictorJobParameters(PredictorJobParameters source) {
        super();
        this.predictorGroups = source.predictorGroups;
        this.predictors = source.predictors;
        this.relativeEnd = source.relativeEnd;
        this.relativeStart = source.relativeStart;
    }

    public PredictorJobParameters(List<String> predictorGroups, List<String> predictors, Integer relativeEnd, Integer relativeStart) {
        super();
        this.predictorGroups = predictorGroups;
        this.predictors = predictors;
        this.relativeEnd = relativeEnd;
        this.relativeStart = relativeStart;
    }

    @JsonProperty("predictorGroups")
    public Optional<List<String>> getPredictorGroups() {
        return Optional.ofNullable(predictorGroups);
    }

    @JsonProperty("predictorGroups")
    public void setPredictorGroups(List<String> predictorGroups) {
        this.predictorGroups = predictorGroups;
    }

    public PredictorJobParameters withPredictorGroups(List<String> predictorGroups) {
        this.predictorGroups = predictorGroups;
        return this;
    }

    @JsonProperty("predictors")
    public Optional<List<String>> getPredictors() {
        return Optional.ofNullable(predictors);
    }

    @JsonProperty("predictors")
    public void setPredictors(List<String> predictors) {
        this.predictors = predictors;
    }

    public PredictorJobParameters withPredictors(List<String> predictors) {
        this.predictors = predictors;
        return this;
    }

    @JsonProperty("relativeEnd")
    public Optional<Integer> getRelativeEnd() {
        return Optional.ofNullable(relativeEnd);
    }

    @JsonProperty("relativeEnd")
    public void setRelativeEnd(Integer relativeEnd) {
        this.relativeEnd = relativeEnd;
    }

    public PredictorJobParameters withRelativeEnd(Integer relativeEnd) {
        this.relativeEnd = relativeEnd;
        return this;
    }

    @JsonProperty("relativeStart")
    public Optional<Integer> getRelativeStart() {
        return Optional.ofNullable(relativeStart);
    }

    @JsonProperty("relativeStart")
    public void setRelativeStart(Integer relativeStart) {
        this.relativeStart = relativeStart;
    }

    public PredictorJobParameters withRelativeStart(Integer relativeStart) {
        this.relativeStart = relativeStart;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PredictorJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("predictorGroups".equals(name)) {
            if (value instanceof List) {
                setPredictorGroups(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"predictorGroups\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("predictors".equals(name)) {
                if (value instanceof List) {
                    setPredictors(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"predictors\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("relativeEnd".equals(name)) {
                    if (value instanceof Integer) {
                        setRelativeEnd(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"relativeEnd\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("relativeStart".equals(name)) {
                        if (value instanceof Integer) {
                            setRelativeStart(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"relativeStart\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("predictorGroups".equals(name)) {
            return getPredictorGroups();
        } else {
            if ("predictors".equals(name)) {
                return getPredictors();
            } else {
                if ("relativeEnd".equals(name)) {
                    return getRelativeEnd();
                } else {
                    if ("relativeStart".equals(name)) {
                        return getRelativeStart();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, PredictorJobParameters.NOT_FOUND_VALUE);
        if (PredictorJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public PredictorJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PredictorJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("predictorGroups");
        sb.append('=');
        sb.append(((this.predictorGroups == null)?"<null>":this.predictorGroups));
        sb.append(',');
        sb.append("predictors");
        sb.append('=');
        sb.append(((this.predictors == null)?"<null>":this.predictors));
        sb.append(',');
        sb.append("relativeEnd");
        sb.append('=');
        sb.append(((this.relativeEnd == null)?"<null>":this.relativeEnd));
        sb.append(',');
        sb.append("relativeStart");
        sb.append('=');
        sb.append(((this.relativeStart == null)?"<null>":this.relativeStart));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.predictors == null)? 0 :this.predictors.hashCode()));
        result = ((result* 31)+((this.relativeEnd == null)? 0 :this.relativeEnd.hashCode()));
        result = ((result* 31)+((this.predictorGroups == null)? 0 :this.predictorGroups.hashCode()));
        result = ((result* 31)+((this.relativeStart == null)? 0 :this.relativeStart.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PredictorJobParameters) == false) {
            return false;
        }
        PredictorJobParameters rhs = ((PredictorJobParameters) other);
        return ((((((this.predictors == rhs.predictors)||((this.predictors!= null)&&this.predictors.equals(rhs.predictors)))&&((this.relativeEnd == rhs.relativeEnd)||((this.relativeEnd!= null)&&this.relativeEnd.equals(rhs.relativeEnd))))&&((this.predictorGroups == rhs.predictorGroups)||((this.predictorGroups!= null)&&this.predictorGroups.equals(rhs.predictorGroups))))&&((this.relativeStart == rhs.relativeStart)||((this.relativeStart!= null)&&this.relativeStart.equals(rhs.relativeStart))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
