
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "emailAddresses",
    "organisationUnit",
    "phoneNumbers",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class ProgramMessageRecipients implements Serializable
{

    @JsonProperty("emailAddresses")
    private List<String> emailAddresses;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("phoneNumbers")
    private List<String> phoneNumbers;
    @JsonProperty("trackedEntityInstance")
    private TrackedEntityInstance__1 trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5691681171959711641L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramMessageRecipients() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramMessageRecipients(ProgramMessageRecipients source) {
        super();
        this.emailAddresses = source.emailAddresses;
        this.organisationUnit = source.organisationUnit;
        this.phoneNumbers = source.phoneNumbers;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    public ProgramMessageRecipients(List<String> emailAddresses, OrganisationUnit organisationUnit, List<String> phoneNumbers, TrackedEntityInstance__1 trackedEntityInstance) {
        super();
        this.emailAddresses = emailAddresses;
        this.organisationUnit = organisationUnit;
        this.phoneNumbers = phoneNumbers;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("emailAddresses")
    public Optional<List<String>> getEmailAddresses() {
        return Optional.ofNullable(emailAddresses);
    }

    @JsonProperty("emailAddresses")
    public void setEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public ProgramMessageRecipients withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public ProgramMessageRecipients withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("phoneNumbers")
    public Optional<List<String>> getPhoneNumbers() {
        return Optional.ofNullable(phoneNumbers);
    }

    @JsonProperty("phoneNumbers")
    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ProgramMessageRecipients withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<TrackedEntityInstance__1> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public ProgramMessageRecipients withTrackedEntityInstance(TrackedEntityInstance__1 trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramMessageRecipients withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("emailAddresses".equals(name)) {
            if (value instanceof List) {
                setEmailAddresses(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"emailAddresses\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("organisationUnit".equals(name)) {
                if (value instanceof OrganisationUnit) {
                    setOrganisationUnit(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_36_11.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("phoneNumbers".equals(name)) {
                    if (value instanceof List) {
                        setPhoneNumbers(((List<String> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"phoneNumbers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("trackedEntityInstance".equals(name)) {
                        if (value instanceof TrackedEntityInstance__1) {
                            setTrackedEntityInstance(((TrackedEntityInstance__1) value));
                        } else {
                            throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"org.hisp.dhis.api.model.v2_36_11.TrackedEntityInstance__1\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("emailAddresses".equals(name)) {
            return getEmailAddresses();
        } else {
            if ("organisationUnit".equals(name)) {
                return getOrganisationUnit();
            } else {
                if ("phoneNumbers".equals(name)) {
                    return getPhoneNumbers();
                } else {
                    if ("trackedEntityInstance".equals(name)) {
                        return getTrackedEntityInstance();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramMessageRecipients.NOT_FOUND_VALUE);
        if (ProgramMessageRecipients.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramMessageRecipients with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramMessageRecipients.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("emailAddresses");
        sb.append('=');
        sb.append(((this.emailAddresses == null)?"<null>":this.emailAddresses));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("phoneNumbers");
        sb.append('=');
        sb.append(((this.phoneNumbers == null)?"<null>":this.phoneNumbers));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.emailAddresses == null)? 0 :this.emailAddresses.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.phoneNumbers == null)? 0 :this.phoneNumbers.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramMessageRecipients) == false) {
            return false;
        }
        ProgramMessageRecipients rhs = ((ProgramMessageRecipients) other);
        return ((((((this.emailAddresses == rhs.emailAddresses)||((this.emailAddresses!= null)&&this.emailAddresses.equals(rhs.emailAddresses)))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.phoneNumbers == rhs.phoneNumbers)||((this.phoneNumbers!= null)&&this.phoneNumbers.equals(rhs.phoneNumbers))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
