
package org.hisp.dhis.api.model.v2_36_11;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiEndpoint",
    "authorities",
    "collectionName",
    "dataReadShareable",
    "dataShareable",
    "dataWriteShareable",
    "defaultPrivate",
    "displayName",
    "embeddedObject",
    "favoritable",
    "href",
    "identifiableObject",
    "implicitPrivateAuthority",
    "klass",
    "metadata",
    "name",
    "nameableObject",
    "namespace",
    "order",
    "persisted",
    "plural",
    "properties",
    "references",
    "relativeApiEndpoint",
    "secondaryMetadata",
    "shareable",
    "singular",
    "subscribable",
    "subscribableObject",
    "translatable"
})
@Generated("jsonschema2pojo")
public class Schema implements Serializable
{

    @JsonProperty("apiEndpoint")
    private String apiEndpoint;
    @JsonProperty("authorities")
    private List<Authority> authorities;
    @JsonProperty("collectionName")
    private String collectionName;
    @JsonProperty("dataReadShareable")
    private Boolean dataReadShareable;
    @JsonProperty("dataShareable")
    private Boolean dataShareable;
    @JsonProperty("dataWriteShareable")
    private Boolean dataWriteShareable;
    @JsonProperty("defaultPrivate")
    private Boolean defaultPrivate;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("embeddedObject")
    private Boolean embeddedObject;
    @JsonProperty("favoritable")
    private Boolean favoritable;
    @JsonProperty("href")
    private String href;
    @JsonProperty("identifiableObject")
    private Boolean identifiableObject;
    @JsonProperty("implicitPrivateAuthority")
    private Boolean implicitPrivateAuthority;
    @JsonProperty("klass")
    private String klass;
    @JsonProperty("metadata")
    private Boolean metadata;
    @JsonProperty("name")
    private String name;
    @JsonProperty("nameableObject")
    private Boolean nameableObject;
    @JsonProperty("namespace")
    private String namespace;
    @JsonProperty("order")
    private Integer order;
    @JsonProperty("persisted")
    private Boolean persisted;
    @JsonProperty("plural")
    private String plural;
    @JsonProperty("properties")
    private List<Property> properties;
    @JsonProperty("references")
    private List<String> references;
    @JsonProperty("relativeApiEndpoint")
    private String relativeApiEndpoint;
    @JsonProperty("secondaryMetadata")
    private Boolean secondaryMetadata;
    @JsonProperty("shareable")
    private Boolean shareable;
    @JsonProperty("singular")
    private String singular;
    @JsonProperty("subscribable")
    private Boolean subscribable;
    @JsonProperty("subscribableObject")
    private Boolean subscribableObject;
    @JsonProperty("translatable")
    private Boolean translatable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1906842152089924980L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Schema() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Schema(Schema source) {
        super();
        this.apiEndpoint = source.apiEndpoint;
        this.authorities = source.authorities;
        this.collectionName = source.collectionName;
        this.dataReadShareable = source.dataReadShareable;
        this.dataShareable = source.dataShareable;
        this.dataWriteShareable = source.dataWriteShareable;
        this.defaultPrivate = source.defaultPrivate;
        this.displayName = source.displayName;
        this.embeddedObject = source.embeddedObject;
        this.favoritable = source.favoritable;
        this.href = source.href;
        this.identifiableObject = source.identifiableObject;
        this.implicitPrivateAuthority = source.implicitPrivateAuthority;
        this.klass = source.klass;
        this.metadata = source.metadata;
        this.name = source.name;
        this.nameableObject = source.nameableObject;
        this.namespace = source.namespace;
        this.order = source.order;
        this.persisted = source.persisted;
        this.plural = source.plural;
        this.properties = source.properties;
        this.references = source.references;
        this.relativeApiEndpoint = source.relativeApiEndpoint;
        this.secondaryMetadata = source.secondaryMetadata;
        this.shareable = source.shareable;
        this.singular = source.singular;
        this.subscribable = source.subscribable;
        this.subscribableObject = source.subscribableObject;
        this.translatable = source.translatable;
    }

    public Schema(String apiEndpoint, List<Authority> authorities, String collectionName, Boolean dataReadShareable, Boolean dataShareable, Boolean dataWriteShareable, Boolean defaultPrivate, String displayName, Boolean embeddedObject, Boolean favoritable, String href, Boolean identifiableObject, Boolean implicitPrivateAuthority, String klass, Boolean metadata, String name, Boolean nameableObject, String namespace, Integer order, Boolean persisted, String plural, List<Property> properties, List<String> references, String relativeApiEndpoint, Boolean secondaryMetadata, Boolean shareable, String singular, Boolean subscribable, Boolean subscribableObject, Boolean translatable) {
        super();
        this.apiEndpoint = apiEndpoint;
        this.authorities = authorities;
        this.collectionName = collectionName;
        this.dataReadShareable = dataReadShareable;
        this.dataShareable = dataShareable;
        this.dataWriteShareable = dataWriteShareable;
        this.defaultPrivate = defaultPrivate;
        this.displayName = displayName;
        this.embeddedObject = embeddedObject;
        this.favoritable = favoritable;
        this.href = href;
        this.identifiableObject = identifiableObject;
        this.implicitPrivateAuthority = implicitPrivateAuthority;
        this.klass = klass;
        this.metadata = metadata;
        this.name = name;
        this.nameableObject = nameableObject;
        this.namespace = namespace;
        this.order = order;
        this.persisted = persisted;
        this.plural = plural;
        this.properties = properties;
        this.references = references;
        this.relativeApiEndpoint = relativeApiEndpoint;
        this.secondaryMetadata = secondaryMetadata;
        this.shareable = shareable;
        this.singular = singular;
        this.subscribable = subscribable;
        this.subscribableObject = subscribableObject;
        this.translatable = translatable;
    }

    @JsonProperty("apiEndpoint")
    public Optional<String> getApiEndpoint() {
        return Optional.ofNullable(apiEndpoint);
    }

    @JsonProperty("apiEndpoint")
    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    public Schema withApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    @JsonProperty("authorities")
    public Optional<List<Authority>> getAuthorities() {
        return Optional.ofNullable(authorities);
    }

    @JsonProperty("authorities")
    public void setAuthorities(List<Authority> authorities) {
        this.authorities = authorities;
    }

    public Schema withAuthorities(List<Authority> authorities) {
        this.authorities = authorities;
        return this;
    }

    @JsonProperty("collectionName")
    public Optional<String> getCollectionName() {
        return Optional.ofNullable(collectionName);
    }

    @JsonProperty("collectionName")
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public Schema withCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    @JsonProperty("dataReadShareable")
    public Optional<Boolean> getDataReadShareable() {
        return Optional.ofNullable(dataReadShareable);
    }

    @JsonProperty("dataReadShareable")
    public void setDataReadShareable(Boolean dataReadShareable) {
        this.dataReadShareable = dataReadShareable;
    }

    public Schema withDataReadShareable(Boolean dataReadShareable) {
        this.dataReadShareable = dataReadShareable;
        return this;
    }

    @JsonProperty("dataShareable")
    public Optional<Boolean> getDataShareable() {
        return Optional.ofNullable(dataShareable);
    }

    @JsonProperty("dataShareable")
    public void setDataShareable(Boolean dataShareable) {
        this.dataShareable = dataShareable;
    }

    public Schema withDataShareable(Boolean dataShareable) {
        this.dataShareable = dataShareable;
        return this;
    }

    @JsonProperty("dataWriteShareable")
    public Optional<Boolean> getDataWriteShareable() {
        return Optional.ofNullable(dataWriteShareable);
    }

    @JsonProperty("dataWriteShareable")
    public void setDataWriteShareable(Boolean dataWriteShareable) {
        this.dataWriteShareable = dataWriteShareable;
    }

    public Schema withDataWriteShareable(Boolean dataWriteShareable) {
        this.dataWriteShareable = dataWriteShareable;
        return this;
    }

    @JsonProperty("defaultPrivate")
    public Optional<Boolean> getDefaultPrivate() {
        return Optional.ofNullable(defaultPrivate);
    }

    @JsonProperty("defaultPrivate")
    public void setDefaultPrivate(Boolean defaultPrivate) {
        this.defaultPrivate = defaultPrivate;
    }

    public Schema withDefaultPrivate(Boolean defaultPrivate) {
        this.defaultPrivate = defaultPrivate;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Schema withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("embeddedObject")
    public Optional<Boolean> getEmbeddedObject() {
        return Optional.ofNullable(embeddedObject);
    }

    @JsonProperty("embeddedObject")
    public void setEmbeddedObject(Boolean embeddedObject) {
        this.embeddedObject = embeddedObject;
    }

    public Schema withEmbeddedObject(Boolean embeddedObject) {
        this.embeddedObject = embeddedObject;
        return this;
    }

    @JsonProperty("favoritable")
    public Optional<Boolean> getFavoritable() {
        return Optional.ofNullable(favoritable);
    }

    @JsonProperty("favoritable")
    public void setFavoritable(Boolean favoritable) {
        this.favoritable = favoritable;
    }

    public Schema withFavoritable(Boolean favoritable) {
        this.favoritable = favoritable;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Schema withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("identifiableObject")
    public Optional<Boolean> getIdentifiableObject() {
        return Optional.ofNullable(identifiableObject);
    }

    @JsonProperty("identifiableObject")
    public void setIdentifiableObject(Boolean identifiableObject) {
        this.identifiableObject = identifiableObject;
    }

    public Schema withIdentifiableObject(Boolean identifiableObject) {
        this.identifiableObject = identifiableObject;
        return this;
    }

    @JsonProperty("implicitPrivateAuthority")
    public Optional<Boolean> getImplicitPrivateAuthority() {
        return Optional.ofNullable(implicitPrivateAuthority);
    }

    @JsonProperty("implicitPrivateAuthority")
    public void setImplicitPrivateAuthority(Boolean implicitPrivateAuthority) {
        this.implicitPrivateAuthority = implicitPrivateAuthority;
    }

    public Schema withImplicitPrivateAuthority(Boolean implicitPrivateAuthority) {
        this.implicitPrivateAuthority = implicitPrivateAuthority;
        return this;
    }

    @JsonProperty("klass")
    public Optional<String> getKlass() {
        return Optional.ofNullable(klass);
    }

    @JsonProperty("klass")
    public void setKlass(String klass) {
        this.klass = klass;
    }

    public Schema withKlass(String klass) {
        this.klass = klass;
        return this;
    }

    @JsonProperty("metadata")
    public Optional<Boolean> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    @JsonProperty("metadata")
    public void setMetadata(Boolean metadata) {
        this.metadata = metadata;
    }

    public Schema withMetadata(Boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Schema withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("nameableObject")
    public Optional<Boolean> getNameableObject() {
        return Optional.ofNullable(nameableObject);
    }

    @JsonProperty("nameableObject")
    public void setNameableObject(Boolean nameableObject) {
        this.nameableObject = nameableObject;
    }

    public Schema withNameableObject(Boolean nameableObject) {
        this.nameableObject = nameableObject;
        return this;
    }

    @JsonProperty("namespace")
    public Optional<String> getNamespace() {
        return Optional.ofNullable(namespace);
    }

    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Schema withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty("order")
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(order);
    }

    @JsonProperty("order")
    public void setOrder(Integer order) {
        this.order = order;
    }

    public Schema withOrder(Integer order) {
        this.order = order;
        return this;
    }

    @JsonProperty("persisted")
    public Optional<Boolean> getPersisted() {
        return Optional.ofNullable(persisted);
    }

    @JsonProperty("persisted")
    public void setPersisted(Boolean persisted) {
        this.persisted = persisted;
    }

    public Schema withPersisted(Boolean persisted) {
        this.persisted = persisted;
        return this;
    }

    @JsonProperty("plural")
    public Optional<String> getPlural() {
        return Optional.ofNullable(plural);
    }

    @JsonProperty("plural")
    public void setPlural(String plural) {
        this.plural = plural;
    }

    public Schema withPlural(String plural) {
        this.plural = plural;
        return this;
    }

    @JsonProperty("properties")
    public Optional<List<Property>> getProperties() {
        return Optional.ofNullable(properties);
    }

    @JsonProperty("properties")
    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public Schema withProperties(List<Property> properties) {
        this.properties = properties;
        return this;
    }

    @JsonProperty("references")
    public Optional<List<String>> getReferences() {
        return Optional.ofNullable(references);
    }

    @JsonProperty("references")
    public void setReferences(List<String> references) {
        this.references = references;
    }

    public Schema withReferences(List<String> references) {
        this.references = references;
        return this;
    }

    @JsonProperty("relativeApiEndpoint")
    public Optional<String> getRelativeApiEndpoint() {
        return Optional.ofNullable(relativeApiEndpoint);
    }

    @JsonProperty("relativeApiEndpoint")
    public void setRelativeApiEndpoint(String relativeApiEndpoint) {
        this.relativeApiEndpoint = relativeApiEndpoint;
    }

    public Schema withRelativeApiEndpoint(String relativeApiEndpoint) {
        this.relativeApiEndpoint = relativeApiEndpoint;
        return this;
    }

    @JsonProperty("secondaryMetadata")
    public Optional<Boolean> getSecondaryMetadata() {
        return Optional.ofNullable(secondaryMetadata);
    }

    @JsonProperty("secondaryMetadata")
    public void setSecondaryMetadata(Boolean secondaryMetadata) {
        this.secondaryMetadata = secondaryMetadata;
    }

    public Schema withSecondaryMetadata(Boolean secondaryMetadata) {
        this.secondaryMetadata = secondaryMetadata;
        return this;
    }

    @JsonProperty("shareable")
    public Optional<Boolean> getShareable() {
        return Optional.ofNullable(shareable);
    }

    @JsonProperty("shareable")
    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    public Schema withShareable(Boolean shareable) {
        this.shareable = shareable;
        return this;
    }

    @JsonProperty("singular")
    public Optional<String> getSingular() {
        return Optional.ofNullable(singular);
    }

    @JsonProperty("singular")
    public void setSingular(String singular) {
        this.singular = singular;
    }

    public Schema withSingular(String singular) {
        this.singular = singular;
        return this;
    }

    @JsonProperty("subscribable")
    public Optional<Boolean> getSubscribable() {
        return Optional.ofNullable(subscribable);
    }

    @JsonProperty("subscribable")
    public void setSubscribable(Boolean subscribable) {
        this.subscribable = subscribable;
    }

    public Schema withSubscribable(Boolean subscribable) {
        this.subscribable = subscribable;
        return this;
    }

    @JsonProperty("subscribableObject")
    public Optional<Boolean> getSubscribableObject() {
        return Optional.ofNullable(subscribableObject);
    }

    @JsonProperty("subscribableObject")
    public void setSubscribableObject(Boolean subscribableObject) {
        this.subscribableObject = subscribableObject;
    }

    public Schema withSubscribableObject(Boolean subscribableObject) {
        this.subscribableObject = subscribableObject;
        return this;
    }

    @JsonProperty("translatable")
    public Optional<Boolean> getTranslatable() {
        return Optional.ofNullable(translatable);
    }

    @JsonProperty("translatable")
    public void setTranslatable(Boolean translatable) {
        this.translatable = translatable;
    }

    public Schema withTranslatable(Boolean translatable) {
        this.translatable = translatable;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Schema withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("apiEndpoint".equals(name)) {
            if (value instanceof String) {
                setApiEndpoint(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"apiEndpoint\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("authorities".equals(name)) {
                if (value instanceof List) {
                    setAuthorities(((List<Authority> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorities\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Authority>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("collectionName".equals(name)) {
                    if (value instanceof String) {
                        setCollectionName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"collectionName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dataReadShareable".equals(name)) {
                        if (value instanceof Boolean) {
                            setDataReadShareable(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dataReadShareable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("dataShareable".equals(name)) {
                            if (value instanceof Boolean) {
                                setDataShareable(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"dataShareable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataWriteShareable".equals(name)) {
                                if (value instanceof Boolean) {
                                    setDataWriteShareable(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataWriteShareable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("defaultPrivate".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setDefaultPrivate(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"defaultPrivate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("embeddedObject".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setEmbeddedObject(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"embeddedObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("favoritable".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setFavoritable(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"favoritable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("href".equals(name)) {
                                                    if (value instanceof String) {
                                                        setHref(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("identifiableObject".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setIdentifiableObject(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"identifiableObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("implicitPrivateAuthority".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setImplicitPrivateAuthority(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"implicitPrivateAuthority\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("klass".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setKlass(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"klass\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("metadata".equals(name)) {
                                                                    if (value instanceof Boolean) {
                                                                        setMetadata(((Boolean) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"metadata\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("nameableObject".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setNameableObject(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"nameableObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("namespace".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setNamespace(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"namespace\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("order".equals(name)) {
                                                                                    if (value instanceof Integer) {
                                                                                        setOrder(((Integer) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("persisted".equals(name)) {
                                                                                        if (value instanceof Boolean) {
                                                                                            setPersisted(((Boolean) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"persisted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("plural".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPlural(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"plural\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("properties".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setProperties(((List<Property> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"properties\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_36_11.Property>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("references".equals(name)) {
                                                                                                    if (value instanceof List) {
                                                                                                        setReferences(((List<String> ) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"references\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("relativeApiEndpoint".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setRelativeApiEndpoint(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"relativeApiEndpoint\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("secondaryMetadata".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setSecondaryMetadata(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"secondaryMetadata\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("shareable".equals(name)) {
                                                                                                                if (value instanceof Boolean) {
                                                                                                                    setShareable(((Boolean) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"shareable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("singular".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setSingular(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"singular\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("subscribable".equals(name)) {
                                                                                                                        if (value instanceof Boolean) {
                                                                                                                            setSubscribable(((Boolean) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"subscribable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("subscribableObject".equals(name)) {
                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                setSubscribableObject(((Boolean) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"subscribableObject\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("translatable".equals(name)) {
                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                    setTranslatable(((Boolean) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"translatable\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("apiEndpoint".equals(name)) {
            return getApiEndpoint();
        } else {
            if ("authorities".equals(name)) {
                return getAuthorities();
            } else {
                if ("collectionName".equals(name)) {
                    return getCollectionName();
                } else {
                    if ("dataReadShareable".equals(name)) {
                        return getDataReadShareable();
                    } else {
                        if ("dataShareable".equals(name)) {
                            return getDataShareable();
                        } else {
                            if ("dataWriteShareable".equals(name)) {
                                return getDataWriteShareable();
                            } else {
                                if ("defaultPrivate".equals(name)) {
                                    return getDefaultPrivate();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("embeddedObject".equals(name)) {
                                            return getEmbeddedObject();
                                        } else {
                                            if ("favoritable".equals(name)) {
                                                return getFavoritable();
                                            } else {
                                                if ("href".equals(name)) {
                                                    return getHref();
                                                } else {
                                                    if ("identifiableObject".equals(name)) {
                                                        return getIdentifiableObject();
                                                    } else {
                                                        if ("implicitPrivateAuthority".equals(name)) {
                                                            return getImplicitPrivateAuthority();
                                                        } else {
                                                            if ("klass".equals(name)) {
                                                                return getKlass();
                                                            } else {
                                                                if ("metadata".equals(name)) {
                                                                    return getMetadata();
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        return getName();
                                                                    } else {
                                                                        if ("nameableObject".equals(name)) {
                                                                            return getNameableObject();
                                                                        } else {
                                                                            if ("namespace".equals(name)) {
                                                                                return getNamespace();
                                                                            } else {
                                                                                if ("order".equals(name)) {
                                                                                    return getOrder();
                                                                                } else {
                                                                                    if ("persisted".equals(name)) {
                                                                                        return getPersisted();
                                                                                    } else {
                                                                                        if ("plural".equals(name)) {
                                                                                            return getPlural();
                                                                                        } else {
                                                                                            if ("properties".equals(name)) {
                                                                                                return getProperties();
                                                                                            } else {
                                                                                                if ("references".equals(name)) {
                                                                                                    return getReferences();
                                                                                                } else {
                                                                                                    if ("relativeApiEndpoint".equals(name)) {
                                                                                                        return getRelativeApiEndpoint();
                                                                                                    } else {
                                                                                                        if ("secondaryMetadata".equals(name)) {
                                                                                                            return getSecondaryMetadata();
                                                                                                        } else {
                                                                                                            if ("shareable".equals(name)) {
                                                                                                                return getShareable();
                                                                                                            } else {
                                                                                                                if ("singular".equals(name)) {
                                                                                                                    return getSingular();
                                                                                                                } else {
                                                                                                                    if ("subscribable".equals(name)) {
                                                                                                                        return getSubscribable();
                                                                                                                    } else {
                                                                                                                        if ("subscribableObject".equals(name)) {
                                                                                                                            return getSubscribableObject();
                                                                                                                        } else {
                                                                                                                            if ("translatable".equals(name)) {
                                                                                                                                return getTranslatable();
                                                                                                                            } else {
                                                                                                                                return notFoundValue;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Schema.NOT_FOUND_VALUE);
        if (Schema.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Schema with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Schema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("apiEndpoint");
        sb.append('=');
        sb.append(((this.apiEndpoint == null)?"<null>":this.apiEndpoint));
        sb.append(',');
        sb.append("authorities");
        sb.append('=');
        sb.append(((this.authorities == null)?"<null>":this.authorities));
        sb.append(',');
        sb.append("collectionName");
        sb.append('=');
        sb.append(((this.collectionName == null)?"<null>":this.collectionName));
        sb.append(',');
        sb.append("dataReadShareable");
        sb.append('=');
        sb.append(((this.dataReadShareable == null)?"<null>":this.dataReadShareable));
        sb.append(',');
        sb.append("dataShareable");
        sb.append('=');
        sb.append(((this.dataShareable == null)?"<null>":this.dataShareable));
        sb.append(',');
        sb.append("dataWriteShareable");
        sb.append('=');
        sb.append(((this.dataWriteShareable == null)?"<null>":this.dataWriteShareable));
        sb.append(',');
        sb.append("defaultPrivate");
        sb.append('=');
        sb.append(((this.defaultPrivate == null)?"<null>":this.defaultPrivate));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("embeddedObject");
        sb.append('=');
        sb.append(((this.embeddedObject == null)?"<null>":this.embeddedObject));
        sb.append(',');
        sb.append("favoritable");
        sb.append('=');
        sb.append(((this.favoritable == null)?"<null>":this.favoritable));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("identifiableObject");
        sb.append('=');
        sb.append(((this.identifiableObject == null)?"<null>":this.identifiableObject));
        sb.append(',');
        sb.append("implicitPrivateAuthority");
        sb.append('=');
        sb.append(((this.implicitPrivateAuthority == null)?"<null>":this.implicitPrivateAuthority));
        sb.append(',');
        sb.append("klass");
        sb.append('=');
        sb.append(((this.klass == null)?"<null>":this.klass));
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(((this.metadata == null)?"<null>":this.metadata));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("nameableObject");
        sb.append('=');
        sb.append(((this.nameableObject == null)?"<null>":this.nameableObject));
        sb.append(',');
        sb.append("namespace");
        sb.append('=');
        sb.append(((this.namespace == null)?"<null>":this.namespace));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("persisted");
        sb.append('=');
        sb.append(((this.persisted == null)?"<null>":this.persisted));
        sb.append(',');
        sb.append("plural");
        sb.append('=');
        sb.append(((this.plural == null)?"<null>":this.plural));
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(((this.properties == null)?"<null>":this.properties));
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(((this.references == null)?"<null>":this.references));
        sb.append(',');
        sb.append("relativeApiEndpoint");
        sb.append('=');
        sb.append(((this.relativeApiEndpoint == null)?"<null>":this.relativeApiEndpoint));
        sb.append(',');
        sb.append("secondaryMetadata");
        sb.append('=');
        sb.append(((this.secondaryMetadata == null)?"<null>":this.secondaryMetadata));
        sb.append(',');
        sb.append("shareable");
        sb.append('=');
        sb.append(((this.shareable == null)?"<null>":this.shareable));
        sb.append(',');
        sb.append("singular");
        sb.append('=');
        sb.append(((this.singular == null)?"<null>":this.singular));
        sb.append(',');
        sb.append("subscribable");
        sb.append('=');
        sb.append(((this.subscribable == null)?"<null>":this.subscribable));
        sb.append(',');
        sb.append("subscribableObject");
        sb.append('=');
        sb.append(((this.subscribableObject == null)?"<null>":this.subscribableObject));
        sb.append(',');
        sb.append("translatable");
        sb.append('=');
        sb.append(((this.translatable == null)?"<null>":this.translatable));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.shareable == null)? 0 :this.shareable.hashCode()));
        result = ((result* 31)+((this.metadata == null)? 0 :this.metadata.hashCode()));
        result = ((result* 31)+((this.relativeApiEndpoint == null)? 0 :this.relativeApiEndpoint.hashCode()));
        result = ((result* 31)+((this.plural == null)? 0 :this.plural.hashCode()));
        result = ((result* 31)+((this.references == null)? 0 :this.references.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.secondaryMetadata == null)? 0 :this.secondaryMetadata.hashCode()));
        result = ((result* 31)+((this.collectionName == null)? 0 :this.collectionName.hashCode()));
        result = ((result* 31)+((this.implicitPrivateAuthority == null)? 0 :this.implicitPrivateAuthority.hashCode()));
        result = ((result* 31)+((this.nameableObject == null)? 0 :this.nameableObject.hashCode()));
        result = ((result* 31)+((this.dataWriteShareable == null)? 0 :this.dataWriteShareable.hashCode()));
        result = ((result* 31)+((this.klass == null)? 0 :this.klass.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.subscribable == null)? 0 :this.subscribable.hashCode()));
        result = ((result* 31)+((this.dataReadShareable == null)? 0 :this.dataReadShareable.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        result = ((result* 31)+((this.translatable == null)? 0 :this.translatable.hashCode()));
        result = ((result* 31)+((this.identifiableObject == null)? 0 :this.identifiableObject.hashCode()));
        result = ((result* 31)+((this.favoritable == null)? 0 :this.favoritable.hashCode()));
        result = ((result* 31)+((this.authorities == null)? 0 :this.authorities.hashCode()));
        result = ((result* 31)+((this.subscribableObject == null)? 0 :this.subscribableObject.hashCode()));
        result = ((result* 31)+((this.dataShareable == null)? 0 :this.dataShareable.hashCode()));
        result = ((result* 31)+((this.apiEndpoint == null)? 0 :this.apiEndpoint.hashCode()));
        result = ((result* 31)+((this.embeddedObject == null)? 0 :this.embeddedObject.hashCode()));
        result = ((result* 31)+((this.defaultPrivate == null)? 0 :this.defaultPrivate.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.namespace == null)? 0 :this.namespace.hashCode()));
        result = ((result* 31)+((this.persisted == null)? 0 :this.persisted.hashCode()));
        result = ((result* 31)+((this.singular == null)? 0 :this.singular.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.properties == null)? 0 :this.properties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Schema) == false) {
            return false;
        }
        Schema rhs = ((Schema) other);
        return ((((((((((((((((((((((((((((((((this.shareable == rhs.shareable)||((this.shareable!= null)&&this.shareable.equals(rhs.shareable)))&&((this.metadata == rhs.metadata)||((this.metadata!= null)&&this.metadata.equals(rhs.metadata))))&&((this.relativeApiEndpoint == rhs.relativeApiEndpoint)||((this.relativeApiEndpoint!= null)&&this.relativeApiEndpoint.equals(rhs.relativeApiEndpoint))))&&((this.plural == rhs.plural)||((this.plural!= null)&&this.plural.equals(rhs.plural))))&&((this.references == rhs.references)||((this.references!= null)&&this.references.equals(rhs.references))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.secondaryMetadata == rhs.secondaryMetadata)||((this.secondaryMetadata!= null)&&this.secondaryMetadata.equals(rhs.secondaryMetadata))))&&((this.collectionName == rhs.collectionName)||((this.collectionName!= null)&&this.collectionName.equals(rhs.collectionName))))&&((this.implicitPrivateAuthority == rhs.implicitPrivateAuthority)||((this.implicitPrivateAuthority!= null)&&this.implicitPrivateAuthority.equals(rhs.implicitPrivateAuthority))))&&((this.nameableObject == rhs.nameableObject)||((this.nameableObject!= null)&&this.nameableObject.equals(rhs.nameableObject))))&&((this.dataWriteShareable == rhs.dataWriteShareable)||((this.dataWriteShareable!= null)&&this.dataWriteShareable.equals(rhs.dataWriteShareable))))&&((this.klass == rhs.klass)||((this.klass!= null)&&this.klass.equals(rhs.klass))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.subscribable == rhs.subscribable)||((this.subscribable!= null)&&this.subscribable.equals(rhs.subscribable))))&&((this.dataReadShareable == rhs.dataReadShareable)||((this.dataReadShareable!= null)&&this.dataReadShareable.equals(rhs.dataReadShareable))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))))&&((this.translatable == rhs.translatable)||((this.translatable!= null)&&this.translatable.equals(rhs.translatable))))&&((this.identifiableObject == rhs.identifiableObject)||((this.identifiableObject!= null)&&this.identifiableObject.equals(rhs.identifiableObject))))&&((this.favoritable == rhs.favoritable)||((this.favoritable!= null)&&this.favoritable.equals(rhs.favoritable))))&&((this.authorities == rhs.authorities)||((this.authorities!= null)&&this.authorities.equals(rhs.authorities))))&&((this.subscribableObject == rhs.subscribableObject)||((this.subscribableObject!= null)&&this.subscribableObject.equals(rhs.subscribableObject))))&&((this.dataShareable == rhs.dataShareable)||((this.dataShareable!= null)&&this.dataShareable.equals(rhs.dataShareable))))&&((this.apiEndpoint == rhs.apiEndpoint)||((this.apiEndpoint!= null)&&this.apiEndpoint.equals(rhs.apiEndpoint))))&&((this.embeddedObject == rhs.embeddedObject)||((this.embeddedObject!= null)&&this.embeddedObject.equals(rhs.embeddedObject))))&&((this.defaultPrivate == rhs.defaultPrivate)||((this.defaultPrivate!= null)&&this.defaultPrivate.equals(rhs.defaultPrivate))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.namespace == rhs.namespace)||((this.namespace!= null)&&this.namespace.equals(rhs.namespace))))&&((this.persisted == rhs.persisted)||((this.persisted!= null)&&this.persisted.equals(rhs.persisted))))&&((this.singular == rhs.singular)||((this.singular!= null)&&this.singular.equals(rhs.singular))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.properties == rhs.properties)||((this.properties!= null)&&this.properties.equals(rhs.properties))));
    }

}
