
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "lastYears",
    "skipPrograms",
    "skipResourceTables",
    "skipTableTypes"
})
@Generated("jsonschema2pojo")
public class AnalyticsJobParameters implements Serializable
{

    @JsonProperty("lastYears")
    private Integer lastYears;
    @JsonProperty("skipPrograms")
    private List<String> skipPrograms;
    @JsonProperty("skipResourceTables")
    private Boolean skipResourceTables;
    @JsonProperty("skipTableTypes")
    private List<AnalyticsTableType> skipTableTypes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3036791885286143217L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AnalyticsJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public AnalyticsJobParameters(AnalyticsJobParameters source) {
        super();
        this.lastYears = source.lastYears;
        this.skipPrograms = source.skipPrograms;
        this.skipResourceTables = source.skipResourceTables;
        this.skipTableTypes = source.skipTableTypes;
    }

    public AnalyticsJobParameters(Integer lastYears, List<String> skipPrograms, Boolean skipResourceTables, List<AnalyticsTableType> skipTableTypes) {
        super();
        this.lastYears = lastYears;
        this.skipPrograms = skipPrograms;
        this.skipResourceTables = skipResourceTables;
        this.skipTableTypes = skipTableTypes;
    }

    @JsonProperty("lastYears")
    public Optional<Integer> getLastYears() {
        return Optional.ofNullable(lastYears);
    }

    @JsonProperty("lastYears")
    public void setLastYears(Integer lastYears) {
        this.lastYears = lastYears;
    }

    public AnalyticsJobParameters withLastYears(Integer lastYears) {
        this.lastYears = lastYears;
        return this;
    }

    @JsonProperty("skipPrograms")
    public Optional<List<String>> getSkipPrograms() {
        return Optional.ofNullable(skipPrograms);
    }

    @JsonProperty("skipPrograms")
    public void setSkipPrograms(List<String> skipPrograms) {
        this.skipPrograms = skipPrograms;
    }

    public AnalyticsJobParameters withSkipPrograms(List<String> skipPrograms) {
        this.skipPrograms = skipPrograms;
        return this;
    }

    @JsonProperty("skipResourceTables")
    public Optional<Boolean> getSkipResourceTables() {
        return Optional.ofNullable(skipResourceTables);
    }

    @JsonProperty("skipResourceTables")
    public void setSkipResourceTables(Boolean skipResourceTables) {
        this.skipResourceTables = skipResourceTables;
    }

    public AnalyticsJobParameters withSkipResourceTables(Boolean skipResourceTables) {
        this.skipResourceTables = skipResourceTables;
        return this;
    }

    @JsonProperty("skipTableTypes")
    public Optional<List<AnalyticsTableType>> getSkipTableTypes() {
        return Optional.ofNullable(skipTableTypes);
    }

    @JsonProperty("skipTableTypes")
    public void setSkipTableTypes(List<AnalyticsTableType> skipTableTypes) {
        this.skipTableTypes = skipTableTypes;
    }

    public AnalyticsJobParameters withSkipTableTypes(List<AnalyticsTableType> skipTableTypes) {
        this.skipTableTypes = skipTableTypes;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AnalyticsJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("lastYears".equals(name)) {
            if (value instanceof Integer) {
                setLastYears(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"lastYears\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("skipPrograms".equals(name)) {
                if (value instanceof List) {
                    setSkipPrograms(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"skipPrograms\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("skipResourceTables".equals(name)) {
                    if (value instanceof Boolean) {
                        setSkipResourceTables(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"skipResourceTables\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("skipTableTypes".equals(name)) {
                        if (value instanceof List) {
                            setSkipTableTypes(((List<AnalyticsTableType> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"skipTableTypes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.AnalyticsTableType>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("lastYears".equals(name)) {
            return getLastYears();
        } else {
            if ("skipPrograms".equals(name)) {
                return getSkipPrograms();
            } else {
                if ("skipResourceTables".equals(name)) {
                    return getSkipResourceTables();
                } else {
                    if ("skipTableTypes".equals(name)) {
                        return getSkipTableTypes();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, AnalyticsJobParameters.NOT_FOUND_VALUE);
        if (AnalyticsJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public AnalyticsJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AnalyticsJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastYears");
        sb.append('=');
        sb.append(((this.lastYears == null)?"<null>":this.lastYears));
        sb.append(',');
        sb.append("skipPrograms");
        sb.append('=');
        sb.append(((this.skipPrograms == null)?"<null>":this.skipPrograms));
        sb.append(',');
        sb.append("skipResourceTables");
        sb.append('=');
        sb.append(((this.skipResourceTables == null)?"<null>":this.skipResourceTables));
        sb.append(',');
        sb.append("skipTableTypes");
        sb.append('=');
        sb.append(((this.skipTableTypes == null)?"<null>":this.skipTableTypes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.lastYears == null)? 0 :this.lastYears.hashCode()));
        result = ((result* 31)+((this.skipTableTypes == null)? 0 :this.skipTableTypes.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.skipPrograms == null)? 0 :this.skipPrograms.hashCode()));
        result = ((result* 31)+((this.skipResourceTables == null)? 0 :this.skipResourceTables.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AnalyticsJobParameters) == false) {
            return false;
        }
        AnalyticsJobParameters rhs = ((AnalyticsJobParameters) other);
        return ((((((this.lastYears == rhs.lastYears)||((this.lastYears!= null)&&this.lastYears.equals(rhs.lastYears)))&&((this.skipTableTypes == rhs.skipTableTypes)||((this.skipTableTypes!= null)&&this.skipTableTypes.equals(rhs.skipTableTypes))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.skipPrograms == rhs.skipPrograms)||((this.skipPrograms!= null)&&this.skipPrograms.equals(rhs.skipPrograms))))&&((this.skipResourceTables == rhs.skipResourceTables)||((this.skipResourceTables!= null)&&this.skipResourceTables.equals(rhs.skipResourceTables))));
    }

}
