
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "persistence",
    "security"
})
@Generated("jsonschema2pojo")
public class ArtemisEmbeddedConfig implements Serializable
{

    @JsonProperty("persistence")
    private Boolean persistence;
    @JsonProperty("security")
    private Boolean security;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8761116388237273354L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ArtemisEmbeddedConfig() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ArtemisEmbeddedConfig(ArtemisEmbeddedConfig source) {
        super();
        this.persistence = source.persistence;
        this.security = source.security;
    }

    public ArtemisEmbeddedConfig(Boolean persistence, Boolean security) {
        super();
        this.persistence = persistence;
        this.security = security;
    }

    @JsonProperty("persistence")
    public Optional<Boolean> getPersistence() {
        return Optional.ofNullable(persistence);
    }

    @JsonProperty("persistence")
    public void setPersistence(Boolean persistence) {
        this.persistence = persistence;
    }

    public ArtemisEmbeddedConfig withPersistence(Boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    @JsonProperty("security")
    public Optional<Boolean> getSecurity() {
        return Optional.ofNullable(security);
    }

    @JsonProperty("security")
    public void setSecurity(Boolean security) {
        this.security = security;
    }

    public ArtemisEmbeddedConfig withSecurity(Boolean security) {
        this.security = security;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ArtemisEmbeddedConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("persistence".equals(name)) {
            if (value instanceof Boolean) {
                setPersistence(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"persistence\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("security".equals(name)) {
                if (value instanceof Boolean) {
                    setSecurity(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"security\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("persistence".equals(name)) {
            return getPersistence();
        } else {
            if ("security".equals(name)) {
                return getSecurity();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ArtemisEmbeddedConfig.NOT_FOUND_VALUE);
        if (ArtemisEmbeddedConfig.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ArtemisEmbeddedConfig with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ArtemisEmbeddedConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("persistence");
        sb.append('=');
        sb.append(((this.persistence == null)?"<null>":this.persistence));
        sb.append(',');
        sb.append("security");
        sb.append('=');
        sb.append(((this.security == null)?"<null>":this.security));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.persistence == null)? 0 :this.persistence.hashCode()));
        result = ((result* 31)+((this.security == null)? 0 :this.security.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ArtemisEmbeddedConfig) == false) {
            return false;
        }
        ArtemisEmbeddedConfig rhs = ((ArtemisEmbeddedConfig) other);
        return ((((this.persistence == rhs.persistence)||((this.persistence!= null)&&this.persistence.equals(rhs.persistence)))&&((this.security == rhs.security)||((this.security!= null)&&this.security.equals(rhs.security))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
