
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "averageEntrySize",
    "averageEntrySizeHumanReadable",
    "entries",
    "size",
    "sizeHumanReadable",
    "threshold"
})
@Generated("jsonschema2pojo")
public class CacheBurdenInfo implements Serializable
{

    @JsonProperty("averageEntrySize")
    private Integer averageEntrySize;
    @JsonProperty("averageEntrySizeHumanReadable")
    private String averageEntrySizeHumanReadable;
    @JsonProperty("entries")
    private Integer entries;
    @JsonProperty("size")
    private Integer size;
    @JsonProperty("sizeHumanReadable")
    private String sizeHumanReadable;
    @JsonProperty("threshold")
    private Double threshold;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -959045305811008213L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CacheBurdenInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CacheBurdenInfo(CacheBurdenInfo source) {
        super();
        this.averageEntrySize = source.averageEntrySize;
        this.averageEntrySizeHumanReadable = source.averageEntrySizeHumanReadable;
        this.entries = source.entries;
        this.size = source.size;
        this.sizeHumanReadable = source.sizeHumanReadable;
        this.threshold = source.threshold;
    }

    public CacheBurdenInfo(Integer averageEntrySize, String averageEntrySizeHumanReadable, Integer entries, Integer size, String sizeHumanReadable, Double threshold) {
        super();
        this.averageEntrySize = averageEntrySize;
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
        this.entries = entries;
        this.size = size;
        this.sizeHumanReadable = sizeHumanReadable;
        this.threshold = threshold;
    }

    @JsonProperty("averageEntrySize")
    public Optional<Integer> getAverageEntrySize() {
        return Optional.ofNullable(averageEntrySize);
    }

    @JsonProperty("averageEntrySize")
    public void setAverageEntrySize(Integer averageEntrySize) {
        this.averageEntrySize = averageEntrySize;
    }

    public CacheBurdenInfo withAverageEntrySize(Integer averageEntrySize) {
        this.averageEntrySize = averageEntrySize;
        return this;
    }

    @JsonProperty("averageEntrySizeHumanReadable")
    public Optional<String> getAverageEntrySizeHumanReadable() {
        return Optional.ofNullable(averageEntrySizeHumanReadable);
    }

    @JsonProperty("averageEntrySizeHumanReadable")
    public void setAverageEntrySizeHumanReadable(String averageEntrySizeHumanReadable) {
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
    }

    public CacheBurdenInfo withAverageEntrySizeHumanReadable(String averageEntrySizeHumanReadable) {
        this.averageEntrySizeHumanReadable = averageEntrySizeHumanReadable;
        return this;
    }

    @JsonProperty("entries")
    public Optional<Integer> getEntries() {
        return Optional.ofNullable(entries);
    }

    @JsonProperty("entries")
    public void setEntries(Integer entries) {
        this.entries = entries;
    }

    public CacheBurdenInfo withEntries(Integer entries) {
        this.entries = entries;
        return this;
    }

    @JsonProperty("size")
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    @JsonProperty("size")
    public void setSize(Integer size) {
        this.size = size;
    }

    public CacheBurdenInfo withSize(Integer size) {
        this.size = size;
        return this;
    }

    @JsonProperty("sizeHumanReadable")
    public Optional<String> getSizeHumanReadable() {
        return Optional.ofNullable(sizeHumanReadable);
    }

    @JsonProperty("sizeHumanReadable")
    public void setSizeHumanReadable(String sizeHumanReadable) {
        this.sizeHumanReadable = sizeHumanReadable;
    }

    public CacheBurdenInfo withSizeHumanReadable(String sizeHumanReadable) {
        this.sizeHumanReadable = sizeHumanReadable;
        return this;
    }

    @JsonProperty("threshold")
    public Optional<Double> getThreshold() {
        return Optional.ofNullable(threshold);
    }

    @JsonProperty("threshold")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public CacheBurdenInfo withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CacheBurdenInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("averageEntrySize".equals(name)) {
            if (value instanceof Integer) {
                setAverageEntrySize(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"averageEntrySize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("averageEntrySizeHumanReadable".equals(name)) {
                if (value instanceof String) {
                    setAverageEntrySizeHumanReadable(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"averageEntrySizeHumanReadable\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("entries".equals(name)) {
                    if (value instanceof Integer) {
                        setEntries(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"entries\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("size".equals(name)) {
                        if (value instanceof Integer) {
                            setSize(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"size\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("sizeHumanReadable".equals(name)) {
                            if (value instanceof String) {
                                setSizeHumanReadable(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"sizeHumanReadable\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("threshold".equals(name)) {
                                if (value instanceof Double) {
                                    setThreshold(((Double) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"threshold\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("averageEntrySize".equals(name)) {
            return getAverageEntrySize();
        } else {
            if ("averageEntrySizeHumanReadable".equals(name)) {
                return getAverageEntrySizeHumanReadable();
            } else {
                if ("entries".equals(name)) {
                    return getEntries();
                } else {
                    if ("size".equals(name)) {
                        return getSize();
                    } else {
                        if ("sizeHumanReadable".equals(name)) {
                            return getSizeHumanReadable();
                        } else {
                            if ("threshold".equals(name)) {
                                return getThreshold();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CacheBurdenInfo.NOT_FOUND_VALUE);
        if (CacheBurdenInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CacheBurdenInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CacheBurdenInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("averageEntrySize");
        sb.append('=');
        sb.append(((this.averageEntrySize == null)?"<null>":this.averageEntrySize));
        sb.append(',');
        sb.append("averageEntrySizeHumanReadable");
        sb.append('=');
        sb.append(((this.averageEntrySizeHumanReadable == null)?"<null>":this.averageEntrySizeHumanReadable));
        sb.append(',');
        sb.append("entries");
        sb.append('=');
        sb.append(((this.entries == null)?"<null>":this.entries));
        sb.append(',');
        sb.append("size");
        sb.append('=');
        sb.append(((this.size == null)?"<null>":this.size));
        sb.append(',');
        sb.append("sizeHumanReadable");
        sb.append('=');
        sb.append(((this.sizeHumanReadable == null)?"<null>":this.sizeHumanReadable));
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(((this.threshold == null)?"<null>":this.threshold));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.averageEntrySizeHumanReadable == null)? 0 :this.averageEntrySizeHumanReadable.hashCode()));
        result = ((result* 31)+((this.entries == null)? 0 :this.entries.hashCode()));
        result = ((result* 31)+((this.size == null)? 0 :this.size.hashCode()));
        result = ((result* 31)+((this.sizeHumanReadable == null)? 0 :this.sizeHumanReadable.hashCode()));
        result = ((result* 31)+((this.threshold == null)? 0 :this.threshold.hashCode()));
        result = ((result* 31)+((this.averageEntrySize == null)? 0 :this.averageEntrySize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CacheBurdenInfo) == false) {
            return false;
        }
        CacheBurdenInfo rhs = ((CacheBurdenInfo) other);
        return ((((((((this.averageEntrySizeHumanReadable == rhs.averageEntrySizeHumanReadable)||((this.averageEntrySizeHumanReadable!= null)&&this.averageEntrySizeHumanReadable.equals(rhs.averageEntrySizeHumanReadable)))&&((this.entries == rhs.entries)||((this.entries!= null)&&this.entries.equals(rhs.entries))))&&((this.size == rhs.size)||((this.size!= null)&&this.size.equals(rhs.size))))&&((this.sizeHumanReadable == rhs.sizeHumanReadable)||((this.sizeHumanReadable!= null)&&this.sizeHumanReadable.equals(rhs.sizeHumanReadable))))&&((this.threshold == rhs.threshold)||((this.threshold!= null)&&this.threshold.equals(rhs.threshold))))&&((this.averageEntrySize == rhs.averageEntrySize)||((this.averageEntrySize!= null)&&this.averageEntrySize.equals(rhs.averageEntrySize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
