
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "completedBy",
    "completedDate",
    "dataElement",
    "dueDate",
    "enrollment",
    "event",
    "eventDate",
    "geometry",
    "latitude",
    "longitude",
    "orgUnit",
    "program",
    "programStage",
    "providedElsewhere",
    "status",
    "storedBy",
    "value"
})
@Generated("jsonschema2pojo")
public class CsvEventDataValue implements Serializable
{

    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("completedDate")
    private String completedDate;
    @JsonProperty("dataElement")
    private String dataElement;
    @JsonProperty("dueDate")
    private String dueDate;
    @JsonProperty("enrollment")
    private String enrollment;
    @JsonProperty("event")
    private String event;
    @JsonProperty("eventDate")
    private String eventDate;
    @JsonProperty("geometry")
    private String geometry;
    @JsonProperty("latitude")
    private Double latitude;
    @JsonProperty("longitude")
    private Double longitude;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("program")
    private String program;
    @JsonProperty("programStage")
    private String programStage;
    @JsonProperty("providedElsewhere")
    private Boolean providedElsewhere;
    @JsonProperty("status")
    private String status;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1191849347887006228L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CsvEventDataValue() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public CsvEventDataValue(CsvEventDataValue source) {
        super();
        this.completedBy = source.completedBy;
        this.completedDate = source.completedDate;
        this.dataElement = source.dataElement;
        this.dueDate = source.dueDate;
        this.enrollment = source.enrollment;
        this.event = source.event;
        this.eventDate = source.eventDate;
        this.geometry = source.geometry;
        this.latitude = source.latitude;
        this.longitude = source.longitude;
        this.orgUnit = source.orgUnit;
        this.program = source.program;
        this.programStage = source.programStage;
        this.providedElsewhere = source.providedElsewhere;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.value = source.value;
    }

    public CsvEventDataValue(String completedBy, String completedDate, String dataElement, String dueDate, String enrollment, String event, String eventDate, String geometry, Double latitude, Double longitude, String orgUnit, String program, String programStage, Boolean providedElsewhere, String status, String storedBy, String value) {
        super();
        this.completedBy = completedBy;
        this.completedDate = completedDate;
        this.dataElement = dataElement;
        this.dueDate = dueDate;
        this.enrollment = enrollment;
        this.event = event;
        this.eventDate = eventDate;
        this.geometry = geometry;
        this.latitude = latitude;
        this.longitude = longitude;
        this.orgUnit = orgUnit;
        this.program = program;
        this.programStage = programStage;
        this.providedElsewhere = providedElsewhere;
        this.status = status;
        this.storedBy = storedBy;
        this.value = value;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public CsvEventDataValue withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("completedDate")
    public Optional<String> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    @JsonProperty("completedDate")
    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public CsvEventDataValue withCompletedDate(String completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public CsvEventDataValue withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("dueDate")
    public Optional<String> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    @JsonProperty("dueDate")
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public CsvEventDataValue withDueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @JsonProperty("enrollment")
    public Optional<String> getEnrollment() {
        return Optional.ofNullable(enrollment);
    }

    @JsonProperty("enrollment")
    public void setEnrollment(String enrollment) {
        this.enrollment = enrollment;
    }

    public CsvEventDataValue withEnrollment(String enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    @JsonProperty("event")
    public Optional<String> getEvent() {
        return Optional.ofNullable(event);
    }

    @JsonProperty("event")
    public void setEvent(String event) {
        this.event = event;
    }

    public CsvEventDataValue withEvent(String event) {
        this.event = event;
        return this;
    }

    @JsonProperty("eventDate")
    public Optional<String> getEventDate() {
        return Optional.ofNullable(eventDate);
    }

    @JsonProperty("eventDate")
    public void setEventDate(String eventDate) {
        this.eventDate = eventDate;
    }

    public CsvEventDataValue withEventDate(String eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @JsonProperty("geometry")
    public Optional<String> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    @JsonProperty("geometry")
    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public CsvEventDataValue withGeometry(String geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("latitude")
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    @JsonProperty("latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public CsvEventDataValue withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    @JsonProperty("longitude")
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    @JsonProperty("longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public CsvEventDataValue withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public CsvEventDataValue withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("program")
    public Optional<String> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public CsvEventDataValue withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public CsvEventDataValue withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("providedElsewhere")
    public Optional<Boolean> getProvidedElsewhere() {
        return Optional.ofNullable(providedElsewhere);
    }

    @JsonProperty("providedElsewhere")
    public void setProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
    }

    public CsvEventDataValue withProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
        return this;
    }

    @JsonProperty("status")
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(String status) {
        this.status = status;
    }

    public CsvEventDataValue withStatus(String status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public CsvEventDataValue withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public CsvEventDataValue withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public CsvEventDataValue withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("completedBy".equals(name)) {
            if (value instanceof String) {
                setCompletedBy(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completedDate".equals(name)) {
                if (value instanceof String) {
                    setCompletedDate(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElement".equals(name)) {
                    if (value instanceof String) {
                        setDataElement(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("dueDate".equals(name)) {
                        if (value instanceof String) {
                            setDueDate(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"dueDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("enrollment".equals(name)) {
                            if (value instanceof String) {
                                setEnrollment(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"enrollment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("event".equals(name)) {
                                if (value instanceof String) {
                                    setEvent(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"event\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("eventDate".equals(name)) {
                                    if (value instanceof String) {
                                        setEventDate(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"eventDate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("geometry".equals(name)) {
                                        if (value instanceof String) {
                                            setGeometry(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("latitude".equals(name)) {
                                            if (value instanceof Double) {
                                                setLatitude(((Double) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"latitude\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("longitude".equals(name)) {
                                                if (value instanceof Double) {
                                                    setLongitude(((Double) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"longitude\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("orgUnit".equals(name)) {
                                                    if (value instanceof String) {
                                                        setOrgUnit(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("program".equals(name)) {
                                                        if (value instanceof String) {
                                                            setProgram(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("programStage".equals(name)) {
                                                            if (value instanceof String) {
                                                                setProgramStage(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("providedElsewhere".equals(name)) {
                                                                if (value instanceof Boolean) {
                                                                    setProvidedElsewhere(((Boolean) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"providedElsewhere\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("status".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setStatus(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"status\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("storedBy".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setStoredBy(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("value".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setValue(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            return false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("completedBy".equals(name)) {
            return getCompletedBy();
        } else {
            if ("completedDate".equals(name)) {
                return getCompletedDate();
            } else {
                if ("dataElement".equals(name)) {
                    return getDataElement();
                } else {
                    if ("dueDate".equals(name)) {
                        return getDueDate();
                    } else {
                        if ("enrollment".equals(name)) {
                            return getEnrollment();
                        } else {
                            if ("event".equals(name)) {
                                return getEvent();
                            } else {
                                if ("eventDate".equals(name)) {
                                    return getEventDate();
                                } else {
                                    if ("geometry".equals(name)) {
                                        return getGeometry();
                                    } else {
                                        if ("latitude".equals(name)) {
                                            return getLatitude();
                                        } else {
                                            if ("longitude".equals(name)) {
                                                return getLongitude();
                                            } else {
                                                if ("orgUnit".equals(name)) {
                                                    return getOrgUnit();
                                                } else {
                                                    if ("program".equals(name)) {
                                                        return getProgram();
                                                    } else {
                                                        if ("programStage".equals(name)) {
                                                            return getProgramStage();
                                                        } else {
                                                            if ("providedElsewhere".equals(name)) {
                                                                return getProvidedElsewhere();
                                                            } else {
                                                                if ("status".equals(name)) {
                                                                    return getStatus();
                                                                } else {
                                                                    if ("storedBy".equals(name)) {
                                                                        return getStoredBy();
                                                                    } else {
                                                                        if ("value".equals(name)) {
                                                                            return getValue();
                                                                        } else {
                                                                            return notFoundValue;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, CsvEventDataValue.NOT_FOUND_VALUE);
        if (CsvEventDataValue.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public CsvEventDataValue with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CsvEventDataValue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("completedDate");
        sb.append('=');
        sb.append(((this.completedDate == null)?"<null>":this.completedDate));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(((this.dueDate == null)?"<null>":this.dueDate));
        sb.append(',');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("event");
        sb.append('=');
        sb.append(((this.event == null)?"<null>":this.event));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("latitude");
        sb.append('=');
        sb.append(((this.latitude == null)?"<null>":this.latitude));
        sb.append(',');
        sb.append("longitude");
        sb.append('=');
        sb.append(((this.longitude == null)?"<null>":this.longitude));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("providedElsewhere");
        sb.append('=');
        sb.append(((this.providedElsewhere == null)?"<null>":this.providedElsewhere));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.dueDate == null)? 0 :this.dueDate.hashCode()));
        result = ((result* 31)+((this.latitude == null)? 0 :this.latitude.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.completedDate == null)? 0 :this.completedDate.hashCode()));
        result = ((result* 31)+((this.providedElsewhere == null)? 0 :this.providedElsewhere.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.event == null)? 0 :this.event.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.longitude == null)? 0 :this.longitude.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CsvEventDataValue) == false) {
            return false;
        }
        CsvEventDataValue rhs = ((CsvEventDataValue) other);
        return (((((((((((((((((((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.dueDate == rhs.dueDate)||((this.dueDate!= null)&&this.dueDate.equals(rhs.dueDate))))&&((this.latitude == rhs.latitude)||((this.latitude!= null)&&this.latitude.equals(rhs.latitude))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.completedDate == rhs.completedDate)||((this.completedDate!= null)&&this.completedDate.equals(rhs.completedDate))))&&((this.providedElsewhere == rhs.providedElsewhere)||((this.providedElsewhere!= null)&&this.providedElsewhere.equals(rhs.providedElsewhere))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.event == rhs.event)||((this.event!= null)&&this.event.equals(rhs.event))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.longitude == rhs.longitude)||((this.longitude!= null)&&this.longitude.equals(rhs.longitude))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
