
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "inactiveMonths",
    "reminderDaysBefore"
})
@Generated("jsonschema2pojo")
public class DisableInactiveUsersJobParameters implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("inactiveMonths")
    private Integer inactiveMonths;
    @JsonProperty("reminderDaysBefore")
    private Integer reminderDaysBefore;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 5792767028540001618L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DisableInactiveUsersJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DisableInactiveUsersJobParameters(DisableInactiveUsersJobParameters source) {
        super();
        this.inactiveMonths = source.inactiveMonths;
        this.reminderDaysBefore = source.reminderDaysBefore;
    }

    public DisableInactiveUsersJobParameters(Integer inactiveMonths, Integer reminderDaysBefore) {
        super();
        this.inactiveMonths = inactiveMonths;
        this.reminderDaysBefore = reminderDaysBefore;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("inactiveMonths")
    public Integer getInactiveMonths() {
        return inactiveMonths;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("inactiveMonths")
    public void setInactiveMonths(Integer inactiveMonths) {
        this.inactiveMonths = inactiveMonths;
    }

    public DisableInactiveUsersJobParameters withInactiveMonths(Integer inactiveMonths) {
        this.inactiveMonths = inactiveMonths;
        return this;
    }

    @JsonProperty("reminderDaysBefore")
    public Optional<Integer> getReminderDaysBefore() {
        return Optional.ofNullable(reminderDaysBefore);
    }

    @JsonProperty("reminderDaysBefore")
    public void setReminderDaysBefore(Integer reminderDaysBefore) {
        this.reminderDaysBefore = reminderDaysBefore;
    }

    public DisableInactiveUsersJobParameters withReminderDaysBefore(Integer reminderDaysBefore) {
        this.reminderDaysBefore = reminderDaysBefore;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DisableInactiveUsersJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("inactiveMonths".equals(name)) {
            if (value instanceof Integer) {
                setInactiveMonths(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"inactiveMonths\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("reminderDaysBefore".equals(name)) {
                if (value instanceof Integer) {
                    setReminderDaysBefore(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"reminderDaysBefore\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("inactiveMonths".equals(name)) {
            return getInactiveMonths();
        } else {
            if ("reminderDaysBefore".equals(name)) {
                return getReminderDaysBefore();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DisableInactiveUsersJobParameters.NOT_FOUND_VALUE);
        if (DisableInactiveUsersJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DisableInactiveUsersJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DisableInactiveUsersJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("inactiveMonths");
        sb.append('=');
        sb.append(((this.inactiveMonths == null)?"<null>":this.inactiveMonths));
        sb.append(',');
        sb.append("reminderDaysBefore");
        sb.append('=');
        sb.append(((this.reminderDaysBefore == null)?"<null>":this.reminderDaysBefore));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.reminderDaysBefore == null)? 0 :this.reminderDaysBefore.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.inactiveMonths == null)? 0 :this.inactiveMonths.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DisableInactiveUsersJobParameters) == false) {
            return false;
        }
        DisableInactiveUsersJobParameters rhs = ((DisableInactiveUsersJobParameters) other);
        return ((((this.reminderDaysBefore == rhs.reminderDaysBefore)||((this.reminderDaysBefore!= null)&&this.reminderDaysBefore.equals(rhs.reminderDaysBefore)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.inactiveMonths == rhs.inactiveMonths)||((this.inactiveMonths!= null)&&this.inactiveMonths.equals(rhs.inactiveMonths))));
    }

}
