
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "group",
    "operator",
    "propertyPath",
    "value"
})
@Generated("jsonschema2pojo")
public class Filter implements Serializable
{

    @JsonProperty("attribute")
    private Boolean attribute;
    @JsonProperty("group")
    private Integer group;
    @JsonProperty("operator")
    private Comparison operator;
    @JsonProperty("propertyPath")
    private String propertyPath;
    @JsonProperty("value")
    private List<String> value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4487716319220957479L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Filter() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Filter(Filter source) {
        super();
        this.attribute = source.attribute;
        this.group = source.group;
        this.operator = source.operator;
        this.propertyPath = source.propertyPath;
        this.value = source.value;
    }

    public Filter(Boolean attribute, Integer group, Comparison operator, String propertyPath, List<String> value) {
        super();
        this.attribute = attribute;
        this.group = group;
        this.operator = operator;
        this.propertyPath = propertyPath;
        this.value = value;
    }

    @JsonProperty("attribute")
    public Optional<Boolean> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(Boolean attribute) {
        this.attribute = attribute;
    }

    public Filter withAttribute(Boolean attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("group")
    public Optional<Integer> getGroup() {
        return Optional.ofNullable(group);
    }

    @JsonProperty("group")
    public void setGroup(Integer group) {
        this.group = group;
    }

    public Filter withGroup(Integer group) {
        this.group = group;
        return this;
    }

    @JsonProperty("operator")
    public Optional<Comparison> getOperator() {
        return Optional.ofNullable(operator);
    }

    @JsonProperty("operator")
    public void setOperator(Comparison operator) {
        this.operator = operator;
    }

    public Filter withOperator(Comparison operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty("propertyPath")
    public Optional<String> getPropertyPath() {
        return Optional.ofNullable(propertyPath);
    }

    @JsonProperty("propertyPath")
    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Filter withPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
        return this;
    }

    @JsonProperty("value")
    public Optional<List<String>> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(List<String> value) {
        this.value = value;
    }

    public Filter withValue(List<String> value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Filter withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof Boolean) {
                setAttribute(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("group".equals(name)) {
                if (value instanceof Integer) {
                    setGroup(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"group\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("operator".equals(name)) {
                    if (value instanceof Comparison) {
                        setOperator(((Comparison) value));
                    } else {
                        throw new IllegalArgumentException(("property \"operator\" is of type \"org.hisp.dhis.api.model.v2_37_7.Comparison\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("propertyPath".equals(name)) {
                        if (value instanceof String) {
                            setPropertyPath(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"propertyPath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("value".equals(name)) {
                            if (value instanceof List) {
                                setValue(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"value\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("group".equals(name)) {
                return getGroup();
            } else {
                if ("operator".equals(name)) {
                    return getOperator();
                } else {
                    if ("propertyPath".equals(name)) {
                        return getPropertyPath();
                    } else {
                        if ("value".equals(name)) {
                            return getValue();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Filter.NOT_FOUND_VALUE);
        if (Filter.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Filter with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Filter.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("group");
        sb.append('=');
        sb.append(((this.group == null)?"<null>":this.group));
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(((this.operator == null)?"<null>":this.operator));
        sb.append(',');
        sb.append("propertyPath");
        sb.append('=');
        sb.append(((this.propertyPath == null)?"<null>":this.propertyPath));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.propertyPath == null)? 0 :this.propertyPath.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.operator == null)? 0 :this.operator.hashCode()));
        result = ((result* 31)+((this.group == null)? 0 :this.group.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Filter) == false) {
            return false;
        }
        Filter rhs = ((Filter) other);
        return (((((((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.propertyPath == rhs.propertyPath)||((this.propertyPath!= null)&&this.propertyPath.equals(rhs.propertyPath))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.operator == rhs.operator)||((this.operator!= null)&&this.operator.equals(rhs.operator))))&&((this.group == rhs.group)||((this.group!= null)&&this.group.equals(rhs.group))));
    }

}
