
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "coc",
    "de",
    "endDate",
    "maxResults",
    "ou",
    "startDate"
})
@Generated("jsonschema2pojo")
public class FollowupAnalysisMetadata implements Serializable
{

    @JsonProperty("coc")
    private List<String> coc;
    @JsonProperty("de")
    private List<String> de;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("maxResults")
    private Integer maxResults;
    @JsonProperty("ou")
    private List<String> ou;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4550881261181825083L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FollowupAnalysisMetadata() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FollowupAnalysisMetadata(FollowupAnalysisMetadata source) {
        super();
        this.coc = source.coc;
        this.de = source.de;
        this.endDate = source.endDate;
        this.maxResults = source.maxResults;
        this.ou = source.ou;
        this.startDate = source.startDate;
    }

    public FollowupAnalysisMetadata(List<String> coc, List<String> de, Date endDate, Integer maxResults, List<String> ou, Date startDate) {
        super();
        this.coc = coc;
        this.de = de;
        this.endDate = endDate;
        this.maxResults = maxResults;
        this.ou = ou;
        this.startDate = startDate;
    }

    @JsonProperty("coc")
    public Optional<List<String>> getCoc() {
        return Optional.ofNullable(coc);
    }

    @JsonProperty("coc")
    public void setCoc(List<String> coc) {
        this.coc = coc;
    }

    public FollowupAnalysisMetadata withCoc(List<String> coc) {
        this.coc = coc;
        return this;
    }

    @JsonProperty("de")
    public Optional<List<String>> getDe() {
        return Optional.ofNullable(de);
    }

    @JsonProperty("de")
    public void setDe(List<String> de) {
        this.de = de;
    }

    public FollowupAnalysisMetadata withDe(List<String> de) {
        this.de = de;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public FollowupAnalysisMetadata withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("maxResults")
    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(maxResults);
    }

    @JsonProperty("maxResults")
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public FollowupAnalysisMetadata withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @JsonProperty("ou")
    public Optional<List<String>> getOu() {
        return Optional.ofNullable(ou);
    }

    @JsonProperty("ou")
    public void setOu(List<String> ou) {
        this.ou = ou;
    }

    public FollowupAnalysisMetadata withOu(List<String> ou) {
        this.ou = ou;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public FollowupAnalysisMetadata withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FollowupAnalysisMetadata withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("coc".equals(name)) {
            if (value instanceof List) {
                setCoc(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"coc\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("de".equals(name)) {
                if (value instanceof List) {
                    setDe(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"de\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("endDate".equals(name)) {
                    if (value instanceof Date) {
                        setEndDate(((Date) value));
                    } else {
                        throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("maxResults".equals(name)) {
                        if (value instanceof Integer) {
                            setMaxResults(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"maxResults\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("ou".equals(name)) {
                            if (value instanceof List) {
                                setOu(((List<String> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"ou\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("startDate".equals(name)) {
                                if (value instanceof Date) {
                                    setStartDate(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("coc".equals(name)) {
            return getCoc();
        } else {
            if ("de".equals(name)) {
                return getDe();
            } else {
                if ("endDate".equals(name)) {
                    return getEndDate();
                } else {
                    if ("maxResults".equals(name)) {
                        return getMaxResults();
                    } else {
                        if ("ou".equals(name)) {
                            return getOu();
                        } else {
                            if ("startDate".equals(name)) {
                                return getStartDate();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FollowupAnalysisMetadata.NOT_FOUND_VALUE);
        if (FollowupAnalysisMetadata.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FollowupAnalysisMetadata with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FollowupAnalysisMetadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("coc");
        sb.append('=');
        sb.append(((this.coc == null)?"<null>":this.coc));
        sb.append(',');
        sb.append("de");
        sb.append('=');
        sb.append(((this.de == null)?"<null>":this.de));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("maxResults");
        sb.append('=');
        sb.append(((this.maxResults == null)?"<null>":this.maxResults));
        sb.append(',');
        sb.append("ou");
        sb.append('=');
        sb.append(((this.ou == null)?"<null>":this.ou));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.de == null)? 0 :this.de.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.coc == null)? 0 :this.coc.hashCode()));
        result = ((result* 31)+((this.maxResults == null)? 0 :this.maxResults.hashCode()));
        result = ((result* 31)+((this.ou == null)? 0 :this.ou.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FollowupAnalysisMetadata) == false) {
            return false;
        }
        FollowupAnalysisMetadata rhs = ((FollowupAnalysisMetadata) other);
        return ((((((((this.de == rhs.de)||((this.de!= null)&&this.de.equals(rhs.de)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.coc == rhs.coc)||((this.coc!= null)&&this.coc.equals(rhs.coc))))&&((this.maxResults == rhs.maxResults)||((this.maxResults!= null)&&this.maxResults.equals(rhs.maxResults))))&&((this.ou == rhs.ou)||((this.ou!= null)&&this.ou.equals(rhs.ou))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
