
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributeOptionComboId",
    "categoryOptionComboId",
    "dataElementId",
    "followup",
    "organisationUnitId",
    "periodId"
})
@Generated("jsonschema2pojo")
public class FollowupParams implements Serializable
{

    @JsonProperty("attributeOptionComboId")
    private Integer attributeOptionComboId;
    @JsonProperty("categoryOptionComboId")
    private Integer categoryOptionComboId;
    @JsonProperty("dataElementId")
    private Integer dataElementId;
    @JsonProperty("followup")
    private Boolean followup;
    @JsonProperty("organisationUnitId")
    private Integer organisationUnitId;
    @JsonProperty("periodId")
    private Integer periodId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1858816649573850297L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FollowupParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FollowupParams(FollowupParams source) {
        super();
        this.attributeOptionComboId = source.attributeOptionComboId;
        this.categoryOptionComboId = source.categoryOptionComboId;
        this.dataElementId = source.dataElementId;
        this.followup = source.followup;
        this.organisationUnitId = source.organisationUnitId;
        this.periodId = source.periodId;
    }

    public FollowupParams(Integer attributeOptionComboId, Integer categoryOptionComboId, Integer dataElementId, Boolean followup, Integer organisationUnitId, Integer periodId) {
        super();
        this.attributeOptionComboId = attributeOptionComboId;
        this.categoryOptionComboId = categoryOptionComboId;
        this.dataElementId = dataElementId;
        this.followup = followup;
        this.organisationUnitId = organisationUnitId;
        this.periodId = periodId;
    }

    @JsonProperty("attributeOptionComboId")
    public Optional<Integer> getAttributeOptionComboId() {
        return Optional.ofNullable(attributeOptionComboId);
    }

    @JsonProperty("attributeOptionComboId")
    public void setAttributeOptionComboId(Integer attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
    }

    public FollowupParams withAttributeOptionComboId(Integer attributeOptionComboId) {
        this.attributeOptionComboId = attributeOptionComboId;
        return this;
    }

    @JsonProperty("categoryOptionComboId")
    public Optional<Integer> getCategoryOptionComboId() {
        return Optional.ofNullable(categoryOptionComboId);
    }

    @JsonProperty("categoryOptionComboId")
    public void setCategoryOptionComboId(Integer categoryOptionComboId) {
        this.categoryOptionComboId = categoryOptionComboId;
    }

    public FollowupParams withCategoryOptionComboId(Integer categoryOptionComboId) {
        this.categoryOptionComboId = categoryOptionComboId;
        return this;
    }

    @JsonProperty("dataElementId")
    public Optional<Integer> getDataElementId() {
        return Optional.ofNullable(dataElementId);
    }

    @JsonProperty("dataElementId")
    public void setDataElementId(Integer dataElementId) {
        this.dataElementId = dataElementId;
    }

    public FollowupParams withDataElementId(Integer dataElementId) {
        this.dataElementId = dataElementId;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public FollowupParams withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    @JsonProperty("organisationUnitId")
    public Optional<Integer> getOrganisationUnitId() {
        return Optional.ofNullable(organisationUnitId);
    }

    @JsonProperty("organisationUnitId")
    public void setOrganisationUnitId(Integer organisationUnitId) {
        this.organisationUnitId = organisationUnitId;
    }

    public FollowupParams withOrganisationUnitId(Integer organisationUnitId) {
        this.organisationUnitId = organisationUnitId;
        return this;
    }

    @JsonProperty("periodId")
    public Optional<Integer> getPeriodId() {
        return Optional.ofNullable(periodId);
    }

    @JsonProperty("periodId")
    public void setPeriodId(Integer periodId) {
        this.periodId = periodId;
    }

    public FollowupParams withPeriodId(Integer periodId) {
        this.periodId = periodId;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FollowupParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributeOptionComboId".equals(name)) {
            if (value instanceof Integer) {
                setAttributeOptionComboId(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"attributeOptionComboId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("categoryOptionComboId".equals(name)) {
                if (value instanceof Integer) {
                    setCategoryOptionComboId(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionComboId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataElementId".equals(name)) {
                    if (value instanceof Integer) {
                        setDataElementId(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataElementId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("followup".equals(name)) {
                        if (value instanceof Boolean) {
                            setFollowup(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("organisationUnitId".equals(name)) {
                            if (value instanceof Integer) {
                                setOrganisationUnitId(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"organisationUnitId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("periodId".equals(name)) {
                                if (value instanceof Integer) {
                                    setPeriodId(((Integer) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"periodId\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributeOptionComboId".equals(name)) {
            return getAttributeOptionComboId();
        } else {
            if ("categoryOptionComboId".equals(name)) {
                return getCategoryOptionComboId();
            } else {
                if ("dataElementId".equals(name)) {
                    return getDataElementId();
                } else {
                    if ("followup".equals(name)) {
                        return getFollowup();
                    } else {
                        if ("organisationUnitId".equals(name)) {
                            return getOrganisationUnitId();
                        } else {
                            if ("periodId".equals(name)) {
                                return getPeriodId();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FollowupParams.NOT_FOUND_VALUE);
        if (FollowupParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FollowupParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FollowupParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributeOptionComboId");
        sb.append('=');
        sb.append(((this.attributeOptionComboId == null)?"<null>":this.attributeOptionComboId));
        sb.append(',');
        sb.append("categoryOptionComboId");
        sb.append('=');
        sb.append(((this.categoryOptionComboId == null)?"<null>":this.categoryOptionComboId));
        sb.append(',');
        sb.append("dataElementId");
        sb.append('=');
        sb.append(((this.dataElementId == null)?"<null>":this.dataElementId));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("organisationUnitId");
        sb.append('=');
        sb.append(((this.organisationUnitId == null)?"<null>":this.organisationUnitId));
        sb.append(',');
        sb.append("periodId");
        sb.append('=');
        sb.append(((this.periodId == null)?"<null>":this.periodId));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementId == null)? 0 :this.dataElementId.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.periodId == null)? 0 :this.periodId.hashCode()));
        result = ((result* 31)+((this.organisationUnitId == null)? 0 :this.organisationUnitId.hashCode()));
        result = ((result* 31)+((this.attributeOptionComboId == null)? 0 :this.attributeOptionComboId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryOptionComboId == null)? 0 :this.categoryOptionComboId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FollowupParams) == false) {
            return false;
        }
        FollowupParams rhs = ((FollowupParams) other);
        return ((((((((this.dataElementId == rhs.dataElementId)||((this.dataElementId!= null)&&this.dataElementId.equals(rhs.dataElementId)))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.periodId == rhs.periodId)||((this.periodId!= null)&&this.periodId.equals(rhs.periodId))))&&((this.organisationUnitId == rhs.organisationUnitId)||((this.organisationUnitId!= null)&&this.organisationUnitId.equals(rhs.organisationUnitId))))&&((this.attributeOptionComboId == rhs.attributeOptionComboId)||((this.attributeOptionComboId!= null)&&this.attributeOptionComboId.equals(rhs.attributeOptionComboId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryOptionComboId == rhs.categoryOptionComboId)||((this.categoryOptionComboId!= null)&&this.categoryOptionComboId.equals(rhs.categoryOptionComboId))));
    }

}
