
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "created",
    "deleted",
    "responseType",
    "updated"
})
@Generated("jsonschema2pojo")
public class ImportCountWebMessageResponse implements Serializable
{

    @JsonProperty("created")
    private Integer created;
    @JsonProperty("deleted")
    private Integer deleted;
    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("updated")
    private Integer updated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 521140536184441346L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportCountWebMessageResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportCountWebMessageResponse(ImportCountWebMessageResponse source) {
        super();
        this.created = source.created;
        this.deleted = source.deleted;
        this.responseType = source.responseType;
        this.updated = source.updated;
    }

    public ImportCountWebMessageResponse(Integer created, Integer deleted, String responseType, Integer updated) {
        super();
        this.created = created;
        this.deleted = deleted;
        this.responseType = responseType;
        this.updated = updated;
    }

    @JsonProperty("created")
    public Optional<Integer> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Integer created) {
        this.created = created;
    }

    public ImportCountWebMessageResponse withCreated(Integer created) {
        this.created = created;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Integer> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public ImportCountWebMessageResponse withDeleted(Integer deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportCountWebMessageResponse withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("updated")
    public Optional<Integer> getUpdated() {
        return Optional.ofNullable(updated);
    }

    @JsonProperty("updated")
    public void setUpdated(Integer updated) {
        this.updated = updated;
    }

    public ImportCountWebMessageResponse withUpdated(Integer updated) {
        this.updated = updated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportCountWebMessageResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("created".equals(name)) {
            if (value instanceof Integer) {
                setCreated(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("deleted".equals(name)) {
                if (value instanceof Integer) {
                    setDeleted(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("responseType".equals(name)) {
                    if (value instanceof String) {
                        setResponseType(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("updated".equals(name)) {
                        if (value instanceof Integer) {
                            setUpdated(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"updated\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("created".equals(name)) {
            return getCreated();
        } else {
            if ("deleted".equals(name)) {
                return getDeleted();
            } else {
                if ("responseType".equals(name)) {
                    return getResponseType();
                } else {
                    if ("updated".equals(name)) {
                        return getUpdated();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportCountWebMessageResponse.NOT_FOUND_VALUE);
        if (ImportCountWebMessageResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportCountWebMessageResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportCountWebMessageResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(((this.updated == null)?"<null>":this.updated));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.updated == null)? 0 :this.updated.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportCountWebMessageResponse) == false) {
            return false;
        }
        ImportCountWebMessageResponse rhs = ((ImportCountWebMessageResponse) other);
        return ((((((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType)))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.updated == rhs.updated)||((this.updated!= null)&&this.updated.equals(rhs.updated))));
    }

}
