
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "conflicts",
    "dataSetComplete",
    "description",
    "enrollments",
    "events",
    "href",
    "importCount",
    "importOptions",
    "reference",
    "relationships",
    "responseType",
    "status"
})
@Generated("jsonschema2pojo")
public class ImportSummary implements Serializable
{

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    private List<Object> conflicts;
    @JsonProperty("dataSetComplete")
    private String dataSetComplete;
    @JsonProperty("description")
    private String description;
    @JsonProperty("enrollments")
    private ImportSummaries enrollments;
    @JsonProperty("events")
    private ImportSummaries events;
    @JsonProperty("href")
    private String href;
    @JsonProperty("importCount")
    private ImportCount importCount;
    @JsonProperty("importOptions")
    private ImportOptions importOptions;
    @JsonProperty("reference")
    private String reference;
    @JsonProperty("relationships")
    private ImportSummaries relationships;
    @JsonProperty("responseType")
    private String responseType;
    @JsonProperty("status")
    private ImportStatus status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2751840755664100481L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportSummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportSummary(ImportSummary source) {
        super();
        this.conflicts = source.conflicts;
        this.dataSetComplete = source.dataSetComplete;
        this.description = source.description;
        this.enrollments = source.enrollments;
        this.events = source.events;
        this.href = source.href;
        this.importCount = source.importCount;
        this.importOptions = source.importOptions;
        this.reference = source.reference;
        this.relationships = source.relationships;
        this.responseType = source.responseType;
        this.status = source.status;
    }

    public ImportSummary(List<Object> conflicts, String dataSetComplete, String description, ImportSummaries enrollments, ImportSummaries events, String href, ImportCount importCount, ImportOptions importOptions, String reference, ImportSummaries relationships, String responseType, ImportStatus status) {
        super();
        this.conflicts = conflicts;
        this.dataSetComplete = dataSetComplete;
        this.description = description;
        this.enrollments = enrollments;
        this.events = events;
        this.href = href;
        this.importCount = importCount;
        this.importOptions = importOptions;
        this.reference = reference;
        this.relationships = relationships;
        this.responseType = responseType;
        this.status = status;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public Optional<List<Object>> getConflicts() {
        return Optional.ofNullable(conflicts);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("conflicts")
    public void setConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
    }

    public ImportSummary withConflicts(List<Object> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    @JsonProperty("dataSetComplete")
    public Optional<String> getDataSetComplete() {
        return Optional.ofNullable(dataSetComplete);
    }

    @JsonProperty("dataSetComplete")
    public void setDataSetComplete(String dataSetComplete) {
        this.dataSetComplete = dataSetComplete;
    }

    public ImportSummary withDataSetComplete(String dataSetComplete) {
        this.dataSetComplete = dataSetComplete;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ImportSummary withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("enrollments")
    public Optional<ImportSummaries> getEnrollments() {
        return Optional.ofNullable(enrollments);
    }

    @JsonProperty("enrollments")
    public void setEnrollments(ImportSummaries enrollments) {
        this.enrollments = enrollments;
    }

    public ImportSummary withEnrollments(ImportSummaries enrollments) {
        this.enrollments = enrollments;
        return this;
    }

    @JsonProperty("events")
    public Optional<ImportSummaries> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(ImportSummaries events) {
        this.events = events;
    }

    public ImportSummary withEvents(ImportSummaries events) {
        this.events = events;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ImportSummary withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("importCount")
    public Optional<ImportCount> getImportCount() {
        return Optional.ofNullable(importCount);
    }

    @JsonProperty("importCount")
    public void setImportCount(ImportCount importCount) {
        this.importCount = importCount;
    }

    public ImportSummary withImportCount(ImportCount importCount) {
        this.importCount = importCount;
        return this;
    }

    @JsonProperty("importOptions")
    public Optional<ImportOptions> getImportOptions() {
        return Optional.ofNullable(importOptions);
    }

    @JsonProperty("importOptions")
    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public ImportSummary withImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
        return this;
    }

    @JsonProperty("reference")
    public Optional<String> getReference() {
        return Optional.ofNullable(reference);
    }

    @JsonProperty("reference")
    public void setReference(String reference) {
        this.reference = reference;
    }

    public ImportSummary withReference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<ImportSummaries> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(ImportSummaries relationships) {
        this.relationships = relationships;
    }

    public ImportSummary withRelationships(ImportSummaries relationships) {
        this.relationships = relationships;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportSummary withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    @JsonProperty("status")
    public Optional<ImportStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(ImportStatus status) {
        this.status = status;
    }

    public ImportSummary withStatus(ImportStatus status) {
        this.status = status;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("conflicts".equals(name)) {
            if (value instanceof List) {
                setConflicts(((List<Object> ) value));
            } else {
                throw new IllegalArgumentException(("property \"conflicts\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataSetComplete".equals(name)) {
                if (value instanceof String) {
                    setDataSetComplete(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSetComplete\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("description".equals(name)) {
                    if (value instanceof String) {
                        setDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("enrollments".equals(name)) {
                        if (value instanceof ImportSummaries) {
                            setEnrollments(((ImportSummaries) value));
                        } else {
                            throw new IllegalArgumentException(("property \"enrollments\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportSummaries\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("events".equals(name)) {
                            if (value instanceof ImportSummaries) {
                                setEvents(((ImportSummaries) value));
                            } else {
                                throw new IllegalArgumentException(("property \"events\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportSummaries\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("href".equals(name)) {
                                if (value instanceof String) {
                                    setHref(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("importCount".equals(name)) {
                                    if (value instanceof ImportCount) {
                                        setImportCount(((ImportCount) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"importCount\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportCount\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("importOptions".equals(name)) {
                                        if (value instanceof ImportOptions) {
                                            setImportOptions(((ImportOptions) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"importOptions\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportOptions\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("reference".equals(name)) {
                                            if (value instanceof String) {
                                                setReference(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"reference\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("relationships".equals(name)) {
                                                if (value instanceof ImportSummaries) {
                                                    setRelationships(((ImportSummaries) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"relationships\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportSummaries\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("responseType".equals(name)) {
                                                    if (value instanceof String) {
                                                        setResponseType(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("status".equals(name)) {
                                                        if (value instanceof ImportStatus) {
                                                            setStatus(((ImportStatus) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_37_7.ImportStatus\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        return false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("conflicts".equals(name)) {
            return getConflicts();
        } else {
            if ("dataSetComplete".equals(name)) {
                return getDataSetComplete();
            } else {
                if ("description".equals(name)) {
                    return getDescription();
                } else {
                    if ("enrollments".equals(name)) {
                        return getEnrollments();
                    } else {
                        if ("events".equals(name)) {
                            return getEvents();
                        } else {
                            if ("href".equals(name)) {
                                return getHref();
                            } else {
                                if ("importCount".equals(name)) {
                                    return getImportCount();
                                } else {
                                    if ("importOptions".equals(name)) {
                                        return getImportOptions();
                                    } else {
                                        if ("reference".equals(name)) {
                                            return getReference();
                                        } else {
                                            if ("relationships".equals(name)) {
                                                return getRelationships();
                                            } else {
                                                if ("responseType".equals(name)) {
                                                    return getResponseType();
                                                } else {
                                                    if ("status".equals(name)) {
                                                        return getStatus();
                                                    } else {
                                                        return notFoundValue;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportSummary.NOT_FOUND_VALUE);
        if (ImportSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("conflicts");
        sb.append('=');
        sb.append(((this.conflicts == null)?"<null>":this.conflicts));
        sb.append(',');
        sb.append("dataSetComplete");
        sb.append('=');
        sb.append(((this.dataSetComplete == null)?"<null>":this.dataSetComplete));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("enrollments");
        sb.append('=');
        sb.append(((this.enrollments == null)?"<null>":this.enrollments));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("importCount");
        sb.append('=');
        sb.append(((this.importCount == null)?"<null>":this.importCount));
        sb.append(',');
        sb.append("importOptions");
        sb.append('=');
        sb.append(((this.importOptions == null)?"<null>":this.importOptions));
        sb.append(',');
        sb.append("reference");
        sb.append('=');
        sb.append(((this.reference == null)?"<null>":this.reference));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.importCount == null)? 0 :this.importCount.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.enrollments == null)? 0 :this.enrollments.hashCode()));
        result = ((result* 31)+((this.reference == null)? 0 :this.reference.hashCode()));
        result = ((result* 31)+((this.importOptions == null)? 0 :this.importOptions.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.conflicts == null)? 0 :this.conflicts.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.dataSetComplete == null)? 0 :this.dataSetComplete.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportSummary) == false) {
            return false;
        }
        ImportSummary rhs = ((ImportSummary) other);
        return ((((((((((((((this.importCount == rhs.importCount)||((this.importCount!= null)&&this.importCount.equals(rhs.importCount)))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.enrollments == rhs.enrollments)||((this.enrollments!= null)&&this.enrollments.equals(rhs.enrollments))))&&((this.reference == rhs.reference)||((this.reference!= null)&&this.reference.equals(rhs.reference))))&&((this.importOptions == rhs.importOptions)||((this.importOptions!= null)&&this.importOptions.equals(rhs.importOptions))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.conflicts == rhs.conflicts)||((this.conflicts!= null)&&this.conflicts.equals(rhs.conflicts))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.dataSetComplete == rhs.dataSetComplete)||((this.dataSetComplete!= null)&&this.dataSetComplete.equals(rhs.dataSetComplete))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
