
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "currentNodeId",
    "currentNodeUuid",
    "leader",
    "leaderNodeId",
    "leaderNodeUuid"
})
@Generated("jsonschema2pojo")
public class LeaderNodeInfo implements Serializable
{

    @JsonProperty("currentNodeId")
    private String currentNodeId;
    @JsonProperty("currentNodeUuid")
    private String currentNodeUuid;
    @JsonProperty("leader")
    private Boolean leader;
    @JsonProperty("leaderNodeId")
    private String leaderNodeId;
    @JsonProperty("leaderNodeUuid")
    private String leaderNodeUuid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -870882292314664771L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LeaderNodeInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public LeaderNodeInfo(LeaderNodeInfo source) {
        super();
        this.currentNodeId = source.currentNodeId;
        this.currentNodeUuid = source.currentNodeUuid;
        this.leader = source.leader;
        this.leaderNodeId = source.leaderNodeId;
        this.leaderNodeUuid = source.leaderNodeUuid;
    }

    public LeaderNodeInfo(String currentNodeId, String currentNodeUuid, Boolean leader, String leaderNodeId, String leaderNodeUuid) {
        super();
        this.currentNodeId = currentNodeId;
        this.currentNodeUuid = currentNodeUuid;
        this.leader = leader;
        this.leaderNodeId = leaderNodeId;
        this.leaderNodeUuid = leaderNodeUuid;
    }

    @JsonProperty("currentNodeId")
    public Optional<String> getCurrentNodeId() {
        return Optional.ofNullable(currentNodeId);
    }

    @JsonProperty("currentNodeId")
    public void setCurrentNodeId(String currentNodeId) {
        this.currentNodeId = currentNodeId;
    }

    public LeaderNodeInfo withCurrentNodeId(String currentNodeId) {
        this.currentNodeId = currentNodeId;
        return this;
    }

    @JsonProperty("currentNodeUuid")
    public Optional<String> getCurrentNodeUuid() {
        return Optional.ofNullable(currentNodeUuid);
    }

    @JsonProperty("currentNodeUuid")
    public void setCurrentNodeUuid(String currentNodeUuid) {
        this.currentNodeUuid = currentNodeUuid;
    }

    public LeaderNodeInfo withCurrentNodeUuid(String currentNodeUuid) {
        this.currentNodeUuid = currentNodeUuid;
        return this;
    }

    @JsonProperty("leader")
    public Optional<Boolean> getLeader() {
        return Optional.ofNullable(leader);
    }

    @JsonProperty("leader")
    public void setLeader(Boolean leader) {
        this.leader = leader;
    }

    public LeaderNodeInfo withLeader(Boolean leader) {
        this.leader = leader;
        return this;
    }

    @JsonProperty("leaderNodeId")
    public Optional<String> getLeaderNodeId() {
        return Optional.ofNullable(leaderNodeId);
    }

    @JsonProperty("leaderNodeId")
    public void setLeaderNodeId(String leaderNodeId) {
        this.leaderNodeId = leaderNodeId;
    }

    public LeaderNodeInfo withLeaderNodeId(String leaderNodeId) {
        this.leaderNodeId = leaderNodeId;
        return this;
    }

    @JsonProperty("leaderNodeUuid")
    public Optional<String> getLeaderNodeUuid() {
        return Optional.ofNullable(leaderNodeUuid);
    }

    @JsonProperty("leaderNodeUuid")
    public void setLeaderNodeUuid(String leaderNodeUuid) {
        this.leaderNodeUuid = leaderNodeUuid;
    }

    public LeaderNodeInfo withLeaderNodeUuid(String leaderNodeUuid) {
        this.leaderNodeUuid = leaderNodeUuid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LeaderNodeInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("currentNodeId".equals(name)) {
            if (value instanceof String) {
                setCurrentNodeId(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"currentNodeId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("currentNodeUuid".equals(name)) {
                if (value instanceof String) {
                    setCurrentNodeUuid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"currentNodeUuid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("leader".equals(name)) {
                    if (value instanceof Boolean) {
                        setLeader(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"leader\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("leaderNodeId".equals(name)) {
                        if (value instanceof String) {
                            setLeaderNodeId(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"leaderNodeId\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("leaderNodeUuid".equals(name)) {
                            if (value instanceof String) {
                                setLeaderNodeUuid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"leaderNodeUuid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("currentNodeId".equals(name)) {
            return getCurrentNodeId();
        } else {
            if ("currentNodeUuid".equals(name)) {
                return getCurrentNodeUuid();
            } else {
                if ("leader".equals(name)) {
                    return getLeader();
                } else {
                    if ("leaderNodeId".equals(name)) {
                        return getLeaderNodeId();
                    } else {
                        if ("leaderNodeUuid".equals(name)) {
                            return getLeaderNodeUuid();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LeaderNodeInfo.NOT_FOUND_VALUE);
        if (LeaderNodeInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LeaderNodeInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LeaderNodeInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("currentNodeId");
        sb.append('=');
        sb.append(((this.currentNodeId == null)?"<null>":this.currentNodeId));
        sb.append(',');
        sb.append("currentNodeUuid");
        sb.append('=');
        sb.append(((this.currentNodeUuid == null)?"<null>":this.currentNodeUuid));
        sb.append(',');
        sb.append("leader");
        sb.append('=');
        sb.append(((this.leader == null)?"<null>":this.leader));
        sb.append(',');
        sb.append("leaderNodeId");
        sb.append('=');
        sb.append(((this.leaderNodeId == null)?"<null>":this.leaderNodeId));
        sb.append(',');
        sb.append("leaderNodeUuid");
        sb.append('=');
        sb.append(((this.leaderNodeUuid == null)?"<null>":this.leaderNodeUuid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.leaderNodeUuid == null)? 0 :this.leaderNodeUuid.hashCode()));
        result = ((result* 31)+((this.leader == null)? 0 :this.leader.hashCode()));
        result = ((result* 31)+((this.currentNodeUuid == null)? 0 :this.currentNodeUuid.hashCode()));
        result = ((result* 31)+((this.currentNodeId == null)? 0 :this.currentNodeId.hashCode()));
        result = ((result* 31)+((this.leaderNodeId == null)? 0 :this.leaderNodeId.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LeaderNodeInfo) == false) {
            return false;
        }
        LeaderNodeInfo rhs = ((LeaderNodeInfo) other);
        return (((((((this.leaderNodeUuid == rhs.leaderNodeUuid)||((this.leaderNodeUuid!= null)&&this.leaderNodeUuid.equals(rhs.leaderNodeUuid)))&&((this.leader == rhs.leader)||((this.leader!= null)&&this.leader.equals(rhs.leader))))&&((this.currentNodeUuid == rhs.currentNodeUuid)||((this.currentNodeUuid!= null)&&this.currentNodeUuid.equals(rhs.currentNodeUuid))))&&((this.currentNodeId == rhs.currentNodeId)||((this.currentNodeId!= null)&&this.currentNodeId.equals(rhs.currentNodeId))))&&((this.leaderNodeId == rhs.leaderNodeId)||((this.leaderNodeId!= null)&&this.leaderNodeId.equals(rhs.leaderNodeId))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
