
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "allowedContentTypes",
    "maxFileSize",
    "version"
})
@Generated("jsonschema2pojo")
public class OrgHispDhisCommonFileTypeValueOptions implements Serializable
{

    @JsonProperty("allowedContentTypes")
    private List<String> allowedContentTypes;
    @JsonProperty("maxFileSize")
    private Integer maxFileSize;
    @JsonProperty("version")
    private Integer version;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6507530831408535832L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrgHispDhisCommonFileTypeValueOptions() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OrgHispDhisCommonFileTypeValueOptions(OrgHispDhisCommonFileTypeValueOptions source) {
        super();
        this.allowedContentTypes = source.allowedContentTypes;
        this.maxFileSize = source.maxFileSize;
        this.version = source.version;
    }

    public OrgHispDhisCommonFileTypeValueOptions(List<String> allowedContentTypes, Integer maxFileSize, Integer version) {
        super();
        this.allowedContentTypes = allowedContentTypes;
        this.maxFileSize = maxFileSize;
        this.version = version;
    }

    @JsonProperty("allowedContentTypes")
    public Optional<List<String>> getAllowedContentTypes() {
        return Optional.ofNullable(allowedContentTypes);
    }

    @JsonProperty("allowedContentTypes")
    public void setAllowedContentTypes(List<String> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
    }

    public OrgHispDhisCommonFileTypeValueOptions withAllowedContentTypes(List<String> allowedContentTypes) {
        this.allowedContentTypes = allowedContentTypes;
        return this;
    }

    @JsonProperty("maxFileSize")
    public Optional<Integer> getMaxFileSize() {
        return Optional.ofNullable(maxFileSize);
    }

    @JsonProperty("maxFileSize")
    public void setMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public OrgHispDhisCommonFileTypeValueOptions withMaxFileSize(Integer maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @JsonProperty("version")
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    @JsonProperty("version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    public OrgHispDhisCommonFileTypeValueOptions withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrgHispDhisCommonFileTypeValueOptions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("allowedContentTypes".equals(name)) {
            if (value instanceof List) {
                setAllowedContentTypes(((List<String> ) value));
            } else {
                throw new IllegalArgumentException(("property \"allowedContentTypes\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("maxFileSize".equals(name)) {
                if (value instanceof Integer) {
                    setMaxFileSize(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxFileSize\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("version".equals(name)) {
                    if (value instanceof Integer) {
                        setVersion(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"version\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("allowedContentTypes".equals(name)) {
            return getAllowedContentTypes();
        } else {
            if ("maxFileSize".equals(name)) {
                return getMaxFileSize();
            } else {
                if ("version".equals(name)) {
                    return getVersion();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrgHispDhisCommonFileTypeValueOptions.NOT_FOUND_VALUE);
        if (OrgHispDhisCommonFileTypeValueOptions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrgHispDhisCommonFileTypeValueOptions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrgHispDhisCommonFileTypeValueOptions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("allowedContentTypes");
        sb.append('=');
        sb.append(((this.allowedContentTypes == null)?"<null>":this.allowedContentTypes));
        sb.append(',');
        sb.append("maxFileSize");
        sb.append('=');
        sb.append(((this.maxFileSize == null)?"<null>":this.maxFileSize));
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.allowedContentTypes == null)? 0 :this.allowedContentTypes.hashCode()));
        result = ((result* 31)+((this.maxFileSize == null)? 0 :this.maxFileSize.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrgHispDhisCommonFileTypeValueOptions) == false) {
            return false;
        }
        OrgHispDhisCommonFileTypeValueOptions rhs = ((OrgHispDhisCommonFileTypeValueOptions) other);
        return (((((this.allowedContentTypes == rhs.allowedContentTypes)||((this.allowedContentTypes!= null)&&this.allowedContentTypes.equals(rhs.allowedContentTypes)))&&((this.maxFileSize == rhs.maxFileSize)||((this.maxFileSize!= null)&&this.maxFileSize.equals(rhs.maxFileSize))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))));
    }

}
