
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "message",
    "recipientsList",
    "smsSubject"
})
@Generated("jsonschema2pojo")
public class SmsJobParameters implements Serializable
{

    @JsonProperty("message")
    private String message;
    @JsonProperty("recipientsList")
    private List<String> recipientsList;
    @JsonProperty("smsSubject")
    private String smsSubject;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3474747327930138516L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SmsJobParameters() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SmsJobParameters(SmsJobParameters source) {
        super();
        this.message = source.message;
        this.recipientsList = source.recipientsList;
        this.smsSubject = source.smsSubject;
    }

    public SmsJobParameters(String message, List<String> recipientsList, String smsSubject) {
        super();
        this.message = message;
        this.recipientsList = recipientsList;
        this.smsSubject = smsSubject;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public SmsJobParameters withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("recipientsList")
    public Optional<List<String>> getRecipientsList() {
        return Optional.ofNullable(recipientsList);
    }

    @JsonProperty("recipientsList")
    public void setRecipientsList(List<String> recipientsList) {
        this.recipientsList = recipientsList;
    }

    public SmsJobParameters withRecipientsList(List<String> recipientsList) {
        this.recipientsList = recipientsList;
        return this;
    }

    @JsonProperty("smsSubject")
    public Optional<String> getSmsSubject() {
        return Optional.ofNullable(smsSubject);
    }

    @JsonProperty("smsSubject")
    public void setSmsSubject(String smsSubject) {
        this.smsSubject = smsSubject;
    }

    public SmsJobParameters withSmsSubject(String smsSubject) {
        this.smsSubject = smsSubject;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SmsJobParameters withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("message".equals(name)) {
            if (value instanceof String) {
                setMessage(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("recipientsList".equals(name)) {
                if (value instanceof List) {
                    setRecipientsList(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"recipientsList\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("smsSubject".equals(name)) {
                    if (value instanceof String) {
                        setSmsSubject(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"smsSubject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("message".equals(name)) {
            return getMessage();
        } else {
            if ("recipientsList".equals(name)) {
                return getRecipientsList();
            } else {
                if ("smsSubject".equals(name)) {
                    return getSmsSubject();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SmsJobParameters.NOT_FOUND_VALUE);
        if (SmsJobParameters.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SmsJobParameters with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SmsJobParameters.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("recipientsList");
        sb.append('=');
        sb.append(((this.recipientsList == null)?"<null>":this.recipientsList));
        sb.append(',');
        sb.append("smsSubject");
        sb.append('=');
        sb.append(((this.smsSubject == null)?"<null>":this.smsSubject));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.smsSubject == null)? 0 :this.smsSubject.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.recipientsList == null)? 0 :this.recipientsList.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SmsJobParameters) == false) {
            return false;
        }
        SmsJobParameters rhs = ((SmsJobParameters) other);
        return (((((this.smsSubject == rhs.smsSubject)||((this.smsSubject!= null)&&this.smsSubject.equals(rhs.smsSubject)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.recipientsList == rhs.recipientsList)||((this.recipientsList!= null)&&this.recipientsList.equals(rhs.recipientsList))));
    }

}
