
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataSynchronizationQuery",
    "includeDeleted",
    "includeEnrollments",
    "includeEvents",
    "includeProgramOwners",
    "includeRelationships"
})
@Generated("jsonschema2pojo")
public class TrackedEntityInstanceParams implements Serializable
{

    @JsonProperty("dataSynchronizationQuery")
    private Boolean dataSynchronizationQuery;
    @JsonProperty("includeDeleted")
    private Boolean includeDeleted;
    @JsonProperty("includeEnrollments")
    private Boolean includeEnrollments;
    @JsonProperty("includeEvents")
    private Boolean includeEvents;
    @JsonProperty("includeProgramOwners")
    private Boolean includeProgramOwners;
    @JsonProperty("includeRelationships")
    private Boolean includeRelationships;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8657320942240391539L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityInstanceParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityInstanceParams(TrackedEntityInstanceParams source) {
        super();
        this.dataSynchronizationQuery = source.dataSynchronizationQuery;
        this.includeDeleted = source.includeDeleted;
        this.includeEnrollments = source.includeEnrollments;
        this.includeEvents = source.includeEvents;
        this.includeProgramOwners = source.includeProgramOwners;
        this.includeRelationships = source.includeRelationships;
    }

    public TrackedEntityInstanceParams(Boolean dataSynchronizationQuery, Boolean includeDeleted, Boolean includeEnrollments, Boolean includeEvents, Boolean includeProgramOwners, Boolean includeRelationships) {
        super();
        this.dataSynchronizationQuery = dataSynchronizationQuery;
        this.includeDeleted = includeDeleted;
        this.includeEnrollments = includeEnrollments;
        this.includeEvents = includeEvents;
        this.includeProgramOwners = includeProgramOwners;
        this.includeRelationships = includeRelationships;
    }

    @JsonProperty("dataSynchronizationQuery")
    public Optional<Boolean> getDataSynchronizationQuery() {
        return Optional.ofNullable(dataSynchronizationQuery);
    }

    @JsonProperty("dataSynchronizationQuery")
    public void setDataSynchronizationQuery(Boolean dataSynchronizationQuery) {
        this.dataSynchronizationQuery = dataSynchronizationQuery;
    }

    public TrackedEntityInstanceParams withDataSynchronizationQuery(Boolean dataSynchronizationQuery) {
        this.dataSynchronizationQuery = dataSynchronizationQuery;
        return this;
    }

    @JsonProperty("includeDeleted")
    public Optional<Boolean> getIncludeDeleted() {
        return Optional.ofNullable(includeDeleted);
    }

    @JsonProperty("includeDeleted")
    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public TrackedEntityInstanceParams withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    @JsonProperty("includeEnrollments")
    public Optional<Boolean> getIncludeEnrollments() {
        return Optional.ofNullable(includeEnrollments);
    }

    @JsonProperty("includeEnrollments")
    public void setIncludeEnrollments(Boolean includeEnrollments) {
        this.includeEnrollments = includeEnrollments;
    }

    public TrackedEntityInstanceParams withIncludeEnrollments(Boolean includeEnrollments) {
        this.includeEnrollments = includeEnrollments;
        return this;
    }

    @JsonProperty("includeEvents")
    public Optional<Boolean> getIncludeEvents() {
        return Optional.ofNullable(includeEvents);
    }

    @JsonProperty("includeEvents")
    public void setIncludeEvents(Boolean includeEvents) {
        this.includeEvents = includeEvents;
    }

    public TrackedEntityInstanceParams withIncludeEvents(Boolean includeEvents) {
        this.includeEvents = includeEvents;
        return this;
    }

    @JsonProperty("includeProgramOwners")
    public Optional<Boolean> getIncludeProgramOwners() {
        return Optional.ofNullable(includeProgramOwners);
    }

    @JsonProperty("includeProgramOwners")
    public void setIncludeProgramOwners(Boolean includeProgramOwners) {
        this.includeProgramOwners = includeProgramOwners;
    }

    public TrackedEntityInstanceParams withIncludeProgramOwners(Boolean includeProgramOwners) {
        this.includeProgramOwners = includeProgramOwners;
        return this;
    }

    @JsonProperty("includeRelationships")
    public Optional<Boolean> getIncludeRelationships() {
        return Optional.ofNullable(includeRelationships);
    }

    @JsonProperty("includeRelationships")
    public void setIncludeRelationships(Boolean includeRelationships) {
        this.includeRelationships = includeRelationships;
    }

    public TrackedEntityInstanceParams withIncludeRelationships(Boolean includeRelationships) {
        this.includeRelationships = includeRelationships;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityInstanceParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dataSynchronizationQuery".equals(name)) {
            if (value instanceof Boolean) {
                setDataSynchronizationQuery(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"dataSynchronizationQuery\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("includeDeleted".equals(name)) {
                if (value instanceof Boolean) {
                    setIncludeDeleted(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"includeDeleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("includeEnrollments".equals(name)) {
                    if (value instanceof Boolean) {
                        setIncludeEnrollments(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"includeEnrollments\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("includeEvents".equals(name)) {
                        if (value instanceof Boolean) {
                            setIncludeEvents(((Boolean) value));
                        } else {
                            throw new IllegalArgumentException(("property \"includeEvents\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("includeProgramOwners".equals(name)) {
                            if (value instanceof Boolean) {
                                setIncludeProgramOwners(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"includeProgramOwners\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("includeRelationships".equals(name)) {
                                if (value instanceof Boolean) {
                                    setIncludeRelationships(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"includeRelationships\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dataSynchronizationQuery".equals(name)) {
            return getDataSynchronizationQuery();
        } else {
            if ("includeDeleted".equals(name)) {
                return getIncludeDeleted();
            } else {
                if ("includeEnrollments".equals(name)) {
                    return getIncludeEnrollments();
                } else {
                    if ("includeEvents".equals(name)) {
                        return getIncludeEvents();
                    } else {
                        if ("includeProgramOwners".equals(name)) {
                            return getIncludeProgramOwners();
                        } else {
                            if ("includeRelationships".equals(name)) {
                                return getIncludeRelationships();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityInstanceParams.NOT_FOUND_VALUE);
        if (TrackedEntityInstanceParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityInstanceParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityInstanceParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataSynchronizationQuery");
        sb.append('=');
        sb.append(((this.dataSynchronizationQuery == null)?"<null>":this.dataSynchronizationQuery));
        sb.append(',');
        sb.append("includeDeleted");
        sb.append('=');
        sb.append(((this.includeDeleted == null)?"<null>":this.includeDeleted));
        sb.append(',');
        sb.append("includeEnrollments");
        sb.append('=');
        sb.append(((this.includeEnrollments == null)?"<null>":this.includeEnrollments));
        sb.append(',');
        sb.append("includeEvents");
        sb.append('=');
        sb.append(((this.includeEvents == null)?"<null>":this.includeEvents));
        sb.append(',');
        sb.append("includeProgramOwners");
        sb.append('=');
        sb.append(((this.includeProgramOwners == null)?"<null>":this.includeProgramOwners));
        sb.append(',');
        sb.append("includeRelationships");
        sb.append('=');
        sb.append(((this.includeRelationships == null)?"<null>":this.includeRelationships));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataSynchronizationQuery == null)? 0 :this.dataSynchronizationQuery.hashCode()));
        result = ((result* 31)+((this.includeRelationships == null)? 0 :this.includeRelationships.hashCode()));
        result = ((result* 31)+((this.includeDeleted == null)? 0 :this.includeDeleted.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.includeProgramOwners == null)? 0 :this.includeProgramOwners.hashCode()));
        result = ((result* 31)+((this.includeEnrollments == null)? 0 :this.includeEnrollments.hashCode()));
        result = ((result* 31)+((this.includeEvents == null)? 0 :this.includeEvents.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityInstanceParams) == false) {
            return false;
        }
        TrackedEntityInstanceParams rhs = ((TrackedEntityInstanceParams) other);
        return ((((((((this.dataSynchronizationQuery == rhs.dataSynchronizationQuery)||((this.dataSynchronizationQuery!= null)&&this.dataSynchronizationQuery.equals(rhs.dataSynchronizationQuery)))&&((this.includeRelationships == rhs.includeRelationships)||((this.includeRelationships!= null)&&this.includeRelationships.equals(rhs.includeRelationships))))&&((this.includeDeleted == rhs.includeDeleted)||((this.includeDeleted!= null)&&this.includeDeleted.equals(rhs.includeDeleted))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.includeProgramOwners == rhs.includeProgramOwners)||((this.includeProgramOwners!= null)&&this.includeProgramOwners.equals(rhs.includeProgramOwners))))&&((this.includeEnrollments == rhs.includeEnrollments)||((this.includeEnrollments!= null)&&this.includeEnrollments.equals(rhs.includeEnrollments))))&&((this.includeEvents == rhs.includeEvents)||((this.includeEvents!= null)&&this.includeEvents.equals(rhs.includeEvents))));
    }

}
