
package org.hisp.dhis.api.model.v2_37_7;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "commentRequiredViolations",
    "validationRuleViolations"
})
@Generated("jsonschema2pojo")
public class ValidationSummary implements Serializable
{

    @JsonProperty("commentRequiredViolations")
    private List<DataElementOperand> commentRequiredViolations;
    @JsonProperty("validationRuleViolations")
    private List<ValidationResult> validationRuleViolations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 3509137206252979613L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ValidationSummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ValidationSummary(ValidationSummary source) {
        super();
        this.commentRequiredViolations = source.commentRequiredViolations;
        this.validationRuleViolations = source.validationRuleViolations;
    }

    public ValidationSummary(List<DataElementOperand> commentRequiredViolations, List<ValidationResult> validationRuleViolations) {
        super();
        this.commentRequiredViolations = commentRequiredViolations;
        this.validationRuleViolations = validationRuleViolations;
    }

    @JsonProperty("commentRequiredViolations")
    public Optional<List<DataElementOperand>> getCommentRequiredViolations() {
        return Optional.ofNullable(commentRequiredViolations);
    }

    @JsonProperty("commentRequiredViolations")
    public void setCommentRequiredViolations(List<DataElementOperand> commentRequiredViolations) {
        this.commentRequiredViolations = commentRequiredViolations;
    }

    public ValidationSummary withCommentRequiredViolations(List<DataElementOperand> commentRequiredViolations) {
        this.commentRequiredViolations = commentRequiredViolations;
        return this;
    }

    @JsonProperty("validationRuleViolations")
    public Optional<List<ValidationResult>> getValidationRuleViolations() {
        return Optional.ofNullable(validationRuleViolations);
    }

    @JsonProperty("validationRuleViolations")
    public void setValidationRuleViolations(List<ValidationResult> validationRuleViolations) {
        this.validationRuleViolations = validationRuleViolations;
    }

    public ValidationSummary withValidationRuleViolations(List<ValidationResult> validationRuleViolations) {
        this.validationRuleViolations = validationRuleViolations;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ValidationSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("commentRequiredViolations".equals(name)) {
            if (value instanceof List) {
                setCommentRequiredViolations(((List<DataElementOperand> ) value));
            } else {
                throw new IllegalArgumentException(("property \"commentRequiredViolations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.DataElementOperand>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("validationRuleViolations".equals(name)) {
                if (value instanceof List) {
                    setValidationRuleViolations(((List<ValidationResult> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"validationRuleViolations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_37_7.ValidationResult>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("commentRequiredViolations".equals(name)) {
            return getCommentRequiredViolations();
        } else {
            if ("validationRuleViolations".equals(name)) {
                return getValidationRuleViolations();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ValidationSummary.NOT_FOUND_VALUE);
        if (ValidationSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ValidationSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidationSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("commentRequiredViolations");
        sb.append('=');
        sb.append(((this.commentRequiredViolations == null)?"<null>":this.commentRequiredViolations));
        sb.append(',');
        sb.append("validationRuleViolations");
        sb.append('=');
        sb.append(((this.validationRuleViolations == null)?"<null>":this.validationRuleViolations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.validationRuleViolations == null)? 0 :this.validationRuleViolations.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.commentRequiredViolations == null)? 0 :this.commentRequiredViolations.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ValidationSummary) == false) {
            return false;
        }
        ValidationSummary rhs = ((ValidationSummary) other);
        return ((((this.validationRuleViolations == rhs.validationRuleViolations)||((this.validationRuleViolations!= null)&&this.validationRuleViolations.equals(rhs.validationRuleViolations)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.commentRequiredViolations == rhs.commentRequiredViolations)||((this.commentRequiredViolations!= null)&&this.commentRequiredViolations.equals(rhs.commentRequiredViolations))));
    }

}
