
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "appKey",
    "attributeValues",
    "code",
    "contentCount",
    "created",
    "createdBy",
    "displayName",
    "eventChart",
    "eventReport",
    "eventVisualization",
    "externalAccess",
    "favorite",
    "favorites",
    "height",
    "href",
    "id",
    "interpretationCount",
    "interpretationLikeCount",
    "lastUpdated",
    "lastUpdatedBy",
    "map",
    "messages",
    "name",
    "publicAccess",
    "reports",
    "resources",
    "shape",
    "sharing",
    "text",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "users",
    "visualization",
    "width",
    "x",
    "y"
})
@Generated("jsonschema2pojo")
public class DashboardItem implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("appKey")
    private String appKey;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("contentCount")
    private Integer contentCount;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("eventChart")
    private EventChart eventChart;
    @JsonProperty("eventReport")
    private EventReport eventReport;
    @JsonProperty("eventVisualization")
    private EventVisualization eventVisualization;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("height")
    private Integer height;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretationCount")
    private Integer interpretationCount;
    @JsonProperty("interpretationLikeCount")
    private Integer interpretationLikeCount;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("map")
    private org.hisp.dhis.api.model.v2_38_1.Map map;
    @JsonProperty("messages")
    private Boolean messages;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("reports")
    private List<Report> reports;
    @JsonProperty("resources")
    private List<Document> resources;
    @JsonProperty("shape")
    private DashboardItem.DashboardItemShape shape;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("type")
    private DashboardItem.DashboardItemType type;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("users")
    private List<User> users;
    @JsonProperty("visualization")
    private Visualization visualization;
    @JsonProperty("width")
    private Integer width;
    @JsonProperty("x")
    private Integer x;
    @JsonProperty("y")
    private Integer y;
    @JsonIgnore
    private java.util.Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1776694943580461138L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DashboardItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DashboardItem(DashboardItem source) {
        super();
        this.access = source.access;
        this.appKey = source.appKey;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.contentCount = source.contentCount;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.displayName = source.displayName;
        this.eventChart = source.eventChart;
        this.eventReport = source.eventReport;
        this.eventVisualization = source.eventVisualization;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.height = source.height;
        this.href = source.href;
        this.id = source.id;
        this.interpretationCount = source.interpretationCount;
        this.interpretationLikeCount = source.interpretationLikeCount;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.map = source.map;
        this.messages = source.messages;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.reports = source.reports;
        this.resources = source.resources;
        this.shape = source.shape;
        this.sharing = source.sharing;
        this.text = source.text;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.users = source.users;
        this.visualization = source.visualization;
        this.width = source.width;
        this.x = source.x;
        this.y = source.y;
    }

    public DashboardItem(Access access, String appKey, List<AttributeValue> attributeValues, String code, Integer contentCount, Date created, User createdBy, String displayName, EventChart eventChart, EventReport eventReport, EventVisualization eventVisualization, Boolean externalAccess, Boolean favorite, List<String> favorites, Integer height, String href, String id, Integer interpretationCount, Integer interpretationLikeCount, Date lastUpdated, User lastUpdatedBy, org.hisp.dhis.api.model.v2_38_1.Map map, Boolean messages, String name, String publicAccess, List<Report> reports, List<Document> resources, DashboardItem.DashboardItemShape shape, Sharing sharing, String text, List<Translation> translations, DashboardItem.DashboardItemType type, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, List<User> users, Visualization visualization, Integer width, Integer x, Integer y) {
        super();
        this.access = access;
        this.appKey = appKey;
        this.attributeValues = attributeValues;
        this.code = code;
        this.contentCount = contentCount;
        this.created = created;
        this.createdBy = createdBy;
        this.displayName = displayName;
        this.eventChart = eventChart;
        this.eventReport = eventReport;
        this.eventVisualization = eventVisualization;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.height = height;
        this.href = href;
        this.id = id;
        this.interpretationCount = interpretationCount;
        this.interpretationLikeCount = interpretationLikeCount;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.map = map;
        this.messages = messages;
        this.name = name;
        this.publicAccess = publicAccess;
        this.reports = reports;
        this.resources = resources;
        this.shape = shape;
        this.sharing = sharing;
        this.text = text;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.users = users;
        this.visualization = visualization;
        this.width = width;
        this.x = x;
        this.y = y;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DashboardItem withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("appKey")
    public Optional<String> getAppKey() {
        return Optional.ofNullable(appKey);
    }

    @JsonProperty("appKey")
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public DashboardItem withAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DashboardItem withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DashboardItem withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("contentCount")
    public Optional<Integer> getContentCount() {
        return Optional.ofNullable(contentCount);
    }

    @JsonProperty("contentCount")
    public void setContentCount(Integer contentCount) {
        this.contentCount = contentCount;
    }

    public DashboardItem withContentCount(Integer contentCount) {
        this.contentCount = contentCount;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DashboardItem withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public DashboardItem withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DashboardItem withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("eventChart")
    public Optional<EventChart> getEventChart() {
        return Optional.ofNullable(eventChart);
    }

    @JsonProperty("eventChart")
    public void setEventChart(EventChart eventChart) {
        this.eventChart = eventChart;
    }

    public DashboardItem withEventChart(EventChart eventChart) {
        this.eventChart = eventChart;
        return this;
    }

    @JsonProperty("eventReport")
    public Optional<EventReport> getEventReport() {
        return Optional.ofNullable(eventReport);
    }

    @JsonProperty("eventReport")
    public void setEventReport(EventReport eventReport) {
        this.eventReport = eventReport;
    }

    public DashboardItem withEventReport(EventReport eventReport) {
        this.eventReport = eventReport;
        return this;
    }

    @JsonProperty("eventVisualization")
    public Optional<EventVisualization> getEventVisualization() {
        return Optional.ofNullable(eventVisualization);
    }

    @JsonProperty("eventVisualization")
    public void setEventVisualization(EventVisualization eventVisualization) {
        this.eventVisualization = eventVisualization;
    }

    public DashboardItem withEventVisualization(EventVisualization eventVisualization) {
        this.eventVisualization = eventVisualization;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DashboardItem withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DashboardItem withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DashboardItem withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("height")
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(height);
    }

    @JsonProperty("height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    public DashboardItem withHeight(Integer height) {
        this.height = height;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DashboardItem withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public DashboardItem withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretationCount")
    public Optional<Integer> getInterpretationCount() {
        return Optional.ofNullable(interpretationCount);
    }

    @JsonProperty("interpretationCount")
    public void setInterpretationCount(Integer interpretationCount) {
        this.interpretationCount = interpretationCount;
    }

    public DashboardItem withInterpretationCount(Integer interpretationCount) {
        this.interpretationCount = interpretationCount;
        return this;
    }

    @JsonProperty("interpretationLikeCount")
    public Optional<Integer> getInterpretationLikeCount() {
        return Optional.ofNullable(interpretationLikeCount);
    }

    @JsonProperty("interpretationLikeCount")
    public void setInterpretationLikeCount(Integer interpretationLikeCount) {
        this.interpretationLikeCount = interpretationLikeCount;
    }

    public DashboardItem withInterpretationLikeCount(Integer interpretationLikeCount) {
        this.interpretationLikeCount = interpretationLikeCount;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DashboardItem withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DashboardItem withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("map")
    public Optional<org.hisp.dhis.api.model.v2_38_1.Map> getMap() {
        return Optional.ofNullable(map);
    }

    @JsonProperty("map")
    public void setMap(org.hisp.dhis.api.model.v2_38_1.Map map) {
        this.map = map;
    }

    public DashboardItem withMap(org.hisp.dhis.api.model.v2_38_1.Map map) {
        this.map = map;
        return this;
    }

    @JsonProperty("messages")
    public Optional<Boolean> getMessages() {
        return Optional.ofNullable(messages);
    }

    @JsonProperty("messages")
    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    public DashboardItem withMessages(Boolean messages) {
        this.messages = messages;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public DashboardItem withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DashboardItem withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("reports")
    public Optional<List<Report>> getReports() {
        return Optional.ofNullable(reports);
    }

    @JsonProperty("reports")
    public void setReports(List<Report> reports) {
        this.reports = reports;
    }

    public DashboardItem withReports(List<Report> reports) {
        this.reports = reports;
        return this;
    }

    @JsonProperty("resources")
    public Optional<List<Document>> getResources() {
        return Optional.ofNullable(resources);
    }

    @JsonProperty("resources")
    public void setResources(List<Document> resources) {
        this.resources = resources;
    }

    public DashboardItem withResources(List<Document> resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty("shape")
    public Optional<DashboardItem.DashboardItemShape> getShape() {
        return Optional.ofNullable(shape);
    }

    @JsonProperty("shape")
    public void setShape(DashboardItem.DashboardItemShape shape) {
        this.shape = shape;
    }

    public DashboardItem withShape(DashboardItem.DashboardItemShape shape) {
        this.shape = shape;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DashboardItem withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public DashboardItem withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DashboardItem withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("type")
    public Optional<DashboardItem.DashboardItemType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(DashboardItem.DashboardItemType type) {
        this.type = type;
    }

    public DashboardItem withType(DashboardItem.DashboardItemType type) {
        this.type = type;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public DashboardItem withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DashboardItem withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DashboardItem withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<User>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<User> users) {
        this.users = users;
    }

    public DashboardItem withUsers(List<User> users) {
        this.users = users;
        return this;
    }

    @JsonProperty("visualization")
    public Optional<Visualization> getVisualization() {
        return Optional.ofNullable(visualization);
    }

    @JsonProperty("visualization")
    public void setVisualization(Visualization visualization) {
        this.visualization = visualization;
    }

    public DashboardItem withVisualization(Visualization visualization) {
        this.visualization = visualization;
        return this;
    }

    @JsonProperty("width")
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    @JsonProperty("width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    public DashboardItem withWidth(Integer width) {
        this.width = width;
        return this;
    }

    @JsonProperty("x")
    public Optional<Integer> getX() {
        return Optional.ofNullable(x);
    }

    @JsonProperty("x")
    public void setX(Integer x) {
        this.x = x;
    }

    public DashboardItem withX(Integer x) {
        this.x = x;
        return this;
    }

    @JsonProperty("y")
    public Optional<Integer> getY() {
        return Optional.ofNullable(y);
    }

    @JsonProperty("y")
    public void setY(Integer y) {
        this.y = y;
    }

    public DashboardItem withY(Integer y) {
        this.y = y;
        return this;
    }

    @JsonAnyGetter
    public java.util.Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DashboardItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("appKey".equals(name)) {
                if (value instanceof String) {
                    setAppKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"appKey\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("contentCount".equals(name)) {
                            if (value instanceof Integer) {
                                setContentCount(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"contentCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("created".equals(name)) {
                                if (value instanceof Date) {
                                    setCreated(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof User) {
                                        setCreatedBy(((User) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("eventChart".equals(name)) {
                                            if (value instanceof EventChart) {
                                                setEventChart(((EventChart) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"eventChart\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("eventReport".equals(name)) {
                                                if (value instanceof EventReport) {
                                                    setEventReport(((EventReport) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"eventReport\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventReport\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("eventVisualization".equals(name)) {
                                                    if (value instanceof EventVisualization) {
                                                        setEventVisualization(((EventVisualization) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"eventVisualization\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventVisualization\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("height".equals(name)) {
                                                                    if (value instanceof Integer) {
                                                                        setHeight(((Integer) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"height\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setHref(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setId(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("interpretationCount".equals(name)) {
                                                                                if (value instanceof Integer) {
                                                                                    setInterpretationCount(((Integer) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"interpretationCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("interpretationLikeCount".equals(name)) {
                                                                                    if (value instanceof Integer) {
                                                                                        setInterpretationLikeCount(((Integer) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"interpretationLikeCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("lastUpdated".equals(name)) {
                                                                                        if (value instanceof Date) {
                                                                                            setLastUpdated(((Date) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                            if (value instanceof User) {
                                                                                                setLastUpdatedBy(((User) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("map".equals(name)) {
                                                                                                if (value instanceof org.hisp.dhis.api.model.v2_38_1.Map) {
                                                                                                    setMap(((org.hisp.dhis.api.model.v2_38_1.Map) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"map\" is of type \"org.hisp.dhis.api.model.v2_38_1.Map\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("messages".equals(name)) {
                                                                                                    if (value instanceof Boolean) {
                                                                                                        setMessages(((Boolean) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"messages\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setName(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setPublicAccess(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("reports".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setReports(((List<Report> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"reports\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Report>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("resources".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setResources(((List<Document> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"resources\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Document>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("shape".equals(name)) {
                                                                                                                        if (value instanceof DashboardItem.DashboardItemShape) {
                                                                                                                            setShape(((DashboardItem.DashboardItemShape) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"shape\" is of type \"org.hisp.dhis.api.model.v2_38_1.DashboardItem.DashboardItemShape\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("sharing".equals(name)) {
                                                                                                                            if (value instanceof Sharing) {
                                                                                                                                setSharing(((Sharing) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("text".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setText(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setTranslations(((List<Translation> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("type".equals(name)) {
                                                                                                                                        if (value instanceof DashboardItem.DashboardItemType) {
                                                                                                                                            setType(((DashboardItem.DashboardItemType) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_38_1.DashboardItem.DashboardItemType\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                            if (value instanceof User) {
                                                                                                                                                setUser(((User) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                if (value instanceof List) {
                                                                                                                                                    setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                        setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("users".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setUsers(((List<User> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.User>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("visualization".equals(name)) {
                                                                                                                                                            if (value instanceof Visualization) {
                                                                                                                                                                setVisualization(((Visualization) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"visualization\" is of type \"org.hisp.dhis.api.model.v2_38_1.Visualization\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("width".equals(name)) {
                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                    setWidth(((Integer) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"width\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("x".equals(name)) {
                                                                                                                                                                    if (value instanceof Integer) {
                                                                                                                                                                        setX(((Integer) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"x\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("y".equals(name)) {
                                                                                                                                                                        if (value instanceof Integer) {
                                                                                                                                                                            setY(((Integer) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"y\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("appKey".equals(name)) {
                return getAppKey();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("contentCount".equals(name)) {
                            return getContentCount();
                        } else {
                            if ("created".equals(name)) {
                                return getCreated();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("eventChart".equals(name)) {
                                            return getEventChart();
                                        } else {
                                            if ("eventReport".equals(name)) {
                                                return getEventReport();
                                            } else {
                                                if ("eventVisualization".equals(name)) {
                                                    return getEventVisualization();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("height".equals(name)) {
                                                                    return getHeight();
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        return getHref();
                                                                    } else {
                                                                        if ("id".equals(name)) {
                                                                            return getId();
                                                                        } else {
                                                                            if ("interpretationCount".equals(name)) {
                                                                                return getInterpretationCount();
                                                                            } else {
                                                                                if ("interpretationLikeCount".equals(name)) {
                                                                                    return getInterpretationLikeCount();
                                                                                } else {
                                                                                    if ("lastUpdated".equals(name)) {
                                                                                        return getLastUpdated();
                                                                                    } else {
                                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                                            return getLastUpdatedBy();
                                                                                        } else {
                                                                                            if ("map".equals(name)) {
                                                                                                return getMap();
                                                                                            } else {
                                                                                                if ("messages".equals(name)) {
                                                                                                    return getMessages();
                                                                                                } else {
                                                                                                    if ("name".equals(name)) {
                                                                                                        return getName();
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            return getPublicAccess();
                                                                                                        } else {
                                                                                                            if ("reports".equals(name)) {
                                                                                                                return getReports();
                                                                                                            } else {
                                                                                                                if ("resources".equals(name)) {
                                                                                                                    return getResources();
                                                                                                                } else {
                                                                                                                    if ("shape".equals(name)) {
                                                                                                                        return getShape();
                                                                                                                    } else {
                                                                                                                        if ("sharing".equals(name)) {
                                                                                                                            return getSharing();
                                                                                                                        } else {
                                                                                                                            if ("text".equals(name)) {
                                                                                                                                return getText();
                                                                                                                            } else {
                                                                                                                                if ("translations".equals(name)) {
                                                                                                                                    return getTranslations();
                                                                                                                                } else {
                                                                                                                                    if ("type".equals(name)) {
                                                                                                                                        return getType();
                                                                                                                                    } else {
                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                            return getUser();
                                                                                                                                        } else {
                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                return getUserAccesses();
                                                                                                                                            } else {
                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                } else {
                                                                                                                                                    if ("users".equals(name)) {
                                                                                                                                                        return getUsers();
                                                                                                                                                    } else {
                                                                                                                                                        if ("visualization".equals(name)) {
                                                                                                                                                            return getVisualization();
                                                                                                                                                        } else {
                                                                                                                                                            if ("width".equals(name)) {
                                                                                                                                                                return getWidth();
                                                                                                                                                            } else {
                                                                                                                                                                if ("x".equals(name)) {
                                                                                                                                                                    return getX();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("y".equals(name)) {
                                                                                                                                                                        return getY();
                                                                                                                                                                    } else {
                                                                                                                                                                        return notFoundValue;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DashboardItem.NOT_FOUND_VALUE);
        if (DashboardItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DashboardItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DashboardItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("appKey");
        sb.append('=');
        sb.append(((this.appKey == null)?"<null>":this.appKey));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("contentCount");
        sb.append('=');
        sb.append(((this.contentCount == null)?"<null>":this.contentCount));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("eventChart");
        sb.append('=');
        sb.append(((this.eventChart == null)?"<null>":this.eventChart));
        sb.append(',');
        sb.append("eventReport");
        sb.append('=');
        sb.append(((this.eventReport == null)?"<null>":this.eventReport));
        sb.append(',');
        sb.append("eventVisualization");
        sb.append('=');
        sb.append(((this.eventVisualization == null)?"<null>":this.eventVisualization));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("height");
        sb.append('=');
        sb.append(((this.height == null)?"<null>":this.height));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretationCount");
        sb.append('=');
        sb.append(((this.interpretationCount == null)?"<null>":this.interpretationCount));
        sb.append(',');
        sb.append("interpretationLikeCount");
        sb.append('=');
        sb.append(((this.interpretationLikeCount == null)?"<null>":this.interpretationLikeCount));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("map");
        sb.append('=');
        sb.append(((this.map == null)?"<null>":this.map));
        sb.append(',');
        sb.append("messages");
        sb.append('=');
        sb.append(((this.messages == null)?"<null>":this.messages));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("reports");
        sb.append('=');
        sb.append(((this.reports == null)?"<null>":this.reports));
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(((this.resources == null)?"<null>":this.resources));
        sb.append(',');
        sb.append("shape");
        sb.append('=');
        sb.append(((this.shape == null)?"<null>":this.shape));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("visualization");
        sb.append('=');
        sb.append(((this.visualization == null)?"<null>":this.visualization));
        sb.append(',');
        sb.append("width");
        sb.append('=');
        sb.append(((this.width == null)?"<null>":this.width));
        sb.append(',');
        sb.append("x");
        sb.append('=');
        sb.append(((this.x == null)?"<null>":this.x));
        sb.append(',');
        sb.append("y");
        sb.append('=');
        sb.append(((this.y == null)?"<null>":this.y));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.reports == null)? 0 :this.reports.hashCode()));
        result = ((result* 31)+((this.visualization == null)? 0 :this.visualization.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.eventVisualization == null)? 0 :this.eventVisualization.hashCode()));
        result = ((result* 31)+((this.appKey == null)? 0 :this.appKey.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.map == null)? 0 :this.map.hashCode()));
        result = ((result* 31)+((this.contentCount == null)? 0 :this.contentCount.hashCode()));
        result = ((result* 31)+((this.height == null)? 0 :this.height.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.shape == null)? 0 :this.shape.hashCode()));
        result = ((result* 31)+((this.interpretationCount == null)? 0 :this.interpretationCount.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.resources == null)? 0 :this.resources.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.eventReport == null)? 0 :this.eventReport.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.eventChart == null)? 0 :this.eventChart.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.width == null)? 0 :this.width.hashCode()));
        result = ((result* 31)+((this.x == null)? 0 :this.x.hashCode()));
        result = ((result* 31)+((this.interpretationLikeCount == null)? 0 :this.interpretationLikeCount.hashCode()));
        result = ((result* 31)+((this.messages == null)? 0 :this.messages.hashCode()));
        result = ((result* 31)+((this.y == null)? 0 :this.y.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DashboardItem) == false) {
            return false;
        }
        DashboardItem rhs = ((DashboardItem) other);
        return ((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.reports == rhs.reports)||((this.reports!= null)&&this.reports.equals(rhs.reports))))&&((this.visualization == rhs.visualization)||((this.visualization!= null)&&this.visualization.equals(rhs.visualization))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.eventVisualization == rhs.eventVisualization)||((this.eventVisualization!= null)&&this.eventVisualization.equals(rhs.eventVisualization))))&&((this.appKey == rhs.appKey)||((this.appKey!= null)&&this.appKey.equals(rhs.appKey))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.map == rhs.map)||((this.map!= null)&&this.map.equals(rhs.map))))&&((this.contentCount == rhs.contentCount)||((this.contentCount!= null)&&this.contentCount.equals(rhs.contentCount))))&&((this.height == rhs.height)||((this.height!= null)&&this.height.equals(rhs.height))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.shape == rhs.shape)||((this.shape!= null)&&this.shape.equals(rhs.shape))))&&((this.interpretationCount == rhs.interpretationCount)||((this.interpretationCount!= null)&&this.interpretationCount.equals(rhs.interpretationCount))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.resources == rhs.resources)||((this.resources!= null)&&this.resources.equals(rhs.resources))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.eventReport == rhs.eventReport)||((this.eventReport!= null)&&this.eventReport.equals(rhs.eventReport))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.eventChart == rhs.eventChart)||((this.eventChart!= null)&&this.eventChart.equals(rhs.eventChart))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.width == rhs.width)||((this.width!= null)&&this.width.equals(rhs.width))))&&((this.x == rhs.x)||((this.x!= null)&&this.x.equals(rhs.x))))&&((this.interpretationLikeCount == rhs.interpretationLikeCount)||((this.interpretationLikeCount!= null)&&this.interpretationLikeCount.equals(rhs.interpretationLikeCount))))&&((this.messages == rhs.messages)||((this.messages!= null)&&this.messages.equals(rhs.messages))))&&((this.y == rhs.y)||((this.y!= null)&&this.y.equals(rhs.y))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum DashboardItemShape {

        NORMAL("NORMAL"),
        DOUBLE_WIDTH("DOUBLE_WIDTH"),
        FULL_WIDTH("FULL_WIDTH");
        private final String value;
        private final static java.util.Map<String, DashboardItem.DashboardItemShape> CONSTANTS = new HashMap<String, DashboardItem.DashboardItemShape>();

        static {
            for (DashboardItem.DashboardItemShape c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DashboardItemShape(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardItem.DashboardItemShape fromValue(String value) {
            DashboardItem.DashboardItemShape constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DashboardItemType {

        VISUALIZATION("VISUALIZATION"),
        EVENT_VISUALIZATION("EVENT_VISUALIZATION"),
        EVENT_CHART("EVENT_CHART"),
        MAP("MAP"),
        EVENT_REPORT("EVENT_REPORT"),
        USERS("USERS"),
        REPORTS("REPORTS"),
        RESOURCES("RESOURCES"),
        TEXT("TEXT"),
        MESSAGES("MESSAGES"),
        APP("APP");
        private final String value;
        private final static java.util.Map<String, DashboardItem.DashboardItemType> CONSTANTS = new HashMap<String, DashboardItem.DashboardItemType>();

        static {
            for (DashboardItem.DashboardItemType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DashboardItemType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardItem.DashboardItemType fromValue(String value) {
            DashboardItem.DashboardItemType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
