
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "createdByUsername",
    "createdDate",
    "dataSet",
    "organisationUnit",
    "period",
    "permissions",
    "state"
})
@Generated("jsonschema2pojo")
public class DataApprovalStateResponse implements Serializable
{

    @JsonProperty("createdByUsername")
    private String createdByUsername;
    @JsonProperty("createdDate")
    private Date createdDate;
    @JsonProperty("dataSet")
    private DataSet dataSet;
    @JsonProperty("organisationUnit")
    private OrganisationUnit organisationUnit;
    @JsonProperty("period")
    private Period period;
    @JsonProperty("permissions")
    private DataApprovalPermissions permissions;
    @JsonProperty("state")
    private String state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6010111715952496730L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataApprovalStateResponse() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataApprovalStateResponse(DataApprovalStateResponse source) {
        super();
        this.createdByUsername = source.createdByUsername;
        this.createdDate = source.createdDate;
        this.dataSet = source.dataSet;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.permissions = source.permissions;
        this.state = source.state;
    }

    public DataApprovalStateResponse(String createdByUsername, Date createdDate, DataSet dataSet, OrganisationUnit organisationUnit, Period period, DataApprovalPermissions permissions, String state) {
        super();
        this.createdByUsername = createdByUsername;
        this.createdDate = createdDate;
        this.dataSet = dataSet;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.permissions = permissions;
        this.state = state;
    }

    @JsonProperty("createdByUsername")
    public Optional<String> getCreatedByUsername() {
        return Optional.ofNullable(createdByUsername);
    }

    @JsonProperty("createdByUsername")
    public void setCreatedByUsername(String createdByUsername) {
        this.createdByUsername = createdByUsername;
    }

    public DataApprovalStateResponse withCreatedByUsername(String createdByUsername) {
        this.createdByUsername = createdByUsername;
        return this;
    }

    @JsonProperty("createdDate")
    public Optional<Date> getCreatedDate() {
        return Optional.ofNullable(createdDate);
    }

    @JsonProperty("createdDate")
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public DataApprovalStateResponse withCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @JsonProperty("dataSet")
    public Optional<DataSet> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    @JsonProperty("dataSet")
    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DataApprovalStateResponse withDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnit> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public DataApprovalStateResponse withOrganisationUnit(OrganisationUnit organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<Period> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(Period period) {
        this.period = period;
    }

    public DataApprovalStateResponse withPeriod(Period period) {
        this.period = period;
        return this;
    }

    @JsonProperty("permissions")
    public Optional<DataApprovalPermissions> getPermissions() {
        return Optional.ofNullable(permissions);
    }

    @JsonProperty("permissions")
    public void setPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
    }

    public DataApprovalStateResponse withPermissions(DataApprovalPermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @JsonProperty("state")
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    @JsonProperty("state")
    public void setState(String state) {
        this.state = state;
    }

    public DataApprovalStateResponse withState(String state) {
        this.state = state;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataApprovalStateResponse withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("createdByUsername".equals(name)) {
            if (value instanceof String) {
                setCreatedByUsername(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"createdByUsername\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("createdDate".equals(name)) {
                if (value instanceof Date) {
                    setCreatedDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"createdDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataSet".equals(name)) {
                    if (value instanceof DataSet) {
                        setDataSet(((DataSet) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataSet\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("organisationUnit".equals(name)) {
                        if (value instanceof OrganisationUnit) {
                            setOrganisationUnit(((OrganisationUnit) value));
                        } else {
                            throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v2_38_1.OrganisationUnit\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("period".equals(name)) {
                            if (value instanceof Period) {
                                setPeriod(((Period) value));
                            } else {
                                throw new IllegalArgumentException(("property \"period\" is of type \"org.hisp.dhis.api.model.v2_38_1.Period\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("permissions".equals(name)) {
                                if (value instanceof DataApprovalPermissions) {
                                    setPermissions(((DataApprovalPermissions) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"permissions\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataApprovalPermissions\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("state".equals(name)) {
                                    if (value instanceof String) {
                                        setState(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"state\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("createdByUsername".equals(name)) {
            return getCreatedByUsername();
        } else {
            if ("createdDate".equals(name)) {
                return getCreatedDate();
            } else {
                if ("dataSet".equals(name)) {
                    return getDataSet();
                } else {
                    if ("organisationUnit".equals(name)) {
                        return getOrganisationUnit();
                    } else {
                        if ("period".equals(name)) {
                            return getPeriod();
                        } else {
                            if ("permissions".equals(name)) {
                                return getPermissions();
                            } else {
                                if ("state".equals(name)) {
                                    return getState();
                                } else {
                                    return notFoundValue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataApprovalStateResponse.NOT_FOUND_VALUE);
        if (DataApprovalStateResponse.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataApprovalStateResponse with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataApprovalStateResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("createdByUsername");
        sb.append('=');
        sb.append(((this.createdByUsername == null)?"<null>":this.createdByUsername));
        sb.append(',');
        sb.append("createdDate");
        sb.append('=');
        sb.append(((this.createdDate == null)?"<null>":this.createdDate));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("permissions");
        sb.append('=');
        sb.append(((this.permissions == null)?"<null>":this.permissions));
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(((this.state == null)?"<null>":this.state));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.createdByUsername == null)? 0 :this.createdByUsername.hashCode()));
        result = ((result* 31)+((this.createdDate == null)? 0 :this.createdDate.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.permissions == null)? 0 :this.permissions.hashCode()));
        result = ((result* 31)+((this.state == null)? 0 :this.state.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataApprovalStateResponse) == false) {
            return false;
        }
        DataApprovalStateResponse rhs = ((DataApprovalStateResponse) other);
        return (((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.createdByUsername == rhs.createdByUsername)||((this.createdByUsername!= null)&&this.createdByUsername.equals(rhs.createdByUsername))))&&((this.createdDate == rhs.createdDate)||((this.createdDate!= null)&&this.createdDate.equals(rhs.createdDate))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.permissions == rhs.permissions)||((this.permissions!= null)&&this.permissions.equals(rhs.permissions))))&&((this.state == rhs.state)||((this.state!= null)&&this.state.equals(rhs.state))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
