
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "description",
    "devMessage",
    "errorCode",
    "httpStatus",
    "httpStatusCode",
    "message",
    "response",
    "status"
})
@Generated("jsonschema2pojo")
public class DescriptiveWebMessage implements Serializable
{

    @JsonProperty("code")
    private Integer code;
    @JsonProperty("description")
    private String description;
    @JsonProperty("devMessage")
    private String devMessage;
    @JsonProperty("errorCode")
    private org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode errorCode;
    @JsonProperty("httpStatus")
    private String httpStatus;
    @JsonProperty("httpStatusCode")
    private Integer httpStatusCode;
    @JsonProperty("message")
    private String message;
    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    private Object response;
    @JsonProperty("status")
    private DescriptiveWebMessage.Status status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1538848118881368341L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DescriptiveWebMessage() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DescriptiveWebMessage(DescriptiveWebMessage source) {
        super();
        this.code = source.code;
        this.description = source.description;
        this.devMessage = source.devMessage;
        this.errorCode = source.errorCode;
        this.httpStatus = source.httpStatus;
        this.httpStatusCode = source.httpStatusCode;
        this.message = source.message;
        this.response = source.response;
        this.status = source.status;
    }

    public DescriptiveWebMessage(Integer code, String description, String devMessage, org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode errorCode, String httpStatus, Integer httpStatusCode, String message, Object response, DescriptiveWebMessage.Status status) {
        super();
        this.code = code;
        this.description = description;
        this.devMessage = devMessage;
        this.errorCode = errorCode;
        this.httpStatus = httpStatus;
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.response = response;
        this.status = status;
    }

    @JsonProperty("code")
    public Optional<Integer> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(Integer code) {
        this.code = code;
    }

    public DescriptiveWebMessage withCode(Integer code) {
        this.code = code;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DescriptiveWebMessage withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("devMessage")
    public Optional<String> getDevMessage() {
        return Optional.ofNullable(devMessage);
    }

    @JsonProperty("devMessage")
    public void setDevMessage(String devMessage) {
        this.devMessage = devMessage;
    }

    public DescriptiveWebMessage withDevMessage(String devMessage) {
        this.devMessage = devMessage;
        return this;
    }

    @JsonProperty("errorCode")
    public Optional<org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    @JsonProperty("errorCode")
    public void setErrorCode(org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public DescriptiveWebMessage withErrorCode(org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty("httpStatus")
    public Optional<String> getHttpStatus() {
        return Optional.ofNullable(httpStatus);
    }

    @JsonProperty("httpStatus")
    public void setHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
    }

    public DescriptiveWebMessage withHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    @JsonProperty("httpStatusCode")
    public Optional<Integer> getHttpStatusCode() {
        return Optional.ofNullable(httpStatusCode);
    }

    @JsonProperty("httpStatusCode")
    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public DescriptiveWebMessage withHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public DescriptiveWebMessage withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    public Optional<Object> getResponse() {
        return Optional.ofNullable(response);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("response")
    public void setResponse(Object response) {
        this.response = response;
    }

    public DescriptiveWebMessage withResponse(Object response) {
        this.response = response;
        return this;
    }

    @JsonProperty("status")
    public Optional<DescriptiveWebMessage.Status> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(DescriptiveWebMessage.Status status) {
        this.status = status;
    }

    public DescriptiveWebMessage withStatus(DescriptiveWebMessage.Status status) {
        this.status = status;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DescriptiveWebMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("code".equals(name)) {
            if (value instanceof Integer) {
                setCode(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("description".equals(name)) {
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("devMessage".equals(name)) {
                    if (value instanceof String) {
                        setDevMessage(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"devMessage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("errorCode".equals(name)) {
                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode) {
                            setErrorCode(((org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode) value));
                        } else {
                            throw new IllegalArgumentException(("property \"errorCode\" is of type \"org.hisp.dhis.api.model.v2_38_1.ErrorReport.ErrorCode\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("httpStatus".equals(name)) {
                            if (value instanceof String) {
                                setHttpStatus(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"httpStatus\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("httpStatusCode".equals(name)) {
                                if (value instanceof Integer) {
                                    setHttpStatusCode(((Integer) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"httpStatusCode\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("message".equals(name)) {
                                    if (value instanceof String) {
                                        setMessage(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("response".equals(name)) {
                                        if (value instanceof Object) {
                                            setResponse(((Object) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"response\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("status".equals(name)) {
                                            if (value instanceof DescriptiveWebMessage.Status) {
                                                setStatus(((DescriptiveWebMessage.Status) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_38_1.DescriptiveWebMessage.Status\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("code".equals(name)) {
            return getCode();
        } else {
            if ("description".equals(name)) {
                return getDescription();
            } else {
                if ("devMessage".equals(name)) {
                    return getDevMessage();
                } else {
                    if ("errorCode".equals(name)) {
                        return getErrorCode();
                    } else {
                        if ("httpStatus".equals(name)) {
                            return getHttpStatus();
                        } else {
                            if ("httpStatusCode".equals(name)) {
                                return getHttpStatusCode();
                            } else {
                                if ("message".equals(name)) {
                                    return getMessage();
                                } else {
                                    if ("response".equals(name)) {
                                        return getResponse();
                                    } else {
                                        if ("status".equals(name)) {
                                            return getStatus();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DescriptiveWebMessage.NOT_FOUND_VALUE);
        if (DescriptiveWebMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DescriptiveWebMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DescriptiveWebMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("devMessage");
        sb.append('=');
        sb.append(((this.devMessage == null)?"<null>":this.devMessage));
        sb.append(',');
        sb.append("errorCode");
        sb.append('=');
        sb.append(((this.errorCode == null)?"<null>":this.errorCode));
        sb.append(',');
        sb.append("httpStatus");
        sb.append('=');
        sb.append(((this.httpStatus == null)?"<null>":this.httpStatus));
        sb.append(',');
        sb.append("httpStatusCode");
        sb.append('=');
        sb.append(((this.httpStatusCode == null)?"<null>":this.httpStatusCode));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("response");
        sb.append('=');
        sb.append(((this.response == null)?"<null>":this.response));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.response == null)? 0 :this.response.hashCode()));
        result = ((result* 31)+((this.httpStatus == null)? 0 :this.httpStatus.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.errorCode == null)? 0 :this.errorCode.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.devMessage == null)? 0 :this.devMessage.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.httpStatusCode == null)? 0 :this.httpStatusCode.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DescriptiveWebMessage) == false) {
            return false;
        }
        DescriptiveWebMessage rhs = ((DescriptiveWebMessage) other);
        return (((((((((((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code)))&&((this.response == rhs.response)||((this.response!= null)&&this.response.equals(rhs.response))))&&((this.httpStatus == rhs.httpStatus)||((this.httpStatus!= null)&&this.httpStatus.equals(rhs.httpStatus))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.errorCode == rhs.errorCode)||((this.errorCode!= null)&&this.errorCode.equals(rhs.errorCode))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.devMessage == rhs.devMessage)||((this.devMessage!= null)&&this.devMessage.equals(rhs.devMessage))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.httpStatusCode == rhs.httpStatusCode)||((this.httpStatusCode!= null)&&this.httpStatusCode.equals(rhs.httpStatusCode))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum Status {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, DescriptiveWebMessage.Status> CONSTANTS = new HashMap<String, DescriptiveWebMessage.Status>();

        static {
            for (DescriptiveWebMessage.Status c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Status(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DescriptiveWebMessage.Status fromValue(String value) {
            DescriptiveWebMessage.Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
