
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attributes",
    "completedBy",
    "completedDate",
    "created",
    "createdAtClient",
    "createdByUserInfo",
    "deleted",
    "enrollment",
    "enrollmentDate",
    "events",
    "followup",
    "geometry",
    "incidentDate",
    "lastUpdated",
    "lastUpdatedAtClient",
    "lastUpdatedByUserInfo",
    "notes",
    "orgUnit",
    "orgUnitName",
    "program",
    "relationships",
    "status",
    "storedBy",
    "trackedEntityInstance",
    "trackedEntityType"
})
@Generated("jsonschema2pojo")
public class Enrollment implements Serializable
{

    @JsonProperty("attributes")
    private List<Attribute__1> attributes;
    @JsonProperty("completedBy")
    private String completedBy;
    @JsonProperty("completedDate")
    private Date completedDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    private String created;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    private String createdAtClient;
    @JsonProperty("createdByUserInfo")
    private UserInfoSnapshot createdByUserInfo;
    @JsonProperty("deleted")
    private Boolean deleted;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    private String enrollment;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentDate")
    private Date enrollmentDate;
    @JsonProperty("events")
    private List<Event> events;
    @JsonProperty("followup")
    private Boolean followup;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("incidentDate")
    private Date incidentDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    private String lastUpdated;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    private String lastUpdatedAtClient;
    @JsonProperty("lastUpdatedByUserInfo")
    private UserInfoSnapshot lastUpdatedByUserInfo;
    @JsonProperty("notes")
    private List<Note> notes;
    @JsonProperty("orgUnit")
    private String orgUnit;
    @JsonProperty("orgUnitName")
    private String orgUnitName;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    private String program;
    @JsonProperty("relationships")
    private List<Relationship> relationships;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private Event.EnrollmentStatus status;
    @JsonProperty("storedBy")
    private String storedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    private String trackedEntityInstance;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    private String trackedEntityType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7179038153846982885L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Enrollment() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Enrollment(Enrollment source) {
        super();
        this.attributes = source.attributes;
        this.completedBy = source.completedBy;
        this.completedDate = source.completedDate;
        this.created = source.created;
        this.createdAtClient = source.createdAtClient;
        this.createdByUserInfo = source.createdByUserInfo;
        this.deleted = source.deleted;
        this.enrollment = source.enrollment;
        this.enrollmentDate = source.enrollmentDate;
        this.events = source.events;
        this.followup = source.followup;
        this.geometry = source.geometry;
        this.incidentDate = source.incidentDate;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedAtClient = source.lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = source.lastUpdatedByUserInfo;
        this.notes = source.notes;
        this.orgUnit = source.orgUnit;
        this.orgUnitName = source.orgUnitName;
        this.program = source.program;
        this.relationships = source.relationships;
        this.status = source.status;
        this.storedBy = source.storedBy;
        this.trackedEntityInstance = source.trackedEntityInstance;
        this.trackedEntityType = source.trackedEntityType;
    }

    public Enrollment(List<Attribute__1> attributes, String completedBy, Date completedDate, String created, String createdAtClient, UserInfoSnapshot createdByUserInfo, Boolean deleted, String enrollment, Date enrollmentDate, List<Event> events, Boolean followup, Object geometry, Date incidentDate, String lastUpdated, String lastUpdatedAtClient, UserInfoSnapshot lastUpdatedByUserInfo, List<Note> notes, String orgUnit, String orgUnitName, String program, List<Relationship> relationships, Event.EnrollmentStatus status, String storedBy, String trackedEntityInstance, String trackedEntityType) {
        super();
        this.attributes = attributes;
        this.completedBy = completedBy;
        this.completedDate = completedDate;
        this.created = created;
        this.createdAtClient = createdAtClient;
        this.createdByUserInfo = createdByUserInfo;
        this.deleted = deleted;
        this.enrollment = enrollment;
        this.enrollmentDate = enrollmentDate;
        this.events = events;
        this.followup = followup;
        this.geometry = geometry;
        this.incidentDate = incidentDate;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        this.notes = notes;
        this.orgUnit = orgUnit;
        this.orgUnitName = orgUnitName;
        this.program = program;
        this.relationships = relationships;
        this.status = status;
        this.storedBy = storedBy;
        this.trackedEntityInstance = trackedEntityInstance;
        this.trackedEntityType = trackedEntityType;
    }

    @JsonProperty("attributes")
    public Optional<List<Attribute__1>> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    @JsonProperty("attributes")
    public void setAttributes(List<Attribute__1> attributes) {
        this.attributes = attributes;
    }

    public Enrollment withAttributes(List<Attribute__1> attributes) {
        this.attributes = attributes;
        return this;
    }

    @JsonProperty("completedBy")
    public Optional<String> getCompletedBy() {
        return Optional.ofNullable(completedBy);
    }

    @JsonProperty("completedBy")
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public Enrollment withCompletedBy(String completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @JsonProperty("completedDate")
    public Optional<Date> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    @JsonProperty("completedDate")
    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public Enrollment withCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    public String getCreated() {
        return created;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("created")
    public void setCreated(String created) {
        this.created = created;
    }

    public Enrollment withCreated(String created) {
        this.created = created;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public String getCreatedAtClient() {
        return createdAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("createdAtClient")
    public void setCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    public Enrollment withCreatedAtClient(String createdAtClient) {
        this.createdAtClient = createdAtClient;
        return this;
    }

    @JsonProperty("createdByUserInfo")
    public Optional<UserInfoSnapshot> getCreatedByUserInfo() {
        return Optional.ofNullable(createdByUserInfo);
    }

    @JsonProperty("createdByUserInfo")
    public void setCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
    }

    public Enrollment withCreatedByUserInfo(UserInfoSnapshot createdByUserInfo) {
        this.createdByUserInfo = createdByUserInfo;
        return this;
    }

    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    @JsonProperty("deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Enrollment withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    public String getEnrollment() {
        return enrollment;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollment")
    public void setEnrollment(String enrollment) {
        this.enrollment = enrollment;
    }

    public Enrollment withEnrollment(String enrollment) {
        this.enrollment = enrollment;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentDate")
    public Date getEnrollmentDate() {
        return enrollmentDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentDate")
    public void setEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
    }

    public Enrollment withEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
        return this;
    }

    @JsonProperty("events")
    public Optional<List<Event>> getEvents() {
        return Optional.ofNullable(events);
    }

    @JsonProperty("events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public Enrollment withEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    @JsonProperty("followup")
    public Optional<Boolean> getFollowup() {
        return Optional.ofNullable(followup);
    }

    @JsonProperty("followup")
    public void setFollowup(Boolean followup) {
        this.followup = followup;
    }

    public Enrollment withFollowup(Boolean followup) {
        this.followup = followup;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public Enrollment withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("incidentDate")
    public Date getIncidentDate() {
        return incidentDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("incidentDate")
    public void setIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
    }

    public Enrollment withIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdated")
    public void setLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Enrollment withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public String getLastUpdatedAtClient() {
        return lastUpdatedAtClient;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("lastUpdatedAtClient")
    public void setLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
    }

    public Enrollment withLastUpdatedAtClient(String lastUpdatedAtClient) {
        this.lastUpdatedAtClient = lastUpdatedAtClient;
        return this;
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public Optional<UserInfoSnapshot> getLastUpdatedByUserInfo() {
        return Optional.ofNullable(lastUpdatedByUserInfo);
    }

    @JsonProperty("lastUpdatedByUserInfo")
    public void setLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
    }

    public Enrollment withLastUpdatedByUserInfo(UserInfoSnapshot lastUpdatedByUserInfo) {
        this.lastUpdatedByUserInfo = lastUpdatedByUserInfo;
        return this;
    }

    @JsonProperty("notes")
    public Optional<List<Note>> getNotes() {
        return Optional.ofNullable(notes);
    }

    @JsonProperty("notes")
    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public Enrollment withNotes(List<Note> notes) {
        this.notes = notes;
        return this;
    }

    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public Enrollment withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("orgUnitName")
    public Optional<String> getOrgUnitName() {
        return Optional.ofNullable(orgUnitName);
    }

    @JsonProperty("orgUnitName")
    public void setOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
    }

    public Enrollment withOrgUnitName(String orgUnitName) {
        this.orgUnitName = orgUnitName;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    public String getProgram() {
        return program;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public Enrollment withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("relationships")
    public Optional<List<Relationship>> getRelationships() {
        return Optional.ofNullable(relationships);
    }

    @JsonProperty("relationships")
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public Enrollment withRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public Event.EnrollmentStatus getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(Event.EnrollmentStatus status) {
        this.status = status;
    }

    public Enrollment withStatus(Event.EnrollmentStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public Enrollment withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public String getTrackedEntityInstance() {
        return trackedEntityInstance;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public Enrollment withTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    public String getTrackedEntityType() {
        return trackedEntityType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public Enrollment withTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Enrollment withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attributes".equals(name)) {
            if (value instanceof List) {
                setAttributes(((List<Attribute__1> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Attribute__1>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("completedBy".equals(name)) {
                if (value instanceof String) {
                    setCompletedBy(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"completedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("completedDate".equals(name)) {
                    if (value instanceof Date) {
                        setCompletedDate(((Date) value));
                    } else {
                        throw new IllegalArgumentException(("property \"completedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof String) {
                            setCreated(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("createdAtClient".equals(name)) {
                            if (value instanceof String) {
                                setCreatedAtClient(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"createdAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdByUserInfo".equals(name)) {
                                if (value instanceof UserInfoSnapshot) {
                                    setCreatedByUserInfo(((UserInfoSnapshot) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_38_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("deleted".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setDeleted(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("enrollment".equals(name)) {
                                        if (value instanceof String) {
                                            setEnrollment(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"enrollment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("enrollmentDate".equals(name)) {
                                            if (value instanceof Date) {
                                                setEnrollmentDate(((Date) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"enrollmentDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("events".equals(name)) {
                                                if (value instanceof List) {
                                                    setEvents(((List<Event> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"events\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Event>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("followup".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setFollowup(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"followup\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("geometry".equals(name)) {
                                                        if (value instanceof Object) {
                                                            setGeometry(((Object) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("incidentDate".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setIncidentDate(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"incidentDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("lastUpdated".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setLastUpdated(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("lastUpdatedAtClient".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setLastUpdatedAtClient(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"lastUpdatedAtClient\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("lastUpdatedByUserInfo".equals(name)) {
                                                                        if (value instanceof UserInfoSnapshot) {
                                                                            setLastUpdatedByUserInfo(((UserInfoSnapshot) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"lastUpdatedByUserInfo\" is of type \"org.hisp.dhis.api.model.v2_38_1.UserInfoSnapshot\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("notes".equals(name)) {
                                                                            if (value instanceof List) {
                                                                                setNotes(((List<Note> ) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"notes\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Note>\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("orgUnit".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setOrgUnit(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("orgUnitName".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setOrgUnitName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"orgUnitName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("program".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setProgram(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("relationships".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setRelationships(((List<Relationship> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"relationships\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Relationship>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("status".equals(name)) {
                                                                                                if (value instanceof Event.EnrollmentStatus) {
                                                                                                    setStatus(((Event.EnrollmentStatus) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_38_1.Event.EnrollmentStatus\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("storedBy".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setStoredBy(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("trackedEntityInstance".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setTrackedEntityInstance(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("trackedEntityType".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setTrackedEntityType(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            return false;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attributes".equals(name)) {
            return getAttributes();
        } else {
            if ("completedBy".equals(name)) {
                return getCompletedBy();
            } else {
                if ("completedDate".equals(name)) {
                    return getCompletedDate();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("createdAtClient".equals(name)) {
                            return getCreatedAtClient();
                        } else {
                            if ("createdByUserInfo".equals(name)) {
                                return getCreatedByUserInfo();
                            } else {
                                if ("deleted".equals(name)) {
                                    return getDeleted();
                                } else {
                                    if ("enrollment".equals(name)) {
                                        return getEnrollment();
                                    } else {
                                        if ("enrollmentDate".equals(name)) {
                                            return getEnrollmentDate();
                                        } else {
                                            if ("events".equals(name)) {
                                                return getEvents();
                                            } else {
                                                if ("followup".equals(name)) {
                                                    return getFollowup();
                                                } else {
                                                    if ("geometry".equals(name)) {
                                                        return getGeometry();
                                                    } else {
                                                        if ("incidentDate".equals(name)) {
                                                            return getIncidentDate();
                                                        } else {
                                                            if ("lastUpdated".equals(name)) {
                                                                return getLastUpdated();
                                                            } else {
                                                                if ("lastUpdatedAtClient".equals(name)) {
                                                                    return getLastUpdatedAtClient();
                                                                } else {
                                                                    if ("lastUpdatedByUserInfo".equals(name)) {
                                                                        return getLastUpdatedByUserInfo();
                                                                    } else {
                                                                        if ("notes".equals(name)) {
                                                                            return getNotes();
                                                                        } else {
                                                                            if ("orgUnit".equals(name)) {
                                                                                return getOrgUnit();
                                                                            } else {
                                                                                if ("orgUnitName".equals(name)) {
                                                                                    return getOrgUnitName();
                                                                                } else {
                                                                                    if ("program".equals(name)) {
                                                                                        return getProgram();
                                                                                    } else {
                                                                                        if ("relationships".equals(name)) {
                                                                                            return getRelationships();
                                                                                        } else {
                                                                                            if ("status".equals(name)) {
                                                                                                return getStatus();
                                                                                            } else {
                                                                                                if ("storedBy".equals(name)) {
                                                                                                    return getStoredBy();
                                                                                                } else {
                                                                                                    if ("trackedEntityInstance".equals(name)) {
                                                                                                        return getTrackedEntityInstance();
                                                                                                    } else {
                                                                                                        if ("trackedEntityType".equals(name)) {
                                                                                                            return getTrackedEntityType();
                                                                                                        } else {
                                                                                                            return notFoundValue;
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Enrollment.NOT_FOUND_VALUE);
        if (Enrollment.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Enrollment with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Enrollment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attributes");
        sb.append('=');
        sb.append(((this.attributes == null)?"<null>":this.attributes));
        sb.append(',');
        sb.append("completedBy");
        sb.append('=');
        sb.append(((this.completedBy == null)?"<null>":this.completedBy));
        sb.append(',');
        sb.append("completedDate");
        sb.append('=');
        sb.append(((this.completedDate == null)?"<null>":this.completedDate));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdAtClient");
        sb.append('=');
        sb.append(((this.createdAtClient == null)?"<null>":this.createdAtClient));
        sb.append(',');
        sb.append("createdByUserInfo");
        sb.append('=');
        sb.append(((this.createdByUserInfo == null)?"<null>":this.createdByUserInfo));
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("enrollment");
        sb.append('=');
        sb.append(((this.enrollment == null)?"<null>":this.enrollment));
        sb.append(',');
        sb.append("enrollmentDate");
        sb.append('=');
        sb.append(((this.enrollmentDate == null)?"<null>":this.enrollmentDate));
        sb.append(',');
        sb.append("events");
        sb.append('=');
        sb.append(((this.events == null)?"<null>":this.events));
        sb.append(',');
        sb.append("followup");
        sb.append('=');
        sb.append(((this.followup == null)?"<null>":this.followup));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("incidentDate");
        sb.append('=');
        sb.append(((this.incidentDate == null)?"<null>":this.incidentDate));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedAtClient");
        sb.append('=');
        sb.append(((this.lastUpdatedAtClient == null)?"<null>":this.lastUpdatedAtClient));
        sb.append(',');
        sb.append("lastUpdatedByUserInfo");
        sb.append('=');
        sb.append(((this.lastUpdatedByUserInfo == null)?"<null>":this.lastUpdatedByUserInfo));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(((this.notes == null)?"<null>":this.notes));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("orgUnitName");
        sb.append('=');
        sb.append(((this.orgUnitName == null)?"<null>":this.orgUnitName));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("relationships");
        sb.append('=');
        sb.append(((this.relationships == null)?"<null>":this.relationships));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.notes == null)? 0 :this.notes.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.enrollmentDate == null)? 0 :this.enrollmentDate.hashCode()));
        result = ((result* 31)+((this.createdAtClient == null)? 0 :this.createdAtClient.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.lastUpdatedByUserInfo == null)? 0 :this.lastUpdatedByUserInfo.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.relationships == null)? 0 :this.relationships.hashCode()));
        result = ((result* 31)+((this.createdByUserInfo == null)? 0 :this.createdByUserInfo.hashCode()));
        result = ((result* 31)+((this.events == null)? 0 :this.events.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.completedDate == null)? 0 :this.completedDate.hashCode()));
        result = ((result* 31)+((this.enrollment == null)? 0 :this.enrollment.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        result = ((result* 31)+((this.followup == null)? 0 :this.followup.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.attributes == null)? 0 :this.attributes.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.incidentDate == null)? 0 :this.incidentDate.hashCode()));
        result = ((result* 31)+((this.completedBy == null)? 0 :this.completedBy.hashCode()));
        result = ((result* 31)+((this.lastUpdatedAtClient == null)? 0 :this.lastUpdatedAtClient.hashCode()));
        result = ((result* 31)+((this.orgUnitName == null)? 0 :this.orgUnitName.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Enrollment) == false) {
            return false;
        }
        Enrollment rhs = ((Enrollment) other);
        return (((((((((((((((((((((((((((this.notes == rhs.notes)||((this.notes!= null)&&this.notes.equals(rhs.notes)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.enrollmentDate == rhs.enrollmentDate)||((this.enrollmentDate!= null)&&this.enrollmentDate.equals(rhs.enrollmentDate))))&&((this.createdAtClient == rhs.createdAtClient)||((this.createdAtClient!= null)&&this.createdAtClient.equals(rhs.createdAtClient))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.lastUpdatedByUserInfo == rhs.lastUpdatedByUserInfo)||((this.lastUpdatedByUserInfo!= null)&&this.lastUpdatedByUserInfo.equals(rhs.lastUpdatedByUserInfo))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.relationships == rhs.relationships)||((this.relationships!= null)&&this.relationships.equals(rhs.relationships))))&&((this.createdByUserInfo == rhs.createdByUserInfo)||((this.createdByUserInfo!= null)&&this.createdByUserInfo.equals(rhs.createdByUserInfo))))&&((this.events == rhs.events)||((this.events!= null)&&this.events.equals(rhs.events))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.completedDate == rhs.completedDate)||((this.completedDate!= null)&&this.completedDate.equals(rhs.completedDate))))&&((this.enrollment == rhs.enrollment)||((this.enrollment!= null)&&this.enrollment.equals(rhs.enrollment))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))))&&((this.followup == rhs.followup)||((this.followup!= null)&&this.followup.equals(rhs.followup))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.attributes == rhs.attributes)||((this.attributes!= null)&&this.attributes.equals(rhs.attributes))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.incidentDate == rhs.incidentDate)||((this.incidentDate!= null)&&this.incidentDate.equals(rhs.incidentDate))))&&((this.completedBy == rhs.completedBy)||((this.completedBy!= null)&&this.completedBy.equals(rhs.completedBy))))&&((this.lastUpdatedAtClient == rhs.lastUpdatedAtClient)||((this.lastUpdatedAtClient!= null)&&this.lastUpdatedAtClient.equals(rhs.lastUpdatedAtClient))))&&((this.orgUnitName == rhs.orgUnitName)||((this.orgUnitName!= null)&&this.orgUnitName.equals(rhs.orgUnitName))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

}
