
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dimension",
    "indexes",
    "parent"
})
@Generated("jsonschema2pojo")
public class EventRepetition implements Serializable
{

    @JsonProperty("dimension")
    private String dimension;
    @JsonProperty("indexes")
    private List<Integer> indexes;
    @JsonProperty("parent")
    private EventRepetition.Attribute parent;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 9210839448673546281L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventRepetition() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EventRepetition(EventRepetition source) {
        super();
        this.dimension = source.dimension;
        this.indexes = source.indexes;
        this.parent = source.parent;
    }

    public EventRepetition(String dimension, List<Integer> indexes, EventRepetition.Attribute parent) {
        super();
        this.dimension = dimension;
        this.indexes = indexes;
        this.parent = parent;
    }

    @JsonProperty("dimension")
    public Optional<String> getDimension() {
        return Optional.ofNullable(dimension);
    }

    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public EventRepetition withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @JsonProperty("indexes")
    public Optional<List<Integer>> getIndexes() {
        return Optional.ofNullable(indexes);
    }

    @JsonProperty("indexes")
    public void setIndexes(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public EventRepetition withIndexes(List<Integer> indexes) {
        this.indexes = indexes;
        return this;
    }

    @JsonProperty("parent")
    public Optional<EventRepetition.Attribute> getParent() {
        return Optional.ofNullable(parent);
    }

    @JsonProperty("parent")
    public void setParent(EventRepetition.Attribute parent) {
        this.parent = parent;
    }

    public EventRepetition withParent(EventRepetition.Attribute parent) {
        this.parent = parent;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventRepetition withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dimension".equals(name)) {
            if (value instanceof String) {
                setDimension(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("indexes".equals(name)) {
                if (value instanceof List) {
                    setIndexes(((List<Integer> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indexes\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("parent".equals(name)) {
                    if (value instanceof EventRepetition.Attribute) {
                        setParent(((EventRepetition.Attribute) value));
                    } else {
                        throw new IllegalArgumentException(("property \"parent\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventRepetition.Attribute\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dimension".equals(name)) {
            return getDimension();
        } else {
            if ("indexes".equals(name)) {
                return getIndexes();
            } else {
                if ("parent".equals(name)) {
                    return getParent();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventRepetition.NOT_FOUND_VALUE);
        if (EventRepetition.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventRepetition with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventRepetition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("indexes");
        sb.append('=');
        sb.append(((this.indexes == null)?"<null>":this.indexes));
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(((this.parent == null)?"<null>":this.parent));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parent == null)? 0 :this.parent.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.indexes == null)? 0 :this.indexes.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventRepetition) == false) {
            return false;
        }
        EventRepetition rhs = ((EventRepetition) other);
        return (((((this.parent == rhs.parent)||((this.parent!= null)&&this.parent.equals(rhs.parent)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.indexes == rhs.indexes)||((this.indexes!= null)&&this.indexes.equals(rhs.indexes))))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))));
    }

    @Generated("jsonschema2pojo")
    public enum Attribute {

        COLUMN("COLUMN"),
        ROW("ROW"),
        FILTER("FILTER");
        private final String value;
        private final static Map<String, EventRepetition.Attribute> CONSTANTS = new HashMap<String, EventRepetition.Attribute>();

        static {
            for (EventRepetition.Attribute c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Attribute(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EventRepetition.Attribute fromValue(String value) {
            EventRepetition.Attribute constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
