
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "attributeDimensions",
    "attributeValueDimension",
    "attributeValues",
    "baseLineLabel",
    "baseLineValue",
    "categoryDimensions",
    "categoryOptionGroupSetDimensions",
    "code",
    "colSubTotals",
    "colTotals",
    "collapseDataDimensions",
    "columnDimensions",
    "columns",
    "completedOnly",
    "created",
    "createdBy",
    "cumulativeValues",
    "dataDimensionItems",
    "dataElementDimensions",
    "dataElementGroupSetDimensions",
    "dataElementValueDimension",
    "dataType",
    "description",
    "digitGroupSeparator",
    "displayBaseLineLabel",
    "displayDensity",
    "displayDescription",
    "displayDomainAxisLabel",
    "displayFormName",
    "displayName",
    "displayRangeAxisLabel",
    "displayShortName",
    "displaySubtitle",
    "displayTargetLineLabel",
    "displayTitle",
    "domainAxisLabel",
    "endDate",
    "eventStatus",
    "externalAccess",
    "favorite",
    "favorites",
    "filterDimensions",
    "filters",
    "fontSize",
    "formName",
    "hideEmptyRowItems",
    "hideEmptyRows",
    "hideLegend",
    "hideNaData",
    "hideSubtitle",
    "hideTitle",
    "href",
    "id",
    "interpretations",
    "itemOrganisationUnitGroups",
    "lastUpdated",
    "lastUpdatedBy",
    "legacy",
    "legendDisplayStrategy",
    "legendSet",
    "name",
    "noSpaceBetweenColumns",
    "orgUnitField",
    "organisationUnitGroupSetDimensions",
    "organisationUnitLevels",
    "organisationUnits",
    "outputType",
    "parentGraphMap",
    "percentStackedValues",
    "periods",
    "program",
    "programIndicatorDimensions",
    "programStage",
    "programStatus",
    "publicAccess",
    "rangeAxisDecimals",
    "rangeAxisLabel",
    "rangeAxisMaxValue",
    "rangeAxisMinValue",
    "rangeAxisSteps",
    "regressionType",
    "relativePeriods",
    "repetitions",
    "rowDimensions",
    "rowSubTotals",
    "rowTotals",
    "rows",
    "sharing",
    "shortName",
    "showData",
    "showDimensionLabels",
    "showHierarchy",
    "simpleDimensions",
    "sortOrder",
    "startDate",
    "subscribed",
    "subscribers",
    "subtitle",
    "targetLineLabel",
    "targetLineValue",
    "timeField",
    "title",
    "topLimit",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "userOrgUnitType",
    "userOrganisationUnit",
    "userOrganisationUnitChildren",
    "userOrganisationUnitGrandChildren",
    "value"
})
@Generated("jsonschema2pojo")
public class EventVisualization implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("attributeDimensions")
    private List<TrackedEntityAttributeDimension> attributeDimensions;
    @JsonProperty("attributeValueDimension")
    private TrackedEntityAttribute attributeValueDimension;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("baseLineLabel")
    private String baseLineLabel;
    @JsonProperty("baseLineValue")
    private Double baseLineValue;
    @JsonProperty("categoryDimensions")
    private List<CategoryDimension> categoryDimensions;
    @JsonProperty("categoryOptionGroupSetDimensions")
    private List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions;
    @JsonProperty("code")
    private String code;
    @JsonProperty("colSubTotals")
    private Boolean colSubTotals;
    @JsonProperty("colTotals")
    private Boolean colTotals;
    @JsonProperty("collapseDataDimensions")
    private Boolean collapseDataDimensions;
    @JsonProperty("columnDimensions")
    private List<String> columnDimensions;
    @JsonProperty("columns")
    private List<Object> columns;
    @JsonProperty("completedOnly")
    private Boolean completedOnly;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("createdBy")
    private User createdBy;
    @JsonProperty("cumulativeValues")
    private Boolean cumulativeValues;
    @JsonProperty("dataDimensionItems")
    private List<DataDimensionItem> dataDimensionItems;
    @JsonProperty("dataElementDimensions")
    private List<TrackedEntityDataElementDimension> dataElementDimensions;
    @JsonProperty("dataElementGroupSetDimensions")
    private List<DataElementGroupSetDimension> dataElementGroupSetDimensions;
    @JsonProperty("dataElementValueDimension")
    private DataElement dataElementValueDimension;
    @JsonProperty("dataType")
    private org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType dataType;
    @JsonProperty("description")
    private String description;
    @JsonProperty("digitGroupSeparator")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator digitGroupSeparator;
    @JsonProperty("displayBaseLineLabel")
    private String displayBaseLineLabel;
    @JsonProperty("displayDensity")
    private org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity displayDensity;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayDomainAxisLabel")
    private String displayDomainAxisLabel;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayRangeAxisLabel")
    private String displayRangeAxisLabel;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("displaySubtitle")
    private String displaySubtitle;
    @JsonProperty("displayTargetLineLabel")
    private String displayTargetLineLabel;
    @JsonProperty("displayTitle")
    private String displayTitle;
    @JsonProperty("domainAxisLabel")
    private String domainAxisLabel;
    @JsonProperty("endDate")
    private Date endDate;
    @JsonProperty("eventStatus")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("filterDimensions")
    private List<String> filterDimensions;
    @JsonProperty("filters")
    private List<Object> filters;
    @JsonProperty("fontSize")
    private org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize fontSize;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("hideEmptyRowItems")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy hideEmptyRowItems;
    @JsonProperty("hideEmptyRows")
    private Boolean hideEmptyRows;
    @JsonProperty("hideLegend")
    private Boolean hideLegend;
    @JsonProperty("hideNaData")
    private Boolean hideNaData;
    @JsonProperty("hideSubtitle")
    private Boolean hideSubtitle;
    @JsonProperty("hideTitle")
    private Boolean hideTitle;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("interpretations")
    private List<Interpretation> interpretations;
    @JsonProperty("itemOrganisationUnitGroups")
    private List<OrganisationUnitGroup> itemOrganisationUnitGroups;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legacy")
    private Boolean legacy;
    @JsonProperty("legendDisplayStrategy")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy legendDisplayStrategy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("noSpaceBetweenColumns")
    private Boolean noSpaceBetweenColumns;
    @JsonProperty("orgUnitField")
    private String orgUnitField;
    @JsonProperty("organisationUnitGroupSetDimensions")
    private List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions;
    @JsonProperty("organisationUnitLevels")
    private List<Integer> organisationUnitLevels;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnit> organisationUnits;
    @JsonProperty("outputType")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType outputType;
    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    private ParentGraphMap__2 parentGraphMap;
    @JsonProperty("percentStackedValues")
    private Boolean percentStackedValues;
    @JsonProperty("periods")
    private List<Period> periods;
    @JsonProperty("program")
    private Program program;
    @JsonProperty("programIndicatorDimensions")
    private List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions;
    @JsonProperty("programStage")
    private ProgramStage programStage;
    @JsonProperty("programStatus")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus programStatus;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("rangeAxisDecimals")
    private Integer rangeAxisDecimals;
    @JsonProperty("rangeAxisLabel")
    private String rangeAxisLabel;
    @JsonProperty("rangeAxisMaxValue")
    private Double rangeAxisMaxValue;
    @JsonProperty("rangeAxisMinValue")
    private Double rangeAxisMinValue;
    @JsonProperty("rangeAxisSteps")
    private Integer rangeAxisSteps;
    @JsonProperty("regressionType")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType regressionType;
    @JsonProperty("relativePeriods")
    private RelativePeriods relativePeriods;
    @JsonProperty("repetitions")
    private List<EventRepetition> repetitions;
    @JsonProperty("rowDimensions")
    private List<String> rowDimensions;
    @JsonProperty("rowSubTotals")
    private Boolean rowSubTotals;
    @JsonProperty("rowTotals")
    private Boolean rowTotals;
    @JsonProperty("rows")
    private List<Object> rows;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("showData")
    private Boolean showData;
    @JsonProperty("showDimensionLabels")
    private Boolean showDimensionLabels;
    @JsonProperty("showHierarchy")
    private Boolean showHierarchy;
    @JsonProperty("simpleDimensions")
    private List<SimpleDimension> simpleDimensions;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("startDate")
    private Date startDate;
    @JsonProperty("subscribed")
    private Boolean subscribed;
    @JsonProperty("subscribers")
    private List<String> subscribers;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("targetLineLabel")
    private String targetLineLabel;
    @JsonProperty("targetLineValue")
    private Double targetLineValue;
    @JsonProperty("timeField")
    private String timeField;
    @JsonProperty("title")
    private String title;
    @JsonProperty("topLimit")
    private Integer topLimit;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonProperty("type")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType type;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses;
    @JsonProperty("userOrgUnitType")
    private org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType userOrgUnitType;
    @JsonProperty("userOrganisationUnit")
    private Boolean userOrganisationUnit;
    @JsonProperty("userOrganisationUnitChildren")
    private Boolean userOrganisationUnitChildren;
    @JsonProperty("userOrganisationUnitGrandChildren")
    private Boolean userOrganisationUnitGrandChildren;
    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    private Object value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6122455125790389646L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventVisualization() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EventVisualization(EventVisualization source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.attributeDimensions = source.attributeDimensions;
        this.attributeValueDimension = source.attributeValueDimension;
        this.attributeValues = source.attributeValues;
        this.baseLineLabel = source.baseLineLabel;
        this.baseLineValue = source.baseLineValue;
        this.categoryDimensions = source.categoryDimensions;
        this.categoryOptionGroupSetDimensions = source.categoryOptionGroupSetDimensions;
        this.code = source.code;
        this.colSubTotals = source.colSubTotals;
        this.colTotals = source.colTotals;
        this.collapseDataDimensions = source.collapseDataDimensions;
        this.columnDimensions = source.columnDimensions;
        this.columns = source.columns;
        this.completedOnly = source.completedOnly;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.cumulativeValues = source.cumulativeValues;
        this.dataDimensionItems = source.dataDimensionItems;
        this.dataElementDimensions = source.dataElementDimensions;
        this.dataElementGroupSetDimensions = source.dataElementGroupSetDimensions;
        this.dataElementValueDimension = source.dataElementValueDimension;
        this.dataType = source.dataType;
        this.description = source.description;
        this.digitGroupSeparator = source.digitGroupSeparator;
        this.displayBaseLineLabel = source.displayBaseLineLabel;
        this.displayDensity = source.displayDensity;
        this.displayDescription = source.displayDescription;
        this.displayDomainAxisLabel = source.displayDomainAxisLabel;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayRangeAxisLabel = source.displayRangeAxisLabel;
        this.displayShortName = source.displayShortName;
        this.displaySubtitle = source.displaySubtitle;
        this.displayTargetLineLabel = source.displayTargetLineLabel;
        this.displayTitle = source.displayTitle;
        this.domainAxisLabel = source.domainAxisLabel;
        this.endDate = source.endDate;
        this.eventStatus = source.eventStatus;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filterDimensions = source.filterDimensions;
        this.filters = source.filters;
        this.fontSize = source.fontSize;
        this.formName = source.formName;
        this.hideEmptyRowItems = source.hideEmptyRowItems;
        this.hideEmptyRows = source.hideEmptyRows;
        this.hideLegend = source.hideLegend;
        this.hideNaData = source.hideNaData;
        this.hideSubtitle = source.hideSubtitle;
        this.hideTitle = source.hideTitle;
        this.href = source.href;
        this.id = source.id;
        this.interpretations = source.interpretations;
        this.itemOrganisationUnitGroups = source.itemOrganisationUnitGroups;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legacy = source.legacy;
        this.legendDisplayStrategy = source.legendDisplayStrategy;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.noSpaceBetweenColumns = source.noSpaceBetweenColumns;
        this.orgUnitField = source.orgUnitField;
        this.organisationUnitGroupSetDimensions = source.organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = source.organisationUnitLevels;
        this.organisationUnits = source.organisationUnits;
        this.outputType = source.outputType;
        this.parentGraphMap = source.parentGraphMap;
        this.percentStackedValues = source.percentStackedValues;
        this.periods = source.periods;
        this.program = source.program;
        this.programIndicatorDimensions = source.programIndicatorDimensions;
        this.programStage = source.programStage;
        this.programStatus = source.programStatus;
        this.publicAccess = source.publicAccess;
        this.rangeAxisDecimals = source.rangeAxisDecimals;
        this.rangeAxisLabel = source.rangeAxisLabel;
        this.rangeAxisMaxValue = source.rangeAxisMaxValue;
        this.rangeAxisMinValue = source.rangeAxisMinValue;
        this.rangeAxisSteps = source.rangeAxisSteps;
        this.regressionType = source.regressionType;
        this.relativePeriods = source.relativePeriods;
        this.repetitions = source.repetitions;
        this.rowDimensions = source.rowDimensions;
        this.rowSubTotals = source.rowSubTotals;
        this.rowTotals = source.rowTotals;
        this.rows = source.rows;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.showData = source.showData;
        this.showDimensionLabels = source.showDimensionLabels;
        this.showHierarchy = source.showHierarchy;
        this.simpleDimensions = source.simpleDimensions;
        this.sortOrder = source.sortOrder;
        this.startDate = source.startDate;
        this.subscribed = source.subscribed;
        this.subscribers = source.subscribers;
        this.subtitle = source.subtitle;
        this.targetLineLabel = source.targetLineLabel;
        this.targetLineValue = source.targetLineValue;
        this.timeField = source.timeField;
        this.title = source.title;
        this.topLimit = source.topLimit;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userOrgUnitType = source.userOrgUnitType;
        this.userOrganisationUnit = source.userOrganisationUnit;
        this.userOrganisationUnitChildren = source.userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = source.userOrganisationUnitGrandChildren;
        this.value = source.value;
    }

    public EventVisualization(Access access, AggregationType aggregationType, List<TrackedEntityAttributeDimension> attributeDimensions, TrackedEntityAttribute attributeValueDimension, List<AttributeValue> attributeValues, String baseLineLabel, Double baseLineValue, List<CategoryDimension> categoryDimensions, List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions, String code, Boolean colSubTotals, Boolean colTotals, Boolean collapseDataDimensions, List<String> columnDimensions, List<Object> columns, Boolean completedOnly, Date created, User createdBy, Boolean cumulativeValues, List<DataDimensionItem> dataDimensionItems, List<TrackedEntityDataElementDimension> dataElementDimensions, List<DataElementGroupSetDimension> dataElementGroupSetDimensions, DataElement dataElementValueDimension, org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType dataType, String description, org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator digitGroupSeparator, String displayBaseLineLabel, org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity displayDensity, String displayDescription, String displayDomainAxisLabel, String displayFormName, String displayName, String displayRangeAxisLabel, String displayShortName, String displaySubtitle, String displayTargetLineLabel, String displayTitle, String domainAxisLabel, Date endDate, org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus, Boolean externalAccess, Boolean favorite, List<String> favorites, List<String> filterDimensions, List<Object> filters, org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize fontSize, String formName, org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy hideEmptyRowItems, Boolean hideEmptyRows, Boolean hideLegend, Boolean hideNaData, Boolean hideSubtitle, Boolean hideTitle, String href, String id, List<Interpretation> interpretations, List<OrganisationUnitGroup> itemOrganisationUnitGroups, Date lastUpdated, User lastUpdatedBy, Boolean legacy, org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy legendDisplayStrategy, LegendSet legendSet, String name, Boolean noSpaceBetweenColumns, String orgUnitField, List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions, List<Integer> organisationUnitLevels, List<OrganisationUnit> organisationUnits, org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType outputType, ParentGraphMap__2 parentGraphMap, Boolean percentStackedValues, List<Period> periods, Program program, List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions, ProgramStage programStage, org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus programStatus, String publicAccess, Integer rangeAxisDecimals, String rangeAxisLabel, Double rangeAxisMaxValue, Double rangeAxisMinValue, Integer rangeAxisSteps, org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType regressionType, RelativePeriods relativePeriods, List<EventRepetition> repetitions, List<String> rowDimensions, Boolean rowSubTotals, Boolean rowTotals, List<Object> rows, Sharing sharing, String shortName, Boolean showData, Boolean showDimensionLabels, Boolean showHierarchy, List<SimpleDimension> simpleDimensions, Integer sortOrder, Date startDate, Boolean subscribed, List<String> subscribers, String subtitle, String targetLineLabel, Double targetLineValue, String timeField, String title, Integer topLimit, List<Translation> translations, org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType type, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType userOrgUnitType, Boolean userOrganisationUnit, Boolean userOrganisationUnitChildren, Boolean userOrganisationUnitGrandChildren, Object value) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.attributeDimensions = attributeDimensions;
        this.attributeValueDimension = attributeValueDimension;
        this.attributeValues = attributeValues;
        this.baseLineLabel = baseLineLabel;
        this.baseLineValue = baseLineValue;
        this.categoryDimensions = categoryDimensions;
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        this.code = code;
        this.colSubTotals = colSubTotals;
        this.colTotals = colTotals;
        this.collapseDataDimensions = collapseDataDimensions;
        this.columnDimensions = columnDimensions;
        this.columns = columns;
        this.completedOnly = completedOnly;
        this.created = created;
        this.createdBy = createdBy;
        this.cumulativeValues = cumulativeValues;
        this.dataDimensionItems = dataDimensionItems;
        this.dataElementDimensions = dataElementDimensions;
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        this.dataElementValueDimension = dataElementValueDimension;
        this.dataType = dataType;
        this.description = description;
        this.digitGroupSeparator = digitGroupSeparator;
        this.displayBaseLineLabel = displayBaseLineLabel;
        this.displayDensity = displayDensity;
        this.displayDescription = displayDescription;
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        this.displayShortName = displayShortName;
        this.displaySubtitle = displaySubtitle;
        this.displayTargetLineLabel = displayTargetLineLabel;
        this.displayTitle = displayTitle;
        this.domainAxisLabel = domainAxisLabel;
        this.endDate = endDate;
        this.eventStatus = eventStatus;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filterDimensions = filterDimensions;
        this.filters = filters;
        this.fontSize = fontSize;
        this.formName = formName;
        this.hideEmptyRowItems = hideEmptyRowItems;
        this.hideEmptyRows = hideEmptyRows;
        this.hideLegend = hideLegend;
        this.hideNaData = hideNaData;
        this.hideSubtitle = hideSubtitle;
        this.hideTitle = hideTitle;
        this.href = href;
        this.id = id;
        this.interpretations = interpretations;
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legacy = legacy;
        this.legendDisplayStrategy = legendDisplayStrategy;
        this.legendSet = legendSet;
        this.name = name;
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        this.orgUnitField = orgUnitField;
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        this.organisationUnitLevels = organisationUnitLevels;
        this.organisationUnits = organisationUnits;
        this.outputType = outputType;
        this.parentGraphMap = parentGraphMap;
        this.percentStackedValues = percentStackedValues;
        this.periods = periods;
        this.program = program;
        this.programIndicatorDimensions = programIndicatorDimensions;
        this.programStage = programStage;
        this.programStatus = programStatus;
        this.publicAccess = publicAccess;
        this.rangeAxisDecimals = rangeAxisDecimals;
        this.rangeAxisLabel = rangeAxisLabel;
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        this.rangeAxisMinValue = rangeAxisMinValue;
        this.rangeAxisSteps = rangeAxisSteps;
        this.regressionType = regressionType;
        this.relativePeriods = relativePeriods;
        this.repetitions = repetitions;
        this.rowDimensions = rowDimensions;
        this.rowSubTotals = rowSubTotals;
        this.rowTotals = rowTotals;
        this.rows = rows;
        this.sharing = sharing;
        this.shortName = shortName;
        this.showData = showData;
        this.showDimensionLabels = showDimensionLabels;
        this.showHierarchy = showHierarchy;
        this.simpleDimensions = simpleDimensions;
        this.sortOrder = sortOrder;
        this.startDate = startDate;
        this.subscribed = subscribed;
        this.subscribers = subscribers;
        this.subtitle = subtitle;
        this.targetLineLabel = targetLineLabel;
        this.targetLineValue = targetLineValue;
        this.timeField = timeField;
        this.title = title;
        this.topLimit = topLimit;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.userOrgUnitType = userOrgUnitType;
        this.userOrganisationUnit = userOrganisationUnit;
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        this.value = value;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public EventVisualization withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public EventVisualization withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("attributeDimensions")
    public Optional<List<TrackedEntityAttributeDimension>> getAttributeDimensions() {
        return Optional.ofNullable(attributeDimensions);
    }

    @JsonProperty("attributeDimensions")
    public void setAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
    }

    public EventVisualization withAttributeDimensions(List<TrackedEntityAttributeDimension> attributeDimensions) {
        this.attributeDimensions = attributeDimensions;
        return this;
    }

    @JsonProperty("attributeValueDimension")
    public Optional<TrackedEntityAttribute> getAttributeValueDimension() {
        return Optional.ofNullable(attributeValueDimension);
    }

    @JsonProperty("attributeValueDimension")
    public void setAttributeValueDimension(TrackedEntityAttribute attributeValueDimension) {
        this.attributeValueDimension = attributeValueDimension;
    }

    public EventVisualization withAttributeValueDimension(TrackedEntityAttribute attributeValueDimension) {
        this.attributeValueDimension = attributeValueDimension;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public EventVisualization withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("baseLineLabel")
    public Optional<String> getBaseLineLabel() {
        return Optional.ofNullable(baseLineLabel);
    }

    @JsonProperty("baseLineLabel")
    public void setBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
    }

    public EventVisualization withBaseLineLabel(String baseLineLabel) {
        this.baseLineLabel = baseLineLabel;
        return this;
    }

    @JsonProperty("baseLineValue")
    public Optional<Double> getBaseLineValue() {
        return Optional.ofNullable(baseLineValue);
    }

    @JsonProperty("baseLineValue")
    public void setBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
    }

    public EventVisualization withBaseLineValue(Double baseLineValue) {
        this.baseLineValue = baseLineValue;
        return this;
    }

    @JsonProperty("categoryDimensions")
    public Optional<List<CategoryDimension>> getCategoryDimensions() {
        return Optional.ofNullable(categoryDimensions);
    }

    @JsonProperty("categoryDimensions")
    public void setCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
    }

    public EventVisualization withCategoryDimensions(List<CategoryDimension> categoryDimensions) {
        this.categoryDimensions = categoryDimensions;
        return this;
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public Optional<List<CategoryOptionGroupSetDimension>> getCategoryOptionGroupSetDimensions() {
        return Optional.ofNullable(categoryOptionGroupSetDimensions);
    }

    @JsonProperty("categoryOptionGroupSetDimensions")
    public void setCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
    }

    public EventVisualization withCategoryOptionGroupSetDimensions(List<CategoryOptionGroupSetDimension> categoryOptionGroupSetDimensions) {
        this.categoryOptionGroupSetDimensions = categoryOptionGroupSetDimensions;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public EventVisualization withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("colSubTotals")
    public Optional<Boolean> getColSubTotals() {
        return Optional.ofNullable(colSubTotals);
    }

    @JsonProperty("colSubTotals")
    public void setColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
    }

    public EventVisualization withColSubTotals(Boolean colSubTotals) {
        this.colSubTotals = colSubTotals;
        return this;
    }

    @JsonProperty("colTotals")
    public Optional<Boolean> getColTotals() {
        return Optional.ofNullable(colTotals);
    }

    @JsonProperty("colTotals")
    public void setColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
    }

    public EventVisualization withColTotals(Boolean colTotals) {
        this.colTotals = colTotals;
        return this;
    }

    @JsonProperty("collapseDataDimensions")
    public Optional<Boolean> getCollapseDataDimensions() {
        return Optional.ofNullable(collapseDataDimensions);
    }

    @JsonProperty("collapseDataDimensions")
    public void setCollapseDataDimensions(Boolean collapseDataDimensions) {
        this.collapseDataDimensions = collapseDataDimensions;
    }

    public EventVisualization withCollapseDataDimensions(Boolean collapseDataDimensions) {
        this.collapseDataDimensions = collapseDataDimensions;
        return this;
    }

    @JsonProperty("columnDimensions")
    public Optional<List<String>> getColumnDimensions() {
        return Optional.ofNullable(columnDimensions);
    }

    @JsonProperty("columnDimensions")
    public void setColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
    }

    public EventVisualization withColumnDimensions(List<String> columnDimensions) {
        this.columnDimensions = columnDimensions;
        return this;
    }

    @JsonProperty("columns")
    public Optional<List<Object>> getColumns() {
        return Optional.ofNullable(columns);
    }

    @JsonProperty("columns")
    public void setColumns(List<Object> columns) {
        this.columns = columns;
    }

    public EventVisualization withColumns(List<Object> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty("completedOnly")
    public Optional<Boolean> getCompletedOnly() {
        return Optional.ofNullable(completedOnly);
    }

    @JsonProperty("completedOnly")
    public void setCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
    }

    public EventVisualization withCompletedOnly(Boolean completedOnly) {
        this.completedOnly = completedOnly;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public EventVisualization withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("createdBy")
    public Optional<User> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    @JsonProperty("createdBy")
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public EventVisualization withCreatedBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("cumulativeValues")
    public Optional<Boolean> getCumulativeValues() {
        return Optional.ofNullable(cumulativeValues);
    }

    @JsonProperty("cumulativeValues")
    public void setCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
    }

    public EventVisualization withCumulativeValues(Boolean cumulativeValues) {
        this.cumulativeValues = cumulativeValues;
        return this;
    }

    @JsonProperty("dataDimensionItems")
    public Optional<List<DataDimensionItem>> getDataDimensionItems() {
        return Optional.ofNullable(dataDimensionItems);
    }

    @JsonProperty("dataDimensionItems")
    public void setDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
    }

    public EventVisualization withDataDimensionItems(List<DataDimensionItem> dataDimensionItems) {
        this.dataDimensionItems = dataDimensionItems;
        return this;
    }

    @JsonProperty("dataElementDimensions")
    public Optional<List<TrackedEntityDataElementDimension>> getDataElementDimensions() {
        return Optional.ofNullable(dataElementDimensions);
    }

    @JsonProperty("dataElementDimensions")
    public void setDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
    }

    public EventVisualization withDataElementDimensions(List<TrackedEntityDataElementDimension> dataElementDimensions) {
        this.dataElementDimensions = dataElementDimensions;
        return this;
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public Optional<List<DataElementGroupSetDimension>> getDataElementGroupSetDimensions() {
        return Optional.ofNullable(dataElementGroupSetDimensions);
    }

    @JsonProperty("dataElementGroupSetDimensions")
    public void setDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
    }

    public EventVisualization withDataElementGroupSetDimensions(List<DataElementGroupSetDimension> dataElementGroupSetDimensions) {
        this.dataElementGroupSetDimensions = dataElementGroupSetDimensions;
        return this;
    }

    @JsonProperty("dataElementValueDimension")
    public Optional<DataElement> getDataElementValueDimension() {
        return Optional.ofNullable(dataElementValueDimension);
    }

    @JsonProperty("dataElementValueDimension")
    public void setDataElementValueDimension(DataElement dataElementValueDimension) {
        this.dataElementValueDimension = dataElementValueDimension;
    }

    public EventVisualization withDataElementValueDimension(DataElement dataElementValueDimension) {
        this.dataElementValueDimension = dataElementValueDimension;
        return this;
    }

    @JsonProperty("dataType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType> getDataType() {
        return Optional.ofNullable(dataType);
    }

    @JsonProperty("dataType")
    public void setDataType(org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType dataType) {
        this.dataType = dataType;
    }

    public EventVisualization withDataType(org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public EventVisualization withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("digitGroupSeparator")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator> getDigitGroupSeparator() {
        return Optional.ofNullable(digitGroupSeparator);
    }

    @JsonProperty("digitGroupSeparator")
    public void setDigitGroupSeparator(org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
    }

    public EventVisualization withDigitGroupSeparator(org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator digitGroupSeparator) {
        this.digitGroupSeparator = digitGroupSeparator;
        return this;
    }

    @JsonProperty("displayBaseLineLabel")
    public Optional<String> getDisplayBaseLineLabel() {
        return Optional.ofNullable(displayBaseLineLabel);
    }

    @JsonProperty("displayBaseLineLabel")
    public void setDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
    }

    public EventVisualization withDisplayBaseLineLabel(String displayBaseLineLabel) {
        this.displayBaseLineLabel = displayBaseLineLabel;
        return this;
    }

    @JsonProperty("displayDensity")
    public Optional<org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity> getDisplayDensity() {
        return Optional.ofNullable(displayDensity);
    }

    @JsonProperty("displayDensity")
    public void setDisplayDensity(org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
    }

    public EventVisualization withDisplayDensity(org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity displayDensity) {
        this.displayDensity = displayDensity;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public EventVisualization withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayDomainAxisLabel")
    public Optional<String> getDisplayDomainAxisLabel() {
        return Optional.ofNullable(displayDomainAxisLabel);
    }

    @JsonProperty("displayDomainAxisLabel")
    public void setDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
    }

    public EventVisualization withDisplayDomainAxisLabel(String displayDomainAxisLabel) {
        this.displayDomainAxisLabel = displayDomainAxisLabel;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public EventVisualization withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EventVisualization withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayRangeAxisLabel")
    public Optional<String> getDisplayRangeAxisLabel() {
        return Optional.ofNullable(displayRangeAxisLabel);
    }

    @JsonProperty("displayRangeAxisLabel")
    public void setDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
    }

    public EventVisualization withDisplayRangeAxisLabel(String displayRangeAxisLabel) {
        this.displayRangeAxisLabel = displayRangeAxisLabel;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public EventVisualization withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("displaySubtitle")
    public Optional<String> getDisplaySubtitle() {
        return Optional.ofNullable(displaySubtitle);
    }

    @JsonProperty("displaySubtitle")
    public void setDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
    }

    public EventVisualization withDisplaySubtitle(String displaySubtitle) {
        this.displaySubtitle = displaySubtitle;
        return this;
    }

    @JsonProperty("displayTargetLineLabel")
    public Optional<String> getDisplayTargetLineLabel() {
        return Optional.ofNullable(displayTargetLineLabel);
    }

    @JsonProperty("displayTargetLineLabel")
    public void setDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
    }

    public EventVisualization withDisplayTargetLineLabel(String displayTargetLineLabel) {
        this.displayTargetLineLabel = displayTargetLineLabel;
        return this;
    }

    @JsonProperty("displayTitle")
    public Optional<String> getDisplayTitle() {
        return Optional.ofNullable(displayTitle);
    }

    @JsonProperty("displayTitle")
    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public EventVisualization withDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
        return this;
    }

    @JsonProperty("domainAxisLabel")
    public Optional<String> getDomainAxisLabel() {
        return Optional.ofNullable(domainAxisLabel);
    }

    @JsonProperty("domainAxisLabel")
    public void setDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
    }

    public EventVisualization withDomainAxisLabel(String domainAxisLabel) {
        this.domainAxisLabel = domainAxisLabel;
        return this;
    }

    @JsonProperty("endDate")
    public Optional<Date> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    @JsonProperty("endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public EventVisualization withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty("eventStatus")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus> getEventStatus() {
        return Optional.ofNullable(eventStatus);
    }

    @JsonProperty("eventStatus")
    public void setEventStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
    }

    public EventVisualization withEventStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public EventVisualization withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public EventVisualization withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public EventVisualization withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filterDimensions")
    public Optional<List<String>> getFilterDimensions() {
        return Optional.ofNullable(filterDimensions);
    }

    @JsonProperty("filterDimensions")
    public void setFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
    }

    public EventVisualization withFilterDimensions(List<String> filterDimensions) {
        this.filterDimensions = filterDimensions;
        return this;
    }

    @JsonProperty("filters")
    public Optional<List<Object>> getFilters() {
        return Optional.ofNullable(filters);
    }

    @JsonProperty("filters")
    public void setFilters(List<Object> filters) {
        this.filters = filters;
    }

    public EventVisualization withFilters(List<Object> filters) {
        this.filters = filters;
        return this;
    }

    @JsonProperty("fontSize")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize> getFontSize() {
        return Optional.ofNullable(fontSize);
    }

    @JsonProperty("fontSize")
    public void setFontSize(org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize fontSize) {
        this.fontSize = fontSize;
    }

    public EventVisualization withFontSize(org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public EventVisualization withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("hideEmptyRowItems")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy> getHideEmptyRowItems() {
        return Optional.ofNullable(hideEmptyRowItems);
    }

    @JsonProperty("hideEmptyRowItems")
    public void setHideEmptyRowItems(org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
    }

    public EventVisualization withHideEmptyRowItems(org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy hideEmptyRowItems) {
        this.hideEmptyRowItems = hideEmptyRowItems;
        return this;
    }

    @JsonProperty("hideEmptyRows")
    public Optional<Boolean> getHideEmptyRows() {
        return Optional.ofNullable(hideEmptyRows);
    }

    @JsonProperty("hideEmptyRows")
    public void setHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
    }

    public EventVisualization withHideEmptyRows(Boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
        return this;
    }

    @JsonProperty("hideLegend")
    public Optional<Boolean> getHideLegend() {
        return Optional.ofNullable(hideLegend);
    }

    @JsonProperty("hideLegend")
    public void setHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
    }

    public EventVisualization withHideLegend(Boolean hideLegend) {
        this.hideLegend = hideLegend;
        return this;
    }

    @JsonProperty("hideNaData")
    public Optional<Boolean> getHideNaData() {
        return Optional.ofNullable(hideNaData);
    }

    @JsonProperty("hideNaData")
    public void setHideNaData(Boolean hideNaData) {
        this.hideNaData = hideNaData;
    }

    public EventVisualization withHideNaData(Boolean hideNaData) {
        this.hideNaData = hideNaData;
        return this;
    }

    @JsonProperty("hideSubtitle")
    public Optional<Boolean> getHideSubtitle() {
        return Optional.ofNullable(hideSubtitle);
    }

    @JsonProperty("hideSubtitle")
    public void setHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
    }

    public EventVisualization withHideSubtitle(Boolean hideSubtitle) {
        this.hideSubtitle = hideSubtitle;
        return this;
    }

    @JsonProperty("hideTitle")
    public Optional<Boolean> getHideTitle() {
        return Optional.ofNullable(hideTitle);
    }

    @JsonProperty("hideTitle")
    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public EventVisualization withHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public EventVisualization withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public EventVisualization withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("interpretations")
    public Optional<List<Interpretation>> getInterpretations() {
        return Optional.ofNullable(interpretations);
    }

    @JsonProperty("interpretations")
    public void setInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
    }

    public EventVisualization withInterpretations(List<Interpretation> interpretations) {
        this.interpretations = interpretations;
        return this;
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getItemOrganisationUnitGroups() {
        return Optional.ofNullable(itemOrganisationUnitGroups);
    }

    @JsonProperty("itemOrganisationUnitGroups")
    public void setItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
    }

    public EventVisualization withItemOrganisationUnitGroups(List<OrganisationUnitGroup> itemOrganisationUnitGroups) {
        this.itemOrganisationUnitGroups = itemOrganisationUnitGroups;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public EventVisualization withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public EventVisualization withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legacy")
    public Optional<Boolean> getLegacy() {
        return Optional.ofNullable(legacy);
    }

    @JsonProperty("legacy")
    public void setLegacy(Boolean legacy) {
        this.legacy = legacy;
    }

    public EventVisualization withLegacy(Boolean legacy) {
        this.legacy = legacy;
        return this;
    }

    @JsonProperty("legendDisplayStrategy")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy> getLegendDisplayStrategy() {
        return Optional.ofNullable(legendDisplayStrategy);
    }

    @JsonProperty("legendDisplayStrategy")
    public void setLegendDisplayStrategy(org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
    }

    public EventVisualization withLegendDisplayStrategy(org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy legendDisplayStrategy) {
        this.legendDisplayStrategy = legendDisplayStrategy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public EventVisualization withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public EventVisualization withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("noSpaceBetweenColumns")
    public Optional<Boolean> getNoSpaceBetweenColumns() {
        return Optional.ofNullable(noSpaceBetweenColumns);
    }

    @JsonProperty("noSpaceBetweenColumns")
    public void setNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
    }

    public EventVisualization withNoSpaceBetweenColumns(Boolean noSpaceBetweenColumns) {
        this.noSpaceBetweenColumns = noSpaceBetweenColumns;
        return this;
    }

    @JsonProperty("orgUnitField")
    public Optional<String> getOrgUnitField() {
        return Optional.ofNullable(orgUnitField);
    }

    @JsonProperty("orgUnitField")
    public void setOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
    }

    public EventVisualization withOrgUnitField(String orgUnitField) {
        this.orgUnitField = orgUnitField;
        return this;
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public Optional<List<OrganisationUnitGroupSetDimension>> getOrganisationUnitGroupSetDimensions() {
        return Optional.ofNullable(organisationUnitGroupSetDimensions);
    }

    @JsonProperty("organisationUnitGroupSetDimensions")
    public void setOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
    }

    public EventVisualization withOrganisationUnitGroupSetDimensions(List<OrganisationUnitGroupSetDimension> organisationUnitGroupSetDimensions) {
        this.organisationUnitGroupSetDimensions = organisationUnitGroupSetDimensions;
        return this;
    }

    @JsonProperty("organisationUnitLevels")
    public Optional<List<Integer>> getOrganisationUnitLevels() {
        return Optional.ofNullable(organisationUnitLevels);
    }

    @JsonProperty("organisationUnitLevels")
    public void setOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
    }

    public EventVisualization withOrganisationUnitLevels(List<Integer> organisationUnitLevels) {
        this.organisationUnitLevels = organisationUnitLevels;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnit>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public EventVisualization withOrganisationUnits(List<OrganisationUnit> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("outputType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType> getOutputType() {
        return Optional.ofNullable(outputType);
    }

    @JsonProperty("outputType")
    public void setOutputType(org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType outputType) {
        this.outputType = outputType;
    }

    public EventVisualization withOutputType(org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public Optional<ParentGraphMap__2> getParentGraphMap() {
        return Optional.ofNullable(parentGraphMap);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("parentGraphMap")
    public void setParentGraphMap(ParentGraphMap__2 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
    }

    public EventVisualization withParentGraphMap(ParentGraphMap__2 parentGraphMap) {
        this.parentGraphMap = parentGraphMap;
        return this;
    }

    @JsonProperty("percentStackedValues")
    public Optional<Boolean> getPercentStackedValues() {
        return Optional.ofNullable(percentStackedValues);
    }

    @JsonProperty("percentStackedValues")
    public void setPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
    }

    public EventVisualization withPercentStackedValues(Boolean percentStackedValues) {
        this.percentStackedValues = percentStackedValues;
        return this;
    }

    @JsonProperty("periods")
    public Optional<List<Period>> getPeriods() {
        return Optional.ofNullable(periods);
    }

    @JsonProperty("periods")
    public void setPeriods(List<Period> periods) {
        this.periods = periods;
    }

    public EventVisualization withPeriods(List<Period> periods) {
        this.periods = periods;
        return this;
    }

    @JsonProperty("program")
    public Optional<Program> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(Program program) {
        this.program = program;
    }

    public EventVisualization withProgram(Program program) {
        this.program = program;
        return this;
    }

    @JsonProperty("programIndicatorDimensions")
    public Optional<List<TrackedEntityProgramIndicatorDimension>> getProgramIndicatorDimensions() {
        return Optional.ofNullable(programIndicatorDimensions);
    }

    @JsonProperty("programIndicatorDimensions")
    public void setProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
    }

    public EventVisualization withProgramIndicatorDimensions(List<TrackedEntityProgramIndicatorDimension> programIndicatorDimensions) {
        this.programIndicatorDimensions = programIndicatorDimensions;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<ProgramStage> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
    }

    public EventVisualization withProgramStage(ProgramStage programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("programStatus")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus> getProgramStatus() {
        return Optional.ofNullable(programStatus);
    }

    @JsonProperty("programStatus")
    public void setProgramStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus programStatus) {
        this.programStatus = programStatus;
    }

    public EventVisualization withProgramStatus(org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus programStatus) {
        this.programStatus = programStatus;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public EventVisualization withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("rangeAxisDecimals")
    public Optional<Integer> getRangeAxisDecimals() {
        return Optional.ofNullable(rangeAxisDecimals);
    }

    @JsonProperty("rangeAxisDecimals")
    public void setRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
    }

    public EventVisualization withRangeAxisDecimals(Integer rangeAxisDecimals) {
        this.rangeAxisDecimals = rangeAxisDecimals;
        return this;
    }

    @JsonProperty("rangeAxisLabel")
    public Optional<String> getRangeAxisLabel() {
        return Optional.ofNullable(rangeAxisLabel);
    }

    @JsonProperty("rangeAxisLabel")
    public void setRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
    }

    public EventVisualization withRangeAxisLabel(String rangeAxisLabel) {
        this.rangeAxisLabel = rangeAxisLabel;
        return this;
    }

    @JsonProperty("rangeAxisMaxValue")
    public Optional<Double> getRangeAxisMaxValue() {
        return Optional.ofNullable(rangeAxisMaxValue);
    }

    @JsonProperty("rangeAxisMaxValue")
    public void setRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
    }

    public EventVisualization withRangeAxisMaxValue(Double rangeAxisMaxValue) {
        this.rangeAxisMaxValue = rangeAxisMaxValue;
        return this;
    }

    @JsonProperty("rangeAxisMinValue")
    public Optional<Double> getRangeAxisMinValue() {
        return Optional.ofNullable(rangeAxisMinValue);
    }

    @JsonProperty("rangeAxisMinValue")
    public void setRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
    }

    public EventVisualization withRangeAxisMinValue(Double rangeAxisMinValue) {
        this.rangeAxisMinValue = rangeAxisMinValue;
        return this;
    }

    @JsonProperty("rangeAxisSteps")
    public Optional<Integer> getRangeAxisSteps() {
        return Optional.ofNullable(rangeAxisSteps);
    }

    @JsonProperty("rangeAxisSteps")
    public void setRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
    }

    public EventVisualization withRangeAxisSteps(Integer rangeAxisSteps) {
        this.rangeAxisSteps = rangeAxisSteps;
        return this;
    }

    @JsonProperty("regressionType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType> getRegressionType() {
        return Optional.ofNullable(regressionType);
    }

    @JsonProperty("regressionType")
    public void setRegressionType(org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType regressionType) {
        this.regressionType = regressionType;
    }

    public EventVisualization withRegressionType(org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType regressionType) {
        this.regressionType = regressionType;
        return this;
    }

    @JsonProperty("relativePeriods")
    public Optional<RelativePeriods> getRelativePeriods() {
        return Optional.ofNullable(relativePeriods);
    }

    @JsonProperty("relativePeriods")
    public void setRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
    }

    public EventVisualization withRelativePeriods(RelativePeriods relativePeriods) {
        this.relativePeriods = relativePeriods;
        return this;
    }

    @JsonProperty("repetitions")
    public Optional<List<EventRepetition>> getRepetitions() {
        return Optional.ofNullable(repetitions);
    }

    @JsonProperty("repetitions")
    public void setRepetitions(List<EventRepetition> repetitions) {
        this.repetitions = repetitions;
    }

    public EventVisualization withRepetitions(List<EventRepetition> repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    @JsonProperty("rowDimensions")
    public Optional<List<String>> getRowDimensions() {
        return Optional.ofNullable(rowDimensions);
    }

    @JsonProperty("rowDimensions")
    public void setRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
    }

    public EventVisualization withRowDimensions(List<String> rowDimensions) {
        this.rowDimensions = rowDimensions;
        return this;
    }

    @JsonProperty("rowSubTotals")
    public Optional<Boolean> getRowSubTotals() {
        return Optional.ofNullable(rowSubTotals);
    }

    @JsonProperty("rowSubTotals")
    public void setRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
    }

    public EventVisualization withRowSubTotals(Boolean rowSubTotals) {
        this.rowSubTotals = rowSubTotals;
        return this;
    }

    @JsonProperty("rowTotals")
    public Optional<Boolean> getRowTotals() {
        return Optional.ofNullable(rowTotals);
    }

    @JsonProperty("rowTotals")
    public void setRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
    }

    public EventVisualization withRowTotals(Boolean rowTotals) {
        this.rowTotals = rowTotals;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<Object>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    public EventVisualization withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public EventVisualization withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public EventVisualization withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("showData")
    public Optional<Boolean> getShowData() {
        return Optional.ofNullable(showData);
    }

    @JsonProperty("showData")
    public void setShowData(Boolean showData) {
        this.showData = showData;
    }

    public EventVisualization withShowData(Boolean showData) {
        this.showData = showData;
        return this;
    }

    @JsonProperty("showDimensionLabels")
    public Optional<Boolean> getShowDimensionLabels() {
        return Optional.ofNullable(showDimensionLabels);
    }

    @JsonProperty("showDimensionLabels")
    public void setShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
    }

    public EventVisualization withShowDimensionLabels(Boolean showDimensionLabels) {
        this.showDimensionLabels = showDimensionLabels;
        return this;
    }

    @JsonProperty("showHierarchy")
    public Optional<Boolean> getShowHierarchy() {
        return Optional.ofNullable(showHierarchy);
    }

    @JsonProperty("showHierarchy")
    public void setShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
    }

    public EventVisualization withShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
        return this;
    }

    @JsonProperty("simpleDimensions")
    public Optional<List<SimpleDimension>> getSimpleDimensions() {
        return Optional.ofNullable(simpleDimensions);
    }

    @JsonProperty("simpleDimensions")
    public void setSimpleDimensions(List<SimpleDimension> simpleDimensions) {
        this.simpleDimensions = simpleDimensions;
    }

    public EventVisualization withSimpleDimensions(List<SimpleDimension> simpleDimensions) {
        this.simpleDimensions = simpleDimensions;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public EventVisualization withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    @JsonProperty("startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public EventVisualization withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty("subscribed")
    public Optional<Boolean> getSubscribed() {
        return Optional.ofNullable(subscribed);
    }

    @JsonProperty("subscribed")
    public void setSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
    }

    public EventVisualization withSubscribed(Boolean subscribed) {
        this.subscribed = subscribed;
        return this;
    }

    @JsonProperty("subscribers")
    public Optional<List<String>> getSubscribers() {
        return Optional.ofNullable(subscribers);
    }

    @JsonProperty("subscribers")
    public void setSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
    }

    public EventVisualization withSubscribers(List<String> subscribers) {
        this.subscribers = subscribers;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public EventVisualization withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("targetLineLabel")
    public Optional<String> getTargetLineLabel() {
        return Optional.ofNullable(targetLineLabel);
    }

    @JsonProperty("targetLineLabel")
    public void setTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
    }

    public EventVisualization withTargetLineLabel(String targetLineLabel) {
        this.targetLineLabel = targetLineLabel;
        return this;
    }

    @JsonProperty("targetLineValue")
    public Optional<Double> getTargetLineValue() {
        return Optional.ofNullable(targetLineValue);
    }

    @JsonProperty("targetLineValue")
    public void setTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
    }

    public EventVisualization withTargetLineValue(Double targetLineValue) {
        this.targetLineValue = targetLineValue;
        return this;
    }

    @JsonProperty("timeField")
    public Optional<String> getTimeField() {
        return Optional.ofNullable(timeField);
    }

    @JsonProperty("timeField")
    public void setTimeField(String timeField) {
        this.timeField = timeField;
    }

    public EventVisualization withTimeField(String timeField) {
        this.timeField = timeField;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public EventVisualization withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("topLimit")
    public Optional<Integer> getTopLimit() {
        return Optional.ofNullable(topLimit);
    }

    @JsonProperty("topLimit")
    public void setTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
    }

    public EventVisualization withTopLimit(Integer topLimit) {
        this.topLimit = topLimit;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public EventVisualization withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("type")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType type) {
        this.type = type;
    }

    public EventVisualization withType(org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType type) {
        this.type = type;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public EventVisualization withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public EventVisualization withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public EventVisualization withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userOrgUnitType")
    public Optional<org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType> getUserOrgUnitType() {
        return Optional.ofNullable(userOrgUnitType);
    }

    @JsonProperty("userOrgUnitType")
    public void setUserOrgUnitType(org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
    }

    public EventVisualization withUserOrgUnitType(org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType userOrgUnitType) {
        this.userOrgUnitType = userOrgUnitType;
        return this;
    }

    @JsonProperty("userOrganisationUnit")
    public Optional<Boolean> getUserOrganisationUnit() {
        return Optional.ofNullable(userOrganisationUnit);
    }

    @JsonProperty("userOrganisationUnit")
    public void setUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
    }

    public EventVisualization withUserOrganisationUnit(Boolean userOrganisationUnit) {
        this.userOrganisationUnit = userOrganisationUnit;
        return this;
    }

    @JsonProperty("userOrganisationUnitChildren")
    public Optional<Boolean> getUserOrganisationUnitChildren() {
        return Optional.ofNullable(userOrganisationUnitChildren);
    }

    @JsonProperty("userOrganisationUnitChildren")
    public void setUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
    }

    public EventVisualization withUserOrganisationUnitChildren(Boolean userOrganisationUnitChildren) {
        this.userOrganisationUnitChildren = userOrganisationUnitChildren;
        return this;
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public Optional<Boolean> getUserOrganisationUnitGrandChildren() {
        return Optional.ofNullable(userOrganisationUnitGrandChildren);
    }

    @JsonProperty("userOrganisationUnitGrandChildren")
    public void setUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
    }

    public EventVisualization withUserOrganisationUnitGrandChildren(Boolean userOrganisationUnitGrandChildren) {
        this.userOrganisationUnitGrandChildren = userOrganisationUnitGrandChildren;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("value")
    public void setValue(Object value) {
        this.value = value;
    }

    public EventVisualization withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EventVisualization withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_38_1.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_38_1.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeDimensions".equals(name)) {
                    if (value instanceof List) {
                        setAttributeDimensions(((List<TrackedEntityAttributeDimension> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.TrackedEntityAttributeDimension>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValueDimension".equals(name)) {
                        if (value instanceof TrackedEntityAttribute) {
                            setAttributeValueDimension(((TrackedEntityAttribute) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValueDimension\" is of type \"org.hisp.dhis.api.model.v2_38_1.TrackedEntityAttribute\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("attributeValues".equals(name)) {
                            if (value instanceof List) {
                                setAttributeValues(((List<AttributeValue> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.AttributeValue>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("baseLineLabel".equals(name)) {
                                if (value instanceof String) {
                                    setBaseLineLabel(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"baseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("baseLineValue".equals(name)) {
                                    if (value instanceof Double) {
                                        setBaseLineValue(((Double) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"baseLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("categoryDimensions".equals(name)) {
                                        if (value instanceof List) {
                                            setCategoryDimensions(((List<CategoryDimension> ) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"categoryDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.CategoryDimension>\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("categoryOptionGroupSetDimensions".equals(name)) {
                                            if (value instanceof List) {
                                                setCategoryOptionGroupSetDimensions(((List<CategoryOptionGroupSetDimension> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"categoryOptionGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.CategoryOptionGroupSetDimension>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("code".equals(name)) {
                                                if (value instanceof String) {
                                                    setCode(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("colSubTotals".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setColSubTotals(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"colSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("colTotals".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setColTotals(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"colTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("collapseDataDimensions".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setCollapseDataDimensions(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"collapseDataDimensions\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("columnDimensions".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setColumnDimensions(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"columnDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("columns".equals(name)) {
                                                                    if (value instanceof List) {
                                                                        setColumns(((List<Object> ) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"columns\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("completedOnly".equals(name)) {
                                                                        if (value instanceof Boolean) {
                                                                            setCompletedOnly(((Boolean) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"completedOnly\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("created".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setCreated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("createdBy".equals(name)) {
                                                                                if (value instanceof User) {
                                                                                    setCreatedBy(((User) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("cumulativeValues".equals(name)) {
                                                                                    if (value instanceof Boolean) {
                                                                                        setCumulativeValues(((Boolean) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"cumulativeValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("dataDimensionItems".equals(name)) {
                                                                                        if (value instanceof List) {
                                                                                            setDataDimensionItems(((List<DataDimensionItem> ) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"dataDimensionItems\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.DataDimensionItem>\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("dataElementDimensions".equals(name)) {
                                                                                            if (value instanceof List) {
                                                                                                setDataElementDimensions(((List<TrackedEntityDataElementDimension> ) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"dataElementDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.TrackedEntityDataElementDimension>\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("dataElementGroupSetDimensions".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setDataElementGroupSetDimensions(((List<DataElementGroupSetDimension> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"dataElementGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.DataElementGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("dataElementValueDimension".equals(name)) {
                                                                                                    if (value instanceof DataElement) {
                                                                                                        setDataElementValueDimension(((DataElement) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"dataElementValueDimension\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataElement\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("dataType".equals(name)) {
                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType) {
                                                                                                            setDataType(((org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"dataType\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventReport.EventDataType\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("description".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setDescription(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("digitGroupSeparator".equals(name)) {
                                                                                                                if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator) {
                                                                                                                    setDigitGroupSeparator(((org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"digitGroupSeparator\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.DigitGroupSeparator\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("displayBaseLineLabel".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setDisplayBaseLineLabel(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"displayBaseLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("displayDensity".equals(name)) {
                                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity) {
                                                                                                                            setDisplayDensity(((org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"displayDensity\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataEntryForm.DisplayDensity\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("displayDescription".equals(name)) {
                                                                                                                            if (value instanceof String) {
                                                                                                                                setDisplayDescription(((String) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("displayDomainAxisLabel".equals(name)) {
                                                                                                                                if (value instanceof String) {
                                                                                                                                    setDisplayDomainAxisLabel(((String) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"displayDomainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("displayFormName".equals(name)) {
                                                                                                                                    if (value instanceof String) {
                                                                                                                                        setDisplayFormName(((String) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("displayName".equals(name)) {
                                                                                                                                        if (value instanceof String) {
                                                                                                                                            setDisplayName(((String) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("displayRangeAxisLabel".equals(name)) {
                                                                                                                                            if (value instanceof String) {
                                                                                                                                                setDisplayRangeAxisLabel(((String) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"displayRangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("displayShortName".equals(name)) {
                                                                                                                                                if (value instanceof String) {
                                                                                                                                                    setDisplayShortName(((String) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("displaySubtitle".equals(name)) {
                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                        setDisplaySubtitle(((String) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"displaySubtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("displayTargetLineLabel".equals(name)) {
                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                            setDisplayTargetLineLabel(((String) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"displayTargetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("displayTitle".equals(name)) {
                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                setDisplayTitle(((String) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"displayTitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("domainAxisLabel".equals(name)) {
                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                    setDomainAxisLabel(((String) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"domainAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("endDate".equals(name)) {
                                                                                                                                                                    if (value instanceof Date) {
                                                                                                                                                                        setEndDate(((Date) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"endDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("eventStatus".equals(name)) {
                                                                                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus) {
                                                                                                                                                                            setEventStatus(((org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"eventStatus\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.EventStatus\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("externalAccess".equals(name)) {
                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                setExternalAccess(((Boolean) value));
                                                                                                                                                                            } else {
                                                                                                                                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                            }
                                                                                                                                                                            return true;
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("favorite".equals(name)) {
                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                    setFavorite(((Boolean) value));
                                                                                                                                                                                } else {
                                                                                                                                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                }
                                                                                                                                                                                return true;
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("favorites".equals(name)) {
                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                        setFavorites(((List<String> ) value));
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                    }
                                                                                                                                                                                    return true;
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("filterDimensions".equals(name)) {
                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                            setFilterDimensions(((List<String> ) value));
                                                                                                                                                                                        } else {
                                                                                                                                                                                            throw new IllegalArgumentException(("property \"filterDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                        }
                                                                                                                                                                                        return true;
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("filters".equals(name)) {
                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                setFilters(((List<Object> ) value));
                                                                                                                                                                                            } else {
                                                                                                                                                                                                throw new IllegalArgumentException(("property \"filters\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                            }
                                                                                                                                                                                            return true;
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("fontSize".equals(name)) {
                                                                                                                                                                                                if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize) {
                                                                                                                                                                                                    setFontSize(((org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize) value));
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"fontSize\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventReport.FontSize\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                }
                                                                                                                                                                                                return true;
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("formName".equals(name)) {
                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                        setFormName(((String) value));
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return true;
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("hideEmptyRowItems".equals(name)) {
                                                                                                                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy) {
                                                                                                                                                                                                            setHideEmptyRowItems(((org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy) value));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"hideEmptyRowItems\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.HideEmptyItemStrategy\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        return true;
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("hideEmptyRows".equals(name)) {
                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                setHideEmptyRows(((Boolean) value));
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"hideEmptyRows\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                            }
                                                                                                                                                                                                            return true;
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("hideLegend".equals(name)) {
                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                    setHideLegend(((Boolean) value));
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"hideLegend\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                }
                                                                                                                                                                                                                return true;
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("hideNaData".equals(name)) {
                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                        setHideNaData(((Boolean) value));
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"hideNaData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("hideSubtitle".equals(name)) {
                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                            setHideSubtitle(((Boolean) value));
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"hideSubtitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("hideTitle".equals(name)) {
                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                setHideTitle(((Boolean) value));
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"hideTitle\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("href".equals(name)) {
                                                                                                                                                                                                                                if (value instanceof String) {
                                                                                                                                                                                                                                    setHref(((String) value));
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("id".equals(name)) {
                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                        setId(((String) value));
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("interpretations".equals(name)) {
                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                            setInterpretations(((List<Interpretation> ) value));
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"interpretations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Interpretation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                setItemOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"itemOrganisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                                                                                                                                                if (value instanceof Date) {
                                                                                                                                                                                                                                                    setLastUpdated(((Date) value));
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                                                                                                                    if (value instanceof User) {
                                                                                                                                                                                                                                                        setLastUpdatedBy(((User) value));
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("legacy".equals(name)) {
                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                            setLegacy(((Boolean) value));
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"legacy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("legendDisplayStrategy".equals(name)) {
                                                                                                                                                                                                                                                            if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy) {
                                                                                                                                                                                                                                                                setLegendDisplayStrategy(((org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy) value));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"legendDisplayStrategy\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.LegendDisplayStrategy\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                                                                                                                                                                if (value instanceof LegendSet) {
                                                                                                                                                                                                                                                                    setLegendSet(((LegendSet) value));
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_38_1.LegendSet\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("name".equals(name)) {
                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                        setName(((String) value));
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("noSpaceBetweenColumns".equals(name)) {
                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                            setNoSpaceBetweenColumns(((Boolean) value));
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"noSpaceBetweenColumns\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                                                                setOrgUnitField(((String) value));
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"orgUnitField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                    setOrganisationUnitGroupSetDimensions(((List<OrganisationUnitGroupSetDimension> ) value));
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"organisationUnitGroupSetDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.OrganisationUnitGroupSetDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                                                        setOrganisationUnitLevels(((List<Integer> ) value));
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"organisationUnitLevels\" is of type \"java.util.List<java.lang.Integer>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                                                                            setOrganisationUnits(((List<OrganisationUnit> ) value));
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.OrganisationUnit>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        if ("outputType".equals(name)) {
                                                                                                                                                                                                                                                                                            if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType) {
                                                                                                                                                                                                                                                                                                setOutputType(((org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType) value));
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"outputType\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.EventOutputType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            if ("parentGraphMap".equals(name)) {
                                                                                                                                                                                                                                                                                                if (value instanceof ParentGraphMap__2) {
                                                                                                                                                                                                                                                                                                    setParentGraphMap(((ParentGraphMap__2) value));
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"parentGraphMap\" is of type \"org.hisp.dhis.api.model.v2_38_1.ParentGraphMap__2\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                if ("percentStackedValues".equals(name)) {
                                                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                        setPercentStackedValues(((Boolean) value));
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"percentStackedValues\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    if ("periods".equals(name)) {
                                                                                                                                                                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                                                                                                                                                                            setPeriods(((List<Period> ) value));
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"periods\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Period>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        if ("program".equals(name)) {
                                                                                                                                                                                                                                                                                                            if (value instanceof Program) {
                                                                                                                                                                                                                                                                                                                setProgram(((Program) value));
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v2_38_1.Program\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                    setProgramIndicatorDimensions(((List<TrackedEntityProgramIndicatorDimension> ) value));
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"programIndicatorDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.TrackedEntityProgramIndicatorDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                if ("programStage".equals(name)) {
                                                                                                                                                                                                                                                                                                                    if (value instanceof ProgramStage) {
                                                                                                                                                                                                                                                                                                                        setProgramStage(((ProgramStage) value));
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v2_38_1.ProgramStage\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    if ("programStatus".equals(name)) {
                                                                                                                                                                                                                                                                                                                        if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus) {
                                                                                                                                                                                                                                                                                                                            setProgramStatus(((org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus) value));
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"programStatus\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.ProgramStatus\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                setPublicAccess(((String) value));
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            if ("rangeAxisDecimals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                                    setRangeAxisDecimals(((Integer) value));
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rangeAxisDecimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                if ("rangeAxisLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                        setRangeAxisLabel(((String) value));
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"rangeAxisLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    if ("rangeAxisMaxValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                        if (value instanceof Double) {
                                                                                                                                                                                                                                                                                                                                            setRangeAxisMaxValue(((Double) value));
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"rangeAxisMaxValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        if ("rangeAxisMinValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                            if (value instanceof Double) {
                                                                                                                                                                                                                                                                                                                                                setRangeAxisMinValue(((Double) value));
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"rangeAxisMinValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            if ("rangeAxisSteps".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                                                    setRangeAxisSteps(((Integer) value));
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rangeAxisSteps\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                if ("regressionType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                    if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType) {
                                                                                                                                                                                                                                                                                                                                                        setRegressionType(((org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType) value));
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"regressionType\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.RegressionType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    if ("relativePeriods".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                        if (value instanceof RelativePeriods) {
                                                                                                                                                                                                                                                                                                                                                            setRelativePeriods(((RelativePeriods) value));
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"relativePeriods\" is of type \"org.hisp.dhis.api.model.v2_38_1.RelativePeriods\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        if ("repetitions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                setRepetitions(((List<EventRepetition> ) value));
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"repetitions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.EventRepetition>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            if ("rowDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                    setRowDimensions(((List<String> ) value));
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"rowDimensions\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                if ("rowSubTotals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                        setRowSubTotals(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"rowSubTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    if ("rowTotals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                            setRowTotals(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"rowTotals\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        if ("rows".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                setRows(((List<Object> ) value));
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.lang.Object>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Sharing) {
                                                                                                                                                                                                                                                                                                                                                                                    setSharing(((Sharing) value));
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v2_38_1.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                                                        setShortName(((String) value));
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    if ("showData".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                            setShowData(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"showData\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        if ("showDimensionLabels".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                setShowDimensionLabels(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"showDimensionLabels\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            if ("showHierarchy".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                    setShowHierarchy(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"showHierarchy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                if ("simpleDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                        setSimpleDimensions(((List<SimpleDimension> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"simpleDimensions\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.SimpleDimension>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                                                                                                            setSortOrder(((Integer) value));
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        if ("startDate".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof Date) {
                                                                                                                                                                                                                                                                                                                                                                                                                setStartDate(((Date) value));
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"startDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            if ("subscribed".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                                    setSubscribed(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"subscribed\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                if ("subscribers".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                                        setSubscribers(((List<String> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"subscribers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    if ("subtitle".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                                                                                            setSubtitle(((String) value));
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        if ("targetLineLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                                                                                                setTargetLineLabel(((String) value));
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"targetLineLabel\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            if ("targetLineValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Double) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    setTargetLineValue(((Double) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"targetLineValue\" is of type \"java.lang.Double\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                if ("timeField".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        setTimeField(((String) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"timeField\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("title".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof String) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            setTitle(((String) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof Integer) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                setTopLimit(((Integer) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"topLimit\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    setTranslations(((List<Translation> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("type".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        setType(((org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.EventVisualizationType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("user".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof User) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            setUser(((User) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_38_1.User\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                setUserAccesses(((List<UserAccess> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.UserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        setUserOrgUnitType(((org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"userOrgUnitType\" is of type \"org.hisp.dhis.api.model.v2_38_1.EventChart.UserOrgUnitType\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            setUserOrganisationUnit(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            throw new IllegalArgumentException(("property \"userOrganisationUnit\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                setUserOrganisationUnitChildren(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                throw new IllegalArgumentException(("property \"userOrganisationUnitChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (value instanceof Boolean) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    setUserOrganisationUnitGrandChildren(((Boolean) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    throw new IllegalArgumentException(("property \"userOrganisationUnitGrandChildren\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("value".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (value instanceof Object) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        setValue(((Object) value));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("attributeDimensions".equals(name)) {
                    return getAttributeDimensions();
                } else {
                    if ("attributeValueDimension".equals(name)) {
                        return getAttributeValueDimension();
                    } else {
                        if ("attributeValues".equals(name)) {
                            return getAttributeValues();
                        } else {
                            if ("baseLineLabel".equals(name)) {
                                return getBaseLineLabel();
                            } else {
                                if ("baseLineValue".equals(name)) {
                                    return getBaseLineValue();
                                } else {
                                    if ("categoryDimensions".equals(name)) {
                                        return getCategoryDimensions();
                                    } else {
                                        if ("categoryOptionGroupSetDimensions".equals(name)) {
                                            return getCategoryOptionGroupSetDimensions();
                                        } else {
                                            if ("code".equals(name)) {
                                                return getCode();
                                            } else {
                                                if ("colSubTotals".equals(name)) {
                                                    return getColSubTotals();
                                                } else {
                                                    if ("colTotals".equals(name)) {
                                                        return getColTotals();
                                                    } else {
                                                        if ("collapseDataDimensions".equals(name)) {
                                                            return getCollapseDataDimensions();
                                                        } else {
                                                            if ("columnDimensions".equals(name)) {
                                                                return getColumnDimensions();
                                                            } else {
                                                                if ("columns".equals(name)) {
                                                                    return getColumns();
                                                                } else {
                                                                    if ("completedOnly".equals(name)) {
                                                                        return getCompletedOnly();
                                                                    } else {
                                                                        if ("created".equals(name)) {
                                                                            return getCreated();
                                                                        } else {
                                                                            if ("createdBy".equals(name)) {
                                                                                return getCreatedBy();
                                                                            } else {
                                                                                if ("cumulativeValues".equals(name)) {
                                                                                    return getCumulativeValues();
                                                                                } else {
                                                                                    if ("dataDimensionItems".equals(name)) {
                                                                                        return getDataDimensionItems();
                                                                                    } else {
                                                                                        if ("dataElementDimensions".equals(name)) {
                                                                                            return getDataElementDimensions();
                                                                                        } else {
                                                                                            if ("dataElementGroupSetDimensions".equals(name)) {
                                                                                                return getDataElementGroupSetDimensions();
                                                                                            } else {
                                                                                                if ("dataElementValueDimension".equals(name)) {
                                                                                                    return getDataElementValueDimension();
                                                                                                } else {
                                                                                                    if ("dataType".equals(name)) {
                                                                                                        return getDataType();
                                                                                                    } else {
                                                                                                        if ("description".equals(name)) {
                                                                                                            return getDescription();
                                                                                                        } else {
                                                                                                            if ("digitGroupSeparator".equals(name)) {
                                                                                                                return getDigitGroupSeparator();
                                                                                                            } else {
                                                                                                                if ("displayBaseLineLabel".equals(name)) {
                                                                                                                    return getDisplayBaseLineLabel();
                                                                                                                } else {
                                                                                                                    if ("displayDensity".equals(name)) {
                                                                                                                        return getDisplayDensity();
                                                                                                                    } else {
                                                                                                                        if ("displayDescription".equals(name)) {
                                                                                                                            return getDisplayDescription();
                                                                                                                        } else {
                                                                                                                            if ("displayDomainAxisLabel".equals(name)) {
                                                                                                                                return getDisplayDomainAxisLabel();
                                                                                                                            } else {
                                                                                                                                if ("displayFormName".equals(name)) {
                                                                                                                                    return getDisplayFormName();
                                                                                                                                } else {
                                                                                                                                    if ("displayName".equals(name)) {
                                                                                                                                        return getDisplayName();
                                                                                                                                    } else {
                                                                                                                                        if ("displayRangeAxisLabel".equals(name)) {
                                                                                                                                            return getDisplayRangeAxisLabel();
                                                                                                                                        } else {
                                                                                                                                            if ("displayShortName".equals(name)) {
                                                                                                                                                return getDisplayShortName();
                                                                                                                                            } else {
                                                                                                                                                if ("displaySubtitle".equals(name)) {
                                                                                                                                                    return getDisplaySubtitle();
                                                                                                                                                } else {
                                                                                                                                                    if ("displayTargetLineLabel".equals(name)) {
                                                                                                                                                        return getDisplayTargetLineLabel();
                                                                                                                                                    } else {
                                                                                                                                                        if ("displayTitle".equals(name)) {
                                                                                                                                                            return getDisplayTitle();
                                                                                                                                                        } else {
                                                                                                                                                            if ("domainAxisLabel".equals(name)) {
                                                                                                                                                                return getDomainAxisLabel();
                                                                                                                                                            } else {
                                                                                                                                                                if ("endDate".equals(name)) {
                                                                                                                                                                    return getEndDate();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("eventStatus".equals(name)) {
                                                                                                                                                                        return getEventStatus();
                                                                                                                                                                    } else {
                                                                                                                                                                        if ("externalAccess".equals(name)) {
                                                                                                                                                                            return getExternalAccess();
                                                                                                                                                                        } else {
                                                                                                                                                                            if ("favorite".equals(name)) {
                                                                                                                                                                                return getFavorite();
                                                                                                                                                                            } else {
                                                                                                                                                                                if ("favorites".equals(name)) {
                                                                                                                                                                                    return getFavorites();
                                                                                                                                                                                } else {
                                                                                                                                                                                    if ("filterDimensions".equals(name)) {
                                                                                                                                                                                        return getFilterDimensions();
                                                                                                                                                                                    } else {
                                                                                                                                                                                        if ("filters".equals(name)) {
                                                                                                                                                                                            return getFilters();
                                                                                                                                                                                        } else {
                                                                                                                                                                                            if ("fontSize".equals(name)) {
                                                                                                                                                                                                return getFontSize();
                                                                                                                                                                                            } else {
                                                                                                                                                                                                if ("formName".equals(name)) {
                                                                                                                                                                                                    return getFormName();
                                                                                                                                                                                                } else {
                                                                                                                                                                                                    if ("hideEmptyRowItems".equals(name)) {
                                                                                                                                                                                                        return getHideEmptyRowItems();
                                                                                                                                                                                                    } else {
                                                                                                                                                                                                        if ("hideEmptyRows".equals(name)) {
                                                                                                                                                                                                            return getHideEmptyRows();
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            if ("hideLegend".equals(name)) {
                                                                                                                                                                                                                return getHideLegend();
                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                if ("hideNaData".equals(name)) {
                                                                                                                                                                                                                    return getHideNaData();
                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                    if ("hideSubtitle".equals(name)) {
                                                                                                                                                                                                                        return getHideSubtitle();
                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                        if ("hideTitle".equals(name)) {
                                                                                                                                                                                                                            return getHideTitle();
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            if ("href".equals(name)) {
                                                                                                                                                                                                                                return getHref();
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                if ("id".equals(name)) {
                                                                                                                                                                                                                                    return getId();
                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                    if ("interpretations".equals(name)) {
                                                                                                                                                                                                                                        return getInterpretations();
                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                        if ("itemOrganisationUnitGroups".equals(name)) {
                                                                                                                                                                                                                                            return getItemOrganisationUnitGroups();
                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                            if ("lastUpdated".equals(name)) {
                                                                                                                                                                                                                                                return getLastUpdated();
                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                if ("lastUpdatedBy".equals(name)) {
                                                                                                                                                                                                                                                    return getLastUpdatedBy();
                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                    if ("legacy".equals(name)) {
                                                                                                                                                                                                                                                        return getLegacy();
                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                        if ("legendDisplayStrategy".equals(name)) {
                                                                                                                                                                                                                                                            return getLegendDisplayStrategy();
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            if ("legendSet".equals(name)) {
                                                                                                                                                                                                                                                                return getLegendSet();
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                if ("name".equals(name)) {
                                                                                                                                                                                                                                                                    return getName();
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    if ("noSpaceBetweenColumns".equals(name)) {
                                                                                                                                                                                                                                                                        return getNoSpaceBetweenColumns();
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        if ("orgUnitField".equals(name)) {
                                                                                                                                                                                                                                                                            return getOrgUnitField();
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            if ("organisationUnitGroupSetDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                return getOrganisationUnitGroupSetDimensions();
                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                if ("organisationUnitLevels".equals(name)) {
                                                                                                                                                                                                                                                                                    return getOrganisationUnitLevels();
                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                    if ("organisationUnits".equals(name)) {
                                                                                                                                                                                                                                                                                        return getOrganisationUnits();
                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                        if ("outputType".equals(name)) {
                                                                                                                                                                                                                                                                                            return getOutputType();
                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                            if ("parentGraphMap".equals(name)) {
                                                                                                                                                                                                                                                                                                return getParentGraphMap();
                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                if ("percentStackedValues".equals(name)) {
                                                                                                                                                                                                                                                                                                    return getPercentStackedValues();
                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                    if ("periods".equals(name)) {
                                                                                                                                                                                                                                                                                                        return getPeriods();
                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                        if ("program".equals(name)) {
                                                                                                                                                                                                                                                                                                            return getProgram();
                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                            if ("programIndicatorDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                return getProgramIndicatorDimensions();
                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                if ("programStage".equals(name)) {
                                                                                                                                                                                                                                                                                                                    return getProgramStage();
                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                    if ("programStatus".equals(name)) {
                                                                                                                                                                                                                                                                                                                        return getProgramStatus();
                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                                                                                                                                                                                                                                            return getPublicAccess();
                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                            if ("rangeAxisDecimals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                return getRangeAxisDecimals();
                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                if ("rangeAxisLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                    return getRangeAxisLabel();
                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                    if ("rangeAxisMaxValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                        return getRangeAxisMaxValue();
                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                        if ("rangeAxisMinValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                            return getRangeAxisMinValue();
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            if ("rangeAxisSteps".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                return getRangeAxisSteps();
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                if ("regressionType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                    return getRegressionType();
                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                    if ("relativePeriods".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                        return getRelativePeriods();
                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                        if ("repetitions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                            return getRepetitions();
                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                            if ("rowDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                return getRowDimensions();
                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                if ("rowSubTotals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                    return getRowSubTotals();
                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                    if ("rowTotals".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                        return getRowTotals();
                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                        if ("rows".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                            return getRows();
                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                return getSharing();
                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                    return getShortName();
                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                    if ("showData".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                        return getShowData();
                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                        if ("showDimensionLabels".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                            return getShowDimensionLabels();
                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                            if ("showHierarchy".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                return getShowHierarchy();
                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                if ("simpleDimensions".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                    return getSimpleDimensions();
                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                    if ("sortOrder".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                        return getSortOrder();
                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                        if ("startDate".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                            return getStartDate();
                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                            if ("subscribed".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                return getSubscribed();
                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                if ("subscribers".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    return getSubscribers();
                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                    if ("subtitle".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        return getSubtitle();
                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                        if ("targetLineLabel".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            return getTargetLineLabel();
                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                            if ("targetLineValue".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                return getTargetLineValue();
                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                if ("timeField".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    return getTimeField();
                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("title".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        return getTitle();
                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("topLimit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            return getTopLimit();
                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("translations".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                return getTranslations();
                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("type".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return getType();
                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("user".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return getUser();
                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return getUserAccesses();
                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return getUserGroupAccesses();
                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("userOrgUnitType".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return getUserOrgUnitType();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if ("userOrganisationUnit".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return getUserOrganisationUnit();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if ("userOrganisationUnitChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return getUserOrganisationUnitChildren();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if ("userOrganisationUnitGrandChildren".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return getUserOrganisationUnitGrandChildren();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if ("value".equals(name)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return getValue();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return notFoundValue;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EventVisualization.NOT_FOUND_VALUE);
        if (EventVisualization.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EventVisualization with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventVisualization.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("attributeDimensions");
        sb.append('=');
        sb.append(((this.attributeDimensions == null)?"<null>":this.attributeDimensions));
        sb.append(',');
        sb.append("attributeValueDimension");
        sb.append('=');
        sb.append(((this.attributeValueDimension == null)?"<null>":this.attributeValueDimension));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("baseLineLabel");
        sb.append('=');
        sb.append(((this.baseLineLabel == null)?"<null>":this.baseLineLabel));
        sb.append(',');
        sb.append("baseLineValue");
        sb.append('=');
        sb.append(((this.baseLineValue == null)?"<null>":this.baseLineValue));
        sb.append(',');
        sb.append("categoryDimensions");
        sb.append('=');
        sb.append(((this.categoryDimensions == null)?"<null>":this.categoryDimensions));
        sb.append(',');
        sb.append("categoryOptionGroupSetDimensions");
        sb.append('=');
        sb.append(((this.categoryOptionGroupSetDimensions == null)?"<null>":this.categoryOptionGroupSetDimensions));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("colSubTotals");
        sb.append('=');
        sb.append(((this.colSubTotals == null)?"<null>":this.colSubTotals));
        sb.append(',');
        sb.append("colTotals");
        sb.append('=');
        sb.append(((this.colTotals == null)?"<null>":this.colTotals));
        sb.append(',');
        sb.append("collapseDataDimensions");
        sb.append('=');
        sb.append(((this.collapseDataDimensions == null)?"<null>":this.collapseDataDimensions));
        sb.append(',');
        sb.append("columnDimensions");
        sb.append('=');
        sb.append(((this.columnDimensions == null)?"<null>":this.columnDimensions));
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(((this.columns == null)?"<null>":this.columns));
        sb.append(',');
        sb.append("completedOnly");
        sb.append('=');
        sb.append(((this.completedOnly == null)?"<null>":this.completedOnly));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("cumulativeValues");
        sb.append('=');
        sb.append(((this.cumulativeValues == null)?"<null>":this.cumulativeValues));
        sb.append(',');
        sb.append("dataDimensionItems");
        sb.append('=');
        sb.append(((this.dataDimensionItems == null)?"<null>":this.dataDimensionItems));
        sb.append(',');
        sb.append("dataElementDimensions");
        sb.append('=');
        sb.append(((this.dataElementDimensions == null)?"<null>":this.dataElementDimensions));
        sb.append(',');
        sb.append("dataElementGroupSetDimensions");
        sb.append('=');
        sb.append(((this.dataElementGroupSetDimensions == null)?"<null>":this.dataElementGroupSetDimensions));
        sb.append(',');
        sb.append("dataElementValueDimension");
        sb.append('=');
        sb.append(((this.dataElementValueDimension == null)?"<null>":this.dataElementValueDimension));
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(((this.dataType == null)?"<null>":this.dataType));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("digitGroupSeparator");
        sb.append('=');
        sb.append(((this.digitGroupSeparator == null)?"<null>":this.digitGroupSeparator));
        sb.append(',');
        sb.append("displayBaseLineLabel");
        sb.append('=');
        sb.append(((this.displayBaseLineLabel == null)?"<null>":this.displayBaseLineLabel));
        sb.append(',');
        sb.append("displayDensity");
        sb.append('=');
        sb.append(((this.displayDensity == null)?"<null>":this.displayDensity));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayDomainAxisLabel");
        sb.append('=');
        sb.append(((this.displayDomainAxisLabel == null)?"<null>":this.displayDomainAxisLabel));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayRangeAxisLabel");
        sb.append('=');
        sb.append(((this.displayRangeAxisLabel == null)?"<null>":this.displayRangeAxisLabel));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("displaySubtitle");
        sb.append('=');
        sb.append(((this.displaySubtitle == null)?"<null>":this.displaySubtitle));
        sb.append(',');
        sb.append("displayTargetLineLabel");
        sb.append('=');
        sb.append(((this.displayTargetLineLabel == null)?"<null>":this.displayTargetLineLabel));
        sb.append(',');
        sb.append("displayTitle");
        sb.append('=');
        sb.append(((this.displayTitle == null)?"<null>":this.displayTitle));
        sb.append(',');
        sb.append("domainAxisLabel");
        sb.append('=');
        sb.append(((this.domainAxisLabel == null)?"<null>":this.domainAxisLabel));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("eventStatus");
        sb.append('=');
        sb.append(((this.eventStatus == null)?"<null>":this.eventStatus));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filterDimensions");
        sb.append('=');
        sb.append(((this.filterDimensions == null)?"<null>":this.filterDimensions));
        sb.append(',');
        sb.append("filters");
        sb.append('=');
        sb.append(((this.filters == null)?"<null>":this.filters));
        sb.append(',');
        sb.append("fontSize");
        sb.append('=');
        sb.append(((this.fontSize == null)?"<null>":this.fontSize));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("hideEmptyRowItems");
        sb.append('=');
        sb.append(((this.hideEmptyRowItems == null)?"<null>":this.hideEmptyRowItems));
        sb.append(',');
        sb.append("hideEmptyRows");
        sb.append('=');
        sb.append(((this.hideEmptyRows == null)?"<null>":this.hideEmptyRows));
        sb.append(',');
        sb.append("hideLegend");
        sb.append('=');
        sb.append(((this.hideLegend == null)?"<null>":this.hideLegend));
        sb.append(',');
        sb.append("hideNaData");
        sb.append('=');
        sb.append(((this.hideNaData == null)?"<null>":this.hideNaData));
        sb.append(',');
        sb.append("hideSubtitle");
        sb.append('=');
        sb.append(((this.hideSubtitle == null)?"<null>":this.hideSubtitle));
        sb.append(',');
        sb.append("hideTitle");
        sb.append('=');
        sb.append(((this.hideTitle == null)?"<null>":this.hideTitle));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("interpretations");
        sb.append('=');
        sb.append(((this.interpretations == null)?"<null>":this.interpretations));
        sb.append(',');
        sb.append("itemOrganisationUnitGroups");
        sb.append('=');
        sb.append(((this.itemOrganisationUnitGroups == null)?"<null>":this.itemOrganisationUnitGroups));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legacy");
        sb.append('=');
        sb.append(((this.legacy == null)?"<null>":this.legacy));
        sb.append(',');
        sb.append("legendDisplayStrategy");
        sb.append('=');
        sb.append(((this.legendDisplayStrategy == null)?"<null>":this.legendDisplayStrategy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("noSpaceBetweenColumns");
        sb.append('=');
        sb.append(((this.noSpaceBetweenColumns == null)?"<null>":this.noSpaceBetweenColumns));
        sb.append(',');
        sb.append("orgUnitField");
        sb.append('=');
        sb.append(((this.orgUnitField == null)?"<null>":this.orgUnitField));
        sb.append(',');
        sb.append("organisationUnitGroupSetDimensions");
        sb.append('=');
        sb.append(((this.organisationUnitGroupSetDimensions == null)?"<null>":this.organisationUnitGroupSetDimensions));
        sb.append(',');
        sb.append("organisationUnitLevels");
        sb.append('=');
        sb.append(((this.organisationUnitLevels == null)?"<null>":this.organisationUnitLevels));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("outputType");
        sb.append('=');
        sb.append(((this.outputType == null)?"<null>":this.outputType));
        sb.append(',');
        sb.append("parentGraphMap");
        sb.append('=');
        sb.append(((this.parentGraphMap == null)?"<null>":this.parentGraphMap));
        sb.append(',');
        sb.append("percentStackedValues");
        sb.append('=');
        sb.append(((this.percentStackedValues == null)?"<null>":this.percentStackedValues));
        sb.append(',');
        sb.append("periods");
        sb.append('=');
        sb.append(((this.periods == null)?"<null>":this.periods));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programIndicatorDimensions");
        sb.append('=');
        sb.append(((this.programIndicatorDimensions == null)?"<null>":this.programIndicatorDimensions));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("programStatus");
        sb.append('=');
        sb.append(((this.programStatus == null)?"<null>":this.programStatus));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("rangeAxisDecimals");
        sb.append('=');
        sb.append(((this.rangeAxisDecimals == null)?"<null>":this.rangeAxisDecimals));
        sb.append(',');
        sb.append("rangeAxisLabel");
        sb.append('=');
        sb.append(((this.rangeAxisLabel == null)?"<null>":this.rangeAxisLabel));
        sb.append(',');
        sb.append("rangeAxisMaxValue");
        sb.append('=');
        sb.append(((this.rangeAxisMaxValue == null)?"<null>":this.rangeAxisMaxValue));
        sb.append(',');
        sb.append("rangeAxisMinValue");
        sb.append('=');
        sb.append(((this.rangeAxisMinValue == null)?"<null>":this.rangeAxisMinValue));
        sb.append(',');
        sb.append("rangeAxisSteps");
        sb.append('=');
        sb.append(((this.rangeAxisSteps == null)?"<null>":this.rangeAxisSteps));
        sb.append(',');
        sb.append("regressionType");
        sb.append('=');
        sb.append(((this.regressionType == null)?"<null>":this.regressionType));
        sb.append(',');
        sb.append("relativePeriods");
        sb.append('=');
        sb.append(((this.relativePeriods == null)?"<null>":this.relativePeriods));
        sb.append(',');
        sb.append("repetitions");
        sb.append('=');
        sb.append(((this.repetitions == null)?"<null>":this.repetitions));
        sb.append(',');
        sb.append("rowDimensions");
        sb.append('=');
        sb.append(((this.rowDimensions == null)?"<null>":this.rowDimensions));
        sb.append(',');
        sb.append("rowSubTotals");
        sb.append('=');
        sb.append(((this.rowSubTotals == null)?"<null>":this.rowSubTotals));
        sb.append(',');
        sb.append("rowTotals");
        sb.append('=');
        sb.append(((this.rowTotals == null)?"<null>":this.rowTotals));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("showData");
        sb.append('=');
        sb.append(((this.showData == null)?"<null>":this.showData));
        sb.append(',');
        sb.append("showDimensionLabels");
        sb.append('=');
        sb.append(((this.showDimensionLabels == null)?"<null>":this.showDimensionLabels));
        sb.append(',');
        sb.append("showHierarchy");
        sb.append('=');
        sb.append(((this.showHierarchy == null)?"<null>":this.showHierarchy));
        sb.append(',');
        sb.append("simpleDimensions");
        sb.append('=');
        sb.append(((this.simpleDimensions == null)?"<null>":this.simpleDimensions));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("subscribed");
        sb.append('=');
        sb.append(((this.subscribed == null)?"<null>":this.subscribed));
        sb.append(',');
        sb.append("subscribers");
        sb.append('=');
        sb.append(((this.subscribers == null)?"<null>":this.subscribers));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("targetLineLabel");
        sb.append('=');
        sb.append(((this.targetLineLabel == null)?"<null>":this.targetLineLabel));
        sb.append(',');
        sb.append("targetLineValue");
        sb.append('=');
        sb.append(((this.targetLineValue == null)?"<null>":this.targetLineValue));
        sb.append(',');
        sb.append("timeField");
        sb.append('=');
        sb.append(((this.timeField == null)?"<null>":this.timeField));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("topLimit");
        sb.append('=');
        sb.append(((this.topLimit == null)?"<null>":this.topLimit));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userOrgUnitType");
        sb.append('=');
        sb.append(((this.userOrgUnitType == null)?"<null>":this.userOrgUnitType));
        sb.append(',');
        sb.append("userOrganisationUnit");
        sb.append('=');
        sb.append(((this.userOrganisationUnit == null)?"<null>":this.userOrganisationUnit));
        sb.append(',');
        sb.append("userOrganisationUnitChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitChildren == null)?"<null>":this.userOrganisationUnitChildren));
        sb.append(',');
        sb.append("userOrganisationUnitGrandChildren");
        sb.append('=');
        sb.append(((this.userOrganisationUnitGrandChildren == null)?"<null>":this.userOrganisationUnitGrandChildren));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElementGroupSetDimensions == null)? 0 :this.dataElementGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.orgUnitField == null)? 0 :this.orgUnitField.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.baseLineValue == null)? 0 :this.baseLineValue.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitChildren == null)? 0 :this.userOrganisationUnitChildren.hashCode()));
        result = ((result* 31)+((this.displaySubtitle == null)? 0 :this.displaySubtitle.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.displayTitle == null)? 0 :this.displayTitle.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.subscribed == null)? 0 :this.subscribed.hashCode()));
        result = ((result* 31)+((this.displayTargetLineLabel == null)? 0 :this.displayTargetLineLabel.hashCode()));
        result = ((result* 31)+((this.attributeDimensions == null)? 0 :this.attributeDimensions.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnit == null)? 0 :this.userOrganisationUnit.hashCode()));
        result = ((result* 31)+((this.filterDimensions == null)? 0 :this.filterDimensions.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.rowSubTotals == null)? 0 :this.rowSubTotals.hashCode()));
        result = ((result* 31)+((this.interpretations == null)? 0 :this.interpretations.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.attributeValueDimension == null)? 0 :this.attributeValueDimension.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.domainAxisLabel == null)? 0 :this.domainAxisLabel.hashCode()));
        result = ((result* 31)+((this.subscribers == null)? 0 :this.subscribers.hashCode()));
        result = ((result* 31)+((this.cumulativeValues == null)? 0 :this.cumulativeValues.hashCode()));
        result = ((result* 31)+((this.showDimensionLabels == null)? 0 :this.showDimensionLabels.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.fontSize == null)? 0 :this.fontSize.hashCode()));
        result = ((result* 31)+((this.rangeAxisDecimals == null)? 0 :this.rangeAxisDecimals.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.topLimit == null)? 0 :this.topLimit.hashCode()));
        result = ((result* 31)+((this.collapseDataDimensions == null)? 0 :this.collapseDataDimensions.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.userOrganisationUnitGrandChildren == null)? 0 :this.userOrganisationUnitGrandChildren.hashCode()));
        result = ((result* 31)+((this.columns == null)? 0 :this.columns.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.percentStackedValues == null)? 0 :this.percentStackedValues.hashCode()));
        result = ((result* 31)+((this.noSpaceBetweenColumns == null)? 0 :this.noSpaceBetweenColumns.hashCode()));
        result = ((result* 31)+((this.dataElementDimensions == null)? 0 :this.dataElementDimensions.hashCode()));
        result = ((result* 31)+((this.rangeAxisSteps == null)? 0 :this.rangeAxisSteps.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.periods == null)? 0 :this.periods.hashCode()));
        result = ((result* 31)+((this.categoryDimensions == null)? 0 :this.categoryDimensions.hashCode()));
        result = ((result* 31)+((this.showHierarchy == null)? 0 :this.showHierarchy.hashCode()));
        result = ((result* 31)+((this.displayRangeAxisLabel == null)? 0 :this.displayRangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.hideTitle == null)? 0 :this.hideTitle.hashCode()));
        result = ((result* 31)+((this.rowDimensions == null)? 0 :this.rowDimensions.hashCode()));
        result = ((result* 31)+((this.eventStatus == null)? 0 :this.eventStatus.hashCode()));
        result = ((result* 31)+((this.displayBaseLineLabel == null)? 0 :this.displayBaseLineLabel.hashCode()));
        result = ((result* 31)+((this.showData == null)? 0 :this.showData.hashCode()));
        result = ((result* 31)+((this.repetitions == null)? 0 :this.repetitions.hashCode()));
        result = ((result* 31)+((this.hideEmptyRows == null)? 0 :this.hideEmptyRows.hashCode()));
        result = ((result* 31)+((this.parentGraphMap == null)? 0 :this.parentGraphMap.hashCode()));
        result = ((result* 31)+((this.hideNaData == null)? 0 :this.hideNaData.hashCode()));
        result = ((result* 31)+((this.itemOrganisationUnitGroups == null)? 0 :this.itemOrganisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.displayDensity == null)? 0 :this.displayDensity.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.displayDomainAxisLabel == null)? 0 :this.displayDomainAxisLabel.hashCode()));
        result = ((result* 31)+((this.programIndicatorDimensions == null)? 0 :this.programIndicatorDimensions.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.dataType == null)? 0 :this.dataType.hashCode()));
        result = ((result* 31)+((this.rangeAxisLabel == null)? 0 :this.rangeAxisLabel.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.columnDimensions == null)? 0 :this.columnDimensions.hashCode()));
        result = ((result* 31)+((this.regressionType == null)? 0 :this.regressionType.hashCode()));
        result = ((result* 31)+((this.completedOnly == null)? 0 :this.completedOnly.hashCode()));
        result = ((result* 31)+((this.colTotals == null)? 0 :this.colTotals.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.hideEmptyRowItems == null)? 0 :this.hideEmptyRowItems.hashCode()));
        result = ((result* 31)+((this.programStatus == null)? 0 :this.programStatus.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.dataDimensionItems == null)? 0 :this.dataDimensionItems.hashCode()));
        result = ((result* 31)+((this.categoryOptionGroupSetDimensions == null)? 0 :this.categoryOptionGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.legacy == null)? 0 :this.legacy.hashCode()));
        result = ((result* 31)+((this.hideSubtitle == null)? 0 :this.hideSubtitle.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.outputType == null)? 0 :this.outputType.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroupSetDimensions == null)? 0 :this.organisationUnitGroupSetDimensions.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.hideLegend == null)? 0 :this.hideLegend.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.organisationUnitLevels == null)? 0 :this.organisationUnitLevels.hashCode()));
        result = ((result* 31)+((this.rangeAxisMinValue == null)? 0 :this.rangeAxisMinValue.hashCode()));
        result = ((result* 31)+((this.colSubTotals == null)? 0 :this.colSubTotals.hashCode()));
        result = ((result* 31)+((this.legendDisplayStrategy == null)? 0 :this.legendDisplayStrategy.hashCode()));
        result = ((result* 31)+((this.dataElementValueDimension == null)? 0 :this.dataElementValueDimension.hashCode()));
        result = ((result* 31)+((this.relativePeriods == null)? 0 :this.relativePeriods.hashCode()));
        result = ((result* 31)+((this.targetLineLabel == null)? 0 :this.targetLineLabel.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.rowTotals == null)? 0 :this.rowTotals.hashCode()));
        result = ((result* 31)+((this.timeField == null)? 0 :this.timeField.hashCode()));
        result = ((result* 31)+((this.simpleDimensions == null)? 0 :this.simpleDimensions.hashCode()));
        result = ((result* 31)+((this.targetLineValue == null)? 0 :this.targetLineValue.hashCode()));
        result = ((result* 31)+((this.filters == null)? 0 :this.filters.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.baseLineLabel == null)? 0 :this.baseLineLabel.hashCode()));
        result = ((result* 31)+((this.digitGroupSeparator == null)? 0 :this.digitGroupSeparator.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.userOrgUnitType == null)? 0 :this.userOrgUnitType.hashCode()));
        result = ((result* 31)+((this.rangeAxisMaxValue == null)? 0 :this.rangeAxisMaxValue.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EventVisualization) == false) {
            return false;
        }
        EventVisualization rhs = ((EventVisualization) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((this.dataElementGroupSetDimensions == rhs.dataElementGroupSetDimensions)||((this.dataElementGroupSetDimensions!= null)&&this.dataElementGroupSetDimensions.equals(rhs.dataElementGroupSetDimensions)))&&((this.orgUnitField == rhs.orgUnitField)||((this.orgUnitField!= null)&&this.orgUnitField.equals(rhs.orgUnitField))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.baseLineValue == rhs.baseLineValue)||((this.baseLineValue!= null)&&this.baseLineValue.equals(rhs.baseLineValue))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.userOrganisationUnitChildren == rhs.userOrganisationUnitChildren)||((this.userOrganisationUnitChildren!= null)&&this.userOrganisationUnitChildren.equals(rhs.userOrganisationUnitChildren))))&&((this.displaySubtitle == rhs.displaySubtitle)||((this.displaySubtitle!= null)&&this.displaySubtitle.equals(rhs.displaySubtitle))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.displayTitle == rhs.displayTitle)||((this.displayTitle!= null)&&this.displayTitle.equals(rhs.displayTitle))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.subscribed == rhs.subscribed)||((this.subscribed!= null)&&this.subscribed.equals(rhs.subscribed))))&&((this.displayTargetLineLabel == rhs.displayTargetLineLabel)||((this.displayTargetLineLabel!= null)&&this.displayTargetLineLabel.equals(rhs.displayTargetLineLabel))))&&((this.attributeDimensions == rhs.attributeDimensions)||((this.attributeDimensions!= null)&&this.attributeDimensions.equals(rhs.attributeDimensions))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.userOrganisationUnit == rhs.userOrganisationUnit)||((this.userOrganisationUnit!= null)&&this.userOrganisationUnit.equals(rhs.userOrganisationUnit))))&&((this.filterDimensions == rhs.filterDimensions)||((this.filterDimensions!= null)&&this.filterDimensions.equals(rhs.filterDimensions))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.rowSubTotals == rhs.rowSubTotals)||((this.rowSubTotals!= null)&&this.rowSubTotals.equals(rhs.rowSubTotals))))&&((this.interpretations == rhs.interpretations)||((this.interpretations!= null)&&this.interpretations.equals(rhs.interpretations))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.attributeValueDimension == rhs.attributeValueDimension)||((this.attributeValueDimension!= null)&&this.attributeValueDimension.equals(rhs.attributeValueDimension))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.domainAxisLabel == rhs.domainAxisLabel)||((this.domainAxisLabel!= null)&&this.domainAxisLabel.equals(rhs.domainAxisLabel))))&&((this.subscribers == rhs.subscribers)||((this.subscribers!= null)&&this.subscribers.equals(rhs.subscribers))))&&((this.cumulativeValues == rhs.cumulativeValues)||((this.cumulativeValues!= null)&&this.cumulativeValues.equals(rhs.cumulativeValues))))&&((this.showDimensionLabels == rhs.showDimensionLabels)||((this.showDimensionLabels!= null)&&this.showDimensionLabels.equals(rhs.showDimensionLabels))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.fontSize == rhs.fontSize)||((this.fontSize!= null)&&this.fontSize.equals(rhs.fontSize))))&&((this.rangeAxisDecimals == rhs.rangeAxisDecimals)||((this.rangeAxisDecimals!= null)&&this.rangeAxisDecimals.equals(rhs.rangeAxisDecimals))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.topLimit == rhs.topLimit)||((this.topLimit!= null)&&this.topLimit.equals(rhs.topLimit))))&&((this.collapseDataDimensions == rhs.collapseDataDimensions)||((this.collapseDataDimensions!= null)&&this.collapseDataDimensions.equals(rhs.collapseDataDimensions))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.userOrganisationUnitGrandChildren == rhs.userOrganisationUnitGrandChildren)||((this.userOrganisationUnitGrandChildren!= null)&&this.userOrganisationUnitGrandChildren.equals(rhs.userOrganisationUnitGrandChildren))))&&((this.columns == rhs.columns)||((this.columns!= null)&&this.columns.equals(rhs.columns))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.percentStackedValues == rhs.percentStackedValues)||((this.percentStackedValues!= null)&&this.percentStackedValues.equals(rhs.percentStackedValues))))&&((this.noSpaceBetweenColumns == rhs.noSpaceBetweenColumns)||((this.noSpaceBetweenColumns!= null)&&this.noSpaceBetweenColumns.equals(rhs.noSpaceBetweenColumns))))&&((this.dataElementDimensions == rhs.dataElementDimensions)||((this.dataElementDimensions!= null)&&this.dataElementDimensions.equals(rhs.dataElementDimensions))))&&((this.rangeAxisSteps == rhs.rangeAxisSteps)||((this.rangeAxisSteps!= null)&&this.rangeAxisSteps.equals(rhs.rangeAxisSteps))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.periods == rhs.periods)||((this.periods!= null)&&this.periods.equals(rhs.periods))))&&((this.categoryDimensions == rhs.categoryDimensions)||((this.categoryDimensions!= null)&&this.categoryDimensions.equals(rhs.categoryDimensions))))&&((this.showHierarchy == rhs.showHierarchy)||((this.showHierarchy!= null)&&this.showHierarchy.equals(rhs.showHierarchy))))&&((this.displayRangeAxisLabel == rhs.displayRangeAxisLabel)||((this.displayRangeAxisLabel!= null)&&this.displayRangeAxisLabel.equals(rhs.displayRangeAxisLabel))))&&((this.hideTitle == rhs.hideTitle)||((this.hideTitle!= null)&&this.hideTitle.equals(rhs.hideTitle))))&&((this.rowDimensions == rhs.rowDimensions)||((this.rowDimensions!= null)&&this.rowDimensions.equals(rhs.rowDimensions))))&&((this.eventStatus == rhs.eventStatus)||((this.eventStatus!= null)&&this.eventStatus.equals(rhs.eventStatus))))&&((this.displayBaseLineLabel == rhs.displayBaseLineLabel)||((this.displayBaseLineLabel!= null)&&this.displayBaseLineLabel.equals(rhs.displayBaseLineLabel))))&&((this.showData == rhs.showData)||((this.showData!= null)&&this.showData.equals(rhs.showData))))&&((this.repetitions == rhs.repetitions)||((this.repetitions!= null)&&this.repetitions.equals(rhs.repetitions))))&&((this.hideEmptyRows == rhs.hideEmptyRows)||((this.hideEmptyRows!= null)&&this.hideEmptyRows.equals(rhs.hideEmptyRows))))&&((this.parentGraphMap == rhs.parentGraphMap)||((this.parentGraphMap!= null)&&this.parentGraphMap.equals(rhs.parentGraphMap))))&&((this.hideNaData == rhs.hideNaData)||((this.hideNaData!= null)&&this.hideNaData.equals(rhs.hideNaData))))&&((this.itemOrganisationUnitGroups == rhs.itemOrganisationUnitGroups)||((this.itemOrganisationUnitGroups!= null)&&this.itemOrganisationUnitGroups.equals(rhs.itemOrganisationUnitGroups))))&&((this.displayDensity == rhs.displayDensity)||((this.displayDensity!= null)&&this.displayDensity.equals(rhs.displayDensity))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.displayDomainAxisLabel == rhs.displayDomainAxisLabel)||((this.displayDomainAxisLabel!= null)&&this.displayDomainAxisLabel.equals(rhs.displayDomainAxisLabel))))&&((this.programIndicatorDimensions == rhs.programIndicatorDimensions)||((this.programIndicatorDimensions!= null)&&this.programIndicatorDimensions.equals(rhs.programIndicatorDimensions))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.dataType == rhs.dataType)||((this.dataType!= null)&&this.dataType.equals(rhs.dataType))))&&((this.rangeAxisLabel == rhs.rangeAxisLabel)||((this.rangeAxisLabel!= null)&&this.rangeAxisLabel.equals(rhs.rangeAxisLabel))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.columnDimensions == rhs.columnDimensions)||((this.columnDimensions!= null)&&this.columnDimensions.equals(rhs.columnDimensions))))&&((this.regressionType == rhs.regressionType)||((this.regressionType!= null)&&this.regressionType.equals(rhs.regressionType))))&&((this.completedOnly == rhs.completedOnly)||((this.completedOnly!= null)&&this.completedOnly.equals(rhs.completedOnly))))&&((this.colTotals == rhs.colTotals)||((this.colTotals!= null)&&this.colTotals.equals(rhs.colTotals))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.hideEmptyRowItems == rhs.hideEmptyRowItems)||((this.hideEmptyRowItems!= null)&&this.hideEmptyRowItems.equals(rhs.hideEmptyRowItems))))&&((this.programStatus == rhs.programStatus)||((this.programStatus!= null)&&this.programStatus.equals(rhs.programStatus))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.dataDimensionItems == rhs.dataDimensionItems)||((this.dataDimensionItems!= null)&&this.dataDimensionItems.equals(rhs.dataDimensionItems))))&&((this.categoryOptionGroupSetDimensions == rhs.categoryOptionGroupSetDimensions)||((this.categoryOptionGroupSetDimensions!= null)&&this.categoryOptionGroupSetDimensions.equals(rhs.categoryOptionGroupSetDimensions))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.legacy == rhs.legacy)||((this.legacy!= null)&&this.legacy.equals(rhs.legacy))))&&((this.hideSubtitle == rhs.hideSubtitle)||((this.hideSubtitle!= null)&&this.hideSubtitle.equals(rhs.hideSubtitle))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.outputType == rhs.outputType)||((this.outputType!= null)&&this.outputType.equals(rhs.outputType))))&&((this.organisationUnitGroupSetDimensions == rhs.organisationUnitGroupSetDimensions)||((this.organisationUnitGroupSetDimensions!= null)&&this.organisationUnitGroupSetDimensions.equals(rhs.organisationUnitGroupSetDimensions))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.hideLegend == rhs.hideLegend)||((this.hideLegend!= null)&&this.hideLegend.equals(rhs.hideLegend))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.organisationUnitLevels == rhs.organisationUnitLevels)||((this.organisationUnitLevels!= null)&&this.organisationUnitLevels.equals(rhs.organisationUnitLevels))))&&((this.rangeAxisMinValue == rhs.rangeAxisMinValue)||((this.rangeAxisMinValue!= null)&&this.rangeAxisMinValue.equals(rhs.rangeAxisMinValue))))&&((this.colSubTotals == rhs.colSubTotals)||((this.colSubTotals!= null)&&this.colSubTotals.equals(rhs.colSubTotals))))&&((this.legendDisplayStrategy == rhs.legendDisplayStrategy)||((this.legendDisplayStrategy!= null)&&this.legendDisplayStrategy.equals(rhs.legendDisplayStrategy))))&&((this.dataElementValueDimension == rhs.dataElementValueDimension)||((this.dataElementValueDimension!= null)&&this.dataElementValueDimension.equals(rhs.dataElementValueDimension))))&&((this.relativePeriods == rhs.relativePeriods)||((this.relativePeriods!= null)&&this.relativePeriods.equals(rhs.relativePeriods))))&&((this.targetLineLabel == rhs.targetLineLabel)||((this.targetLineLabel!= null)&&this.targetLineLabel.equals(rhs.targetLineLabel))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.rowTotals == rhs.rowTotals)||((this.rowTotals!= null)&&this.rowTotals.equals(rhs.rowTotals))))&&((this.timeField == rhs.timeField)||((this.timeField!= null)&&this.timeField.equals(rhs.timeField))))&&((this.simpleDimensions == rhs.simpleDimensions)||((this.simpleDimensions!= null)&&this.simpleDimensions.equals(rhs.simpleDimensions))))&&((this.targetLineValue == rhs.targetLineValue)||((this.targetLineValue!= null)&&this.targetLineValue.equals(rhs.targetLineValue))))&&((this.filters == rhs.filters)||((this.filters!= null)&&this.filters.equals(rhs.filters))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.baseLineLabel == rhs.baseLineLabel)||((this.baseLineLabel!= null)&&this.baseLineLabel.equals(rhs.baseLineLabel))))&&((this.digitGroupSeparator == rhs.digitGroupSeparator)||((this.digitGroupSeparator!= null)&&this.digitGroupSeparator.equals(rhs.digitGroupSeparator))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.userOrgUnitType == rhs.userOrgUnitType)||((this.userOrgUnitType!= null)&&this.userOrgUnitType.equals(rhs.userOrgUnitType))))&&((this.rangeAxisMaxValue == rhs.rangeAxisMaxValue)||((this.rangeAxisMaxValue!= null)&&this.rangeAxisMaxValue.equals(rhs.rangeAxisMaxValue))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
