
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "headerWidth",
    "headers",
    "height",
    "metaData",
    "performanceMetrics",
    "refs",
    "rows",
    "subtitle",
    "table",
    "title",
    "width"
})
@Generated("jsonschema2pojo")
public class ListGrid implements Serializable
{

    @JsonProperty("headerWidth")
    private Integer headerWidth;
    @JsonProperty("headers")
    private List<GridHeader> headers;
    @JsonProperty("height")
    private Integer height;
    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    private MetaData__1 metaData;
    @JsonProperty("performanceMetrics")
    private PerformanceMetrics performanceMetrics;
    @JsonProperty("refs")
    private List<Reference> refs;
    @JsonProperty("rows")
    private List<List<Object>> rows;
    @JsonProperty("subtitle")
    private String subtitle;
    @JsonProperty("table")
    private String table;
    @JsonProperty("title")
    private String title;
    @JsonProperty("width")
    private Integer width;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1927242360609817491L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListGrid() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ListGrid(ListGrid source) {
        super();
        this.headerWidth = source.headerWidth;
        this.headers = source.headers;
        this.height = source.height;
        this.metaData = source.metaData;
        this.performanceMetrics = source.performanceMetrics;
        this.refs = source.refs;
        this.rows = source.rows;
        this.subtitle = source.subtitle;
        this.table = source.table;
        this.title = source.title;
        this.width = source.width;
    }

    public ListGrid(Integer headerWidth, List<GridHeader> headers, Integer height, MetaData__1 metaData, PerformanceMetrics performanceMetrics, List<Reference> refs, List<List<Object>> rows, String subtitle, String table, String title, Integer width) {
        super();
        this.headerWidth = headerWidth;
        this.headers = headers;
        this.height = height;
        this.metaData = metaData;
        this.performanceMetrics = performanceMetrics;
        this.refs = refs;
        this.rows = rows;
        this.subtitle = subtitle;
        this.table = table;
        this.title = title;
        this.width = width;
    }

    @JsonProperty("headerWidth")
    public Optional<Integer> getHeaderWidth() {
        return Optional.ofNullable(headerWidth);
    }

    @JsonProperty("headerWidth")
    public void setHeaderWidth(Integer headerWidth) {
        this.headerWidth = headerWidth;
    }

    public ListGrid withHeaderWidth(Integer headerWidth) {
        this.headerWidth = headerWidth;
        return this;
    }

    @JsonProperty("headers")
    public Optional<List<GridHeader>> getHeaders() {
        return Optional.ofNullable(headers);
    }

    @JsonProperty("headers")
    public void setHeaders(List<GridHeader> headers) {
        this.headers = headers;
    }

    public ListGrid withHeaders(List<GridHeader> headers) {
        this.headers = headers;
        return this;
    }

    @JsonProperty("height")
    public Optional<Integer> getHeight() {
        return Optional.ofNullable(height);
    }

    @JsonProperty("height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    public ListGrid withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    public Optional<MetaData__1> getMetaData() {
        return Optional.ofNullable(metaData);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("metaData")
    public void setMetaData(MetaData__1 metaData) {
        this.metaData = metaData;
    }

    public ListGrid withMetaData(MetaData__1 metaData) {
        this.metaData = metaData;
        return this;
    }

    @JsonProperty("performanceMetrics")
    public Optional<PerformanceMetrics> getPerformanceMetrics() {
        return Optional.ofNullable(performanceMetrics);
    }

    @JsonProperty("performanceMetrics")
    public void setPerformanceMetrics(PerformanceMetrics performanceMetrics) {
        this.performanceMetrics = performanceMetrics;
    }

    public ListGrid withPerformanceMetrics(PerformanceMetrics performanceMetrics) {
        this.performanceMetrics = performanceMetrics;
        return this;
    }

    @JsonProperty("refs")
    public Optional<List<Reference>> getRefs() {
        return Optional.ofNullable(refs);
    }

    @JsonProperty("refs")
    public void setRefs(List<Reference> refs) {
        this.refs = refs;
    }

    public ListGrid withRefs(List<Reference> refs) {
        this.refs = refs;
        return this;
    }

    @JsonProperty("rows")
    public Optional<List<List<Object>>> getRows() {
        return Optional.ofNullable(rows);
    }

    @JsonProperty("rows")
    public void setRows(List<List<Object>> rows) {
        this.rows = rows;
    }

    public ListGrid withRows(List<List<Object>> rows) {
        this.rows = rows;
        return this;
    }

    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return Optional.ofNullable(subtitle);
    }

    @JsonProperty("subtitle")
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ListGrid withSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @JsonProperty("table")
    public Optional<String> getTable() {
        return Optional.ofNullable(table);
    }

    @JsonProperty("table")
    public void setTable(String table) {
        this.table = table;
    }

    public ListGrid withTable(String table) {
        this.table = table;
        return this;
    }

    @JsonProperty("title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    public ListGrid withTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("width")
    public Optional<Integer> getWidth() {
        return Optional.ofNullable(width);
    }

    @JsonProperty("width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    public ListGrid withWidth(Integer width) {
        this.width = width;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ListGrid withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("headerWidth".equals(name)) {
            if (value instanceof Integer) {
                setHeaderWidth(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"headerWidth\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("headers".equals(name)) {
                if (value instanceof List) {
                    setHeaders(((List<GridHeader> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"headers\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.GridHeader>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("height".equals(name)) {
                    if (value instanceof Integer) {
                        setHeight(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"height\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("metaData".equals(name)) {
                        if (value instanceof MetaData__1) {
                            setMetaData(((MetaData__1) value));
                        } else {
                            throw new IllegalArgumentException(("property \"metaData\" is of type \"org.hisp.dhis.api.model.v2_38_1.MetaData__1\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("performanceMetrics".equals(name)) {
                            if (value instanceof PerformanceMetrics) {
                                setPerformanceMetrics(((PerformanceMetrics) value));
                            } else {
                                throw new IllegalArgumentException(("property \"performanceMetrics\" is of type \"org.hisp.dhis.api.model.v2_38_1.PerformanceMetrics\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("refs".equals(name)) {
                                if (value instanceof List) {
                                    setRefs(((List<Reference> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"refs\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_38_1.Reference>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("rows".equals(name)) {
                                    if (value instanceof List) {
                                        setRows(((List<List<Object>> ) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"rows\" is of type \"java.util.List<java.util.List<java.lang.Object>>\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("subtitle".equals(name)) {
                                        if (value instanceof String) {
                                            setSubtitle(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"subtitle\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("table".equals(name)) {
                                            if (value instanceof String) {
                                                setTable(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"table\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("title".equals(name)) {
                                                if (value instanceof String) {
                                                    setTitle(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"title\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("width".equals(name)) {
                                                    if (value instanceof Integer) {
                                                        setWidth(((Integer) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"width\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("headerWidth".equals(name)) {
            return getHeaderWidth();
        } else {
            if ("headers".equals(name)) {
                return getHeaders();
            } else {
                if ("height".equals(name)) {
                    return getHeight();
                } else {
                    if ("metaData".equals(name)) {
                        return getMetaData();
                    } else {
                        if ("performanceMetrics".equals(name)) {
                            return getPerformanceMetrics();
                        } else {
                            if ("refs".equals(name)) {
                                return getRefs();
                            } else {
                                if ("rows".equals(name)) {
                                    return getRows();
                                } else {
                                    if ("subtitle".equals(name)) {
                                        return getSubtitle();
                                    } else {
                                        if ("table".equals(name)) {
                                            return getTable();
                                        } else {
                                            if ("title".equals(name)) {
                                                return getTitle();
                                            } else {
                                                if ("width".equals(name)) {
                                                    return getWidth();
                                                } else {
                                                    return notFoundValue;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ListGrid.NOT_FOUND_VALUE);
        if (ListGrid.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ListGrid with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ListGrid.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("headerWidth");
        sb.append('=');
        sb.append(((this.headerWidth == null)?"<null>":this.headerWidth));
        sb.append(',');
        sb.append("headers");
        sb.append('=');
        sb.append(((this.headers == null)?"<null>":this.headers));
        sb.append(',');
        sb.append("height");
        sb.append('=');
        sb.append(((this.height == null)?"<null>":this.height));
        sb.append(',');
        sb.append("metaData");
        sb.append('=');
        sb.append(((this.metaData == null)?"<null>":this.metaData));
        sb.append(',');
        sb.append("performanceMetrics");
        sb.append('=');
        sb.append(((this.performanceMetrics == null)?"<null>":this.performanceMetrics));
        sb.append(',');
        sb.append("refs");
        sb.append('=');
        sb.append(((this.refs == null)?"<null>":this.refs));
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(((this.rows == null)?"<null>":this.rows));
        sb.append(',');
        sb.append("subtitle");
        sb.append('=');
        sb.append(((this.subtitle == null)?"<null>":this.subtitle));
        sb.append(',');
        sb.append("table");
        sb.append('=');
        sb.append(((this.table == null)?"<null>":this.table));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("width");
        sb.append('=');
        sb.append(((this.width == null)?"<null>":this.width));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.headers == null)? 0 :this.headers.hashCode()));
        result = ((result* 31)+((this.headerWidth == null)? 0 :this.headerWidth.hashCode()));
        result = ((result* 31)+((this.performanceMetrics == null)? 0 :this.performanceMetrics.hashCode()));
        result = ((result* 31)+((this.rows == null)? 0 :this.rows.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.metaData == null)? 0 :this.metaData.hashCode()));
        result = ((result* 31)+((this.refs == null)? 0 :this.refs.hashCode()));
        result = ((result* 31)+((this.subtitle == null)? 0 :this.subtitle.hashCode()));
        result = ((result* 31)+((this.width == null)? 0 :this.width.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.table == null)? 0 :this.table.hashCode()));
        result = ((result* 31)+((this.height == null)? 0 :this.height.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ListGrid) == false) {
            return false;
        }
        ListGrid rhs = ((ListGrid) other);
        return (((((((((((((this.headers == rhs.headers)||((this.headers!= null)&&this.headers.equals(rhs.headers)))&&((this.headerWidth == rhs.headerWidth)||((this.headerWidth!= null)&&this.headerWidth.equals(rhs.headerWidth))))&&((this.performanceMetrics == rhs.performanceMetrics)||((this.performanceMetrics!= null)&&this.performanceMetrics.equals(rhs.performanceMetrics))))&&((this.rows == rhs.rows)||((this.rows!= null)&&this.rows.equals(rhs.rows))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.metaData == rhs.metaData)||((this.metaData!= null)&&this.metaData.equals(rhs.metaData))))&&((this.refs == rhs.refs)||((this.refs!= null)&&this.refs.equals(rhs.refs))))&&((this.subtitle == rhs.subtitle)||((this.subtitle!= null)&&this.subtitle.equals(rhs.subtitle))))&&((this.width == rhs.width)||((this.width!= null)&&this.width.equals(rhs.width))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.table == rhs.table)||((this.table!= null)&&this.table.equals(rhs.table))))&&((this.height == rhs.height)||((this.height!= null)&&this.height.equals(rhs.height))));
    }

}
