
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "importReport",
    "importSummary",
    "metadataVersion"
})
@Generated("jsonschema2pojo")
public class MetadataSyncSummary implements Serializable
{

    @JsonProperty("importReport")
    private ImportReport importReport;
    @JsonProperty("importSummary")
    private ImportSummary__1 importSummary;
    @JsonProperty("metadataVersion")
    private MetadataVersion metadataVersion;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4413407653979378117L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetadataSyncSummary() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MetadataSyncSummary(MetadataSyncSummary source) {
        super();
        this.importReport = source.importReport;
        this.importSummary = source.importSummary;
        this.metadataVersion = source.metadataVersion;
    }

    public MetadataSyncSummary(ImportReport importReport, ImportSummary__1 importSummary, MetadataVersion metadataVersion) {
        super();
        this.importReport = importReport;
        this.importSummary = importSummary;
        this.metadataVersion = metadataVersion;
    }

    @JsonProperty("importReport")
    public Optional<ImportReport> getImportReport() {
        return Optional.ofNullable(importReport);
    }

    @JsonProperty("importReport")
    public void setImportReport(ImportReport importReport) {
        this.importReport = importReport;
    }

    public MetadataSyncSummary withImportReport(ImportReport importReport) {
        this.importReport = importReport;
        return this;
    }

    @JsonProperty("importSummary")
    public Optional<ImportSummary__1> getImportSummary() {
        return Optional.ofNullable(importSummary);
    }

    @JsonProperty("importSummary")
    public void setImportSummary(ImportSummary__1 importSummary) {
        this.importSummary = importSummary;
    }

    public MetadataSyncSummary withImportSummary(ImportSummary__1 importSummary) {
        this.importSummary = importSummary;
        return this;
    }

    @JsonProperty("metadataVersion")
    public Optional<MetadataVersion> getMetadataVersion() {
        return Optional.ofNullable(metadataVersion);
    }

    @JsonProperty("metadataVersion")
    public void setMetadataVersion(MetadataVersion metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public MetadataSyncSummary withMetadataVersion(MetadataVersion metadataVersion) {
        this.metadataVersion = metadataVersion;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MetadataSyncSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("importReport".equals(name)) {
            if (value instanceof ImportReport) {
                setImportReport(((ImportReport) value));
            } else {
                throw new IllegalArgumentException(("property \"importReport\" is of type \"org.hisp.dhis.api.model.v2_38_1.ImportReport\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("importSummary".equals(name)) {
                if (value instanceof ImportSummary__1) {
                    setImportSummary(((ImportSummary__1) value));
                } else {
                    throw new IllegalArgumentException(("property \"importSummary\" is of type \"org.hisp.dhis.api.model.v2_38_1.ImportSummary__1\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("metadataVersion".equals(name)) {
                    if (value instanceof MetadataVersion) {
                        setMetadataVersion(((MetadataVersion) value));
                    } else {
                        throw new IllegalArgumentException(("property \"metadataVersion\" is of type \"org.hisp.dhis.api.model.v2_38_1.MetadataVersion\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("importReport".equals(name)) {
            return getImportReport();
        } else {
            if ("importSummary".equals(name)) {
                return getImportSummary();
            } else {
                if ("metadataVersion".equals(name)) {
                    return getMetadataVersion();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MetadataSyncSummary.NOT_FOUND_VALUE);
        if (MetadataSyncSummary.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MetadataSyncSummary with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataSyncSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("importReport");
        sb.append('=');
        sb.append(((this.importReport == null)?"<null>":this.importReport));
        sb.append(',');
        sb.append("importSummary");
        sb.append('=');
        sb.append(((this.importSummary == null)?"<null>":this.importSummary));
        sb.append(',');
        sb.append("metadataVersion");
        sb.append('=');
        sb.append(((this.metadataVersion == null)?"<null>":this.metadataVersion));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.importSummary == null)? 0 :this.importSummary.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importReport == null)? 0 :this.importReport.hashCode()));
        result = ((result* 31)+((this.metadataVersion == null)? 0 :this.metadataVersion.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MetadataSyncSummary) == false) {
            return false;
        }
        MetadataSyncSummary rhs = ((MetadataSyncSummary) other);
        return (((((this.importSummary == rhs.importSummary)||((this.importSummary!= null)&&this.importSummary.equals(rhs.importSummary)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importReport == rhs.importReport)||((this.importReport!= null)&&this.importReport.equals(rhs.importReport))))&&((this.metadataVersion == rhs.metadataVersion)||((this.metadataVersion!= null)&&this.metadataVersion.equals(rhs.metadataVersion))));
    }

}
