
package org.hisp.dhis.api.model.v2_38_1;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "includeFrom",
    "includeTo"
})
@Generated("jsonschema2pojo")
public class RelationshipParams implements Serializable
{

    @JsonProperty("includeFrom")
    private Boolean includeFrom;
    @JsonProperty("includeTo")
    private Boolean includeTo;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7119964409532705350L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelationshipParams() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public RelationshipParams(RelationshipParams source) {
        super();
        this.includeFrom = source.includeFrom;
        this.includeTo = source.includeTo;
    }

    public RelationshipParams(Boolean includeFrom, Boolean includeTo) {
        super();
        this.includeFrom = includeFrom;
        this.includeTo = includeTo;
    }

    @JsonProperty("includeFrom")
    public Optional<Boolean> getIncludeFrom() {
        return Optional.ofNullable(includeFrom);
    }

    @JsonProperty("includeFrom")
    public void setIncludeFrom(Boolean includeFrom) {
        this.includeFrom = includeFrom;
    }

    public RelationshipParams withIncludeFrom(Boolean includeFrom) {
        this.includeFrom = includeFrom;
        return this;
    }

    @JsonProperty("includeTo")
    public Optional<Boolean> getIncludeTo() {
        return Optional.ofNullable(includeTo);
    }

    @JsonProperty("includeTo")
    public void setIncludeTo(Boolean includeTo) {
        this.includeTo = includeTo;
    }

    public RelationshipParams withIncludeTo(Boolean includeTo) {
        this.includeTo = includeTo;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RelationshipParams withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("includeFrom".equals(name)) {
            if (value instanceof Boolean) {
                setIncludeFrom(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"includeFrom\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("includeTo".equals(name)) {
                if (value instanceof Boolean) {
                    setIncludeTo(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"includeTo\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("includeFrom".equals(name)) {
            return getIncludeFrom();
        } else {
            if ("includeTo".equals(name)) {
                return getIncludeTo();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RelationshipParams.NOT_FOUND_VALUE);
        if (RelationshipParams.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RelationshipParams with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RelationshipParams.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("includeFrom");
        sb.append('=');
        sb.append(((this.includeFrom == null)?"<null>":this.includeFrom));
        sb.append(',');
        sb.append("includeTo");
        sb.append('=');
        sb.append(((this.includeTo == null)?"<null>":this.includeTo));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.includeFrom == null)? 0 :this.includeFrom.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.includeTo == null)? 0 :this.includeTo.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RelationshipParams) == false) {
            return false;
        }
        RelationshipParams rhs = ((RelationshipParams) other);
        return ((((this.includeFrom == rhs.includeFrom)||((this.includeFrom!= null)&&this.includeFrom.equals(rhs.includeFrom)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.includeTo == rhs.includeTo)||((this.includeTo!= null)&&this.includeTo.equals(rhs.includeTo))));
    }

}
